/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.ldap.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.security.auth.x500.X500Principal;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.ldap.LdapClientFactory;
import org.openspcoop2.utils.transport.ldap.LdapClientInterface;
import org.openspcoop2.utils.transport.ldap.LdapEngineType;
import org.openspcoop2.utils.transport.ldap.LdapFilter;
import org.openspcoop2.utils.transport.ldap.LdapQuery;
import org.openspcoop2.utils.transport.ldap.LdapUtility;
import org.openspcoop2.utils.transport.ldap.test.LdapServerTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.ldap.ldif.parser.LdifParser;

public class LdapTest {
    private static final String USER_CERTIFICATE = "userCertificate";
    private static final String RISULTATO_QUERY_NON_EQUIVALENTE = "Il risultato della query non risulta equivalente a quello atteso";
    private static List<Attributes> attributes;
    private static final String USERNAME = "uid=admin,ou=system";
    private static final String PASSWORD = "secret";
    private static LdapServerTest server;

    public static void readLdif(Resource ldifResourse) throws IOException {
        LdifParser parser = new LdifParser(ldifResourse);
        parser.open();
        attributes = new ArrayList<Attributes>();
        while (parser.hasMoreRecords()) {
            attributes.add((Attributes)parser.getRecord());
        }
    }

    private static List<Attributes> applyQuery(LdapQuery query) {
        ArrayList<Attributes> rv = new ArrayList<Attributes>();
        List<String> retAttributes = query.getAttributes();
        for (Attributes attrs : attributes) {
            if (!query.getFilter().check(attrs)) continue;
            BasicAttributes newAttrs = new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> names = attrs.getAll();
            while (names.hasMoreElements()) {
                Attribute name = (Attribute)names.nextElement();
                if (!retAttributes.isEmpty() && !retAttributes.contains(name.getID())) continue;
                newAttrs.put(name);
            }
            rv.add(newAttrs);
        }
        return rv;
    }

    private static boolean compareAttributes(List<Attributes> lst1, List<Attributes> lst2) {
        int value;
        HashMap<Attributes, Integer> table = new HashMap<Attributes, Integer>();
        for (Attributes attrs : lst1) {
            value = table.getOrDefault(attrs, 0);
            table.put(attrs, value + 1);
        }
        for (Attributes attrs : lst2) {
            value = table.getOrDefault(attrs, 0);
            if (value > 1) {
                table.put(attrs, value - 1);
                continue;
            }
            if (value > 0) {
                table.remove(attrs);
                continue;
            }
            return false;
        }
        return table.isEmpty();
    }

    private static void printAttributes(OutputStream stream, List<Attributes> list) throws NamingException, IOException {
        for (Attributes attrs : list) {
            NamingEnumeration<? extends Attribute> names = attrs.getAll();
            stream.write("{\n".getBytes());
            while (names.hasMoreElements()) {
                Attribute attr = names.next();
                stream.write(attr.getID().getBytes());
                stream.write(": ".getBytes());
                NamingEnumeration<?> values = attr.getAll();
                while (values.hasMoreElements()) {
                    Object value = values.nextElement();
                    if (value instanceof byte[]) {
                        stream.write(Base64.getEncoder().encode((byte[])value));
                    } else {
                        stream.write(((String)value).getBytes());
                    }
                    stream.write(", ".getBytes());
                }
                stream.write("\n".getBytes());
            }
            stream.write("},\n".getBytes());
        }
    }

    public static List<Attributes> testQuery(LdapEngineType type, LdapQuery query) throws UtilsException, InvalidNameException, URISyntaxException {
        LdapClientInterface client = LdapClientFactory.getClient(type);
        client.uri(new URI(server.getURL())).username(new LdapName(USERNAME)).password(PASSWORD);
        List<Attributes> res = client.search(query);
        List<Attributes> baseCase = LdapTest.applyQuery(query);
        LdapTest.print("elementi trovati: " + res.size() + ", elementi attesi: " + baseCase.size());
        if (!LdapTest.compareAttributes(res, baseCase)) {
            throw new UtilsException(RISULTATO_QUERY_NON_EQUIVALENTE);
        }
        return res;
    }

    public static List<Attributes> testCRL(LdapEngineType type) throws UtilsException, URISyntaxException, NamingException, CertificateException, CRLException {
        LdapClientInterface client = LdapClientFactory.getClient(type);
        client.uri(new URI(server.getURL())).base(new LdapName("dc=example,dc=com")).username(new LdapName(USERNAME)).password(PASSWORD);
        LdapQuery query = new LdapQuery().filter(LdapFilter.isPresent(USER_CERTIFICATE)).attributes(USER_CERTIFICATE);
        List<Attributes> res = client.search(query);
        List<Attributes> baseCase = LdapTest.applyQuery(query);
        if (!LdapTest.compareAttributes(res, baseCase)) {
            throw new UtilsException(RISULTATO_QUERY_NON_EQUIVALENTE);
        }
        byte[] crlContent = (byte[])res.get(0).get(USER_CERTIFICATE).get();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL crl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(crlContent));
        X500Principal principal = crl.getIssuerX500Principal();
        LdapTest.print("issuer trovato: [" + principal.getName() + "], issuer atteso: [O=Link.it,L=Pisa,ST=PI,C=IT]");
        if (!principal.getName().equals("O=Link.it,L=Pisa,ST=PI,C=IT")) {
            throw new UtilsException("certificato ottenuto non valido");
        }
        return res;
    }

    public static List<Attributes> testParsing(LdapEngineType type, LdapQuery query, String url) throws UtilsException, URISyntaxException, InvalidNameException, ParseException {
        URI uri = new URI(url);
        LdapQuery parsedQuery = LdapUtility.getQueryFromURI(uri);
        LdapClientInterface client1 = LdapClientFactory.getClient(type);
        client1.uri(new URI(server.getURL())).username(new LdapName(USERNAME)).password(PASSWORD);
        List<Attributes> list1 = client1.search(query);
        LdapClientInterface client2 = LdapClientFactory.getClient(type);
        client2.uri(LdapUtility.getBaseUrlFromURI(uri)).username(new LdapName(USERNAME)).password(PASSWORD);
        List<Attributes> list2 = client2.search(parsedQuery);
        LdapTest.print("elementi trovati: " + list2.size() + ", elementi attesi: " + list1.size());
        if (!LdapTest.compareAttributes(list1, list2)) {
            throw new UtilsException(RISULTATO_QUERY_NON_EQUIVALENTE);
        }
        return list2;
    }

    public static void startServer() throws Exception {
        File dirTmp = File.createTempFile("ldapServer", "dat");
        FileSystemUtilities.deleteFile(dirTmp);
        FileSystemUtilities.mkdir(dirTmp);
        server.start(dirTmp.getPath());
    }

    public static void stopServer() {
        try {
            server.shutdown(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() throws IOException {
        ClassPathResource ldif = new ClassPathResource("server.ldif", LdapTest.class);
        server = new LdapServerTest((Resource)ldif);
        LdapTest.readLdif((Resource)ldif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            LdapTest.init();
            LdapTest.startServer();
            LdapTest.printAttributes(LdapTest.getPrintStream(), attributes);
            String baseUrl = LdapTest.getUrl();
            String base = "dc=example,dc=com";
            LdapQuery query = new LdapQuery().base(new LdapName(base)).attributes(USER_CERTIFICATE);
            String url = baseUrl + "/dc=example,dc=com?userCertificate";
            LdapTest.print("query: " + query.getFilter().toString());
            LdapTest.print("**************** QUERY ****************");
            LdapTest.printAttributes(LdapTest.getPrintStream(), LdapTest.testQuery(LdapEngineType.SPRING_FRAMEWORK, query));
            LdapTest.print("**************** CRL ****************");
            LdapTest.printAttributes(LdapTest.getPrintStream(), LdapTest.testCRL(LdapEngineType.SPRING_FRAMEWORK));
            LdapTest.print("**************** ATTRIBUTES ****************");
            LdapTest.printAttributes(LdapTest.getPrintStream(), LdapTest.testParsing(LdapEngineType.SPRING_FRAMEWORK, query, url));
            LdapTest.stopServer();
            LdapTest.print("Testsuite terminata");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LdapTest.stopServer();
        }
    }

    public static String getUrl() {
        return server.getURL();
    }

    private static void print(String msg) {
        LdapTest.getPrintStream().println(msg);
    }

    private static PrintStream getPrintStream() {
        return System.out;
    }
}

