/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class DOM3LS_XMLUtils {
    public static AbstractXMLUtils xmlUtils = XMLUtils.getInstance();

    public static synchronized void setXMLUtils(AbstractXMLUtils xmlUtilsParam) {
        xmlUtils = xmlUtilsParam;
    }

    private static void _serialize(Document documentImplementation, Node n, Object out, boolean prettyPrint) {
        LSOutput lsOutput;
        LSSerializer lsSerializer;
        DOMImplementation domImplementation = documentImplementation.getImplementation();
        if (domImplementation.hasFeature("LS", "3.0") && domImplementation.hasFeature("Core", "2.0")) {
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
            lsSerializer = domImplementationLS.createLSSerializer();
            DOMConfiguration domConfiguration = lsSerializer.getDomConfig();
            if (prettyPrint) {
                if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                } else {
                    throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
                }
            }
            lsOutput = domImplementationLS.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            if (out instanceof OutputStream) {
                lsOutput.setByteStream((OutputStream)out);
            } else if (out instanceof Writer) {
                lsOutput.setCharacterStream((Writer)out);
            }
        } else {
            throw new RuntimeException("DOM 3.0 LS and/or DOM 2.0 Core not supported.");
        }
        lsSerializer.write(n, lsOutput);
    }

    public static void serialize(Document document, OutputStream out, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(document, (Node)document, out, prettyPrint);
    }

    public static void serialize(Document document, OutputStream out) {
        DOM3LS_XMLUtils.serialize(document, (Node)document, out, false);
    }

    public static void serialize(Element element, OutputStream out, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, out, prettyPrint);
    }

    public static void serialize(Element element, OutputStream out) {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, out, false);
    }

    public static void serialize(Node node, OutputStream out, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, out, prettyPrint);
    }

    public static void serialize(Node node, OutputStream out) {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, out, false);
    }

    public static void serialize(Document documentImplementation, Node n, OutputStream out, boolean prettyPrint) {
        DOM3LS_XMLUtils._serialize(documentImplementation, n, out, prettyPrint);
    }

    public static void serialize(Document document, Writer writer, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(document, (Node)document, writer, prettyPrint);
    }

    public static void serialize(Document document, Writer writer) {
        DOM3LS_XMLUtils.serialize(document, (Node)document, writer, false);
    }

    public static void serialize(Element element, Writer writer, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, writer, prettyPrint);
    }

    public static void serialize(Element element, Writer writer) {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, writer, false);
    }

    public static void serialize(Node node, Writer writer, boolean prettyPrint) {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, writer, prettyPrint);
    }

    public static void serialize(Node node, Writer writer) {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, writer, false);
    }

    public static void serialize(Document documentImplementation, Node n, Writer writer, boolean prettyPrint) {
        DOM3LS_XMLUtils._serialize(documentImplementation, n, writer, prettyPrint);
    }

    public static void serialize(Document document, File file, boolean prettyPrint) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(document, (Node)document, file, prettyPrint);
    }

    public static void serialize(Document document, File file) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(document, (Node)document, file, false);
    }

    public static void serialize(Element element, File file, boolean prettyPrint) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, file, prettyPrint);
    }

    public static void serialize(Element element, File file) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(element.getOwnerDocument(), (Node)element, file, false);
    }

    public static void serialize(Node node, File file, boolean prettyPrint) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, file, prettyPrint);
    }

    public static void serialize(Node node, File file) throws FileNotFoundException {
        DOM3LS_XMLUtils.serialize(node.getOwnerDocument(), node, file, false);
    }

    public static void serialize(Document documentImplementation, Node n, File file, boolean prettyPrint) throws FileNotFoundException {
        DOM3LS_XMLUtils._serialize(documentImplementation, n, file, prettyPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _serialize(Document documentImplementation, Node n, File file, boolean prettyPrint) throws FileNotFoundException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            DOM3LS_XMLUtils._serialize(documentImplementation, n, fout, prettyPrint);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String toString(Document document, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toString(document, document, prettyPrint);
    }

    public static String toString(Document document) {
        return DOM3LS_XMLUtils.toString(document, document, false);
    }

    public static String toString(Element element, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toString(element.getOwnerDocument(), element, prettyPrint);
    }

    public static String toString(Element element) {
        return DOM3LS_XMLUtils.toString(element.getOwnerDocument(), element, false);
    }

    public static String toString(Node node, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toString(node.getOwnerDocument(), node, prettyPrint);
    }

    public static String toString(Node node) {
        return DOM3LS_XMLUtils.toString(node.getOwnerDocument(), node, false);
    }

    public static String toString(Document documentImplementation, Node n, boolean prettyPrint) {
        return DOM3LS_XMLUtils._toString(documentImplementation, n, prettyPrint);
    }

    public static String _toString(Document documentImplementation, Node n, boolean prettyPrint) {
        StringWriter stringWriter = new StringWriter();
        DOM3LS_XMLUtils._serialize(documentImplementation, n, stringWriter, prettyPrint);
        return stringWriter.toString();
    }

    public static byte[] toByteArray(Document document, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toByteArray(document, document, prettyPrint);
    }

    public static byte[] toByteArray(Document document) {
        return DOM3LS_XMLUtils.toByteArray(document, document, false);
    }

    public static byte[] toByteArray(Element element, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toByteArray(element.getOwnerDocument(), element, prettyPrint);
    }

    public static byte[] toByteArray(Element element) {
        return DOM3LS_XMLUtils.toByteArray(element.getOwnerDocument(), element, false);
    }

    public static byte[] toByteArray(Node node, boolean prettyPrint) {
        return DOM3LS_XMLUtils.toByteArray(node.getOwnerDocument(), node, prettyPrint);
    }

    public static byte[] toByteArray(Node node) {
        return DOM3LS_XMLUtils.toByteArray(node.getOwnerDocument(), node, false);
    }

    public static byte[] toByteArray(Document documentImplementation, Node n, boolean prettyPrint) {
        return DOM3LS_XMLUtils._toByteArray(documentImplementation, n, prettyPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] _toByteArray(Document documentImplementation, Node n, boolean prettyPrint) {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            DOM3LS_XMLUtils._serialize(documentImplementation, n, bout, prettyPrint);
        }
        finally {
            try {
                bout.flush();
            }
            catch (Exception exception) {}
            try {
                bout.close();
            }
            catch (Exception exception) {}
        }
        return bout.toByteArray();
    }
}

