/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class JaxbUtils {
    private static Map<String, JAXBContext> mapJAXBContext = new ConcurrentHashMap<String, JAXBContext>();

    private JaxbUtils() {
    }

    private static byte[] sanitizeXml10(byte[] xml) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(xml.length);
        for (byte b : xml) {
            int unsigned = b & 0xFF;
            if (unsigned < 32) {
                if (unsigned != 9 && unsigned != 10 && unsigned != 13) continue;
                out.write(b);
                continue;
            }
            out.write(b);
        }
        return out.toByteArray();
    }

    private static InputStream sanitizeXml10(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        byte[] sanitized = JaxbUtils.sanitizeXml10(baos.toByteArray());
        return new ByteArrayInputStream(sanitized);
    }

    private static synchronized void initJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            mapJAXBContext.put(packageName, JAXBContext.newInstance((String)packageName));
        }
    }

    private static JAXBContext getJAXBContext(String packageName) throws JAXBException {
        if (!mapJAXBContext.containsKey(packageName)) {
            JaxbUtils.initJAXBContext(packageName);
        }
        return mapJAXBContext.get(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(String xmlFileName, Class<?> classType) throws JAXBException, IOException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        FileInputStream fis = new FileInputStream(xmlFileName);
        InputStream sanitizedIs = null;
        Object objectRead = null;
        try {
            sanitizedIs = JaxbUtils.sanitizeXml10(fis);
            objectRead = uctx.unmarshal(sanitizedIs);
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
            try {
                if (sanitizedIs != null) {
                    sanitizedIs.close();
                }
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object) throws JAXBException {
        JaxbUtils.objToXml(xmlFileName, classType, object, false);
    }

    public static void objToXml(String xmlFileName, Class<?> classType, Object object, boolean prettyDocument) throws JAXBException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            FileSystemUtilities.deleteFile(file);
        }
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        uctx.marshal(object, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objToXml(String xmlFileName, byte[] object) throws IOException {
        File file = new File(xmlFileName);
        if (file.exists()) {
            FileSystemUtilities.deleteFile(file);
        }
        FileOutputStream fileOut = new FileOutputStream(xmlFileName);
        try {
            fileOut.write(object);
            fileOut.flush();
        }
        finally {
            try {
                fileOut.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object xmlToObj(InputStream i, Class<?> classType) throws JAXBException, IOException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Unmarshaller uctx = jc.createUnmarshaller();
        InputStream sanitizedIs = null;
        Object objectRead = null;
        try {
            sanitizedIs = JaxbUtils.sanitizeXml10(i);
            objectRead = uctx.unmarshal(sanitizedIs);
        }
        finally {
            try {
                i.close();
            }
            catch (Exception exception) {}
            try {
                if (sanitizedIs != null) {
                    sanitizedIs.close();
                }
            }
            catch (Exception exception) {}
        }
        if (objectRead instanceof JAXBElement) {
            return ((JAXBElement)objectRead).getValue();
        }
        return objectRead;
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object) throws JAXBException {
        JaxbUtils.objToXml(out, classType, object, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument) throws JAXBException {
        JaxbUtils.objToXml(out, classType, object, prettyDocument, false);
    }

    public static void objToXml(OutputStream out, Class<?> classType, Object object, boolean prettyDocument, boolean omitXmlDeclaration) throws JAXBException {
        JAXBContext jc = JaxbUtils.getJAXBContext(classType.getPackage().getName());
        Marshaller uctx = jc.createMarshaller();
        if (prettyDocument) {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        } else {
            uctx.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        }
        if (omitXmlDeclaration) {
            uctx.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        uctx.marshal(object, out);
    }
}

