/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openspcoop2.utils.CopyCharStream;
import org.openspcoop2.utils.CopyStream;
import org.w3c.dom.ls.LSInput;

public class LSInputImpl
implements LSInput {
    private String type;
    private String namespaceURI;
    private String publicId;
    private String systemId;
    private String baseURI;
    private byte[] resource;
    private String encoding = Charset.defaultCharset().name();

    public LSInputImpl(String type, String namespaceURI, String publicId, String systemId, String baseURI, byte[] resource) {
        this.type = type;
        this.namespaceURI = namespaceURI;
        this.publicId = publicId;
        this.systemId = systemId;
        this.baseURI = baseURI;
        this.resource = resource;
    }

    @Override
    public Reader getCharacterStream() {
        try {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(this.resource), this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException("Metodo getCharacterStream() ha causato un errore", e);
        }
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            CopyCharStream.copy(characterStream, bout);
            this.resource = bout.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Metodo setCharacterStream(Reader characterStream) ha causato un errore", e);
        }
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.resource);
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            CopyStream.copy(byteStream, (OutputStream)bout);
            this.resource = bout.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Metodo setByteStream(InputStream byteStream) ha causato un errore", e);
        }
    }

    @Override
    public String getStringData() {
        try {
            return new String(this.resource, this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException("Metodo getStringData() ha causato un errore", e);
        }
    }

    @Override
    public void setStringData(String stringData) {
        this.resource = stringData.getBytes();
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public boolean getCertifiedText() {
        throw new RuntimeException("Metodo getCertifiedText() non implementato");
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
        throw new RuntimeException("Metodo setCertifiedText(boolean certifiedText) non implementato");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public byte[] getResource() {
        return this.resource;
    }

    public void setResource(byte[] resource) {
        this.resource = resource;
    }
}

