/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.validation.Schema;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.slf4j.Logger;
import org.w3c.dom.ls.LSResourceResolver;

public class XSDSchemaCollection {
    private static volatile boolean serializeXSDSchemiBuildSchemaSuccessDefault = false;
    private static volatile boolean serializeXSDSchemiBuildSchemaErrorDefault = true;
    private static File serializeXSDSchemiBuildSchemaDefaultDir = null;
    private byte[] schemaRoot;
    private Map<String, byte[]> resources;
    private Map<String, List<String>> mappingNamespaceLocations;
    private volatile boolean serializeXSDSchemiBuildSchemaSuccess = XSDSchemaCollection.isSerializeXSDSchemiBuildSchemaSuccessDefault();
    private volatile boolean serializeXSDSchemiBuildSchemaError = XSDSchemaCollection.isSerializeXSDSchemiBuildSchemaErrorDefault();
    private File serializeXSDSchemiBuildSchemaDir = XSDSchemaCollection.getSerializeXSDSchemiBuildSchemaDefaultDir();
    private static long counter = 0L;

    public static boolean isSerializeXSDSchemiBuildSchemaSuccessDefault() {
        return serializeXSDSchemiBuildSchemaSuccessDefault;
    }

    public static void setSerializeXSDSchemiBuildSchemaSuccessDefault(boolean serializeXSDSchemiBuildSchemaSuccessDefault) {
        XSDSchemaCollection.serializeXSDSchemiBuildSchemaSuccessDefault = serializeXSDSchemiBuildSchemaSuccessDefault;
    }

    public static boolean isSerializeXSDSchemiBuildSchemaErrorDefault() {
        return serializeXSDSchemiBuildSchemaErrorDefault;
    }

    public static void setSerializeXSDSchemiBuildSchemaErrorDefault(boolean serializeXSDSchemiBuildSchemaErrorDefault) {
        XSDSchemaCollection.serializeXSDSchemiBuildSchemaErrorDefault = serializeXSDSchemiBuildSchemaErrorDefault;
    }

    public static File getSerializeXSDSchemiBuildSchemaDefaultDir() {
        return serializeXSDSchemiBuildSchemaDefaultDir;
    }

    public static void setSerializeXSDSchemiBuildSchemaDefaultDir(File serializeXSDSchemiBuildSchemaDefaultDir) {
        XSDSchemaCollection.serializeXSDSchemiBuildSchemaDefaultDir = serializeXSDSchemiBuildSchemaDefaultDir;
    }

    public boolean isSerializeXSDSchemiBuildSchemaSuccess() {
        return this.serializeXSDSchemiBuildSchemaSuccess;
    }

    public void setSerializeXSDSchemiBuildSchemaSuccess(boolean serializeXSDSchemiBuildSchemaSuccess) {
        this.serializeXSDSchemiBuildSchemaSuccess = serializeXSDSchemiBuildSchemaSuccess;
    }

    public boolean isSerializeXSDSchemiBuildSchemaError() {
        return this.serializeXSDSchemiBuildSchemaError;
    }

    public void setSerializeXSDSchemiBuildSchemaError(boolean serializeXSDSchemiBuildSchemaErrror) {
        this.serializeXSDSchemiBuildSchemaError = serializeXSDSchemiBuildSchemaErrror;
    }

    public File getSerializeXSDSchemiBuildSchemaDir() {
        return this.serializeXSDSchemiBuildSchemaDir;
    }

    public void setSerializeXSDSchemiBuildSchemaDir(File serializeXSDSchemiBuildSchemaDir) {
        this.serializeXSDSchemiBuildSchemaDir = serializeXSDSchemiBuildSchemaDir;
    }

    public byte[] getSchemaRoot() {
        return this.schemaRoot;
    }

    public void setSchemaRoot(byte[] schemaRoot) {
        this.schemaRoot = schemaRoot;
    }

    public Map<String, byte[]> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, byte[]> resources) {
        this.resources = resources;
    }

    public Map<String, List<String>> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void setMappingNamespaceLocations(Map<String, List<String>> mappingNamespaceLocations) {
        this.mappingNamespaceLocations = mappingNamespaceLocations;
    }

    public void serialize(Logger log, File file) throws XMLException {
        try (FileOutputStream fout = new FileOutputStream(file);){
            this.serialize(log, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void serialize(Logger log, String fileName) throws XMLException {
        try (FileOutputStream fout = new FileOutputStream(fileName);){
            this.serialize(log, fout);
            fout.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public byte[] serialize(Logger log) throws XMLException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.serialize(log, bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void serialize(Logger log, OutputStream out) throws XMLException {
        try (ZipOutputStream zipOut = new ZipOutputStream(out);){
            this.zipSerialize(log, zipOut);
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void zipSerialize(Logger log, ZipOutputStream zipOut) throws XMLException {
        try {
            Object rootPackageDir = "";
            rootPackageDir = "schemi" + File.separatorChar;
            Object nomeFile = "RootSchema.xsd";
            zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
            zipOut.write(this.schemaRoot);
            if (this.resources != null && this.resources.size() > 0) {
                for (String name : this.resources.keySet()) {
                    nomeFile = name;
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    zipOut.write(this.resources.get(name));
                    String namespaceFound = null;
                    String locationFound = null;
                    for (String namespace : this.mappingNamespaceLocations.keySet()) {
                        List<String> split = this.mappingNamespaceLocations.get(namespace);
                        if (split == null) continue;
                        for (int i = 0; i < split.size(); ++i) {
                            if (split.get(i) == null || !split.get(i).equals(nomeFile)) continue;
                            namespaceFound = namespace;
                            locationFound = split.get(i);
                            break;
                        }
                        if (namespaceFound == null) continue;
                        break;
                    }
                    if (namespaceFound == null) continue;
                    nomeFile = name + ".namespace.txt";
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + (String)nomeFile));
                    Object valore = namespaceFound;
                    if (locationFound != null) {
                        valore = locationFound + "\n" + valore;
                    }
                    zipOut.write(((String)valore).getBytes());
                }
            }
            try {
                this.buildSchemaEngine(log, false, false, null);
            }
            catch (Throwable e) {
                log.error("Costruzione Struttura degli Schemi XSD fallita: " + e.getMessage(), e);
                nomeFile = "BuildSchemaFailed.txt";
                zipOut.putNextEntry(new ZipEntry((String)nomeFile));
                String msg = e.getMessage();
                if (msg == null || msg.equals("")) {
                    if (e instanceof NullPointerException) {
                        msg = "Internal Error (NP)";
                    } else {
                        msg = e.toString();
                        if (msg == null || msg.equals("")) {
                            msg = "Internal Error";
                        }
                    }
                }
                zipOut.write(msg.getBytes());
            }
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public Schema buildSchema(Logger logger) throws XMLException {
        return this.buildSchemaEngine(logger, this.serializeXSDSchemiBuildSchemaSuccess, this.serializeXSDSchemiBuildSchemaError, this.serializeXSDSchemiBuildSchemaDir);
    }

    private Schema buildSchemaEngine(Logger logger, boolean serializeXSDSchemiBuildSchemaSuccess, boolean serializeXSDSchemiBuildSchemaError, File serializeXSDSchemiBuildSchemaDir) throws XMLException {
        XSDResourceResolver resourceResolver = new XSDResourceResolver(this.resources);
        try {
            ValidatoreXSD validatoreXSD = new ValidatoreXSD(logger, "org.apache.xerces.jaxp.validation.XMLSchemaFactory", (LSResourceResolver)resourceResolver, (InputStream)new ByteArrayInputStream(this.schemaRoot));
            if (serializeXSDSchemiBuildSchemaSuccess) {
                this.debugPrintXSDSchemi(this.schemaRoot, resourceResolver, logger, true, serializeXSDSchemiBuildSchemaDir);
            }
            return validatoreXSD.getSchema();
        }
        catch (Exception e) {
            if (serializeXSDSchemiBuildSchemaError) {
                this.debugPrintXSDSchemi(this.schemaRoot, resourceResolver, logger, false, serializeXSDSchemiBuildSchemaDir);
            }
            throw new XMLException("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    private void debugPrintXSDSchemi(byte[] schemaPerValidazione, XSDResourceResolver resourceResolver, Logger logger, boolean success, File serializeXSDSchemiBuildSchemaDir) {
        try {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            File dir = null;
            dir = serializeXSDSchemiBuildSchemaDir != null ? Files.createTempDirectory(serializeXSDSchemiBuildSchemaDir.toPath(), "xsd_dir_", attr).toFile() : Files.createTempDirectory("xsd_dir_", attr).toFile();
            boolean dirCreate = dir.exists();
            dirCreate = dirCreate && dir.isDirectory();
            String uniqueID = XSDSchemaCollection.getIdForDebug();
            File f = null;
            f = dirCreate ? File.createTempFile("root_" + uniqueID + "_", ".xsd", dir) : FileSystemUtilities.createTempFile("root_" + uniqueID + "_", ".xsd");
            FileSystemUtilities.writeFile(f, schemaPerValidazione);
            if (resourceResolver != null) {
                XSDResourceResolver xsdResolver = resourceResolver;
                for (String systemId : xsdResolver.getResources().keySet()) {
                    byte[] contenuto = xsdResolver.getResources().get(systemId);
                    File schemaTmpLog = null;
                    schemaTmpLog = dirCreate ? File.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd", dir) : FileSystemUtilities.createTempFile("import_" + uniqueID + "_" + systemId + "_", ".xsd");
                    FileSystemUtilities.writeFile(schemaTmpLog, contenuto);
                }
            }
            String motivo = null;
            motivo = success ? "completata con successo" : "completata con errore";
            String msg = null;
            msg = dirCreate ? "Inizializzazione dello schema " + motivo + ", gli schemi sono stati registrati nella directory " + dir.getAbsolutePath() : "Inizializzazione dello schema " + motivo + ", gli schemi sono stati registrati nella area temporanea (root schema: " + f.getAbsolutePath() + ")";
            if (success) {
                logger.info(msg);
            } else {
                logger.error(msg);
            }
        }
        catch (Exception eDebug) {
            logger.error("Registrazione xsd per debug non riuscita: " + eDebug.getMessage(), (Throwable)eDebug);
        }
    }

    private static synchronized String getIdForDebug() {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        return "ID_" + ++counter + "_" + dateformat.format(DateManager.getDate());
    }
}

