/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml.test;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XSDResourceResolver;
import org.openspcoop2.utils.xml.XSDSchemaCollection;
import org.openspcoop2.utils.xml.XSDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TestXSDUtils {
    public static final String TYPE_CYCLIC_1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<xs:schema targetNamespace=\"http://test.cyclic.org\"\n  elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n  xmlns:sg=\"http://test.cyclic.org\">\n\n  <xs:include schemaLocation=\"cycle_2.xsd\"/>\n\n  <xs:complexType name=\"abstractType\" abstract=\"true\"/>\n\n</xs:schema>";
    public static final String TYPE_CYCLIC_2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<xs:schema targetNamespace=\"http://test.cyclic.org\"\n  elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n  xmlns:sg=\"http://test.cyclic.org\">\n  \n  <xs:include schemaLocation=\"cycle_1.xsd\"/>\n\n</xs:schema>";
    public static final String ROOT_XSD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n\telementFormDefault=\"qualified\"\n\ttargetNamespace=\"http://www.test.org/root\"\n\txmlns:c=\"http://test.cyclic.org\"\n\txmlns:r=\"http://test.root.org\">\n\t\n\t<xs:import namespace=\"http://test.cyclic.org\" schemaLocation=\"cycle_1.xsd\"/>\n\t\t\t\t\n\t<xs:complexType name=\"concreteType\">\n\t\t<xs:complexContent>\n\t\t\t<xs:extension base=\"c:abstractType\">\n\t\t\t</xs:extension>\n\t\t</xs:complexContent>\n\t</xs:complexType>\n\t\n</xs:schema>";

    public static void main(String[] args) throws Exception {
        TestXSDUtils test = new TestXSDUtils();
        test.testCycle();
        System.out.println("Testsuite completata");
    }

    public void testCycle() throws XMLException, SAXException {
        XMLUtils xmlUtils = XMLUtils.getInstance();
        XSDUtils xsdUtils = new XSDUtils(xmlUtils);
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        resources.put("cycle_1.xsd", TYPE_CYCLIC_1.getBytes());
        resources.put("cycle_2.xsd", TYPE_CYCLIC_2.getBytes());
        resources.put("root.xsd", ROOT_XSD.getBytes());
        HashMap<String, List<String>> mappingNamespaceLocation = new HashMap<String, List<String>>();
        mappingNamespaceLocation.put("http://test.cyclic.org", List.of("cycle_1.xsd", "cycle_2.xsd"));
        mappingNamespaceLocation.put("http://www.test.org/root", List.of("root.xsd"));
        Logger logger = LoggerFactory.getLogger(TestXSDUtils.class);
        XSDSchemaCollection collection = xsdUtils.buildSchemaCollection(resources, mappingNamespaceLocation, logger);
        SchemaFactory factory = xmlUtils.getSchemaFactory();
        XSDResourceResolver resourceResolver = new XSDResourceResolver(collection.getResources());
        factory.setResourceResolver(resourceResolver);
        StreamSource schemaSource = new StreamSource(new ByteArrayInputStream(collection.getSchemaRoot()));
        factory.newSchema(schemaSource);
    }
}

