/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.sdk.condition;

import java.lang.reflect.Constructor;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.condition.IFilter;
import org.openspcoop2.monitor.sdk.condition.IStatisticFilter;
import org.openspcoop2.monitor.sdk.condition.StatisticsContext;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.FilterFactoryException;
import org.openspcoop2.monitor.sdk.statistic.IStatistic;
import org.openspcoop2.utils.TipiDatabase;

public class FilterFactory {
    public static IStatisticFilter newFilterStatisticRepository(TipiDatabase tipiDatabase, StatisticType statisticType) throws FilterFactoryException {
        try {
            Class<?> c = Class.forName("org.openspcoop2.monitor.engine.condition.FilterStatisticRepositoryImpl");
            Constructor<?> constructor = c.getConstructor(TipiDatabase.class, StatisticType.class);
            return (IStatisticFilter)constructor.newInstance(new Object[]{tipiDatabase, statisticType});
        }
        catch (Exception e) {
            throw new FilterFactoryException(e);
        }
    }

    public static IStatisticFilter newFilterStatisticRepository(StatisticsContext searchContext) throws FilterFactoryException {
        try {
            TipiDatabase tipiDatabase = searchContext.getDatabaseType();
            if (tipiDatabase == null) {
                throw new Exception("Field 'TipoDatabase' undefinded in SearchContext");
            }
            StatisticType statisticType = searchContext.getStatisticType();
            if (statisticType == null) {
                throw new Exception("Field 'StatisticType' undefinded in SearchContext");
            }
            return FilterFactory.newFilterStatisticRepository(tipiDatabase, statisticType);
        }
        catch (Exception e) {
            throw new FilterFactoryException(e);
        }
    }

    public static IFilter newFilterTransactionRepository(TipiDatabase tipiDatabase) throws FilterFactoryException {
        try {
            Class<?> c = Class.forName("org.openspcoop2.monitor.engine.condition.FilterTransactionRepositoryImpl");
            Constructor<?> constructor = c.getConstructor(TipiDatabase.class);
            return (IFilter)constructor.newInstance(tipiDatabase);
        }
        catch (Exception e) {
            throw new FilterFactoryException(e);
        }
    }

    public static IFilter newFilterTransactionRepository(Context searchContext) throws FilterFactoryException {
        try {
            TipiDatabase tipiDatabase = searchContext.getDatabaseType();
            if (tipiDatabase == null) {
                throw new Exception("Field 'TipoDatabase' undefinded in SearchContext");
            }
            return FilterFactory.newFilterTransactionRepository(tipiDatabase);
        }
        catch (Exception e) {
            throw new FilterFactoryException(e);
        }
    }

    public static IFilter newFilterTransactionRepository(IStatistic context) throws FilterFactoryException {
        try {
            TipiDatabase tipiDatabase = context.getDatabaseType();
            if (tipiDatabase == null) {
                throw new Exception("Field 'TipoDatabase' undefinded in IStatistic");
            }
            return FilterFactory.newFilterTransactionRepository(tipiDatabase);
        }
        catch (Exception e) {
            throw new FilterFactoryException(e);
        }
    }
}

