/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.xml.soap.SOAPEnvelope;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.DigestServiceParams;
import org.openspcoop2.pdd.config.DigestServiceParamsDriver;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.transazioni.Transaction;
import org.openspcoop2.pdd.core.transazioni.TransactionContext;
import org.openspcoop2.pdd.core.transazioni.TransactionNotExistsException;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.AbstractModISecurityToken;
import org.openspcoop2.protocol.modipa.ModIBustaRawContent;
import org.openspcoop2.protocol.modipa.authorization.SignalHubPushParams;
import org.openspcoop2.protocol.modipa.builder.ImbustamentoUtils;
import org.openspcoop2.protocol.modipa.builder.ModIImbustamentoRest;
import org.openspcoop2.protocol.modipa.builder.ModIImbustamentoSoap;
import org.openspcoop2.protocol.modipa.builder.ModIJWTToken;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.constants.ModIHeaderType;
import org.openspcoop2.protocol.modipa.constants.ModISignalHubOperation;
import org.openspcoop2.protocol.modipa.utils.ModIKeystoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.utils.SignalHubUtils;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.IDSerialGenerator;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.digest.DigestConfig;
import org.openspcoop2.utils.digest.DigestFactory;
import org.openspcoop2.utils.digest.IDigest;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.http.MockHttpServletRequest;
import org.openspcoop2.utils.transport.http.MockHttpServletResponse;
import org.openspcoop2.utils.transport.http.MockServletInputStream;
import org.openspcoop2.utils.transport.http.MockServletOutputStream;
import org.slf4j.Logger;

public class ModIImbustamento {
    private Logger log;
    private ModIProperties modiProperties;
    private static final String DIAGNOSTIC_ADD_TOKEN_ID_AUTH = "addTokenIdAuth";
    private static final String DIAGNOSTIC_ADD_TOKEN_INTEGRITY = "addTokenIntegrity";
    private static final String DIAGNOSTIC_IN_CORSO = "inCorso";
    private static final String DIAGNOSTIC_COMPLETATA = "completata";
    private static final String DIAGNOSTIC_FALLITA = "fallita";
    private static final String ERROR_MESSAGE_SEED_NOT_UPDATED = "seed update non riuscito";

    public ModIImbustamento(Logger log) throws ProtocolException {
        this.log = log;
        this.modiProperties = ModIProperties.getInstance();
    }

    private static String getReplyToErogazione(IDSoggetto idSoggettoMittente, AccordoServizioParteComune aspc, String nomePortType, String azione, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo) throws ProtocolException {
        try {
            return ModIUtilities.getReplyToErogazione(idSoggettoMittente, aspc, nomePortType, azione, registryReader, configIntegrationReader, protocolFactory, state, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException("Configurazione presente nel registro non corretta: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String newUniqueIdentifier() throws ProtocolException {
        try {
            return UniqueIdentifierManager.newUniqueIdentifier().getAsString();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    public ProtocolMessage buildMessage(OpenSPCoop2Message msg, Context context, Busta busta, Busta bustaRichiesta, RuoloMessaggio ruoloMessaggio, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException {
        try {
            ProtocolMessage protocolMessage = new ProtocolMessage();
            MessageRole messageRole = MessageRole.REQUEST;
            if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
                messageRole = MessageRole.RESPONSE;
            }
            IDSoggetto idSoggettoMittente = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            IDSoggetto idSoggettoDestinatario = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            IDSoggetto idSoggettoErogatore = null;
            IDSoggetto idSoggettoProprietarioSA = null;
            if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                idSoggettoErogatore = idSoggettoDestinatario;
                idSoggettoProprietarioSA = idSoggettoMittente;
            } else {
                idSoggettoErogatore = idSoggettoMittente;
                idSoggettoProprietarioSA = idSoggettoDestinatario;
            }
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(busta.getTipoServizio(), busta.getServizio(), idSoggettoErogatore, busta.getVersioneServizio().intValue());
            AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio);
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo);
            boolean rest = ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
            IDServizioApplicativo idSA = null;
            ServizioApplicativo sa = null;
            if (MessageRole.REQUEST.equals((Object)messageRole) && busta.getServizioApplicativoFruitore() != null && !"Anonimo".equals(busta.getServizioApplicativoFruitore())) {
                idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idSoggettoProprietarioSA);
                idSA.setNome(busta.getServizioApplicativoFruitore());
                sa = configIntegrationReader.getServizioApplicativo(idSA);
            }
            if (MessageRole.REQUEST.equals((Object)messageRole) && sa == null) {
                IDServizioApplicativo idServizioApplicativoToken = null;
                if (context != null && context.containsKey(Costanti.ID_APPLICATIVO_TOKEN)) {
                    idServizioApplicativoToken = (IDServizioApplicativo)context.getObject(Costanti.ID_APPLICATIVO_TOKEN);
                }
                if (idServizioApplicativoToken != null) {
                    idSA = idServizioApplicativoToken;
                    sa = configIntegrationReader.getServizioApplicativo(idSA);
                }
            }
            String azione = busta.getAzione();
            String nomePortType = asps.getPortType();
            RequestInfo requestInfo = null;
            if (context != null && context.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
            }
            ModIImbustamentoRest imbustamentoRest = null;
            ModIImbustamentoSoap imbustamentoSoap = null;
            if (rest) {
                imbustamentoRest = new ModIImbustamentoRest(this.log);
            } else {
                imbustamentoSoap = new ModIImbustamentoSoap(this.log);
            }
            String interactionProfile = ModIPropertiesUtils.readPropertyInteractionProfile(aspc, nomePortType, azione);
            busta.addProperty("ProfiloInterazione", interactionProfile);
            boolean bulkResource = ModIPropertiesUtils.readPropertyBulkResource(aspc);
            if (bulkResource && context != null) {
                context.addObject(Costanti.MODIPA_BULK_RESOURCE_REST, (Object)"true");
            }
            if ("bloccante".equals(interactionProfile)) {
                if (rest) {
                    imbustamentoRest.addSyncInteractionProfile(msg, ruoloMessaggio);
                }
            } else if ("nonBloccante".equals(interactionProfile)) {
                String asyncInteractionType = ModIPropertiesUtils.readPropertyAsyncInteractionProfile(aspc, nomePortType, azione);
                busta.addProperty("ProfiloInterazioneAsincrona-Tipo", asyncInteractionType);
                String asyncInteractionRole = ModIPropertiesUtils.readPropertyAsyncInteractionRole(aspc, nomePortType, azione);
                busta.addProperty("ProfiloInterazioneAsincrona-Ruolo", asyncInteractionRole);
                String replyTo = null;
                AccordoServizioParteComune apiContenenteRisorsa = null;
                if ("Richiesta".equals(asyncInteractionRole)) {
                    if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) && "PUSH".equals(asyncInteractionType)) {
                        replyTo = ModIImbustamento.getReplyToErogazione(idSoggettoMittente, aspc, nomePortType, azione, registryReader, configIntegrationReader, protocolFactory, state, requestInfo);
                    }
                    apiContenenteRisorsa = aspc;
                } else {
                    if ("PUSH".equals(asyncInteractionType)) {
                        String asyncInteractionRequestApi = ModIPropertiesUtils.readPropertyAsyncInteractionRequestApi(aspc, nomePortType, azione);
                        IDAccordo idApiCorrelata = IDAccordoFactory.getInstance().getIDAccordoFromUri(asyncInteractionRequestApi);
                        String labelApi = NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idApiCorrelata);
                        busta.addProperty("ProfiloInterazioneAsincrona-ApiCorrelata", labelApi);
                        apiContenenteRisorsa = registryReader.getAccordoServizioParteComune(idApiCorrelata, false, false);
                    } else {
                        apiContenenteRisorsa = aspc;
                    }
                    if (rest) {
                        String asyncInteractionRequestResource;
                        String labelResourceCorrelata = asyncInteractionRequestResource = ModIPropertiesUtils.readPropertyAsyncInteractionRequestAction(aspc, nomePortType, azione);
                        for (Resource r : apiContenenteRisorsa.getResourceList()) {
                            if (!r.getNome().equals(asyncInteractionRequestResource)) continue;
                            labelResourceCorrelata = NamingUtils.getLabelResource((Resource)r);
                            break;
                        }
                        busta.addProperty("ProfiloInterazioneAsincrona-RisorsaCorrelata", labelResourceCorrelata);
                    } else {
                        String asyncInteractionRequestService = ModIPropertiesUtils.readPropertyAsyncInteractionRequestService(aspc, nomePortType, azione);
                        busta.addProperty("ProfiloInterazioneAsincrona-ServizioCorrelato", asyncInteractionRequestService);
                        String asyncInteractionRequestAction = ModIPropertiesUtils.readPropertyAsyncInteractionRequestAction(aspc, nomePortType, azione);
                        busta.addProperty("ProfiloInterazioneAsincrona-AzioneCorrelata", asyncInteractionRequestAction);
                    }
                }
                if (rest) {
                    imbustamentoRest.addAsyncInteractionProfile(msg, busta, ruoloMessaggio, asyncInteractionType, asyncInteractionRole, replyTo, apiContenenteRisorsa, azione);
                } else {
                    imbustamentoSoap.addAsyncInteractionProfile(msg, busta, ruoloMessaggio, asyncInteractionType, asyncInteractionRole, replyTo, apiContenenteRisorsa, azione);
                }
            }
            if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) && context.containsKey(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_PUSH_PARAMS)) {
                msg = this.computeSignalHubMessage(msg, context, protocolFactory, state);
            }
            String securityChannelProfile = ModIPropertiesUtils.readPropertySecurityChannelProfile(aspc, asps);
            busta.addProperty("ProfiloSicurezzaCanale", securityChannelProfile);
            boolean isRichiesta = MessageRole.REQUEST.equals((Object)messageRole);
            boolean filterPDND = true;
            String securityMessageProfileNonFiltratoPDND = ModIPropertiesUtils.readPropertySecurityMessageProfile(aspc, nomePortType, azione, !filterPDND);
            boolean existsSecurityFlusso = false;
            if (securityMessageProfileNonFiltratoPDND != null && !"-".equals(securityMessageProfileNonFiltratoPDND)) {
                existsSecurityFlusso = ModIPropertiesUtils.processSecurity(this.log, aspc, nomePortType, azione, isRichiesta, msg, rest, this.modiProperties);
            }
            if (existsSecurityFlusso) {
                boolean securityMessageProfilePrevedeTokenLocale;
                IDSoggetto idSoggetto;
                busta.addProperty("ProfiloSicurezzaMessaggio", ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue(securityMessageProfileNonFiltratoPDND, rest));
                String sorgenteToken = ModIPropertiesUtils.readPropertySecurityMessageSorgenteToken(aspc, nomePortType, azione, true);
                busta.addProperty("GenerazioneTokenIDAuth", ModIPropertiesUtils.convertProfiloSicurezzaSorgenteTokenToSDKValue(sorgenteToken));
                boolean sorgenteLocale = true;
                if ("pdnd".equals(sorgenteToken) || "oauth".equals(sorgenteToken)) {
                    sorgenteLocale = false;
                }
                String securityMessageProfile = ModIPropertiesUtils.readPropertySecurityMessageProfile(aspc, nomePortType, azione, filterPDND);
                boolean sicurezzaRidefinitaOperazione = ModIPropertiesUtils.readSicurezzaMessaggioRidefinitaOperazioneEngine(aspc, nomePortType, azione);
                MsgDiagnostico msgDiag = null;
                TipoPdD tipoPdD = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? TipoPdD.DELEGATA : TipoPdD.APPLICATIVA;
                IDSoggetto iDSoggetto = idSoggetto = TipoPdD.DELEGATA.equals((Object)tipoPdD) ? idSoggettoMittente : idSoggettoDestinatario;
                if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
                    idSoggetto = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(protocolFactory.getProtocol(), requestInfo);
                } else {
                    idSoggetto.setCodicePorta(registryReader.getDominio(idSoggetto));
                }
                msgDiag = MsgDiagnostico.newInstance((TipoPdD)TipoPdD.DELEGATA, (IDSoggetto)idSoggetto, (String)"ModI", requestInfo != null && requestInfo.getProtocolContext() != null ? requestInfo.getProtocolContext().getInterfaceName() : null, (RequestInfo)requestInfo, (IState)state);
                if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                }
                msgDiag.setPddContext(context, protocolFactory);
                String tipoDiagnostico = RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio) ? ".richiesta." : ".risposta.";
                boolean addSecurity = false;
                boolean bl = securityMessageProfilePrevedeTokenLocale = securityMessageProfile != null && !"-".equals(securityMessageProfile);
                if (securityMessageProfilePrevedeTokenLocale) {
                    addSecurity = existsSecurityFlusso;
                }
                boolean corniceSicurezza = ModIPropertiesUtils.isPropertySecurityMessageConCorniceSicurezza(aspc, nomePortType, azione);
                String patternCorniceSicurezza = null;
                String schemaCorniceSicurezza = null;
                if (corniceSicurezza) {
                    patternCorniceSicurezza = ModIPropertiesUtils.readPropertySecurityMessageCorniceSicurezzaPattern(aspc, nomePortType, azione);
                    if (patternCorniceSicurezza == null) {
                        patternCorniceSicurezza = "old";
                    }
                    if (!"old".equals(patternCorniceSicurezza)) {
                        schemaCorniceSicurezza = ModIPropertiesUtils.readPropertySecurityMessageCorniceSicurezzaSchema(aspc, nomePortType, azione);
                    }
                }
                boolean bufferMessageReadOnly = this.modiProperties.isReadByPathBufferEnabled();
                boolean fruizione = isRichiesta;
                boolean addAudit = fruizione && corniceSicurezza && patternCorniceSicurezza != null && !"old".equals(patternCorniceSicurezza);
                boolean keystoreKidMode = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile) || !sorgenteLocale;
                Map dynamicMap = null;
                ModISecurityConfig securityConfig = null;
                ModISecurityConfig securityConfigAudit = null;
                ModIKeystoreConfig keystoreConfig = null;
                boolean keystoreDefinitoInFruizione = false;
                boolean keystoreDefinitoInTokenPolicy = false;
                String tokenPolicyKid = null;
                String tokenPolicyClientId = null;
                String headerTokenRest = null;
                String headerTokenRestIntegrity = null;
                boolean integritaCustom = false;
                if (addSecurity || addAudit) {
                    Map<String, Object> dynamicMapRequest = null;
                    if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
                        dynamicMapRequest = ModIUtilities.removeDynamicMapRequest(context);
                    }
                    if (dynamicMapRequest != null) {
                        dynamicMap = DynamicUtils.buildDynamicMapResponse((OpenSPCoop2Message)msg, (Context)context, (Busta)busta, (Logger)this.log, (boolean)bufferMessageReadOnly, dynamicMapRequest);
                    } else {
                        dynamicMap = DynamicUtils.buildDynamicMap((OpenSPCoop2Message)msg, (Context)context, (Busta)busta, (Logger)this.log, (boolean)bufferMessageReadOnly);
                        ModIUtilities.saveDynamicMapRequest(context, dynamicMap);
                    }
                    Boolean multipleHeaderAuthorizationConfig = null;
                    if (rest) {
                        String[] tmp;
                        headerTokenRest = ModIPropertiesUtils.readPropertySecurityMessageHeader(aspc, nomePortType, azione, isRichiesta, filterPDND);
                        if (headerTokenRest.contains(" ") && (tmp = headerTokenRest.split(" ")) != null && tmp.length == 2 && tmp[0] != null && tmp[1] != null) {
                            headerTokenRest = tmp[0];
                            headerTokenRestIntegrity = tmp[1];
                            multipleHeaderAuthorizationConfig = true;
                        }
                        integritaCustom = ModIPropertiesUtils.isPropertySecurityMessageHeaderCustom(aspc, nomePortType, azione, isRichiesta);
                    }
                    KeystoreParams tokenPolicyKeystore = null;
                    if (isRichiesta) {
                        PolicyNegoziazioneToken pnt;
                        keystoreDefinitoInFruizione = ModIKeystoreConfig.isKeystoreDefinitoInFruizione(idSoggettoMittente, asps);
                        if (!keystoreDefinitoInFruizione) {
                            keystoreDefinitoInTokenPolicy = ModIKeystoreConfig.isKeystoreDefinitoInTokenPolicy(idSoggettoMittente, asps);
                        }
                        StringBuilder sbRequired = new StringBuilder();
                        if (keystoreDefinitoInTokenPolicy && (pnt = ImbustamentoUtils.readPolicyNegoziazioneToken(this.log, state, idSoggettoMittente, idServizio, azione, requestInfo, sbRequired)) != null) {
                            tokenPolicyKeystore = ImbustamentoUtils.readKeystoreParams(this.log, pnt, sbRequired);
                            if (sbRequired.length() <= 0) {
                                tokenPolicyClientId = ImbustamentoUtils.readClientId(this.log, pnt, sbRequired);
                            }
                            if (sbRequired.length() <= 0) {
                                tokenPolicyKid = ImbustamentoUtils.readKID(this.log, pnt, tokenPolicyClientId, tokenPolicyKeystore, sbRequired);
                            }
                            if (sbRequired.length() > 0) {
                                tokenPolicyKeystore = null;
                            }
                        }
                        boolean erroreTP = false;
                        boolean erroreSA = false;
                        if (keystoreDefinitoInTokenPolicy) {
                            if (tokenPolicyKeystore == null) {
                                erroreTP = true;
                            }
                        } else if (!keystoreDefinitoInFruizione && sa == null) {
                            erroreSA = true;
                        }
                        if (erroreTP || erroreSA) {
                            boolean auditMsg = addAudit && patternCorniceSicurezza != null && StringUtils.isNotEmpty((CharSequence)patternCorniceSicurezza);
                            StringBuilder sb = new StringBuilder("'");
                            if (securityMessageProfile != null && StringUtils.isNotEmpty((CharSequence)securityMessageProfile)) {
                                sb.append(securityMessageProfile);
                                if (auditMsg) {
                                    sb.append("' + '").append(patternCorniceSicurezza);
                                }
                            } else if (auditMsg) {
                                sb.append(patternCorniceSicurezza);
                            } else {
                                sb.append("-");
                            }
                            sb.append("'");
                            String descrizioneErrore = erroreTP ? sbRequired.toString() : "l'identificazione di un applicativo";
                            ProtocolException pe = new ProtocolException("Il profilo di sicurezza richiesto " + sb.toString() + " richiede " + descrizioneErrore);
                            pe.setInteroperabilityError(true);
                            throw pe;
                        }
                    }
                    if (addAudit) {
                        securityConfigAudit = new ModISecurityConfig(msg, context, protocolFactory, state, requestInfo, idSoggettoMittente, asps, sa, rest, fruizione, isRichiesta, patternCorniceSicurezza, schemaCorniceSicurezza, busta, bustaRichiesta, multipleHeaderAuthorizationConfig, keystoreDefinitoInFruizione, keystoreDefinitoInTokenPolicy, tokenPolicyKid, tokenPolicyClientId, keystoreKidMode, addSecurity, addAudit);
                    }
                    boolean keystoreKidModeSecurityToken = keystoreKidMode;
                    if (rest && headerTokenRestIntegrity == null && ("idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile))) {
                        keystoreKidModeSecurityToken = false;
                    }
                    securityConfig = new ModISecurityConfig(msg, context, protocolFactory, state, requestInfo, idSoggettoMittente, asps, sa, rest, fruizione, isRichiesta, patternCorniceSicurezza, schemaCorniceSicurezza, busta, bustaRichiesta, multipleHeaderAuthorizationConfig, keystoreDefinitoInFruizione, keystoreDefinitoInTokenPolicy, tokenPolicyKid, tokenPolicyClientId, keystoreKidModeSecurityToken, addSecurity, addAudit);
                    keystoreConfig = isRichiesta ? (keystoreDefinitoInFruizione ? new ModIKeystoreConfig(fruizione, idSoggettoMittente, asps, securityMessageProfile) : (keystoreDefinitoInTokenPolicy ? new ModIKeystoreConfig(tokenPolicyKeystore) : new ModIKeystoreConfig(sa, securityMessageProfile))) : new ModIKeystoreConfig(fruizione, idSoggettoMittente, asps, securityMessageProfile);
                }
                String purposeId = null;
                if (addSecurity || addAudit) {
                    purposeId = ModIPropertiesUtils.readPurposeId(configIntegrationReader, asps, idSoggettoMittente, azione);
                }
                long now = DateManager.getTimeMillis();
                if (addSecurity) {
                    boolean includiRequestDigest = ModIPropertiesUtils.isPropertySecurityMessageIncludiRequestDigest(aspc, nomePortType, azione);
                    boolean signAttachments = false;
                    if (!rest) {
                        signAttachments = ModIPropertiesUtils.isAttachmentsSignature(aspc, nomePortType, azione, isRichiesta, msg);
                    }
                    if (rest) {
                        integritaX509 = "idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile);
                        integritaKid = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                        boolean bl2 = integrita = integritaX509 || integritaKid;
                        if (integrita) {
                            // empty if block
                        }
                        boolean addIntegrity = false;
                        boolean signedHeaders = false;
                        String integrityMode = null;
                        if (securityConfig.getHttpHeaders() != null && !securityConfig.getHttpHeaders().isEmpty()) {
                            Map mapForceTransportHeaders = msg.getForceTransportHeaders();
                            for (String httpHeader : securityConfig.getHttpHeaders()) {
                                List<String> values;
                                if (httpHeader.equalsIgnoreCase("Digest") || (values = ModIImbustamentoRest.getHeaderValues(ruoloMessaggio, msg, mapForceTransportHeaders, httpHeader)) == null || values.isEmpty()) continue;
                                signedHeaders = true;
                                break;
                            }
                        }
                        if (msg.castAsRest().hasContent() || signedHeaders) {
                            addIntegrity = true;
                        } else {
                            integrityMode = ModIPropertiesUtils.getPropertySecurityMessageHeaderCustomMode(aspc, nomePortType, azione, isRichiesta);
                            boolean bl3 = addIntegrity = "always".equals(integrityMode) || isRichiesta && "responsePayload".equals(integrityMode) || !isRichiesta && "requestPayload".equals(integrityMode);
                        }
                        if (headerTokenRestIntegrity == null) {
                            String headerTokenRestOption;
                            boolean opzioneDueHeaderRichiestaGeneraSoloIntegrityRisposta;
                            boolean addToken = false;
                            addToken = sorgenteLocale ? (isRichiesta ? true : (!(opzioneDueHeaderRichiestaGeneraSoloIntegrityRisposta = "autonlyreq_modipa".equals(headerTokenRestOption = ModIPropertiesUtils.readPropertySecurityMessageHeaderRawOptionValue(aspc, nomePortType, azione, isRichiesta))) ? true : addIntegrity)) : addIntegrity;
                            if (addToken) {
                                String prefixMsgDiag = null;
                                prefixMsgDiag = "Authorization".equalsIgnoreCase(headerTokenRest) ? DIAGNOSTIC_ADD_TOKEN_ID_AUTH : DIAGNOSTIC_ADD_TOKEN_INTEGRITY;
                                try {
                                    msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                    ModIJWTToken modiToken = imbustamentoRest.addToken(msg, isRichiesta, context, keystoreConfig, securityConfig, busta, securityMessageProfile, false, headerTokenRest, corniceSicurezza, patternCorniceSicurezza, null, ruoloMessaggio, includiRequestDigest, now, busta.getID(), ModIHeaderType.SINGLE, integritaCustom, integrityMode, dynamicMap, requestInfo, purposeId, sicurezzaRidefinitaOperazione);
                                    protocolMessage.setBustaRawContent((BustaRawContent)new ModIBustaRawContent(headerTokenRest, modiToken.getToken()));
                                    CostantiPdD.addKeywordInCache((MsgDiagnostico)msgDiag, (boolean)modiToken.isInCache(), (Context)context, (MapKey)CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUTHORIZATION);
                                    msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                                }
                                catch (ProtocolException pe) {
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                    msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                    throw pe;
                                }
                            }
                        } else {
                            String jtiAuthorization = busta.getID();
                            String jtiIntegrity = busta.getID();
                            if (!securityConfig.isMultipleHeaderUseSameJti()) {
                                if (securityConfig.isMultipleHeaderUseJtiAuthorizationAsIdMessaggio()) {
                                    jtiIntegrity = ModIImbustamento.newUniqueIdentifier();
                                } else {
                                    jtiAuthorization = ModIImbustamento.newUniqueIdentifier();
                                }
                            }
                            String securityMessageProfileAuthorization = null;
                            securityMessageProfileAuthorization = "idam0301".equals(securityMessageProfile) || "idam0401".equals(securityMessageProfile) ? "idam01" : "idam02";
                            boolean useKIDforIdAUTH = false;
                            if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile)) {
                                useKIDforIdAUTH = true;
                            }
                            ModIJWTToken modiTokenAuthorization = null;
                            try {
                                msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                modiTokenAuthorization = imbustamentoRest.addToken(msg, isRichiesta, context, keystoreConfig, securityConfig, busta, securityMessageProfileAuthorization, useKIDforIdAUTH, headerTokenRest, corniceSicurezza, patternCorniceSicurezza, null, ruoloMessaggio, includiRequestDigest, now, jtiAuthorization, ModIHeaderType.BOTH_AUTH, integritaCustom, integrityMode, dynamicMap, requestInfo, purposeId, sicurezzaRidefinitaOperazione);
                                CostantiPdD.addKeywordInCache((MsgDiagnostico)msgDiag, (boolean)modiTokenAuthorization.isInCache(), (Context)context, (MapKey)CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUTHORIZATION);
                                msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                            }
                            catch (ProtocolException pe) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                throw pe;
                            }
                            ModIJWTToken modiTokenIntegrity = null;
                            if (addIntegrity) {
                                try {
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                    boolean keystoreKidModeIntegrity = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                                    ModISecurityConfig securityConfigIntegrity = new ModISecurityConfig(msg, context, protocolFactory, state, requestInfo, idSoggettoMittente, asps, sa, rest, fruizione, isRichiesta, patternCorniceSicurezza, schemaCorniceSicurezza, busta, bustaRichiesta, false, keystoreDefinitoInFruizione, keystoreDefinitoInTokenPolicy, tokenPolicyKid, tokenPolicyClientId, keystoreKidModeIntegrity, addSecurity, addAudit);
                                    modiTokenIntegrity = imbustamentoRest.addToken(msg, isRichiesta, context, keystoreConfig, securityConfigIntegrity, busta, securityMessageProfile, false, headerTokenRestIntegrity, corniceSicurezza, patternCorniceSicurezza, null, ruoloMessaggio, includiRequestDigest, now, jtiIntegrity, ModIHeaderType.BOTH_INTEGRITY, integritaCustom, integrityMode, dynamicMap, requestInfo, purposeId, sicurezzaRidefinitaOperazione);
                                    CostantiPdD.addKeywordInCache((MsgDiagnostico)msgDiag, (boolean)modiTokenIntegrity.isInCache(), (Context)context, (MapKey)CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_INTEGRITY);
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                                }
                                catch (ProtocolException pe) {
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_ADD_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                    throw pe;
                                }
                            }
                            if (modiTokenIntegrity != null) {
                                protocolMessage.setBustaRawContent((BustaRawContent)new ModIBustaRawContent(modiTokenAuthorization.getToken(), headerTokenRestIntegrity, modiTokenIntegrity.getToken()));
                            } else {
                                protocolMessage.setBustaRawContent((BustaRawContent)new ModIBustaRawContent(headerTokenRest, modiTokenAuthorization.getToken()));
                            }
                        }
                    } else {
                        integritaX509 = "idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile);
                        integritaKid = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                        integrita = integritaX509 || integritaKid;
                        String prefixMsgDiag = null;
                        MapKey mapKey = null;
                        if (integrita) {
                            prefixMsgDiag = DIAGNOSTIC_ADD_TOKEN_INTEGRITY;
                            mapKey = CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_INTEGRITY;
                        } else {
                            prefixMsgDiag = DIAGNOSTIC_ADD_TOKEN_ID_AUTH;
                            mapKey = CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUTHORIZATION;
                        }
                        try {
                            msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                            boolean corniceSicurezzaLegacySoap = corniceSicurezza && !addAudit;
                            SOAPEnvelope env = imbustamentoSoap.addSecurity(msg, isRichiesta, context, keystoreConfig, securityConfig, busta, securityMessageProfile, corniceSicurezzaLegacySoap, ruoloMessaggio, includiRequestDigest, signAttachments, dynamicMap, requestInfo);
                            protocolMessage.setBustaRawContent((BustaRawContent)new ModIBustaRawContent(env));
                            CostantiPdD.addKeywordInCache((MsgDiagnostico)msgDiag, (boolean)false, (Context)context, (MapKey)mapKey);
                            msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                        }
                        catch (ProtocolException pe) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                            msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                            throw pe;
                        }
                    }
                }
                if (addAudit) {
                    busta.addProperty("ProfiloSicurezzaAudit", ModIPropertiesUtils.convertProfiloAuditToSDKValue(patternCorniceSicurezza));
                    busta.addProperty("ProfiloSicurezzaAudit-SchemaDati", ModIPropertiesUtils.convertSchemaAuditToSDKValue(schemaCorniceSicurezza, this.modiProperties));
                    if (imbustamentoRest == null) {
                        imbustamentoRest = new ModIImbustamentoRest(this.log);
                    }
                    String securityMessageProfileAudit = null;
                    securityMessageProfileAudit = "idam0301".equals(securityMessageProfile) || "idam0401".equals(securityMessageProfile) ? "idam01" : "idam02";
                    boolean useKIDforAudit = false;
                    if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile) || !sorgenteLocale) {
                        useKIDforAudit = true;
                    }
                    String headerTokenAudit = this.modiProperties.getSecurityTokenHeaderModIAudit();
                    String jtiAudit = ModIImbustamento.newUniqueIdentifier();
                    try {
                        msgDiag.logPersonalizzato("addTokenAudit.richiesta.inCorso");
                        ModIJWTToken modiTokenAudit = imbustamentoRest.addToken(msg, isRichiesta, context, keystoreConfig, securityConfigAudit, busta, securityMessageProfileAudit, useKIDforAudit, headerTokenAudit, corniceSicurezza, patternCorniceSicurezza, schemaCorniceSicurezza, ruoloMessaggio, false, now, jtiAudit, ModIHeaderType.SINGLE, false, null, dynamicMap, requestInfo, purposeId, sicurezzaRidefinitaOperazione);
                        if (protocolMessage.getBustaRawContent() instanceof ModIBustaRawContent) {
                            ModIBustaRawContent raw = (ModIBustaRawContent)protocolMessage.getBustaRawContent();
                            ((AbstractModISecurityToken)raw.getElement()).setTokenAudit(headerTokenAudit, modiTokenAudit.getToken());
                        }
                        CostantiPdD.addKeywordInCache((MsgDiagnostico)msgDiag, (boolean)modiTokenAudit.isInCache(), (Context)context, (MapKey)CostantiPdD.KEY_INFO_IN_CACHE_FUNZIONE_MODI_TOKEN_AUDIT);
                        msgDiag.logPersonalizzato("addTokenAudit.richiesta.completata");
                    }
                    catch (ProtocolException pe) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                        msgDiag.logPersonalizzato("addTokenAudit.richiesta.fallita");
                        throw pe;
                    }
                }
            }
            protocolMessage.setMessage(msg);
            return protocolMessage;
        }
        catch (ProtocolException pe) {
            if (pe.isInteroperabilityError() && context != null) {
                context.addObject(Costanti.ERRORE_VALIDAZIONE_PROTOCOLLO, (Object)"true");
            }
            throw pe;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private OpenSPCoop2Message computeSignalHubMessage(OpenSPCoop2Message msg, Context context, IProtocolFactory<?> protocolFactory, IState state) throws ProtocolException, UtilsException, DriverConfigurazioneException {
        Long signalId;
        SignalHubPushParams params = SignalHubPushParams.load((org.openspcoop2.utils.Map<Object>)context);
        IDServizio idServizio = params.getIdServizio();
        String objectId = params.getObjectId();
        String objectType = params.getObjectType();
        ModISignalHubOperation signalType = params.getSignalType();
        String serviceId = params.getEServiceId();
        ConfigurazionePdD config = protocolFactory.getConfigurazionePdD();
        IDSerialGenerator serialGenerator = new IDSerialGenerator(config.getLog(), state, config.getTipoDatabase());
        IDSerialGeneratorParameter serialGeneratorParameter = new IDSerialGeneratorParameter(protocolFactory.getProtocol());
        serialGeneratorParameter.setSerializableTimeWaitMs(config.getAttesaAttivaJDBC());
        serialGeneratorParameter.setSerializableNextIntervalTimeMs(config.getCheckIntervalJDBC());
        serialGeneratorParameter.setTipo(IDSerialGeneratorType.NUMERIC);
        serialGeneratorParameter.setWrap(true);
        serialGeneratorParameter.setSize(Integer.valueOf(256));
        serialGeneratorParameter.setMaxValue(Long.valueOf(Long.MAX_VALUE));
        serialGeneratorParameter.setInformazioneAssociataAlProgressivo(serviceId);
        if (signalType.equals((Object)ModISignalHubOperation.SEEDUPDATE)) {
            signalId = Long.valueOf(objectId);
            objectId = "-";
            objectType = "-";
        } else {
            boolean pseudonymizationEnabled = this.isPseudonymizationEnabled(context);
            if (pseudonymizationEnabled) {
                DigestServiceParams param = this.obtainDigestServiceParam(context, idServizio, serialGenerator, serialGeneratorParameter);
                DigestConfig digestConfig = new DigestConfig();
                digestConfig.setDigestType(param.getDigestAlgorithm());
                digestConfig.setSaltLength(Integer.valueOf(param.getSeed().length));
                digestConfig.setHashComposition(this.modiProperties.getSignalHubHashCompose());
                digestConfig.setBase64Encode(true);
                IDigest digestGenerator = DigestFactory.getDigest((Logger)this.log, (DigestConfig)digestConfig);
                objectId = new String(digestGenerator.digest(objectId.getBytes(), param.getSeed()));
            }
            signalId = Long.valueOf(serialGenerator.buildID(serialGeneratorParameter));
        }
        JSONUtils jsonUtils = JSONUtils.getInstance();
        ObjectNode root = jsonUtils.newObjectNode();
        root.put("signalId", signalId);
        root.put("objectType", objectType);
        root.put("objectId", objectId);
        root.put("eserviceId", serviceId);
        root.put("signalType", signalType.toString());
        TransportRequestContext transportRequestContext = msg.getTransportRequestContext();
        String protocolName = msg.getProtocolName();
        String transactionId = msg.getTransactionId();
        msg = OpenSPCoop2MessageFactory.getDefaultMessageFactory().createMessage(msg.getMessageType(), msg.getMessageRole(), "application/json", jsonUtils.toByteArray((JsonNode)root)).getMessage();
        msg.setTransportRequestContext(transportRequestContext);
        msg.setProtocolName(protocolName);
        msg.setTransactionId(transactionId);
        return msg;
    }

    private boolean isPseudonymizationEnabled(Context context) throws ProtocolException {
        List<ProtocolProperty> eServiceProperties = SignalHubUtils.obtainSignalHubProtocolProperty(context);
        if (!this.modiProperties.isSignalHubPseudonymizationChoiceEnabled()) {
            return true;
        }
        for (ProtocolProperty pp : eServiceProperties) {
            if (!"modipaInfoGenSignalHubPseudonymization".equals(pp.getName())) continue;
            if (pp.getBooleanValue() != null) {
                return pp.getBooleanValue();
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DigestServiceParams obtainDigestServiceParam(Context context, IDServizio idServizio, IDSerialGenerator serialGenerator, IDSerialGeneratorParameter serialGeneratorParameter) throws ProtocolException, UtilsException, DriverConfigurazioneException {
        IDriverConfigurazioneGet db = ConfigurazionePdDReader.getDriverConfigurazionePdD();
        if (!(db instanceof DriverConfigurazioneDB)) {
            throw new ProtocolException("driver db non trovato");
        }
        DigestServiceParamsDriver driver = new DigestServiceParamsDriver((DriverConfigurazioneDB)db);
        DigestServiceParams param = driver.getLastEntry(idServizio);
        if (param == null || !driver.isValid(param)) {
            RequestInfo reqInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
            driver.acquireLock(reqInfo.getIdTransazione());
            try {
                param = driver.getLastEntry(idServizio);
                if (param != null && driver.isValid(param)) {
                    DigestServiceParams digestServiceParams = param;
                    return digestServiceParams;
                }
                List<ProtocolProperty> eServiceProperties = SignalHubUtils.obtainSignalHubProtocolProperty(context);
                if (param == null) {
                    param = SignalHubUtils.generateDigestServiceParams(idServizio, eServiceProperties, null);
                    driver.addNewEntry(param);
                    DigestServiceParams digestServiceParams = param;
                    return digestServiceParams;
                }
                String seedSignalId = serialGenerator.buildID(serialGeneratorParameter);
                param = SignalHubUtils.generateDigestServiceParams(idServizio, eServiceProperties, Long.valueOf(seedSignalId));
                this.sendSeedUpdateRequest(context, eServiceProperties, seedSignalId);
                driver.addNewEntry(param);
            }
            finally {
                driver.releaseLock();
            }
            driver.removeOldEntries(idServizio, this.modiProperties.getSignalHubDigestHistroy());
        }
        return param;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendSeedUpdateRequest(Context context, List<ProtocolProperty> eServiceProperties, String seedSignalId) throws ProtocolException {
        RequestInfo reqInfo = (RequestInfo)context.getObject(Costanti.REQUEST_INFO);
        String eServiceId = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry(eServiceProperties, (String)"modipaInfoGenEserviceId");
        MockHttpServletRequest req = new MockHttpServletRequest(reqInfo.getProtocolContext().getHttpServletRequest());
        MockHttpServletResponse res = new MockHttpServletResponse(reqInfo.getProtocolContext().getHttpServletResponse());
        Transaction transaction = null;
        try (MockServletInputStream is4 = new MockServletInputStream();){
            req.setInputStream(is4);
            req.setHeader("GovWay-Signal-Type", List.of(ModISignalHubOperation.SEEDUPDATE.toString()));
            req.setHeader("GovWay-Signal-ObjectId", List.of(seedSignalId));
            req.setHeader("GovWay-Signal-ObjectType", List.of("seed"));
            req.setHeader("GovWay-Signal-ServiceId", List.of(eServiceId));
            req.setHeader("Content-Length", List.of("0"));
            req.setHeader("Content-Type", null);
            transaction = TransactionContext.removeTransaction((String)reqInfo.getIdTransazione());
            req.getRequestDispatcher(req.getPathInfo()).include((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            try {
                throw this.newSeedUpdateException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (transaction == null) throw throwable;
                    TransactionContext.setTransactionThreadLocal((String)reqInfo.getIdTransazione(), transaction);
                    throw throwable;
                }
                catch (TransactionNotExistsException transactionNotExistsException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (transaction != null) {
                TransactionContext.setTransactionThreadLocal((String)reqInfo.getIdTransazione(), (Transaction)transaction);
            }
        }
        catch (TransactionNotExistsException is4) {}
        try {
            if (res.getStatus() != 200) {
                throw this.newSeedUpdateException("returnCode:" + res.getStatus());
            }
            byte[] out = ((MockServletOutputStream)res.getOutputStream()).getByteArrayOutputStream().toByteArray();
            JSONUtils jsonUtils = JSONUtils.getInstance();
            JsonNode node = jsonUtils.getAsNode(out);
            if (!node.get("signalId").isNull()) return;
            throw this.newSeedUpdateException("signalId is null");
        }
        catch (IOException | UtilsException e) {
            throw this.newSeedUpdateException((Exception)e, "seed response invalid");
        }
    }

    private ProtocolException newSeedUpdateException(Exception e) {
        return this.newSeedUpdateException(e, null);
    }

    private ProtocolException newSeedUpdateException(String posizione) {
        return this.newSeedUpdateException(null, posizione);
    }

    private ProtocolException newSeedUpdateException(Exception e, String posizione) {
        Object msgError = posizione != null ? " (" + posizione + ")" : "";
        msgError = ERROR_MESSAGE_SEED_NOT_UPDATED + (String)msgError;
        if (this.log != null && e != null) {
            this.log.error("{}: {}", new Object[]{msgError, e.getMessage(), e});
        }
        return new ProtocolException((String)msgError);
    }
}

