/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.builder;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.CostantiLabel;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingUtilities;
import org.openspcoop2.message.soap.wsaddressing.WSAddressingValue;
import org.openspcoop2.message.xml.MessageDynamicNamespaceContextFactory;
import org.openspcoop2.message.xml.XPathExpressionEngine;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.byok.BYOKUnwrapPolicyUtilities;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.utils.ModIKeystoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.utils.SOAPHeader;
import org.openspcoop2.protocol.modipa.validator.ModISOAPSecurity;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.SoapMessageSecurityToken;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.constants.SignatureDigestAlgorithm;
import org.openspcoop2.security.message.engine.MessageSecurityContext_impl;
import org.openspcoop2.security.message.wss4j.MessageSecuritySender_wss4j;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.xml.XPathNotFoundException;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModIImbustamentoSoap {
    private Logger log;
    private ModIProperties modiProperties;
    private static boolean senderVouche = true;
    private static final String ATTR_0 = "ATTR_0";
    private static final String ATTR_1 = "ATTR_1";
    private static final String ATTR_2 = "ATTR_2";

    public ModIImbustamentoSoap(Logger log) throws ProtocolException {
        this.log = log;
        this.modiProperties = ModIProperties.getInstance();
    }

    private static String getHeaderSoapPrefix(String hdr) {
        return "Header SOAP '" + hdr + "'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAsyncInteractionProfile(OpenSPCoop2Message msg, Busta busta, RuoloMessaggio ruoloMessaggio, String asyncInteractionType, String asyncInteractionRole, String replyTo, AccordoServizioParteComune apiContenenteRisorsa, String azione) throws ProtocolException {
        if (apiContenenteRisorsa == null || azione != null) {
            // empty if block
        }
        OpenSPCoop2SoapMessage soapMessage = null;
        try {
            soapMessage = msg.castAsSoap();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        boolean bufferMessageReadOnly = true;
        String idTransazione = soapMessage.getTransactionId();
        if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
            if ("PUSH".equals(asyncInteractionType)) {
                if (!"Richiesta".equals(asyncInteractionRole)) {
                    if (!"Risposta".equals(asyncInteractionRole)) return;
                    this.processCorrelationId(soapMessage, busta, true, asyncInteractionType, true);
                    return;
                }
                if (this.modiProperties.isSoapSecurityTokenPushReplyToUpdateOrCreateInFruizione()) {
                    ModIUtilities.addSOAPHeaderReplyTo(soapMessage, !bufferMessageReadOnly, idTransazione, replyTo);
                    busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyTo);
                    return;
                }
                String replyToFound = ModIUtilities.getSOAPHeaderReplyToValue(soapMessage, bufferMessageReadOnly, idTransazione);
                if (replyToFound != null && !"".equals(replyToFound)) {
                    busta.addProperty("ProfiloInterazioneAsincrona-ReplyTo", replyToFound);
                    return;
                }
                ProtocolException pe = new ProtocolException(ModIImbustamentoSoap.getHeaderSoapPrefix(this.modiProperties.getSoapReplyToName()) + ", richiesto dal profilo non bloccante PUSH, non trovato");
                pe.setInteroperabilityError(true);
                throw pe;
            }
            if (!"RichiestaStato".equals(asyncInteractionRole)) {
                if (!"Risposta".equals(asyncInteractionRole)) return;
            }
            this.processCorrelationId(soapMessage, busta, true, asyncInteractionType, true);
            return;
        }
        if ("PUSH".equals(asyncInteractionType)) {
            if (!"Richiesta".equals(asyncInteractionRole)) return;
            boolean foundCorrelationId = this.processCorrelationId(soapMessage, busta, false, asyncInteractionType, false);
            if (foundCorrelationId) return;
            if (!this.modiProperties.isSoapSecurityTokenPushCorrelationIdUseTransactionIdIfNotExists()) {
                ProtocolException pe = new ProtocolException(ModIImbustamentoSoap.getHeaderSoapPrefix(this.modiProperties.getSoapCorrelationIdName()) + ", richiesto dal profilo non bloccante PUSH, non trovato");
                pe.setInteroperabilityError(true);
                throw pe;
            }
            ModIUtilities.addSOAPHeaderCorrelationId(soapMessage, !bufferMessageReadOnly, idTransazione, idTransazione);
            busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", idTransazione);
            busta.setCollaborazione(idTransazione);
            return;
        }
        if (!"Richiesta".equals(asyncInteractionRole)) return;
        boolean foundCorrelationId = this.processCorrelationId(soapMessage, busta, false, asyncInteractionType, false);
        if (foundCorrelationId) return;
        if (!this.modiProperties.isSoapSecurityTokenPullCorrelationIdUseTransactionIdIfNotExists()) {
            ProtocolException pe = new ProtocolException(ModIImbustamentoSoap.getHeaderSoapPrefix(this.modiProperties.getSoapCorrelationIdName()) + ", richiesto dal profilo non bloccante PULL, non trovato");
            pe.setInteroperabilityError(true);
            throw pe;
        }
        ModIUtilities.addSOAPHeaderCorrelationId(soapMessage, !bufferMessageReadOnly, idTransazione, idTransazione);
        busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", idTransazione);
        busta.setCollaborazione(idTransazione);
    }

    private boolean processCorrelationId(OpenSPCoop2SoapMessage soapMessage, Busta busta, boolean notFoundException, String profilo, boolean useAlternativeMethod) throws ProtocolException {
        boolean bufferMessageReadOnly = true;
        String idTransazione = soapMessage.getTransactionId();
        String correlationIdFound = ModIUtilities.getSOAPHeaderCorrelationIdValue(soapMessage, bufferMessageReadOnly, idTransazione);
        if (correlationIdFound != null && !"".equals(correlationIdFound)) {
            busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", correlationIdFound);
            if (correlationIdFound.length() <= 255) {
                busta.setCollaborazione(correlationIdFound);
            }
            return true;
        }
        if (useAlternativeMethod) {
            String headerCorrelationIdHttp = this.modiProperties.getRestCorrelationIdHeader();
            String correlationIdFoundHttp = null;
            if (soapMessage.getTransportRequestContext() != null) {
                correlationIdFoundHttp = soapMessage.getTransportRequestContext().getHeaderFirstValue(headerCorrelationIdHttp);
            } else if (soapMessage.getTransportResponseContext() != null) {
                correlationIdFoundHttp = soapMessage.getTransportResponseContext().getHeaderFirstValue(headerCorrelationIdHttp);
            }
            if (correlationIdFoundHttp != null && !"".equals(correlationIdFoundHttp)) {
                busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", correlationIdFoundHttp);
                if (correlationIdFoundHttp.length() <= 255) {
                    busta.setCollaborazione(correlationIdFoundHttp);
                }
                ModIUtilities.addSOAPHeaderCorrelationId(soapMessage, !bufferMessageReadOnly, idTransazione, correlationIdFoundHttp);
                return true;
            }
            if (busta.getCollaborazione() != null) {
                busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", busta.getCollaborazione());
                ModIUtilities.addSOAPHeaderCorrelationId(soapMessage, !bufferMessageReadOnly, idTransazione, busta.getCollaborazione());
                return true;
            }
            if (busta.getRiferimentoMessaggio() != null) {
                busta.setCollaborazione(busta.getRiferimentoMessaggio());
                busta.addProperty("ProfiloInterazioneAsincrona-CorrelationID", busta.getRiferimentoMessaggio());
                ModIUtilities.addSOAPHeaderCorrelationId(soapMessage, !bufferMessageReadOnly, idTransazione, busta.getRiferimentoMessaggio());
                return true;
            }
        }
        if (notFoundException) {
            ProtocolException pe = new ProtocolException(ModIImbustamentoSoap.getHeaderSoapPrefix(this.modiProperties.getSoapCorrelationIdName()) + ", richiesto dal profilo non bloccante " + profilo + ", non trovato");
            pe.setInteroperabilityError(true);
            throw pe;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public SOAPEnvelope addSecurity(OpenSPCoop2Message msg, boolean request, Context context, ModIKeystoreConfig keystoreConfig, ModISecurityConfig securityConfig, Busta busta, String securityMessageProfile, boolean corniceSicurezza, RuoloMessaggio ruoloMessaggio, boolean includiRequestDigest, boolean signAttachments, Map<String, Object> dynamicMap, RequestInfo requestInfo) throws ProtocolException {
        modIProperties = ModIProperties.getInstance();
        v0 = messageFactory = msg != null ? msg.getFactory() : OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        if (msg == null) {
            throw new ProtocolException("Param msg is null");
        }
        soapMessage = null;
        soapEnvelope = null;
        try {
            soapMessage = msg.castAsSoap();
            soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        bufferMessageReadOnly = true;
        idTransazione = soapMessage.getTransactionId();
        integritaX509 = "idam0301".equals(securityMessageProfile) != false || "idam0302".equals(securityMessageProfile) != false;
        integritaKid = "idam0401".equals(securityMessageProfile) != false || "idam0402".equals(securityMessageProfile) != false;
        v1 = integrita = integritaX509 != false || integritaKid != false;
        if (integritaKid) {
            labelPattern = "idam0401".equals(securityMessageProfile) != false ? "INTEGRITY_REST_02 con ID_AUTH_REST_01" : "INTEGRITY_REST_02 con ID_AUTH_REST_02";
            throw new ProtocolException("Sicurezza Messaggio con pattern '" + labelPattern + "' non utilizzabile su API SOAP");
        }
        requestDigest = null;
        if (integrita && RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio) && includiRequestDigest && context.containsKey(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST)) {
            o = context.getObject(ModICostanti.MODIPA_CONTEXT_REQUEST_DIGEST);
            nodeList = (NodeList)o;
            requestDigest = ModIUtilities.addSOAPHeaderRequestDigest(soapMessage, bufferMessageReadOnly == false, idTransazione, nodeList);
        }
        wsaddressingUtilities = new WSAddressingUtilities(this.log);
        wsAddressingValue = new WSAddressingValue();
        if (busta.getID() != null) {
            wsAddressingValue.setId(busta.getID());
            busta.addProperty("ProfiloSicurezzaMessaggio-MessageId", busta.getID());
        }
        if (securityConfig.getAudience() != null) {
            audience = securityConfig.getAudience();
            if (RuoloMessaggio.RICHIESTA.equals((Object)ruoloMessaggio)) {
                try {
                    audience = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-WSA-To", audience, dynamicMap, context);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    pe = new ProtocolException(e.getMessage());
                    pe.setInteroperabilityError(true);
                    throw pe;
                }
            }
            wsAddressingValue.setTo(audience);
            busta.addProperty("ProfiloSicurezzaMessaggio-WSA-To", audience);
        }
        if (securityConfig.getClientId() != null) {
            wsAddressingValue.setFrom(securityConfig.getClientId());
            busta.addProperty("ProfiloSicurezzaMessaggio-WSA-From", securityConfig.getClientId());
        }
        if (busta.getRiferimentoMessaggio() != null) {
            add = true;
            if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
                buildSecurityTokenInRequest = false;
                buildSecurityTokenInRequestObject = null;
                if (context != null && (buildSecurityTokenInRequestObject = context.getObject(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_BUILD_SECURITY_REQUEST_TOKEN)) instanceof Boolean) {
                    buildSecurityTokenInRequest = (Boolean)buildSecurityTokenInRequestObject;
                }
                add = buildSecurityTokenInRequest;
            }
            if (add) {
                wsAddressingValue.setRelatesTo(busta.getRiferimentoMessaggio());
                busta.addProperty("ProfiloSicurezzaMessaggio-RelatesTo", busta.getRiferimentoMessaggio());
            }
        }
        wsAddressingValue.setReplyToAnonymouys();
        if (this.modiProperties.isSoapSecurityTokenWsaToSoapAction()) {
            try {
                if (soapMessage.getSoapAction() == null) ** GOTO lbl73
                soapAction = soapMessage.getSoapAction();
                if ((soapAction = soapAction.trim()).startsWith("\"") && soapAction.length() > 1) {
                    soapAction = soapAction.substring(1);
                }
                if (soapAction.endsWith("\"") && soapAction.length() > 1) {
                    soapAction = soapAction.substring(0, soapAction.length() - 1);
                }
                wsAddressingValue.setAction(soapAction);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        } else if (this.modiProperties.isSoapSecurityTokenWsaToOperation()) {
            wsAddressingValue.setAction(busta.getAzione());
        }
lbl73:
        // 5 sources

        wsAddressingHeaders = null;
        try {
            wsAddressingHeaders = wsaddressingUtilities.build(soapMessage, modIProperties.getSoapWSAddressingActor(), modIProperties.isSoapWSAddressingMustUnderstand(), wsAddressingValue);
            wsaddressingUtilities.addHeader(wsAddressingHeaders, soapMessage);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        wss4jSignature = new MessageSecuritySender_wss4j();
        messageSecurityContextParameters = new MessageSecurityContextParameters();
        messageSecurityContextParameters.setFunctionAsClient(true);
        messageSecurityContextParameters.setPrefixWsuId(OpenSPCoop2Properties.getInstance().getPrefixWsuId());
        messageSecurityContext = new MessageSecurityContext_impl(messageSecurityContextParameters);
        secProperties = new HashMap<String, Object>();
        secProperties.put("securityEngine", "wss4j");
        if (modIProperties.getSoapSecurityTokenActor() != null && !"".equals(modIProperties.getSoapSecurityTokenActor())) {
            secProperties.put("actor", modIProperties.getSoapSecurityTokenActor());
        }
        secProperties.put("mustUnderstand", "" + modIProperties.isSoapSecurityTokenMustUnderstand());
        secProperties.put("timeToLive", "" + securityConfig.getTtlSeconds());
        secProperties.put("isBSPCompliant", "true");
        if (RuoloMessaggio.RISPOSTA.equals((Object)ruoloMessaggio)) {
            corniceSicurezza = false;
        }
        if (corniceSicurezza) {
            this.addCorniceSicurezza(secProperties, context, busta, securityConfig, dynamicMap);
        }
        bfAction = new StringBuilder();
        if (corniceSicurezza) {
            bfAction.append("SAMLTokenUnsigned").append(" ");
        }
        bfAction.append("Timestamp").append(" ").append("Signature");
        secProperties.put("action", bfAction.toString());
        soapHeaderAggiuntiviDaFirmare = securityConfig.getSoapHeaders();
        bf = new StringBuilder();
        this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
        if (wsAddressingHeaders.getTo() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getTo().getNamespaceURI(), wsAddressingHeaders.getTo().getLocalName());
        }
        if (wsAddressingHeaders.getFrom() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getFrom().getNamespaceURI(), wsAddressingHeaders.getFrom().getLocalName());
        }
        if (wsAddressingHeaders.getAction() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getAction().getNamespaceURI(), wsAddressingHeaders.getAction().getLocalName());
        }
        if (wsAddressingHeaders.getId() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getId().getNamespaceURI(), wsAddressingHeaders.getId().getLocalName());
        }
        if (wsAddressingHeaders.getRelatesTo() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getRelatesTo().getNamespaceURI(), wsAddressingHeaders.getRelatesTo().getLocalName());
        }
        if (wsAddressingHeaders.getReplyTo() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getReplyTo().getNamespaceURI(), wsAddressingHeaders.getReplyTo().getLocalName());
        }
        if (wsAddressingHeaders.getFaultTo() != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, wsAddressingHeaders.getFaultTo().getNamespaceURI(), wsAddressingHeaders.getFaultTo().getLocalName());
        }
        if (integrita) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, soapEnvelope.getNamespaceURI(), "Body");
            if (signAttachments) {
                if (bf.length() > 0) {
                    bf.append(";");
                }
                bf.append("{}cid:Attachments");
                busta.addProperty("ProfiloSicurezzaMessaggioSignedSoap-Attachments", "tutti");
            }
        }
        if (corniceSicurezza) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        }
        if (requestDigest != null) {
            this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, requestDigest.getNamespaceURI(), requestDigest.getLocalName());
        }
        if (soapHeaderAggiuntiviDaFirmare != null) {
            while (!soapHeaderAggiuntiviDaFirmare.isEmpty()) {
                soapHeader = soapHeaderAggiuntiviDaFirmare.get(0);
                this.addSignaturePart(soapHeaderAggiuntiviDaFirmare, busta, bf, soapHeader.getNamespace(), soapHeader.getLocalName());
            }
        }
        secProperties.put("signatureParts", bf.toString());
        secProperties.put("signatureAlgorithm", securityConfig.getAlgorithm());
        secProperties.put("signatureC14nAlgorithm", securityConfig.getC14nAlgorithm());
        secProperties.put("signatureDigestAlgorithm", securityConfig.getDigestAlgorithm());
        secProperties.put("signatureKeyIdentifier", securityConfig.getKeyIdentifierMode());
        if ("DirectReference".equals(securityConfig.getKeyIdentifierMode())) {
            secProperties.put("useSingleCertificate", "" + securityConfig.isUseSingleCertificate());
        } else if ("IssuerSerial".equals(securityConfig.getKeyIdentifierMode()) || "Thumbprint".equals(securityConfig.getKeyIdentifierMode()) || "SKIKeyIdentifier".equals(securityConfig.getKeyIdentifierMode())) {
            secProperties.put("includeSignatureToken", "" + securityConfig.isIncludeSignatureToken());
        }
        pKeystore = new Properties();
        pKeystore.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
        pKeystore.put("org.apache.ws.security.crypto.merlin.keystore.type", keystoreConfig.getSecurityMessageKeystoreType());
        if (keystoreConfig.getSecurityMessageKeystorePassword() != null) {
            pKeystore.put("org.apache.ws.security.crypto.merlin.keystore.password", keystoreConfig.getSecurityMessageKeystorePassword());
        }
        if (keystoreConfig.getSecurityMessageKeystorePath() != null || keystoreConfig.isSecurityMessageKeystoreHSM()) {
            if (CostantiDB.KEYSTORE_TYPE_JWK.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType())) {
                throw new ProtocolException("Keystore di tipo '" + CostantiLabel.KEYSTORE_TYPE_JWK + "' non utilizzabile su API SOAP");
            }
            if (CostantiDB.KEYSTORE_TYPE_KEY_PAIR.equalsIgnoreCase(keystoreConfig.getSecurityMessageKeystoreType())) {
                throw new ProtocolException("Keystore di tipo '" + CostantiLabel.KEYSTORE_TYPE_KEY_PAIR + "' non utilizzabile su API SOAP");
            }
            pKeystore.put("org.apache.ws.security.crypto.merlin.file", keystoreConfig.getSecurityMessageKeystorePath());
            if (!keystoreConfig.isSecurityMessageKeystoreHSM() && keystoreConfig.getSecurityMessageKeystoreByokPolicy() != null) {
                DynamicMapBuilderUtils.injectDynamicMap((Busta)busta, (RequestInfo)requestInfo, (org.openspcoop2.utils.Map)context, (Logger)this.log);
                pKeystore.put("org.apache.ws.security.crypto.merlin.file.byok", keystoreConfig.getSecurityMessageKeystoreByokPolicy());
            }
        } else {
            pKeystore.put("org.apache.ws.security.crypto.merlin.keystore", keystoreConfig.getSecurityMessageKeystoreArchive());
        }
        pKeystore.put("requestInfo", requestInfo);
        secProperties.put("signaturePropRefId", pKeystore);
        secProperties.put("signatureUser", keystoreConfig.getSecurityMessageKeyAlias());
        secProperties.put("signaturePassword", keystoreConfig.getSecurityMessageKeyPassword());
        secProperties.put("passwordCallbackRef", "true");
        try {
            messageSecurityContext.setOutgoingProperties(secProperties, false);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        try {
            wss4jSignature.process((MessageSecurityContext)messageSecurityContext, msg, (org.openspcoop2.utils.Map)context);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        ks = null;
        if (keystoreConfig.getSecurityMessageKeystorePath() != null) {
            try {
                keystoreByokPolicy = keystoreConfig.getSecurityMessageKeystoreByokPolicy();
                byokParams = null;
                try {
                    byokParams = BYOKUnwrapPolicyUtilities.getBYOKRequestParams((String)keystoreByokPolicy, dynamicMap);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)keystoreConfig.getSecurityMessageKeystorePath(), (String)keystoreConfig.getSecurityMessageKeystoreType(), (String)keystoreConfig.getSecurityMessageKeystorePassword(), (BYOKRequestParams)byokParams);
                if (merlinKs == null) {
                    throw new ProtocolException("Accesso al keystore '" + keystoreConfig.getSecurityMessageKeystorePath() + "' non riuscito");
                }
                ks = merlinKs.getKeyStore();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            merlinKs = GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (byte[])keystoreConfig.getSecurityMessageKeystoreArchive(), (String)keystoreConfig.getSecurityMessageKeystoreType(), (String)keystoreConfig.getSecurityMessageKeystorePassword());
            if (merlinKs == null) {
                throw new ProtocolException("Accesso al keystore non riuscito");
            }
            ks = merlinKs.getKeyStore();
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        certificate = null;
        try {
            certificate = ks.getCertificate(keystoreConfig.getSecurityMessageKeyAlias());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        x509 = null;
        if (certificate instanceof X509Certificate) {
            x509 = (X509Certificate)certificate;
            busta.addProperty("ProfiloSicurezzaMessaggio-X509-Subject", x509.getSubjectX500Principal().toString());
            if (x509.getIssuerX500Principal() != null) {
                busta.addProperty("ProfiloSicurezzaMessaggio-X509-Issuer", x509.getIssuerX500Principal().toString());
            }
        }
        securityHeader = messageSecurityContext.getSecurityHeader(msg, modIProperties.getSoapSecurityTokenActor());
        dnc = MessageDynamicNamespaceContextFactory.getInstance((OpenSPCoop2MessageFactory)messageFactory).getNamespaceContext((Node)securityHeader);
        wsuNamespace = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
        xpathEngine = new XPathExpressionEngine(messageFactory);
        patternCreated = "//{" + wsuNamespace + "}Timestamp/{" + wsuNamespace + "}Created/text()";
        created = null;
        try {
            created = xpathEngine.getStringMatchPattern((SOAPElement)securityHeader, dnc, patternCreated);
        }
        catch (XPathNotFoundException var44_60) {
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (created != null) {
            iCreated = Instant.parse(created);
            dCreated = new Date(iCreated.toEpochMilli());
            busta.addProperty("ProfiloSicurezzaMessaggio-IssuedAt", DateUtils.getSimpleDateFormatMs().format(dCreated));
        }
        patternExpires = "//{" + wsuNamespace + "}Timestamp/{" + wsuNamespace + "}Expires/text()";
        expires = null;
        try {
            expires = xpathEngine.getStringMatchPattern((SOAPElement)securityHeader, dnc, patternExpires);
        }
        catch (XPathNotFoundException var46_64) {
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        if (expires != null) {
            iExpires = Instant.parse(expires);
            dExpires = new Date(iExpires.toEpochMilli());
            busta.addProperty("ProfiloSicurezzaMessaggio-Expiration", DateUtils.getSimpleDateFormatMs().format(dExpires));
        }
        soapSecurity = new ModISOAPSecurity();
        soapSecurity.setSecurityHeader(securityHeader);
        soapSecurity.setWsAddressingHeader(wsAddressingHeaders);
        soapSecurity.setRequestDigestHeader(requestDigest);
        if (integrita) {
            qname = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            soapBody = null;
            try {
                soapBody = msg.castAsSoap().getSOAPBody();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
            wsuIdBodyRef = soapBody.getAttributeValue(qname);
            soapSecurity.setWsuIdBodyRef(wsuIdBodyRef);
            if (wsuIdBodyRef != null) {
                digestNamespace = "http://www.w3.org/2000/09/xmldsig#";
                digestReferencePattern = "//{" + digestNamespace + "}:Reference[@URI='#" + wsuIdBodyRef + "']";
                digestValuePattern = digestReferencePattern + "/{" + digestNamespace + "}:DigestValue/text()";
                digestAlgorithmPattern = digestReferencePattern + "/{" + digestNamespace + "}:DigestMethod/@Algorithm";
                digestValue = null;
                try {
                    digestValue = xpathEngine.getStringMatchPattern((SOAPElement)securityHeader, dnc, digestValuePattern);
                }
                catch (XPathNotFoundException var55_77) {
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                digestAlgorithm = null;
                try {
                    digestAlgorithm = xpathEngine.getStringMatchPattern((SOAPElement)securityHeader, dnc, digestAlgorithmPattern);
                }
                catch (XPathNotFoundException var56_80) {
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), (Throwable)e);
                }
                if (digestValue != null && digestAlgorithm != null) {
                    s = SignatureDigestAlgorithm.toEnumConstant((String)digestAlgorithm);
                    digestValueBusta = s != null ? s.name() + "=" : "";
                    digestValueBusta = (String)digestValueBusta + digestValue;
                    busta.addProperty("ProfiloSicurezzaMessaggio-Digest", (String)digestValueBusta);
                }
            }
        }
        soapEnvelopeTraccia = null;
        try {
            soapEnvelopeTraccia = soapSecurity.buildTraccia(msg.getMessageType());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        soapSecurityToken = null;
        if (request && context != null) {
            securityTokenForContext = ModIUtilities.newSecurityToken(context);
            soapSecurityToken = new SoapMessageSecurityToken();
            soapSecurityToken.setCertificate(new CertificateInfo(x509, "soapEnvelope"));
            if (soapEnvelopeTraccia != null) {
                soapSecurityToken.setToken(soapEnvelopeTraccia);
            }
            securityTokenForContext.setEnvelope(soapSecurityToken);
        }
        return soapEnvelopeTraccia;
    }

    private void addSignaturePart(List<SOAPHeader> soapHeaderAggiuntiviDaFirmare, Busta busta, StringBuilder bf, String namespace, String localName) {
        if (bf.length() > 0) {
            bf.append(";");
        }
        bf.append("{Element}{").append(namespace).append("}").append(localName);
        SOAPHeader.remove(soapHeaderAggiuntiviDaFirmare, namespace, localName);
        busta.addProperty("ProfiloSicurezzaMessaggioSignedSoap-" + localName, namespace);
    }

    public static boolean isSenderVouche() {
        return senderVouche;
    }

    public static void setSenderVouche(boolean senderVouche) {
        ModIImbustamentoSoap.senderVouche = senderVouche;
    }

    private void addCorniceSicurezza(Map<String, Object> secProperties, Context context, Busta busta, ModISecurityConfig securityConfig, Map<String, Object> dynamicMap) throws ProtocolException {
        String nomeSoggettoMittente = busta.getMittente();
        String attributeNameCodiceEnte = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaSoapCodiceEnte();
        String codiceEnte = null;
        try {
            codiceEnte = ModIUtilities.getDynamicValue("Informazioni Audit - Codice Ente", securityConfig.getCorniceSicurezzaCodiceEnteRule(), dynamicMap, context);
        }
        catch (Exception e) {
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        String attributeNameUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaSoapUser();
        String utente = null;
        try {
            utente = ModIUtilities.getDynamicValue("Informazioni Audit - UserID Utente", securityConfig.getCorniceSicurezzaUserRule(), dynamicMap, context);
        }
        catch (Exception e) {
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        String attributeNameIpUser = this.modiProperties.getSicurezzaMessaggioCorniceSicurezzaSoapIpuser();
        String indirizzoIpPostazione = null;
        try {
            indirizzoIpPostazione = ModIUtilities.getDynamicValue("Informazioni Audit - Indirizzo IP Utente", securityConfig.getCorniceSicurezzaIpUserRule(), dynamicMap, context);
        }
        catch (Exception e) {
            ProtocolException pe = new ProtocolException(e.getMessage());
            pe.setInteroperabilityError(true);
            throw pe;
        }
        Properties pSaml = new Properties();
        pSaml.put("openspcoop2.saml.assertion.sign", "false");
        pSaml.put("openspcoop2.saml.assertion.sign.sendKeyValue", "false");
        pSaml.put("openspcoop2.saml.version", "2.0");
        pSaml.put("openspcoop2.saml.issuer.value", nomeSoggettoMittente);
        pSaml.put("openspcoop2.saml.issuer.format", "UNSPECIFIED");
        pSaml.put("openspcoop2.saml.subject.nameID.value", codiceEnte);
        pSaml.put("openspcoop2.saml.subject.nameID.format", "UNSPECIFIED");
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-Ente", codiceEnte);
        if (senderVouche) {
            pSaml.put("openspcoop2.saml.subject.confirmation.method", "SENDER_VOUCHES");
        } else {
            pSaml.put("openspcoop2.saml.subject.confirmation.method", "BEARER");
        }
        pSaml.put("openspcoop2.saml.authn.statement.enabled", "true");
        pSaml.put("openspcoop2.saml.authn", "UNSPECIFIED");
        pSaml.put("openspcoop2.saml.conditions.notOnOrAfter.minutes", "60");
        pSaml.put("openspcoop2.saml.conditions.notBefore.minutes", "0");
        if (attributeNameCodiceEnte != null && !"".equals(attributeNameCodiceEnte)) {
            pSaml.put("openspcoop2.saml.attribute.statement.ATTR_0.name.qualified", attributeNameCodiceEnte);
            pSaml.put("openspcoop2.saml.attribute.statement.ATTR_0.name.format", "UNSPECIFIED");
            pSaml.put("openspcoop2.saml.attribute.statement.ATTR_0.values.separator", ",");
            pSaml.put("openspcoop2.saml.attribute.statement.ATTR_0.values", codiceEnte);
        }
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_1.name.qualified", attributeNameUser);
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_1.name.format", "UNSPECIFIED");
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_1.values.separator", ",");
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_1.values", utente);
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-User", utente);
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_2.name.qualified", attributeNameIpUser);
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_2.name.format", "UNSPECIFIED");
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_2.values.separator", ",");
        pSaml.put("openspcoop2.saml.attribute.statement.ATTR_2.values", indirizzoIpPostazione);
        busta.addProperty("ProfiloSicurezzaMessaggio-CorniceSicurezza-UserIP", indirizzoIpPostazione);
        secProperties.put("samlPropRefId", pSaml);
    }
}

