/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.protocol.modipa.config.ModIAuditClaimConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;

public class ModIAuditConfig {
    public static final String PROPERTY_NOME = "nome";
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_CLAIMS = "claims";
    public static final String PROPERTY_ISS_LOCALE = "iss.locale";
    public static final String PROPERTY_ISS_OAUTH = "iss.oauth";
    public static final String PROPERTY_SUB_LOCALE = "sub.locale";
    public static final String PROPERTY_SUB_OAUTH = "sub.oauth";
    public static final String PROPERTY_CLIENT_ID_LOCALE = "client_id.locale";
    public static final String PROPERTY_CLIENT_ID_OAUTH = "client_id.oauth";
    private String propertyId;
    private String nome;
    private String label;
    private List<ModIAuditClaimConfig> claims;
    private boolean issLocale = false;
    private boolean issOAuth = true;
    private boolean subLocale = false;
    private boolean subOAuth = false;
    private boolean clientIdLocale = false;
    private boolean clientIdOAuth = false;

    public ModIAuditConfig copyNewInstance() {
        ModIAuditConfig config = new ModIAuditConfig();
        config.propertyId = this.propertyId;
        config.nome = this.nome;
        config.label = this.label;
        config.claims = new ArrayList<ModIAuditClaimConfig>();
        if (this.claims != null && !this.claims.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : this.claims) {
                config.claims.add(modIAuditClaimConfig.copyNewInstance());
            }
        }
        config.issLocale = this.issLocale;
        config.issOAuth = this.issOAuth;
        config.subLocale = this.subLocale;
        config.subOAuth = this.subOAuth;
        config.clientIdLocale = this.clientIdLocale;
        config.clientIdOAuth = this.clientIdOAuth;
        return config;
    }

    private ModIAuditConfig() {
    }

    ModIAuditConfig(String prefix, String propertyId, Properties p) throws ProtocolException {
        this.propertyId = propertyId;
        this.nome = ModIAuditConfig.getProperty(prefix, p, PROPERTY_NOME, true);
        this.label = ModIAuditConfig.getProperty(prefix, p, PROPERTY_LABEL, true);
        String claimsP = ModIAuditConfig.getProperty(prefix, p, PROPERTY_CLAIMS, true);
        String[] tmp = claimsP.split(",");
        if (tmp == null || tmp.length <= 0) {
            throw new ProtocolException("Property 'claims' empty");
        }
        this.claims = new ArrayList<ModIAuditClaimConfig>();
        for (String c : tmp) {
            c = c.trim();
            this.claims.add(new ModIAuditClaimConfig(prefix, c, p));
        }
        if (this.claims != null && !this.claims.isEmpty()) {
            for (ModIAuditClaimConfig modIAuditClaimConfig : this.claims) {
                String name = modIAuditClaimConfig.getNome();
                int count = 0;
                for (ModIAuditClaimConfig modIAuditClaimConfigCheck : this.claims) {
                    if (!name.equals(modIAuditClaimConfigCheck.getNome())) continue;
                    ++count;
                }
                if (count <= true) continue;
                throw new ProtocolException("Property claims.xx.nome=" + name + " defined more then one time (" + count + ")");
            }
        }
        this.issLocale = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_ISS_LOCALE, false, false);
        this.issOAuth = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_ISS_OAUTH, false, true);
        this.subLocale = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_SUB_LOCALE, false, false);
        this.subOAuth = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_SUB_OAUTH, false, false);
        this.clientIdLocale = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_CLIENT_ID_LOCALE, false, false);
        this.clientIdOAuth = ModIAuditConfig.getBooleanProperty(prefix, p, PROPERTY_CLIENT_ID_OAUTH, false, false);
    }

    static String getProperty(String prefixProperty, Properties p, String name, boolean required) throws ProtocolException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new ProtocolException("Property '" + prefixProperty + "." + name + "' notFound");
        }
        return null;
    }

    static boolean getBooleanProperty(String prefixProperty, Properties p, String name, boolean required, boolean defaultValue) throws ProtocolException {
        String tmp = ModIAuditConfig.getProperty(prefixProperty, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            try {
                return Boolean.valueOf(tmp);
            }
            catch (Exception t) {
                throw new ProtocolException("Boolean property '" + prefixProperty + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), (Throwable)t);
            }
        }
        return defaultValue;
    }

    static int getIntProperty(String prefixProperty, Properties p, String name, boolean required, int defaultValue) throws ProtocolException {
        String tmp = ModIAuditConfig.getProperty(prefixProperty, p, name, required);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp)) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception t) {
                throw new ProtocolException("Int property '" + prefixProperty + "." + name + "' invalid (found value:[" + tmp + "]): " + t.getMessage(), (Throwable)t);
            }
        }
        return defaultValue;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLabel() {
        return this.label;
    }

    public List<ModIAuditClaimConfig> getClaims() {
        return this.claims;
    }

    public void setClaims(List<ModIAuditClaimConfig> claims) {
        this.claims = claims;
    }

    public boolean isIssLocale() {
        return this.issLocale;
    }

    public boolean isIssOAuth() {
        return this.issOAuth;
    }

    public boolean isSubLocale() {
        return this.subLocale;
    }

    public boolean isSubOAuth() {
        return this.subOAuth;
    }

    public boolean isClientIdLocale() {
        return this.clientIdLocale;
    }

    public boolean isClientIdOAuth() {
        return this.clientIdOAuth;
    }
}

