/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.config;

import java.util.List;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.config.BasicConfiguration;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;

public class ModIProtocolConfiguration
extends BasicConfiguration {
    private ModIProperties properties = ModIProperties.getInstance();

    public ModIProtocolConfiguration(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public boolean isIntegrationInfoRequired(TipoPdD tipoPdD, ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        if (FunzionalitaProtocollo.RIFERIMENTO_ID_RICHIESTA.equals((Object)funzionalitaProtocollo)) {
            if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                return this.properties.isRiferimentoIDRichiestaPortaDelegataRequired();
            }
            return this.properties.isRiferimentoIDRichiestaPortaApplicativaRequired();
        }
        return super.isIntegrationInfoRequired(tipoPdD, serviceBinding, funzionalitaProtocollo);
    }

    public boolean isAbilitataGenerazioneTracce() {
        if (this.properties.isGenerazioneTracce() != null && this.properties.isGenerazioneTracce().booleanValue()) {
            return true;
        }
        return super.isAbilitataGenerazioneTracce();
    }

    public boolean isAbilitatoSalvataggioHeaderProtocolloTracce() {
        return this.properties.isGenerazioneTracceRegistraToken();
    }

    public boolean isSupportato(ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        if (funzionalitaProtocollo == null || serviceBinding == null) {
            throw new ProtocolException("Params not defined");
        }
        if (FunzionalitaProtocollo.FILTRO_DUPLICATI.equals((Object)funzionalitaProtocollo)) {
            return true;
        }
        return super.isSupportato(serviceBinding, funzionalitaProtocollo);
    }

    public boolean isDataPresenteInIdentificativoMessaggio() {
        return this.properties.generateIDasUUID() == false;
    }

    public List<RemoteStoreConfig> getRemoteStoreConfig() throws ProtocolException {
        return this.properties.getRemoteStoreConfig();
    }
}

