/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.protocol.modipa.config.ModIAuditConfig;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.utils.ModISecurityUtils;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.slf4j.Logger;

public class ModIPropertiesUtils {
    private static final String RAW_VALUE = "--RAW-VALUE";

    private ModIPropertiesUtils() {
    }

    public static boolean readPropertyBulkResource(AccordoServizioParteComune aspc) {
        try {
            BooleanNullable v = ProtocolPropertiesUtils.getOptionalBooleanValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaInteractionBulkResource");
            return v != null && v.getValue() != null && v.getValue() != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String readPropertySecurityChannelProfile(AccordoServizioParteComune aspc, AccordoServizioParteSpecifica asps) throws ProtocolException {
        try {
            return ModIPropertiesUtils.readPropertySecurityChannelProfileEngine(aspc).toUpperCase();
        }
        catch (ProtocolException e) {
            if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)asps.getPortType())) {
                throw e;
            }
            return null;
        }
    }

    public static String readPropertySecurityChannelProfileEngine(AccordoServizioParteComune aspc) throws ProtocolException {
        return ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityChannelProfile");
    }

    public static String readPropertyInteractionProfile(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionProfile");
    }

    public static String readPropertyAsyncInteractionProfile(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionAsyncProfile");
    }

    public static String readPropertyAsyncInteractionRole(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionAsyncRole");
    }

    public static String readPropertyAsyncInteractionRequestApi(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionAsyncApiRequest");
    }

    public static String readPropertyAsyncInteractionRequestService(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionAsyncServiceRequest");
    }

    public static String readPropertyAsyncInteractionRequestAction(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaInteractionAsyncActionRequest");
    }

    public static String readPropertySecurityMessageProfile(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean filterPDND) throws ProtocolException {
        try {
            return ModIPropertiesUtils.readPropertySecurityMessageProfileEngine(aspc, nomePortType, azione, filterPDND);
        }
        catch (ProtocolException e) {
            if (ModISecurityUtils.isSicurezzaMessaggioRequired((AccordoServizioParteComune)aspc, (String)nomePortType)) {
                throw e;
            }
            return null;
        }
    }

    public static String readPropertySecurityMessageProfileEngine(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean filterPDND) throws ProtocolException {
        String sorgenteToken;
        String profile = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageProfile");
        if (filterPDND && ("idam01".equals(profile) || "idam02".equals(profile)) && ("pdnd".equals(sorgenteToken = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageSorgenteToken")) || "oauth".equals(sorgenteToken))) {
            profile = null;
        }
        return profile;
    }

    public static String readPropertySecurityMessageHeader(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean request, boolean filterPDND) throws ProtocolException {
        String sorgenteToken;
        String header = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageHeaderName", request);
        if (header != null && filterPDND && ("pdnd".equals(sorgenteToken = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageSorgenteToken")) || "oauth".equals(sorgenteToken))) {
            header = header.replace("Authorization", "");
            header = header.trim();
        }
        return header;
    }

    public static String readPropertySecurityMessageHeaderRawOptionValue(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean request) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageHeaderName--RAW-VALUE", request);
    }

    public static String readPropertySecurityMessageSorgenteToken(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean request) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageSorgenteToken", request);
    }

    public static boolean isPropertySecurityMessageHeaderCustom(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean request) throws ProtocolException {
        String tmp = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageHeaderCustomName", request);
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public static String getPropertySecurityMessageHeaderCustomMode(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean request) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageHeaderCustomMode", request);
    }

    public static boolean isPropertySecurityMessageConCorniceSicurezza(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        String tmp = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageCorniceSicurezza");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public static String readPropertySecurityMessageCorniceSicurezzaPattern(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageCorniceSicurezzaPattern");
    }

    public static String readPropertySecurityMessageCorniceSicurezzaSchema(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageCorniceSicurezzaSchema");
    }

    public static boolean isPropertySecurityMessageCorniceSicurezzaOpzionale(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        String tmp = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageCorniceSicurezzaOpzionale");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public static boolean isPropertySecurityMessageIncludiRequestDigest(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        String tmp = ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageRequestDigest");
        return tmp != null && Boolean.valueOf(tmp) != false;
    }

    public static String readPropertySecurityMessageApplicabilita(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityMessageConfig");
    }

    public static String readPropertySecurityMessageApplicabilitaRichiesta(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityRequest");
    }

    public static String readPropertySecurityMessageApplicabilitaRichiestaContentType(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityRequestContentType");
    }

    public static String readPropertySecurityMessageApplicabilitaRisposta(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityResponse");
    }

    public static String readPropertySecurityMessageApplicabilitaRispostaContentType(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityResponseContentType");
    }

    public static String readPropertySecurityMessageApplicabilitaRispostaReturnCode(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, "modipaSecurityResponseReturnCode");
    }

    private static String readPropertyEngine(AccordoServizioParteComune aspc, String nomePortType, String azione, String propertyName) throws ProtocolException {
        return ModIPropertiesUtils.readPropertyEngine(aspc, nomePortType, azione, propertyName, null);
    }

    private static String readPropertyEngine(AccordoServizioParteComune aspc, String nomePortType, String azione, String propertyName, Boolean request) throws ProtocolException {
        String securityMessageApplicabilitaRispostaReturnCode;
        String securityMessageApplicabilitaRispostaContentType;
        String securityMessageApplicabilitaRisposta;
        String securityMessageApplicabilitaRichiestaContentType;
        String securityMessageApplicabilitaRichiesta;
        String securityMessageApplicabilita;
        String securityMessageRequestDigest;
        String securityMessageCorniceSicurezzaOpzionale;
        String securityMessageCorniceSicurezzaSchema;
        String securityMessageCorniceSicurezzaPattern;
        String securityMessageCorniceSicurezza;
        String securityMessageProfileHeaderCustomMode;
        String securityMessageProfileHeaderCustom;
        String securityMessageProfileHeader;
        String securityMessageProfileSorgenteTokenIdAuth;
        String securityMessageProfile;
        String asyncInteractionRequestAction;
        String asyncInteractionRequestService;
        String asyncInteractionRequestApi;
        String asyncInteractionRole;
        String asyncInteractionProfile;
        String interactionProfile;
        block62: {
            interactionProfile = null;
            asyncInteractionProfile = null;
            asyncInteractionRole = null;
            asyncInteractionRequestApi = null;
            asyncInteractionRequestService = null;
            asyncInteractionRequestAction = null;
            securityMessageProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageProfile");
            securityMessageProfileSorgenteTokenIdAuth = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageSorgenteToken");
            securityMessageProfileHeader = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderName");
            securityMessageProfileHeaderCustom = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomName");
            securityMessageProfileHeaderCustomMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomMode");
            securityMessageCorniceSicurezza = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezza", (boolean)false);
            securityMessageCorniceSicurezzaPattern = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaPattern");
            securityMessageCorniceSicurezzaSchema = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaSchema");
            securityMessageCorniceSicurezzaOpzionale = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaOpzionale", (boolean)false);
            securityMessageRequestDigest = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageRequestDigest", (boolean)false);
            securityMessageApplicabilita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityMessageConfig");
            securityMessageApplicabilitaRichiesta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityRequest");
            securityMessageApplicabilitaRichiestaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityRequestContentType");
            securityMessageApplicabilitaRisposta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityResponse");
            securityMessageApplicabilitaRispostaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityResponseContentType");
            securityMessageApplicabilitaRispostaReturnCode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)aspc.getProtocolPropertyList(), (String)"modipaSecurityResponseReturnCode");
            if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
                for (Resource resource : aspc.getResourceList()) {
                    if (!resource.getNome().equals(azione)) continue;
                    interactionProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionProfile");
                    if (interactionProfile == null) {
                        interactionProfile = "crud";
                    }
                    if ("nonBloccante".equals(interactionProfile)) {
                        asyncInteractionProfile = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionAsyncProfile");
                        asyncInteractionRole = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionAsyncRole");
                        if ("PUSH".equals(asyncInteractionProfile)) {
                            if (!"Richiesta".equals(asyncInteractionRole)) {
                                asyncInteractionRequestApi = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionAsyncApiRequest");
                                asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                            }
                        } else if (!"Richiesta".equals(asyncInteractionRole)) {
                            asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                        }
                    }
                    if ((securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode")) == null) {
                        securityMessageProfileMode = "default";
                    }
                    if (!"ridefinisci".equals(securityMessageProfileMode)) break;
                    securityMessageProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageProfile");
                    securityMessageProfileSorgenteTokenIdAuth = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageSorgenteToken");
                    securityMessageProfileHeader = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderName");
                    securityMessageProfileHeaderCustom = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomName");
                    securityMessageProfileHeaderCustomMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomMode");
                    securityMessageCorniceSicurezza = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezza", (boolean)false);
                    securityMessageCorniceSicurezzaPattern = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaPattern");
                    securityMessageCorniceSicurezzaSchema = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaSchema");
                    securityMessageCorniceSicurezzaOpzionale = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaOpzionale", (boolean)false);
                    securityMessageRequestDigest = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageRequestDigest", (boolean)false);
                    securityMessageApplicabilita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageConfig");
                    securityMessageApplicabilitaRichiesta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityRequest");
                    securityMessageApplicabilitaRichiestaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityRequestContentType");
                    securityMessageApplicabilitaRisposta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityResponse");
                    securityMessageApplicabilitaRispostaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityResponseContentType");
                    securityMessageApplicabilitaRispostaReturnCode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityResponseReturnCode");
                    break;
                }
            } else if (nomePortType != null) {
                for (PortType pt : aspc.getPortTypeList()) {
                    if (!pt.getNome().equals(nomePortType)) continue;
                    for (Operation op : pt.getAzioneList()) {
                        String securityMessageProfileMode;
                        if (!op.getNome().equals(azione)) continue;
                        interactionProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionProfile");
                        if (interactionProfile == null) {
                            interactionProfile = "bloccante";
                        }
                        if ("nonBloccante".equals(interactionProfile)) {
                            asyncInteractionProfile = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncProfile");
                            asyncInteractionRole = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncRole");
                            if ("PUSH".equals(asyncInteractionProfile)) {
                                if (!"Richiesta".equals(asyncInteractionRole)) {
                                    asyncInteractionRequestApi = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncApiRequest");
                                    asyncInteractionRequestService = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncServiceRequest");
                                    asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                                }
                            } else if (!"Richiesta".equals(asyncInteractionRole)) {
                                asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                            }
                        }
                        if ((securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode")) == null) {
                            securityMessageProfileMode = "default";
                        }
                        if (!"ridefinisci".equals(securityMessageProfileMode)) break block62;
                        securityMessageProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageProfile");
                        securityMessageProfileSorgenteTokenIdAuth = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageSorgenteToken");
                        securityMessageProfileHeader = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderName");
                        securityMessageProfileHeaderCustom = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomName");
                        securityMessageProfileHeaderCustomMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomMode");
                        securityMessageCorniceSicurezza = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezza", (boolean)false);
                        securityMessageCorniceSicurezzaPattern = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaPattern");
                        securityMessageCorniceSicurezzaSchema = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaSchema");
                        securityMessageCorniceSicurezzaOpzionale = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaOpzionale", (boolean)false);
                        securityMessageRequestDigest = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageRequestDigest", (boolean)false);
                        securityMessageApplicabilita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageConfig");
                        securityMessageApplicabilitaRichiesta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityRequest");
                        securityMessageApplicabilitaRichiestaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityRequestContentType");
                        securityMessageApplicabilitaRisposta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityResponse");
                        securityMessageApplicabilitaRispostaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityResponseContentType");
                        securityMessageApplicabilitaRispostaReturnCode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityResponseReturnCode");
                        break block62;
                    }
                    break;
                }
            } else {
                for (Azione azioneAccordo : aspc.getAzioneList()) {
                    if (!azioneAccordo.getNome().equals(azione)) continue;
                    interactionProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionProfile");
                    if (interactionProfile == null) {
                        interactionProfile = "bloccante";
                    }
                    if ("nonBloccante".equals(interactionProfile)) {
                        asyncInteractionProfile = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncProfile");
                        asyncInteractionRole = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncRole");
                        if ("PUSH".equals(asyncInteractionProfile)) {
                            if (!"Richiesta".equals(asyncInteractionRole)) {
                                asyncInteractionRequestApi = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncApiRequest");
                                asyncInteractionRequestService = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncServiceRequest");
                                asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                            }
                        } else if (!"Richiesta".equals(asyncInteractionRole)) {
                            asyncInteractionRequestAction = ProtocolPropertiesUtils.getRequiredStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaInteractionAsyncActionRequest");
                        }
                    }
                    if ((securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode")) == null) {
                        securityMessageProfileMode = "default";
                    }
                    if (!"ridefinisci".equals(securityMessageProfileMode)) break;
                    securityMessageProfile = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageProfile");
                    securityMessageProfileSorgenteTokenIdAuth = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageSorgenteToken");
                    securityMessageProfileHeader = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderName");
                    securityMessageProfileHeaderCustom = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomName");
                    securityMessageProfileHeaderCustomMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageHeaderCustomMode");
                    securityMessageCorniceSicurezza = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezza", (boolean)false);
                    securityMessageCorniceSicurezzaPattern = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaPattern");
                    securityMessageCorniceSicurezzaSchema = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaSchema");
                    securityMessageCorniceSicurezzaOpzionale = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageCorniceSicurezzaOpzionale", (boolean)false);
                    securityMessageRequestDigest = "" + ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageRequestDigest", (boolean)false);
                    securityMessageApplicabilita = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageConfig");
                    securityMessageApplicabilitaRichiesta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityRequest");
                    securityMessageApplicabilitaRichiestaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityRequestContentType");
                    securityMessageApplicabilitaRisposta = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityResponse");
                    securityMessageApplicabilitaRispostaContentType = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityResponseContentType");
                    securityMessageApplicabilitaRispostaReturnCode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityResponseReturnCode");
                    break;
                }
            }
        }
        if ("modipaInteractionProfile".equals(propertyName)) {
            return interactionProfile;
        }
        if ("modipaInteractionAsyncProfile".equals(propertyName)) {
            return asyncInteractionProfile;
        }
        if ("modipaInteractionAsyncRole".equals(propertyName)) {
            return asyncInteractionRole;
        }
        if ("modipaInteractionAsyncApiRequest".equals(propertyName)) {
            return asyncInteractionRequestApi;
        }
        if ("modipaInteractionAsyncServiceRequest".equals(propertyName)) {
            return asyncInteractionRequestService;
        }
        if ("modipaInteractionAsyncActionRequest".equals(propertyName)) {
            return asyncInteractionRequestAction;
        }
        if ("modipaSecurityMessageProfile".equals(propertyName)) {
            return securityMessageProfile;
        }
        if ("modipaSecurityMessageSorgenteToken".equals(propertyName)) {
            return securityMessageProfileSorgenteTokenIdAuth;
        }
        if ("modipaSecurityMessageHeaderName--RAW-VALUE".equals(propertyName)) {
            return securityMessageProfileHeader;
        }
        if ("modipaSecurityMessageHeaderName".equals(propertyName)) {
            if (securityMessageProfileHeader == null || StringUtils.isEmpty((CharSequence)securityMessageProfileHeader)) {
                boolean integritaX5c = "idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile);
                boolean integritaKid = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                boolean integrita = integritaX5c || integritaKid;
                securityMessageProfileHeader = integrita ? "autonlyreq_modipa" : "authorization";
            }
            if ("modipa".equals(securityMessageProfileHeader)) {
                return ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
            }
            if ("authorization".equals(securityMessageProfileHeader)) {
                return "Authorization";
            }
            if ("authorization_modipa".equals(securityMessageProfileHeader)) {
                return "Authorization " + ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
            }
            if ("autonlyreq_modipa".equals(securityMessageProfileHeader)) {
                if (request != null && request.booleanValue()) {
                    return "Authorization " + ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
                }
                return ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
            }
            if ("custom".equals(securityMessageProfileHeader)) {
                return securityMessageProfileHeaderCustom != null && StringUtils.isNotEmpty((CharSequence)securityMessageProfileHeaderCustom) ? securityMessageProfileHeaderCustom : ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
            }
            if ("authorization_custom".equals(securityMessageProfileHeader)) {
                String integrityCustom = securityMessageProfileHeaderCustom != null && StringUtils.isNotEmpty((CharSequence)securityMessageProfileHeaderCustom) ? securityMessageProfileHeaderCustom : ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
                return "Authorization " + integrityCustom;
            }
            if ("autonlyreq_custom".equals(securityMessageProfileHeader)) {
                String integrityCustom;
                String string = integrityCustom = securityMessageProfileHeaderCustom != null && StringUtils.isNotEmpty((CharSequence)securityMessageProfileHeaderCustom) ? securityMessageProfileHeaderCustom : ModIProperties.getInstance().getRestSecurityTokenHeaderModI();
                if (request != null && request.booleanValue()) {
                    return "Authorization " + integrityCustom;
                }
                return integrityCustom;
            }
            return "Authorization";
        }
        if ("modipaSecurityMessageHeaderCustomName".equals(propertyName)) {
            return "" + ("custom".equals(securityMessageProfileHeader) || "authorization_custom".equals(securityMessageProfileHeader) || "autonlyreq_custom".equals(securityMessageProfileHeader));
        }
        if ("modipaSecurityMessageHeaderCustomMode".equals(propertyName)) {
            return securityMessageProfileHeaderCustomMode;
        }
        if ("modipaSecurityMessageCorniceSicurezza".equals(propertyName)) {
            return securityMessageCorniceSicurezza;
        }
        if ("modipaSecurityMessageCorniceSicurezzaPattern".equals(propertyName)) {
            return securityMessageCorniceSicurezzaPattern;
        }
        if ("modipaSecurityMessageCorniceSicurezzaSchema".equals(propertyName)) {
            return securityMessageCorniceSicurezzaSchema;
        }
        if ("modipaSecurityMessageCorniceSicurezzaOpzionale".equals(propertyName)) {
            return securityMessageCorniceSicurezzaOpzionale;
        }
        if ("modipaSecurityMessageRequestDigest".equals(propertyName)) {
            return securityMessageRequestDigest;
        }
        if ("modipaSecurityMessageConfig".equals(propertyName)) {
            return securityMessageApplicabilita;
        }
        if ("modipaSecurityRequest".equals(propertyName)) {
            return securityMessageApplicabilitaRichiesta;
        }
        if ("modipaSecurityRequestContentType".equals(propertyName)) {
            return securityMessageApplicabilitaRichiestaContentType;
        }
        if ("modipaSecurityResponse".equals(propertyName)) {
            return securityMessageApplicabilitaRisposta;
        }
        if ("modipaSecurityResponseContentType".equals(propertyName)) {
            return securityMessageApplicabilitaRispostaContentType;
        }
        if ("modipaSecurityResponseReturnCode".equals(propertyName)) {
            return securityMessageApplicabilitaRispostaReturnCode;
        }
        return null;
    }

    public static boolean readSicurezzaMessaggioRidefinitaOperazioneEngine(AccordoServizioParteComune aspc, String nomePortType, String azione) throws ProtocolException {
        block14: {
            if (ServiceBinding.REST.equals((Object)aspc.getServiceBinding())) {
                for (Resource resource : aspc.getResourceList()) {
                    if (!resource.getNome().equals(azione)) continue;
                    String securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)resource.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode");
                    if (securityMessageProfileMode == null) {
                        securityMessageProfileMode = "default";
                    }
                    if ("ridefinisci".equals(securityMessageProfileMode)) {
                        return true;
                    }
                    break;
                }
            } else if (nomePortType != null) {
                for (PortType pt : aspc.getPortTypeList()) {
                    if (!pt.getNome().equals(nomePortType)) continue;
                    for (Operation op : pt.getAzioneList()) {
                        if (!op.getNome().equals(azione)) continue;
                        String securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)op.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode");
                        if (securityMessageProfileMode == null) {
                            securityMessageProfileMode = "default";
                        }
                        if ("ridefinisci".equals(securityMessageProfileMode)) {
                            return true;
                        }
                        break block14;
                    }
                    break;
                }
            } else {
                for (Azione azioneAccordo : aspc.getAzioneList()) {
                    if (!azioneAccordo.getNome().equals(azione)) continue;
                    String securityMessageProfileMode = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry((List)azioneAccordo.getProtocolPropertyList(), (String)"modipaSecurityMessageProfileActionMode");
                    if (securityMessageProfileMode == null) {
                        securityMessageProfileMode = "default";
                    }
                    if ("ridefinisci".equals(securityMessageProfileMode)) {
                        return true;
                    }
                    break;
                }
            }
        }
        return false;
    }

    public static List<ProtocolProperty> getProtocolProperties(boolean fruizione, IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        return ProtocolPropertiesUtils.getProtocolProperties((boolean)fruizione, (IDSoggetto)soggettoFruitore, (AccordoServizioParteSpecifica)asps);
    }

    public static Fruitore getFruitore(IDSoggetto soggettoFruitore, AccordoServizioParteSpecifica asps) throws ProtocolException {
        return ProtocolPropertiesUtils.getFruitore((IDSoggetto)soggettoFruitore, (AccordoServizioParteSpecifica)asps);
    }

    public static String convertProfiloSicurezzaToSDKValue(String securityMessageProfile, boolean rest) {
        return ModIUtils.convertProfiloSicurezzaToSDKValue((String)securityMessageProfile, (boolean)rest);
    }

    public static String convertProfiloSicurezzaToConfigurationValue(String securityMessageProfileSDKValue) {
        return ModIUtils.convertProfiloSicurezzaToConfigurationValue((String)securityMessageProfileSDKValue);
    }

    private static ProtocolException newProtocolExceptionUnknown(String prefix, String value) {
        return ModIUtils.newProtocolExceptionUnknown((String)prefix, (String)value);
    }

    public static String convertProfiloSicurezzaSorgenteTokenToSDKValue(String sorgenteToken) {
        return ModIUtils.convertProfiloSicurezzaSorgenteTokenToSDKValue((String)sorgenteToken);
    }

    public static String convertProfiloSicurezzaSorgenteTokenToConfigurationValue(String sorgenteTokenSDKValue) throws ProtocolException {
        return ModIUtils.convertProfiloSicurezzaSorgenteTokenToConfigurationValue((String)sorgenteTokenSDKValue);
    }

    public static String convertProfiloAuditToSDKValue(String patternCorniceSicurezza) throws ProtocolException {
        return ModIUtils.convertProfiloAuditToSDKValue((String)patternCorniceSicurezza);
    }

    public static String convertProfiloAuditToConfigurationValue(String patternCorniceSicurezzaSDKValue) throws ProtocolException {
        return ModIUtils.convertProfiloAuditToConfigurationValue((String)patternCorniceSicurezzaSDKValue);
    }

    public static String convertSchemaAuditToSDKValue(String schemaCorniceSicurezza, ModIProperties modiProperties) throws ProtocolException {
        if (modiProperties.getAuditConfig() != null && !modiProperties.getAuditConfig().isEmpty()) {
            for (ModIAuditConfig c : modiProperties.getAuditConfig()) {
                if (!c.getNome().equals(schemaCorniceSicurezza)) continue;
                return c.getLabel();
            }
        }
        throw ModIPropertiesUtils.newProtocolExceptionUnknown("Schema value", schemaCorniceSicurezza);
    }

    public static String convertSchemaAuditToConfigurationValue(String schemaCorniceSicurezzaSDKValue, ModIProperties modiProperties) throws ProtocolException {
        if (modiProperties.getAuditConfig() != null && !modiProperties.getAuditConfig().isEmpty()) {
            for (ModIAuditConfig c : modiProperties.getAuditConfig()) {
                if (!c.getLabel().equals(schemaCorniceSicurezzaSDKValue)) continue;
                return c.getNome();
            }
        }
        throw ModIPropertiesUtils.newProtocolExceptionUnknown("Schema label", schemaCorniceSicurezzaSDKValue);
    }

    public static boolean isAttachmentsSignature(AccordoServizioParteComune aspc, String nomePortType, String azione, boolean isRichiesta, OpenSPCoop2Message message) throws ProtocolException {
        boolean sign = false;
        String securityMessageApplicabilita = ModIPropertiesUtils.readPropertySecurityMessageApplicabilita(aspc, nomePortType, azione);
        if (securityMessageApplicabilita == null || StringUtils.isEmpty((CharSequence)securityMessageApplicabilita)) {
            securityMessageApplicabilita = "entrambi";
        }
        if ("entrambi_attachments".equals(securityMessageApplicabilita)) {
            sign = true;
        } else if ("richiesta_attachments".equals(securityMessageApplicabilita)) {
            sign = isRichiesta;
        } else if ("risposta_attachments".equals(securityMessageApplicabilita)) {
            boolean bl = sign = !isRichiesta;
        }
        if (sign) {
            try {
                return message.castAsSoap().hasAttachments();
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean processSecurity(Logger log, AccordoServizioParteComune aspc, String nomePortType, String azione, boolean isRichiesta, OpenSPCoop2Message message, boolean rest, ModIProperties modiProperties) throws Exception {
        boolean processSecurity = false;
        String securityMessageApplicabilita = ModIPropertiesUtils.readPropertySecurityMessageApplicabilita(aspc, nomePortType, azione);
        if (securityMessageApplicabilita == null || StringUtils.isEmpty((CharSequence)securityMessageApplicabilita)) {
            securityMessageApplicabilita = "entrambi";
        }
        boolean configurazionePersonalizzata = false;
        if ("entrambi".equals(securityMessageApplicabilita) || "entrambi_attachments".equals(securityMessageApplicabilita)) {
            processSecurity = true;
        } else if ("richiesta".equals(securityMessageApplicabilita) || "richiesta_attachments".equals(securityMessageApplicabilita)) {
            processSecurity = isRichiesta;
        } else if ("risposta".equals(securityMessageApplicabilita) || "risposta_attachments".equals(securityMessageApplicabilita)) {
            processSecurity = !isRichiesta;
        } else if ("custom".equals(securityMessageApplicabilita)) {
            if (isRichiesta) {
                String securityMessageApplicabilitaRichiesta = ModIPropertiesUtils.readPropertySecurityMessageApplicabilitaRichiesta(aspc, nomePortType, azione);
                if (securityMessageApplicabilitaRichiesta == null || StringUtils.isEmpty((CharSequence)securityMessageApplicabilitaRichiesta)) {
                    securityMessageApplicabilitaRichiesta = "true";
                }
                if ("true".equals(securityMessageApplicabilitaRichiesta)) {
                    processSecurity = true;
                } else if ("false".equals(securityMessageApplicabilitaRichiesta)) {
                    processSecurity = false;
                } else if ("custom".equals(securityMessageApplicabilitaRichiesta)) {
                    configurazionePersonalizzata = true;
                    String securityMessageApplicabilitaRichiestaContentType = ModIPropertiesUtils.readPropertySecurityMessageApplicabilitaRichiestaContentType(aspc, nomePortType, azione);
                    List<String> check = ModIPropertiesUtils.readValues(securityMessageApplicabilitaRichiestaContentType);
                    if (!check.isEmpty()) {
                        try {
                            processSecurity = ContentTypeUtilities.isMatch((Logger)log, (String)message.getContentType(), check);
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            } else {
                String securityMessageApplicabilitaRisposta = ModIPropertiesUtils.readPropertySecurityMessageApplicabilitaRisposta(aspc, nomePortType, azione);
                if (securityMessageApplicabilitaRisposta == null || StringUtils.isEmpty((CharSequence)securityMessageApplicabilitaRisposta)) {
                    securityMessageApplicabilitaRisposta = "true";
                }
                if ("true".equals(securityMessageApplicabilitaRisposta)) {
                    processSecurity = true;
                } else if ("false".equals(securityMessageApplicabilitaRisposta)) {
                    processSecurity = false;
                } else if ("custom".equals(securityMessageApplicabilitaRisposta)) {
                    configurazionePersonalizzata = true;
                    String securityMessageApplicabilitaRispostaContentType = ModIPropertiesUtils.readPropertySecurityMessageApplicabilitaRispostaContentType(aspc, nomePortType, azione);
                    List<String> check = ModIPropertiesUtils.readValues(securityMessageApplicabilitaRispostaContentType);
                    if (!check.isEmpty()) {
                        try {
                            processSecurity = ContentTypeUtilities.isMatch((Logger)log, (String)message.getContentType(), check);
                        }
                        catch (Exception e) {
                            throw new ProtocolException(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        processSecurity = false;
                    }
                    if (processSecurity) {
                        String securityMessageApplicabilitaRispostaReturnCode = ModIPropertiesUtils.readPropertySecurityMessageApplicabilitaRispostaReturnCode(aspc, nomePortType, azione);
                        List<String> checkReturnCode = ModIPropertiesUtils.readValues(securityMessageApplicabilitaRispostaReturnCode);
                        if (checkReturnCode.size() > 0) {
                            int httpStatus = -1;
                            if (message.getTransportResponseContext() != null) {
                                try {
                                    httpStatus = Integer.parseInt(message.getTransportResponseContext().getCodiceTrasporto());
                                }
                                catch (Exception e) {
                                    throw new ProtocolException("Transport Response Context non contiene un http status valido (" + message.getTransportResponseContext().getCodiceTrasporto() + ")");
                                }
                            } else {
                                throw new ProtocolException("Transport Response Context non disponibile");
                            }
                            boolean match = false;
                            for (String codice : checkReturnCode) {
                                if (codice.contains("-")) {
                                    String[] tmp = codice.split("-");
                                    if (tmp == null || tmp.length != 2) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato; atteso: codiceMin-codiceMax");
                                    }
                                    String codiceMin = tmp[0];
                                    String codiceMax = tmp[1];
                                    if (codiceMin == null || StringUtils.isEmpty((CharSequence)codiceMin.trim())) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato (intervallo minimo non definito); atteso: codiceMin-codiceMax");
                                    }
                                    if (codiceMax == null || StringUtils.isEmpty((CharSequence)codiceMax.trim())) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' possiede un formato errato (intervallo massimo non definito); atteso: codiceMin-codiceMax");
                                    }
                                    codiceMin = codiceMin.trim();
                                    codiceMax = codiceMax.trim();
                                    int codiceMinInt = -1;
                                    try {
                                        codiceMinInt = Integer.valueOf(codiceMin);
                                    }
                                    catch (Exception e) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo minimo '" + codiceMin + "' che non \u00e8 un numero intero");
                                    }
                                    int codiceMaxInt = -1;
                                    try {
                                        codiceMaxInt = Integer.valueOf(codiceMax);
                                    }
                                    catch (Exception e) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo massimo '" + codiceMax + "' che non \u00e8 un numero intero");
                                    }
                                    if (codiceMaxInt <= codiceMinInt) {
                                        throw new ProtocolException("Codice Risposta '" + codice + "' contiene un intervallo massimo '" + codiceMax + "' minore o uguale all'intervallo minimo '" + codiceMin + "'");
                                    }
                                    if (codiceMinInt > httpStatus || httpStatus > codiceMaxInt) continue;
                                    match = true;
                                    break;
                                }
                                try {
                                    int codiceInt = Integer.parseInt(codice);
                                    if (codiceInt != httpStatus) continue;
                                    match = true;
                                    break;
                                }
                                catch (Exception e) {
                                    throw new ProtocolException("Codice Risposta '" + codice + "' non \u00e8 un numero intero");
                                }
                            }
                            processSecurity = match;
                        } else {
                            processSecurity = false;
                        }
                    }
                }
            }
        }
        if (processSecurity && !configurazionePersonalizzata) {
            boolean isFault = false;
            boolean processFault = false;
            if (rest) {
                isFault = message.isFault() || message.castAsRest().isProblemDetailsForHttpApis_RFC7807();
                processFault = modiProperties.isRestSecurityTokenFaultProcessEnabled();
            } else {
                isFault = message.isFault() || message.castAsSoap().hasSOAPFault();
                processFault = modiProperties.isSoapSecurityTokenFaultProcessEnabled();
            }
            if (isFault && !processFault) {
                processSecurity = false;
            }
        }
        return processSecurity;
    }

    private static List<String> readValues(String v) {
        ArrayList<String> codici = new ArrayList<String>();
        if (v != null && !StringUtils.isEmpty((CharSequence)v)) {
            if (v.contains(",")) {
                String[] tmp = v.split(",");
                for (int i = 0; i < tmp.length; ++i) {
                    codici.add(tmp[i].trim());
                }
            } else {
                codici.add(v.trim());
            }
        }
        return codici;
    }

    public static String readPurposeId(IConfigIntegrationReader configIntegrationReader, AccordoServizioParteSpecifica asps, IDSoggetto idFruitore, String azione) throws ProtocolException {
        boolean pdnd;
        boolean signedJWT;
        String tokenPolicy = ModIPropertiesUtils.readTokenPolicy(asps, idFruitore, azione);
        if (tokenPolicy != null && (signedJWT = ModIPropertiesUtils.isTokenPolicySignedJWT(configIntegrationReader, tokenPolicy)) && (pdnd = ModIPropertiesUtils.isTokenPolicyPdnd(configIntegrationReader, tokenPolicy))) {
            return ModIPropertiesUtils.getTokenPolicyPdndPurposeId(configIntegrationReader, tokenPolicy);
        }
        return null;
    }

    private static String readTokenPolicy(AccordoServizioParteSpecifica asps, IDSoggetto idFruitore, String azione) throws ProtocolException {
        if (asps != null && idFruitore != null) {
            try {
                if (asps.sizeFruitoreList() > 0) {
                    for (Fruitore fruitore : asps.getFruitoreList()) {
                        IDSoggetto check;
                        if (fruitore == null || !idFruitore.equals((Object)(check = new IDSoggetto(fruitore.getTipo(), fruitore.getNome())))) continue;
                        if (fruitore.getConfigurazioneAzioneList() != null && !fruitore.getConfigurazioneAzioneList().isEmpty()) {
                            for (ConfigurazioneServizioAzione csa : fruitore.getConfigurazioneAzioneList()) {
                                if (csa == null || csa.getAzioneList() == null || !csa.getAzioneList().contains(azione)) continue;
                                if (csa.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(csa.getConnettore().getTipo()) || csa.getConnettore().sizePropertyList() <= 0) break;
                                for (Property p : csa.getConnettore().getPropertyList()) {
                                    String tokenPolicy;
                                    if (!"tokenPolicy".equals(p.getNome()) || (tokenPolicy = p.getValore()) == null || !StringUtils.isNotEmpty((CharSequence)tokenPolicy) || "-".equals(tokenPolicy)) continue;
                                    return tokenPolicy;
                                }
                            }
                        }
                        if (fruitore.getConnettore() == null || TipiConnettore.DISABILITATO.getNome().equals(fruitore.getConnettore().getTipo()) || fruitore.getConnettore().sizePropertyList() <= 0) continue;
                        for (Property p : fruitore.getConnettore().getPropertyList()) {
                            String tokenPolicy;
                            if (!"tokenPolicy".equals(p.getNome()) || (tokenPolicy = p.getValore()) == null || !StringUtils.isNotEmpty((CharSequence)tokenPolicy) || "-".equals(tokenPolicy)) continue;
                            return tokenPolicy;
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isTokenPolicySignedJWT(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        try {
            GenericProperties gp = configIntegrationReader.getTokenPolicyNegoziazione(tokenPolicy);
            return ModIPropertiesUtils.isTokenPolicySignedJWT(gp);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isTokenPolicySignedJWT(GenericProperties gp) {
        boolean jwt = false;
        if (gp != null && gp.sizePropertyList() > 0) {
            for (int i = 0; i < gp.sizePropertyList(); ++i) {
                if (!"policy.retrieveToken.mode".equals(gp.getProperty(i).getNome())) continue;
                String v = gp.getProperty(i).getValore();
                jwt = "rfc7523_x509".equals(v);
            }
        }
        return jwt;
    }

    public static boolean isTokenPolicyPdnd(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        try {
            GenericProperties gp = configIntegrationReader.getTokenPolicyNegoziazione(tokenPolicy);
            return ModIPropertiesUtils.isTokenPolicyPdnd(gp);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isTokenPolicyPdnd(GenericProperties gp) {
        boolean pdnd = false;
        if (gp != null && gp.sizePropertyList() > 0) {
            for (int i = 0; i < gp.sizePropertyList(); ++i) {
                if (!"policy.retrieveToken.jwt.pdnd".equals(gp.getProperty(i).getNome())) continue;
                String v = gp.getProperty(i).getValore();
                pdnd = ModIPropertiesUtils.isEnabled(v);
            }
        }
        return pdnd;
    }

    public static boolean isTokenPolicyDPoP(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        try {
            GenericProperties gp = configIntegrationReader.getTokenPolicyNegoziazione(tokenPolicy);
            return ModIPropertiesUtils.isTokenPolicyDPoP(gp);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isTokenPolicyDPoP(GenericProperties gp) {
        boolean dpop = false;
        if (gp != null && gp.sizePropertyList() > 0) {
            for (int i = 0; i < gp.sizePropertyList(); ++i) {
                if (!"policy.retrieveToken.dpop".equals(gp.getProperty(i).getNome())) continue;
                String v = gp.getProperty(i).getValore();
                dpop = ModIPropertiesUtils.isEnabled(v);
            }
        }
        return dpop;
    }

    public static String getTokenPolicyPdndPurposeId(IConfigIntegrationReader configIntegrationReader, String tokenPolicy) throws ProtocolException {
        try {
            GenericProperties gp = configIntegrationReader.getTokenPolicyNegoziazione(tokenPolicy);
            if (gp != null && gp.sizePropertyList() > 0) {
                for (int i = 0; i < gp.sizePropertyList(); ++i) {
                    if (!"policy.retrieveToken.jwt.purposeId".equals(gp.getProperty(i).getNome())) continue;
                    return gp.getProperty(i).getValore();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isEnabled(String v) {
        return "true".equals(v) || "yes".equals(v);
    }
}

