/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import jakarta.xml.soap.SOAPEnvelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.protocol.basic.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.modipa.AbstractModISecurityToken;
import org.openspcoop2.protocol.modipa.ModIBustaRawContent;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.constants.ModICostanti;
import org.openspcoop2.protocol.modipa.constants.ModIHeaderType;
import org.openspcoop2.protocol.modipa.utils.ModIPropertiesUtils;
import org.openspcoop2.protocol.modipa.utils.ModISecurityConfig;
import org.openspcoop2.protocol.modipa.utils.ModITruststoreConfig;
import org.openspcoop2.protocol.modipa.utils.ModIUtilities;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSintatticaRest;
import org.openspcoop2.protocol.modipa.validator.ModIValidazioneSintatticaSoap;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.protocol.sdk.validator.ValidazioneSintatticaResult;
import org.openspcoop2.protocol.sdk.validator.ValidazioneUtils;

public class ModIValidazioneSintattica
extends ValidazioneSintattica<AbstractModISecurityToken<?>> {
    protected ValidazioneUtils validazioneUtils;
    private ModIProperties modiProperties;
    private static final String DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH = "validateTokenIdAuth";
    private static final String DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY = "validateTokenIntegrity";
    private static final String DIAGNOSTIC_IN_CORSO = "inCorso";
    private static final String DIAGNOSTIC_COMPLETATA = "completata";
    private static final String DIAGNOSTIC_FALLITA = "fallita";

    public ModIValidazioneSintattica(IProtocolFactory<AbstractModISecurityToken<?>> factory, IState state) throws ProtocolException {
        super(factory, state);
        this.validazioneUtils = new ValidazioneUtils(factory);
        this.modiProperties = ModIProperties.getInstance();
    }

    public ValidazioneSintatticaResult<AbstractModISecurityToken<?>> validaRichiesta(OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        ValidazioneSintatticaResult basicResult = super.validaRichiesta(msg, datiBustaLettiURLMappingProperties, proprietaValidazioneErrori);
        return this.validate(basicResult, true, msg, datiBustaLettiURLMappingProperties);
    }

    public ValidazioneSintatticaResult<AbstractModISecurityToken<?>> validaRisposta(OpenSPCoop2Message msg, Busta bustaRichiesta, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        ValidazioneSintatticaResult basicResult = super.validaRisposta(msg, bustaRichiesta, proprietaValidazioneErrori);
        return this.validate(basicResult, false, msg, bustaRichiesta);
    }

    private ValidazioneSintatticaResult<AbstractModISecurityToken<?>> validate(ValidazioneSintatticaResult<AbstractModISecurityToken<?>> basicResult, boolean request, OpenSPCoop2Message msg, Busta datiRichiesta) {
        String erroreProcessamentoInternalMessage;
        Busta bustaRitornata;
        ModIBustaRawContent rawContent;
        ArrayList<Eccezione> erroriProcessamento;
        ArrayList<Eccezione> erroriValidazione;
        block132: {
            erroriValidazione = new ArrayList<Eccezione>();
            erroriProcessamento = new ArrayList<Eccezione>();
            rawContent = null;
            bustaRitornata = basicResult.getBusta();
            erroreProcessamentoInternalMessage = null;
            try {
                boolean securityMessageProfilePrevedeTokenLocale;
                IDSoggetto idSoggetto;
                boolean filterPDND;
                ProtocolProperty pseudonymization;
                List protoProps;
                IDServizio idServizio = null;
                if (datiRichiesta == null || datiRichiesta.getTipoDestinatario() == null || datiRichiesta.getDestinatario() == null || datiRichiesta.getTipoServizio() == null || datiRichiesta.getServizio() == null || datiRichiesta.getVersioneServizio() == null) break block132;
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(datiRichiesta.getTipoServizio(), datiRichiesta.getServizio(), datiRichiesta.getTipoDestinatario(), datiRichiesta.getDestinatario(), datiRichiesta.getVersioneServizio().intValue());
                RequestInfo requestInfo = null;
                if (this.context != null && this.context.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)this.context.getObject(Costanti.REQUEST_INFO);
                }
                IRegistryReader registryReader = this.getProtocolFactory().getCachedRegistryReader(this.state, requestInfo);
                IConfigIntegrationReader configIntegrationReader = this.getProtocolFactory().getCachedConfigIntegrationReader(this.state, requestInfo);
                AccordoServizioParteSpecifica asps = registryReader.getAccordoServizioParteSpecifica(idServizio);
                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                AccordoServizioParteComune aspc = registryReader.getAccordoServizioParteComune(idAccordo);
                boolean rest = ServiceBinding.REST.equals((Object)aspc.getServiceBinding());
                String nomePortType = asps.getPortType();
                String azione = datiRichiesta.getAzione();
                IDSoggetto idSoggettoMittente = null;
                if (!request && datiRichiesta.getTipoMittente() != null && datiRichiesta.getMittente() != null) {
                    idSoggettoMittente = new IDSoggetto(datiRichiesta.getTipoMittente(), datiRichiesta.getMittente());
                }
                IDServizioApplicativo idSA = null;
                ServizioApplicativo sa = null;
                if (!request && datiRichiesta.getServizioApplicativoFruitore() != null && !"Anonimo".equals(datiRichiesta.getServizioApplicativoFruitore()) && idSoggettoMittente != null) {
                    idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(idSoggettoMittente);
                    idSA.setNome(datiRichiesta.getServizioApplicativoFruitore());
                    sa = configIntegrationReader.getServizioApplicativo(idSA);
                }
                if (!request && sa == null) {
                    IDServizioApplicativo idServizioApplicativoToken = null;
                    if (this.context != null && this.context.containsKey(Costanti.ID_APPLICATIVO_TOKEN)) {
                        idServizioApplicativoToken = (IDServizioApplicativo)this.context.getObject(Costanti.ID_APPLICATIVO_TOKEN);
                    }
                    if (idServizioApplicativoToken != null) {
                        idSA = idServizioApplicativoToken;
                        sa = configIntegrationReader.getServizioApplicativo(idSA);
                    }
                }
                ModIValidazioneSintatticaRest validatoreSintatticoRest = null;
                ModIValidazioneSintatticaSoap validatoreSintatticoSoap = null;
                if (rest) {
                    validatoreSintatticoRest = new ModIValidazioneSintatticaRest(this.log, this.state, this.context, this.protocolFactory, requestInfo, this.modiProperties, this.validazioneUtils);
                } else {
                    validatoreSintatticoSoap = new ModIValidazioneSintatticaSoap(this.log, this.state, this.context, this.protocolFactory, requestInfo, this.modiProperties, this.validazioneUtils);
                }
                boolean isFault = false;
                isFault = rest ? msg.isFault() || msg.castAsRest().isProblemDetailsForHttpApis_RFC7807() : msg.isFault() || msg.castAsSoap().hasSOAPFault();
                String interactionProfile = ModIPropertiesUtils.readPropertyInteractionProfile(aspc, nomePortType, azione);
                bustaRitornata.addProperty("ProfiloInterazione", interactionProfile);
                boolean bulkResource = ModIPropertiesUtils.readPropertyBulkResource(aspc);
                if (bulkResource && this.context != null) {
                    this.context.addObject(Costanti.MODIPA_BULK_RESOURCE_REST, (Object)"true");
                }
                if ("bloccante".equals(interactionProfile)) {
                    if (!isFault && rest) {
                        validatoreSintatticoRest.validateSyncInteractionProfile(msg, request, erroriValidazione);
                    }
                } else if ("nonBloccante".equals(interactionProfile)) {
                    String asyncInteractionType = ModIPropertiesUtils.readPropertyAsyncInteractionProfile(aspc, nomePortType, azione);
                    bustaRitornata.addProperty("ProfiloInterazioneAsincrona-Tipo", asyncInteractionType);
                    String asyncInteractionRole = ModIPropertiesUtils.readPropertyAsyncInteractionRole(aspc, nomePortType, azione);
                    bustaRitornata.addProperty("ProfiloInterazioneAsincrona-Ruolo", asyncInteractionRole);
                    AccordoServizioParteComune apiContenenteRisorsa = null;
                    if (!"Richiesta".equals(asyncInteractionRole)) {
                        if ("PUSH".equals(asyncInteractionType)) {
                            String asyncInteractionRequestApi = ModIPropertiesUtils.readPropertyAsyncInteractionRequestApi(aspc, nomePortType, azione);
                            IDAccordo idApiCorrelata = IDAccordoFactory.getInstance().getIDAccordoFromUri(asyncInteractionRequestApi);
                            String labelApi = NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idApiCorrelata);
                            bustaRitornata.addProperty("ProfiloInterazioneAsincrona-ApiCorrelata", labelApi);
                            apiContenenteRisorsa = registryReader.getAccordoServizioParteComune(idApiCorrelata, false, false);
                        } else {
                            apiContenenteRisorsa = aspc;
                        }
                        if (rest) {
                            String asyncInteractionRequestResource;
                            String labelResourceCorrelata = asyncInteractionRequestResource = ModIPropertiesUtils.readPropertyAsyncInteractionRequestAction(aspc, nomePortType, azione);
                            for (Resource r : apiContenenteRisorsa.getResourceList()) {
                                if (!r.getNome().equals(asyncInteractionRequestResource)) continue;
                                labelResourceCorrelata = NamingUtils.getLabelResource((Resource)r);
                                break;
                            }
                            bustaRitornata.addProperty("ProfiloInterazioneAsincrona-RisorsaCorrelata", labelResourceCorrelata);
                        } else {
                            String asyncInteractionRequestService = ModIPropertiesUtils.readPropertyAsyncInteractionRequestService(aspc, nomePortType, azione);
                            bustaRitornata.addProperty("ProfiloInterazioneAsincrona-ServizioCorrelato", asyncInteractionRequestService);
                            String asyncInteractionRequestAction = ModIPropertiesUtils.readPropertyAsyncInteractionRequestAction(aspc, nomePortType, azione);
                            bustaRitornata.addProperty("ProfiloInterazioneAsincrona-AzioneCorrelata", asyncInteractionRequestAction);
                        }
                    } else {
                        apiContenenteRisorsa = aspc;
                    }
                    String replyTo = null;
                    if ("Richiesta".equals(asyncInteractionRole) && request && "PUSH".equals(asyncInteractionType)) {
                        try {
                            replyTo = ModIUtilities.getReplyToFruizione(idServizio.getSoggettoErogatore(), idSoggettoMittente, aspc, nomePortType, azione, registryReader, configIntegrationReader, this.protocolFactory, this.state, requestInfo);
                        }
                        catch (Exception e) {
                            throw new ProtocolException("Configurazione presente nel registro non corretta: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (!isFault) {
                        if (rest) {
                            validatoreSintatticoRest.validateAsyncInteractionProfile(msg, request, asyncInteractionType, asyncInteractionRole, apiContenenteRisorsa, azione, bustaRitornata, erroriValidazione, replyTo);
                        } else {
                            validatoreSintatticoSoap.validateAsyncInteractionProfile(msg, request, asyncInteractionType, asyncInteractionRole, bustaRitornata, erroriValidazione, replyTo);
                        }
                    }
                }
                if (!(protoProps = asps.getProtocolProperty()).isEmpty() && ProtocolPropertiesUtils.getBooleanValuePropertyRegistry((List)protoProps, (String)"modipaInfoGenSignalHub", (boolean)false)) {
                    ProtocolProperty operation = ProtocolPropertiesUtils.getProtocolPropertyRegistry((List)protoProps, (String)"modipaInfoGenSignalHubOp", (boolean)false);
                    pseudonymization = ProtocolPropertiesUtils.getProtocolPropertyRegistry((List)protoProps, (String)"modipaInfoGenSignalHubPseudonymization", (boolean)false);
                    if (pseudonymization == null || !Boolean.FALSE.equals(pseudonymization.getBooleanValue())) {
                        if (operation == null) {
                            throw new ProtocolException("Required property [modipaInfoGenSignalHubOp] not found");
                        }
                        if (azione.equals(operation.getValue())) {
                            this.context.addObject(ModICostanti.MODIPA_KEY_INFO_SIGNAL_HUB_PROPERTIES, (Object)protoProps);
                            this.context.addObject(CostantiPdD.KEY_OVERRIDE_CONNETTORE, (Object)"signalHubPseudonymization");
                        }
                    }
                }
                String securityChannelProfile = ModIPropertiesUtils.readPropertySecurityChannelProfile(aspc, asps);
                bustaRitornata.addProperty("ProfiloSicurezzaCanale", securityChannelProfile);
                if (request && this.context != null) {
                    pseudonymization = ModIUtilities.newSecurityToken(this.context);
                }
                String securityMessageProfileNonFiltratoPDND = ModIPropertiesUtils.readPropertySecurityMessageProfile(aspc, nomePortType, azione, !(filterPDND = true));
                boolean existsSecurityFlusso = false;
                if (securityMessageProfileNonFiltratoPDND != null && !"-".equals(securityMessageProfileNonFiltratoPDND)) {
                    existsSecurityFlusso = ModIPropertiesUtils.processSecurity(this.log, aspc, nomePortType, azione, request, msg, rest, this.modiProperties);
                }
                if (!existsSecurityFlusso) break block132;
                bustaRitornata.addProperty("ProfiloSicurezzaMessaggio", ModIPropertiesUtils.convertProfiloSicurezzaToSDKValue(securityMessageProfileNonFiltratoPDND, rest));
                String sorgenteToken = ModIPropertiesUtils.readPropertySecurityMessageSorgenteToken(aspc, nomePortType, azione, true);
                bustaRitornata.addProperty("GenerazioneTokenIDAuth", ModIPropertiesUtils.convertProfiloSicurezzaSorgenteTokenToSDKValue(sorgenteToken));
                boolean sorgenteLocale = true;
                if ("pdnd".equals(sorgenteToken) || "oauth".equals(sorgenteToken)) {
                    sorgenteLocale = false;
                }
                String securityMessageProfile = ModIPropertiesUtils.readPropertySecurityMessageProfile(aspc, nomePortType, azione, filterPDND);
                MsgDiagnostico msgDiag = null;
                TipoPdD tipoPdD = request ? TipoPdD.APPLICATIVA : TipoPdD.DELEGATA;
                IDSoggetto iDSoggetto = idSoggetto = TipoPdD.DELEGATA.equals((Object)tipoPdD) ? idSoggettoMittente : idServizio.getSoggettoErogatore();
                if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
                    idSoggetto = OpenSPCoop2Properties.getInstance().getIdentitaPortaDefault(this.protocolFactory.getProtocol(), requestInfo);
                } else {
                    idSoggetto.setCodicePorta(registryReader.getDominio(idSoggetto));
                }
                msgDiag = MsgDiagnostico.newInstance((TipoPdD)TipoPdD.DELEGATA, (IDSoggetto)idSoggetto, (String)"ModI", requestInfo != null && requestInfo.getProtocolContext() != null ? requestInfo.getProtocolContext().getInterfaceName() : null, (RequestInfo)requestInfo, (IState)this.state);
                if (TipoPdD.DELEGATA.equals((Object)tipoPdD)) {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneContenutiApplicativi.");
                } else {
                    msgDiag.setPrefixMsgPersonalizzati("ricezioneBuste.");
                }
                msgDiag.setPddContext(this.context, this.protocolFactory);
                String tipoDiagnostico = request ? ".richiesta." : ".risposta.";
                boolean processSecurity = false;
                boolean bl = securityMessageProfilePrevedeTokenLocale = securityMessageProfile != null && !"-".equals(securityMessageProfile);
                if (securityMessageProfilePrevedeTokenLocale) {
                    processSecurity = existsSecurityFlusso;
                }
                boolean corniceSicurezza = ModIPropertiesUtils.isPropertySecurityMessageConCorniceSicurezza(aspc, nomePortType, azione);
                String patternCorniceSicurezza = null;
                String schemaCorniceSicurezza = null;
                boolean corniceSicurezzaOpzionale = false;
                if (corniceSicurezza) {
                    patternCorniceSicurezza = ModIPropertiesUtils.readPropertySecurityMessageCorniceSicurezzaPattern(aspc, nomePortType, azione);
                    if (patternCorniceSicurezza == null) {
                        patternCorniceSicurezza = "old";
                    }
                    if (!"old".equals(patternCorniceSicurezza)) {
                        schemaCorniceSicurezza = ModIPropertiesUtils.readPropertySecurityMessageCorniceSicurezzaSchema(aspc, nomePortType, azione);
                        corniceSicurezzaOpzionale = ModIPropertiesUtils.isPropertySecurityMessageCorniceSicurezzaOpzionale(aspc, nomePortType, azione);
                    }
                }
                boolean fruizione = !request;
                boolean processAudit = !fruizione && corniceSicurezza && patternCorniceSicurezza != null && !"old".equals(patternCorniceSicurezza);
                boolean keystoreKidMode = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile) || !sorgenteLocale;
                HashMap<String, Object> dynamicMap = null;
                ModISecurityConfig securityConfig = null;
                ModISecurityConfig securityConfigAudit = null;
                ModITruststoreConfig trustStoreCertificati = null;
                ModITruststoreConfig trustStoreSsl = null;
                String headerTokenRest = null;
                String headerTokenRestIntegrity = null;
                boolean integritaCustom = false;
                boolean buildSecurityTokenInRequest = true;
                if (processSecurity || processAudit) {
                    dynamicMap = new HashMap<String, Object>();
                    Boolean multipleHeaderAuthorizationConfig = null;
                    if (rest) {
                        String[] tmp;
                        headerTokenRest = ModIPropertiesUtils.readPropertySecurityMessageHeader(aspc, nomePortType, azione, request, filterPDND);
                        if (headerTokenRest.contains(" ") && (tmp = headerTokenRest.split(" ")) != null && tmp.length == 2 && tmp[0] != null && tmp[1] != null) {
                            headerTokenRest = tmp[0];
                            headerTokenRestIntegrity = tmp[1];
                            multipleHeaderAuthorizationConfig = true;
                        }
                        integritaCustom = ModIPropertiesUtils.isPropertySecurityMessageHeaderCustom(aspc, nomePortType, azione, request);
                    }
                    if (processAudit) {
                        securityConfigAudit = new ModISecurityConfig(msg, this.context, this.protocolFactory, this.state, requestInfo, idSoggettoMittente, aspc, asps, sa, rest, fruizione, request, multipleHeaderAuthorizationConfig, keystoreKidMode, patternCorniceSicurezza, schemaCorniceSicurezza);
                    }
                    boolean keystoreKidModeSecurityToken = keystoreKidMode;
                    if (rest && headerTokenRestIntegrity == null && ("idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile))) {
                        keystoreKidModeSecurityToken = false;
                    }
                    securityConfig = new ModISecurityConfig(msg, this.context, this.protocolFactory, this.state, requestInfo, idSoggettoMittente, aspc, asps, sa, rest, fruizione, request, multipleHeaderAuthorizationConfig, keystoreKidModeSecurityToken, patternCorniceSicurezza, schemaCorniceSicurezza);
                    trustStoreCertificati = new ModITruststoreConfig(fruizione, idSoggettoMittente, asps, false);
                    if (securityConfig.isX5u()) {
                        trustStoreSsl = new ModITruststoreConfig(fruizione, idSoggettoMittente, asps, true);
                    }
                    if (!request) {
                        String securityMessageRequest = null;
                        if (datiRichiesta != null) {
                            securityMessageRequest = datiRichiesta.getProperty("ProfiloSicurezzaMessaggio");
                        }
                        if (securityMessageRequest == null) {
                            buildSecurityTokenInRequest = false;
                        }
                        msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_BUILD_SECURITY_REQUEST_TOKEN, (Object)buildSecurityTokenInRequest);
                    } else if (this.context != null) {
                        this.context.addObject(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_BUILD_SECURITY_REQUEST_TOKEN, (Object)processSecurity);
                    }
                }
                boolean errorOccurs = false;
                if (processSecurity) {
                    boolean integrita;
                    boolean includiRequestDigest = ModIPropertiesUtils.isPropertySecurityMessageIncludiRequestDigest(aspc, nomePortType, azione);
                    boolean signAttachments = false;
                    if (!rest) {
                        signAttachments = ModIPropertiesUtils.isAttachmentsSignature(aspc, nomePortType, azione, request, msg);
                    }
                    boolean integritaX509 = "idam0301".equals(securityMessageProfile) || "idam0302".equals(securityMessageProfile);
                    boolean integritaKid = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                    boolean bl2 = integrita = integritaX509 || integritaKid;
                    if (rest) {
                        boolean securityHeaderObbligatorio = true;
                        if (headerTokenRestIntegrity == null) {
                            String token = null;
                            String prefixMsgDiag = null;
                            prefixMsgDiag = "Authorization".equalsIgnoreCase(headerTokenRest) ? DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH : DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY;
                            try {
                                String headerTokenRestOption;
                                boolean opzioneDueHeaderRichiestaGeneraSoloIntegrityRisposta;
                                msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                String integrityMode = ModIPropertiesUtils.getPropertySecurityMessageHeaderCustomMode(aspc, nomePortType, azione, request);
                                boolean expectedIntegrity = false;
                                expectedIntegrity = msg.castAsRest().hasContent() ? true : "always".equals(integrityMode) || request && "responsePayload".equals(integrityMode) || !request && "requestPayload".equals(integrityMode);
                                boolean validateToken = false;
                                validateToken = sorgenteLocale ? (request ? true : (!(opzioneDueHeaderRichiestaGeneraSoloIntegrityRisposta = "autonlyreq_modipa".equals(headerTokenRestOption = ModIPropertiesUtils.readPropertySecurityMessageHeaderRawOptionValue(aspc, nomePortType, azione, request))) ? true : expectedIntegrity)) : expectedIntegrity;
                                securityHeaderObbligatorio = validateToken;
                                token = validatoreSintatticoRest.validateSecurityProfile(msg, request, securityMessageProfile, false, headerTokenRest, corniceSicurezza, patternCorniceSicurezza, null, includiRequestDigest, bustaRitornata, erroriValidazione, trustStoreCertificati, trustStoreSsl, securityConfig, buildSecurityTokenInRequest, ModIHeaderType.SINGLE, integritaCustom, integrityMode, securityHeaderObbligatorio, dynamicMap, datiRichiesta, idSoggetto, msgDiag);
                                if (token != null || !sorgenteLocale) {
                                    // empty if block
                                }
                                if (erroriValidazione.isEmpty()) {
                                    msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                                } else {
                                    String errore = ModIValidazioneSintattica.buildErrore(erroriValidazione, this.protocolFactory);
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                                    msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                    errorOccurs = true;
                                }
                            }
                            catch (ProtocolException pe) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                throw pe;
                            }
                            if (token != null) {
                                if (securityConfig.getAudience() != null && (request || securityConfig.isCheckAudience())) {
                                    String audience = securityConfig.getAudience();
                                    if (fruizione && !request) {
                                        try {
                                            audience = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience", audience, dynamicMap, this.context);
                                        }
                                        catch (Exception e) {
                                            this.logError(e.getMessage(), e);
                                            throw e;
                                        }
                                    }
                                    msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK, (Object)audience);
                                }
                                if (!request && securityConfig.isCheckAudience() && integritaKid && securityConfig.getTokenClientId() != null) {
                                    String audienceClientId = null;
                                    try {
                                        audienceClientId = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience-OAuth", securityConfig.getTokenClientId(), dynamicMap, this.context);
                                    }
                                    catch (Exception e) {
                                        this.logError(e.getMessage(), e);
                                        throw e;
                                    }
                                    if (audienceClientId != null) {
                                        msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK_OAUTH, (Object)audienceClientId);
                                    }
                                }
                                rawContent = new ModIBustaRawContent(headerTokenRest, token);
                            }
                        } else {
                            boolean useKIDforIdAUTH = false;
                            if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile)) {
                                useKIDforIdAUTH = true;
                            }
                            String tokenAuthorization = null;
                            try {
                                msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                String securityMessageProfileAuthorization = null;
                                securityMessageProfileAuthorization = "idam0301".equals(securityMessageProfile) || "idam0401".equals(securityMessageProfile) ? "idam01" : "idam02";
                                tokenAuthorization = validatoreSintatticoRest.validateSecurityProfile(msg, request, securityMessageProfileAuthorization, useKIDforIdAUTH, headerTokenRest, corniceSicurezza, patternCorniceSicurezza, null, includiRequestDigest, bustaRitornata, erroriValidazione, trustStoreCertificati, trustStoreSsl, securityConfig, buildSecurityTokenInRequest, ModIHeaderType.BOTH_AUTH, integritaCustom, null, securityHeaderObbligatorio, dynamicMap, datiRichiesta, idSoggetto, msgDiag);
                                String audAuthorization = null;
                                if (tokenAuthorization != null && securityConfig.getAudience() != null && (request || securityConfig.isCheckAudience())) {
                                    audAuthorization = securityConfig.getAudience();
                                    if (fruizione && !request) {
                                        try {
                                            audAuthorization = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience", audAuthorization, dynamicMap, this.context);
                                        }
                                        catch (Exception e) {
                                            this.logError(e.getMessage(), e);
                                            throw e;
                                        }
                                    }
                                    msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK, (Object)audAuthorization);
                                }
                                if (erroriValidazione.isEmpty()) {
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                                } else {
                                    String errore = ModIValidazioneSintattica.buildErrore(erroriValidazione, this.protocolFactory);
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                    errorOccurs = true;
                                }
                            }
                            catch (ProtocolException pe) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                throw pe;
                            }
                            String tokenIntegrity = null;
                            ModISecurityConfig securityConfigIntegrity = null;
                            try {
                                msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                                String integrityMode = ModIPropertiesUtils.getPropertySecurityMessageHeaderCustomMode(aspc, nomePortType, azione, request);
                                boolean securityHeaderIntegrityObbligatorio = false;
                                securityHeaderIntegrityObbligatorio = msg.castAsRest().hasContent() ? true : "always".equals(integrityMode) || request && "responsePayload".equals(integrityMode) || !request && "requestPayload".equals(integrityMode);
                                boolean keystoreKidModeIntegrity = "idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile);
                                securityConfigIntegrity = new ModISecurityConfig(msg, this.context, this.protocolFactory, this.state, requestInfo, idSoggettoMittente, aspc, asps, sa, rest, fruizione, request, false, keystoreKidModeIntegrity, patternCorniceSicurezza, schemaCorniceSicurezza);
                                tokenIntegrity = validatoreSintatticoRest.validateSecurityProfile(msg, request, securityMessageProfile, useKIDforIdAUTH, headerTokenRestIntegrity, corniceSicurezza, patternCorniceSicurezza, null, includiRequestDigest, bustaRitornata, erroriValidazione, trustStoreCertificati, trustStoreSsl, securityConfigIntegrity, buildSecurityTokenInRequest, ModIHeaderType.BOTH_INTEGRITY, integritaCustom, integrityMode, securityHeaderIntegrityObbligatorio, null, null, idSoggetto, msgDiag);
                                if (tokenIntegrity == null) {
                                    String idAuth = bustaRitornata.getProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId");
                                    String id = bustaRitornata.getProperty("ProfiloSicurezzaMessaggio-MessageId");
                                    if ((id == null || StringUtils.isEmpty((CharSequence)id)) && idAuth != null && StringUtils.isNotEmpty((CharSequence)idAuth) && !idAuth.equals(bustaRitornata.getID())) {
                                        bustaRitornata.removeProperty("ProfiloSicurezzaMessaggio-AuthorizationMessageId");
                                        bustaRitornata.addProperty("ProfiloSicurezzaMessaggio-MessageId", idAuth);
                                        if (idAuth.length() <= 255) {
                                            bustaRitornata.setID(idAuth);
                                        }
                                    }
                                }
                                if (erroriValidazione.isEmpty()) {
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                                } else {
                                    String errore = ModIValidazioneSintattica.buildErrore(erroriValidazione, this.protocolFactory);
                                    msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                                    msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                    errorOccurs = true;
                                }
                            }
                            catch (ProtocolException pe) {
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                                msgDiag.logPersonalizzato(DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                throw pe;
                            }
                            if (tokenIntegrity != null && securityConfigIntegrity.getAudience() != null && (request || securityConfigIntegrity.isCheckAudience())) {
                                String audIntegrity = securityConfigIntegrity.getAudience();
                                if (fruizione && !request) {
                                    try {
                                        audIntegrity = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience", audIntegrity, dynamicMap, this.context);
                                    }
                                    catch (Exception e) {
                                        this.logError(e.getMessage(), e);
                                        throw e;
                                    }
                                }
                                msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_INTEGRITY_CHECK, (Object)audIntegrity);
                                if (!request && securityConfig.isCheckAudience() && integritaKid && securityConfig.getTokenClientId() != null) {
                                    String audienceClientId = null;
                                    try {
                                        audienceClientId = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-Audience-OAuth", securityConfig.getTokenClientId(), dynamicMap, this.context);
                                    }
                                    catch (Exception e) {
                                        this.logError(e.getMessage(), e);
                                        throw e;
                                    }
                                    if (audienceClientId != null) {
                                        msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_INTEGRITY_CHECK_OAUTH, (Object)audienceClientId);
                                    }
                                }
                            }
                            if (tokenAuthorization != null && tokenIntegrity != null) {
                                rawContent = new ModIBustaRawContent(tokenAuthorization, headerTokenRestIntegrity, tokenIntegrity);
                            } else if (tokenAuthorization != null) {
                                rawContent = new ModIBustaRawContent(headerTokenRest, tokenAuthorization);
                            } else if (tokenIntegrity != null) {
                                rawContent = new ModIBustaRawContent(headerTokenRestIntegrity, tokenIntegrity);
                            }
                        }
                    } else {
                        String prefixMsgDiag = null;
                        prefixMsgDiag = integrita ? DIAGNOSTIC_VALIDATE_TOKEN_INTEGRITY : DIAGNOSTIC_VALIDATE_TOKEN_ID_AUTH;
                        try {
                            msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_IN_CORSO);
                            boolean corniceSicurezzaLegacySoap = corniceSicurezza && !processAudit;
                            SOAPEnvelope token = validatoreSintatticoSoap.validateSecurityProfile(msg, request, securityMessageProfile, corniceSicurezzaLegacySoap, includiRequestDigest, signAttachments, bustaRitornata, erroriValidazione, trustStoreCertificati, securityConfig, buildSecurityTokenInRequest, dynamicMap, datiRichiesta, requestInfo, msgDiag);
                            if (token != null) {
                                if (securityConfig.getAudience() != null && (request || securityConfig.isCheckAudience())) {
                                    String audience = securityConfig.getAudience();
                                    if (fruizione && !request) {
                                        try {
                                            audience = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggio-WSA-To", audience, dynamicMap, this.context);
                                        }
                                        catch (Exception e) {
                                            this.logError(e.getMessage(), e);
                                            throw e;
                                        }
                                    }
                                    msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_CHECK, (Object)audience);
                                }
                                rawContent = new ModIBustaRawContent(token);
                            }
                            if (erroriValidazione.isEmpty()) {
                                msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_COMPLETATA);
                            } else {
                                String errore = ModIValidazioneSintattica.buildErrore(erroriValidazione, this.protocolFactory);
                                msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                                msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                                errorOccurs = true;
                            }
                        }
                        catch (ProtocolException pe) {
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                            msgDiag.logPersonalizzato(prefixMsgDiag + tipoDiagnostico + DIAGNOSTIC_FALLITA);
                            throw pe;
                        }
                    }
                }
                if (!errorOccurs && processAudit) {
                    bustaRitornata.addProperty("ProfiloSicurezzaAudit", ModIPropertiesUtils.convertProfiloAuditToSDKValue(patternCorniceSicurezza));
                    bustaRitornata.addProperty("ProfiloSicurezzaAudit-SchemaDati", ModIPropertiesUtils.convertSchemaAuditToSDKValue(schemaCorniceSicurezza, this.modiProperties));
                    if (validatoreSintatticoRest == null) {
                        validatoreSintatticoRest = new ModIValidazioneSintatticaRest(this.log, this.state, this.context, this.protocolFactory, requestInfo, this.modiProperties, this.validazioneUtils);
                    }
                    String securityMessageProfileAudit = null;
                    securityMessageProfileAudit = "idam0301".equals(securityMessageProfile) || "idam0401".equals(securityMessageProfile) ? "idam01" : "idam02";
                    boolean useKIDforAudit = false;
                    if ("idam0401".equals(securityMessageProfile) || "idam0402".equals(securityMessageProfile) || !sorgenteLocale) {
                        useKIDforAudit = true;
                    }
                    String headerTokenAudit = this.modiProperties.getSecurityTokenHeaderModIAudit();
                    try {
                        msgDiag.logPersonalizzato("validateTokenAudit.richiesta.inCorso");
                        boolean securityHeaderObbligatorio = !corniceSicurezzaOpzionale;
                        String tokenAudit = validatoreSintatticoRest.validateSecurityProfile(msg, request, securityMessageProfileAudit, useKIDforAudit, headerTokenAudit, corniceSicurezza, patternCorniceSicurezza, schemaCorniceSicurezza, false, bustaRitornata, erroriValidazione, trustStoreCertificati, trustStoreSsl, securityConfigAudit, buildSecurityTokenInRequest, ModIHeaderType.SINGLE, integritaCustom, null, securityHeaderObbligatorio, dynamicMap, datiRichiesta, idSoggetto, msgDiag);
                        if (tokenAudit != null) {
                            String audExpected = securityConfig.getCorniceSicurezzaAudience();
                            try {
                                audExpected = ModIUtilities.getDynamicValue("ProfiloSicurezzaMessaggioAudit-Audience", audExpected, dynamicMap, this.context);
                            }
                            catch (Exception e) {
                                this.logError(e.getMessage(), e);
                                throw e;
                            }
                            msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_AUDIENCE_AUDIT_CHECK, (Object)audExpected);
                        }
                        if (rawContent != null) {
                            ((AbstractModISecurityToken)rawContent.getElement()).setTokenAudit(headerTokenAudit, tokenAudit);
                        }
                        if (erroriValidazione.isEmpty()) {
                            msgDiag.logPersonalizzato("validateTokenAudit.richiesta.completata");
                        } else {
                            String errore = ModIValidazioneSintattica.buildErrore(erroriValidazione, this.protocolFactory);
                            msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", errore);
                            msgDiag.logPersonalizzato("validateTokenAudit.richiesta.fallita");
                        }
                    }
                    catch (ProtocolException pe) {
                        msgDiag.addKeyword("@ERRORE_PROCESSAMENTO@", pe.getMessage());
                        msgDiag.logPersonalizzato("validateTokenAudit.richiesta.fallita");
                        throw pe;
                    }
                }
                if (request && !sorgenteLocale) {
                    if (processSecurity) {
                        String multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry;
                        String idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio = "modipaSecurityMessageRequestDuplicateJti";
                        List<ProtocolProperty> listProtocolPropertiesInternal = ModIPropertiesUtils.getProtocolProperties(fruizione, idSoggettoMittente, asps);
                        if (listProtocolPropertiesInternal != null && !listProtocolPropertiesInternal.isEmpty() && (multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry = ProtocolPropertiesUtils.getOptionalStringValuePropertyRegistry(listProtocolPropertiesInternal, (String)idPropertyMultipleHeaderUseJtiAuthorizationAsIdMessaggio)) != null) {
                            boolean multipleHeaderUseJtiAuthorizationAsIdMessaggio = "auth".equals(multipleHeaderUseJtiAuthorizationAsIdMessaggioPropRegistry);
                            msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_USE_JTI_AUTHORIZATION, (Object)multipleHeaderUseJtiAuthorizationAsIdMessaggio);
                        }
                    } else {
                        msg.addContextProperty(ModICostanti.MODIPA_OPENSPCOOP2_MSG_CONTEXT_USE_JTI_AUTHORIZATION, (Object)true);
                    }
                }
            }
            catch (Exception e) {
                erroreProcessamentoInternalMessage = e.getMessage();
                String msgErrore = "[ErroreInterno]: " + e.getMessage();
                this.logError(msgErrore, e);
                if (request) {
                    ValidazioneSintatticaResult errorResult = new ValidazioneSintatticaResult(null, null, null, bustaRitornata, new ErroreCooperazione(msgErrore, CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO), null, null, false);
                    errorResult.setErrore_integrationFunctionError(IntegrationFunctionError.INTERNAL_REQUEST_ERROR);
                    return errorResult;
                }
                try {
                    erroriProcessamento.add(this.validazioneUtils.newEccezioneProcessamento(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO));
                }
                catch (Exception eInternal) {
                    ValidazioneSintatticaResult errorResult = new ValidazioneSintatticaResult(null, null, null, bustaRitornata, new ErroreCooperazione(msgErrore, CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO), null, null, false);
                    errorResult.setErrore_integrationFunctionError(IntegrationFunctionError.INTERNAL_RESPONSE_ERROR);
                    return errorResult;
                }
            }
        }
        if (!erroriValidazione.isEmpty() || !erroriProcessamento.isEmpty()) {
            ValidazioneSintatticaResult resultError = new ValidazioneSintatticaResult(erroriValidazione, erroriProcessamento, null, bustaRitornata, null, null, rawContent, true);
            resultError.setErroreProcessamento_internalMessage(erroreProcessamentoInternalMessage);
            if (!erroriValidazione.isEmpty() && this.context != null) {
                this.context.addObject(Costanti.ERRORE_VALIDAZIONE_PROTOCOLLO, (Object)"true");
            }
            return resultError;
        }
        basicResult.setBustaRaw(rawContent);
        return basicResult;
    }

    static String buildErrore(List<Eccezione> list, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        return ModIValidazioneSintattica.buildErrore(list, 0, protocolFactory);
    }

    static String buildErrore(List<Eccezione> list, int offset, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1) {
                if (offset > 0) {
                    throw new ProtocolException("Offset > 0 con lista di dimensione '" + list.size() + "'");
                }
                Eccezione eccezione = list.get(0);
                sb.append("[");
                sb.append(eccezione.getCodiceEccezioneValue(protocolFactory));
                sb.append("] ");
                sb.append(eccezione.getDescrizione(protocolFactory));
            } else {
                if (offset > list.size()) {
                    throw new ProtocolException("Offset maggiore della dimensione della lista di errori '" + list.size() + "'");
                }
                int size = list.size() - offset;
                sb.append("Riscontrate " + size + " eccezioni.");
                int index = 0;
                for (Eccezione eccezione : list) {
                    if (index >= offset) {
                        sb.append("\n[");
                        sb.append(eccezione.getCodiceEccezioneValue(protocolFactory));
                        sb.append("] ");
                        sb.append(eccezione.getDescrizione(protocolFactory));
                    }
                    ++index;
                }
            }
        }
        return sb.toString();
    }
}

