/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.properties;

import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.protocol.basic.properties.BasicDynamicConfiguration;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteComuneUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationAccordiParteSpecificaUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationApplicativiUtilities;
import org.openspcoop2.protocol.modipa.properties.ModIDynamicConfigurationSoggettiUtilities;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.ModISecurityUtils;

public class ModIDynamicConfiguration
extends BasicDynamicConfiguration
implements IConsoleDynamicConfiguration {
    private ModIProperties modiProperties = ModIProperties.getInstance();

    public ModIDynamicConfiguration(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public ConsoleConfiguration getDynamicConfigSoggetto(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        ConsoleConfiguration configuration = ModIDynamicConfigurationSoggettiUtilities.getDynamicConfigSoggetto(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigSoggetto(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigSoggetto(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        ModIDynamicConfigurationSoggettiUtilities.updateDynamicConfigSoggetto(consoleConfiguration, consoleOperationType, consoleHelper, properties, configIntegrationReader, registryReader, id);
    }

    public void validateDynamicConfigSoggetto(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDSoggetto id) throws ProtocolException {
        ModIDynamicConfigurationSoggettiUtilities.validateDynamicConfigSoggetto(consoleConfiguration, consoleOperationType, consoleHelper, properties, configIntegrationReader, id, registryReader);
    }

    public ConsoleConfiguration getDynamicConfigServizioApplicativo(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        ConsoleConfiguration configuration = ModIDynamicConfigurationApplicativiUtilities.getDynamicConfigServizioApplicativo(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigServizioApplicativo(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigServizioApplicativo(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        ModIDynamicConfigurationApplicativiUtilities.updateDynamicConfigServizioApplicativo(consoleConfiguration, consoleOperationType, consoleHelper, properties, configIntegrationReader, id);
    }

    public void validateDynamicConfigServizioApplicativo(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizioApplicativo id) throws ProtocolException {
        ModIDynamicConfigurationApplicativiUtilities.validateDynamicConfigServizioApplicativo(consoleConfiguration, consoleOperationType, consoleHelper, properties, configIntegrationReader, id);
    }

    public ConsoleConfiguration getDynamicConfigAccordoServizioParteComune(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        if (ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(id, registryReader, this.modiProperties, this.log)) {
            // empty if block
        }
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAPITitleId", (String)"ModI");
        configuration.addConsoleItem(titolo);
        boolean rest = ModIDynamicConfigurationAccordiParteComuneUtilities.isApiRest(consoleOperationType, consoleHelper, registryReader, id);
        if (rest) {
            configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIProfiloInterazioneRestSubTitleId", (String)"Interazione"));
            BooleanConsoleItem bulkResourceItem = (BooleanConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.BOOLEAN, (ConsoleItemType)ConsoleItemType.CHECKBOX, (String)"modipaInteractionBulkResource", (String)"");
            bulkResourceItem.setLabelRight("Risorse Massive (BULK_RESOURCE_REST)");
            bulkResourceItem.setDefaultValue((Object)false);
            configuration.addConsoleItem((BaseConsoleItem)bulkResourceItem);
        }
        configuration.addConsoleItem(ProtocolPropertiesFactory.newSubTitleItem((String)"modipaAPIProfiloSicurezzaSubTitleId", (String)"Sicurezza Canale"));
        StringConsoleItem profiloSicurezzaCanaleItem = (StringConsoleItem)ProtocolPropertiesFactory.newConsoleItem((ConsoleItemValueType)ConsoleItemValueType.STRING, (ConsoleItemType)ConsoleItemType.SELECT, (String)"modipaSecurityChannelProfile", (String)"Pattern");
        profiloSicurezzaCanaleItem.addLabelValue(this.modiProperties.isModIVersioneBozza() != null && this.modiProperties.isModIVersioneBozza() != false ? "IDAC01" : "ID_AUTH_CHANNEL_01", (Object)"idac01");
        profiloSicurezzaCanaleItem.addLabelValue(this.modiProperties.isModIVersioneBozza() != null && this.modiProperties.isModIVersioneBozza() != false ? "IDAC02" : "ID_AUTH_CHANNEL_02", (Object)"idac02");
        profiloSicurezzaCanaleItem.setDefaultValue((Object)"idac01");
        if ("idac01".equals("idac01")) {
            profiloSicurezzaCanaleItem.setNote("Direct Trust Transport-Level Security");
        } else if ("idac01".equals("idac02")) {
            profiloSicurezzaCanaleItem.setNote("Direct Trust mutual Transport-Level Security");
        }
        profiloSicurezzaCanaleItem.setReloadOnChange(true);
        configuration.addConsoleItem((BaseConsoleItem)profiloSicurezzaCanaleItem);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.addProfiloSicurezzaMessaggio(this.modiProperties, configuration, rest, false, null);
        return configuration;
    }

    public void updateDynamicConfigAccordoServizioParteComune(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        if (ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(id, registryReader, this.modiProperties, this.log)) {
            // empty if block
        }
        ModIDynamicConfigurationAccordiParteComuneUtilities.updateProfiloSicurezzaCanale(consoleConfiguration, properties);
        boolean rest = ModIDynamicConfigurationAccordiParteComuneUtilities.isApiRest(consoleOperationType, consoleHelper, registryReader, id);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.updateProfiloSicurezzaMessaggio(this.modiProperties, consoleConfiguration, consoleHelper, properties, rest, false);
    }

    public void validateDynamicConfigAccordoServizioParteComune(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDAccordo id) throws ProtocolException {
        if (ModIDynamicConfigurationAccordiParteComuneUtilities.isApiSignalHubPushAPI(id, registryReader, this.modiProperties, this.log)) {
            // empty if block
        }
        ModIDynamicConfigurationAccordiParteComuneUtilities.validateDynamicConfigAccordoServizioParteComune(consoleOperationType, consoleHelper, properties, registryReader, id);
    }

    public ConsoleConfiguration getDynamicConfigOperation(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDPortTypeAzione id) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAzioneTitleId", (String)"ModI");
        configuration.addConsoleItem(titolo);
        ModIDynamicConfigurationAccordiParteComuneUtilities.addProfiloInterazione(this.modiProperties, configuration, false, null);
        AccordoServizioParteComune api = null;
        try {
            api = registryReader.getAccordoServizioParteComune(id.getIdPortType().getIdAccordo(), false, false);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        String schemaAuditImpostatoInAPIoAltreAzioni = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema((AccordoServizioParteComune)api, (String)id.getIdPortType().getNome());
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.addProfiloSicurezzaMessaggio(this.modiProperties, configuration, false, true, schemaAuditImpostatoInAPIoAltreAzioni);
        return configuration;
    }

    public void updateDynamicConfigOperation(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDPortTypeAzione id) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteComuneUtilities.updateProfiloInterazione(this.modiProperties, this.protocolFactory, this.log, consoleConfiguration, consoleOperationType, properties, registryReader, id.getIdPortType().getIdAccordo(), id.getIdPortType().getNome(), id.getNome(), false, null);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.updateProfiloSicurezzaMessaggio(this.modiProperties, consoleConfiguration, consoleHelper, properties, false, true);
    }

    public void validateDynamicConfigOperation(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDPortTypeAzione id) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteComuneUtilities.validateProfiloInterazione(properties, id.getIdPortType().getNome(), false);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.validateProfiloSicurezzaMessaggio(properties, false);
    }

    public ConsoleConfiguration getDynamicConfigResource(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDResource id, String httpMethod, String path) throws ProtocolException {
        ConsoleConfiguration configuration = new ConsoleConfiguration();
        BaseConsoleItem titolo = ProtocolPropertiesFactory.newTitleItem((String)"modipaAzioneTitleId", (String)"ModI");
        configuration.addConsoleItem(titolo);
        ModIDynamicConfigurationAccordiParteComuneUtilities.addProfiloInterazione(this.modiProperties, configuration, true, httpMethod);
        AccordoServizioParteComune api = null;
        try {
            api = registryReader.getAccordoServizioParteComune(id.getIdAccordo(), false, false);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
        String schemaAuditImpostatoInAPIoAltreAzioni = ModISecurityUtils.getProfiloSicurezzaMessaggioCorniceSicurezzaSchema((AccordoServizioParteComune)api, null);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.addProfiloSicurezzaMessaggio(this.modiProperties, configuration, true, true, schemaAuditImpostatoInAPIoAltreAzioni);
        return configuration;
    }

    public void updateDynamicConfigResource(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDResource id, String httpMethod, String path) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteComuneUtilities.updateProfiloInterazione(this.modiProperties, this.protocolFactory, this.log, consoleConfiguration, consoleOperationType, properties, registryReader, id.getIdAccordo(), null, id.getNome(), true, httpMethod);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.updateProfiloSicurezzaMessaggio(this.modiProperties, consoleConfiguration, consoleHelper, properties, true, true);
    }

    public void validateDynamicConfigResource(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDResource id, String httpMethod, String path) throws ProtocolException {
        ModIDynamicConfigurationAccordiParteComuneUtilities.validateProfiloInterazione(properties, null, true);
        ModIDynamicConfigurationAccordiParteComuneSicurezzaMessaggioUtilities.validateProfiloSicurezzaMessaggio(properties, true);
    }

    public ConsoleConfiguration getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        ConsoleConfiguration configuration = ModIDynamicConfigurationAccordiParteSpecificaUtilities.getDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id, null, false);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        boolean operazioneGestita = ModIDynamicConfigurationAccordiParteSpecificaUtilities.updateDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleConfiguration, consoleOperationType, consoleHelper, properties, id, registryReader, configIntegrationReader, false);
        if (!operazioneGestita) {
            super.updateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
        }
    }

    public void validateDynamicConfigAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDServizio id) throws ProtocolException {
        boolean operazioneGestita = ModIDynamicConfigurationAccordiParteSpecificaUtilities.validateDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleConfiguration, consoleHelper, properties, id, registryReader, configIntegrationReader, false);
        if (!operazioneGestita) {
            super.validateDynamicConfigAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
        }
    }

    public ConsoleConfiguration getDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        ConsoleConfiguration configuration = ModIDynamicConfigurationAccordiParteSpecificaUtilities.getDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id.getIdServizio(), id.getIdFruitore(), true);
        if (configuration != null) {
            return configuration;
        }
        return super.getDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleOperationType, consoleHelper, registryReader, configIntegrationReader, id);
    }

    public void updateDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        boolean operazioneGestita = ModIDynamicConfigurationAccordiParteSpecificaUtilities.updateDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleConfiguration, consoleOperationType, consoleHelper, properties, id.getIdServizio(), registryReader, configIntegrationReader, true);
        if (!operazioneGestita) {
            super.updateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
        }
    }

    public void validateDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, IConsoleHelper consoleHelper, ProtocolProperties properties, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IDFruizione id) throws ProtocolException {
        boolean operazioneGestita = ModIDynamicConfigurationAccordiParteSpecificaUtilities.validateDynamicConfigParteSpecifica(this.log, this.modiProperties, consoleConfiguration, consoleHelper, properties, id.getIdServizio(), registryReader, configIntegrationReader, true);
        if (!operazioneGestita) {
            super.validateDynamicConfigFruizioneAccordoServizioParteSpecifica(consoleConfiguration, consoleOperationType, consoleHelper, properties, registryReader, configIntegrationReader, id);
        }
    }
}

