/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.modipa.validator;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.protocol.modipa.config.ModIProperties;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.security.SecurityException;

public class ModIRESTSecurity {
    private List<String> tokenHeaderNames = new ArrayList<String>();
    private boolean cleanDigest;
    private RuoloMessaggio ruoloMessaggio;

    public ModIRESTSecurity(String tokenHeaderName, boolean request) throws ProtocolException, Exception {
        this.tokenHeaderNames.add(tokenHeaderName);
        this.ruoloMessaggio = request ? RuoloMessaggio.RICHIESTA : RuoloMessaggio.RISPOSTA;
        switch (this.ruoloMessaggio) {
            case RICHIESTA: {
                this.cleanDigest = ModIProperties.getInstance().isRestSecurityTokenRequestDigestClean();
                break;
            }
            case RISPOSTA: {
                this.cleanDigest = ModIProperties.getInstance().isRestSecurityTokenResponseDigestClean();
            }
        }
    }

    public RuoloMessaggio getRuoloMessaggio() {
        return this.ruoloMessaggio;
    }

    public void setRuoloMessaggio(RuoloMessaggio ruoloMessaggio) {
        this.ruoloMessaggio = ruoloMessaggio;
    }

    public List<String> getTokenHeaderNames() {
        return this.tokenHeaderNames;
    }

    public void setTokenHeaderNames(List<String> tokenHeaderNames) {
        this.tokenHeaderNames = tokenHeaderNames;
    }

    public boolean isCleanDigest() {
        return this.cleanDigest;
    }

    public void setCleanDigest(boolean cleanDigest) {
        this.cleanDigest = cleanDigest;
    }

    public void clean(OpenSPCoop2Message msg) throws SecurityException, MessageException, MessageNotSupportedException {
        if (RuoloMessaggio.RICHIESTA.equals((Object)this.ruoloMessaggio)) {
            if (msg != null && msg.getTransportRequestContext() != null) {
                if (this.tokenHeaderNames != null && !this.tokenHeaderNames.isEmpty()) {
                    for (String hdr : this.tokenHeaderNames) {
                        msg.getTransportRequestContext().removeHeader(hdr);
                    }
                }
                if (this.cleanDigest) {
                    msg.getTransportRequestContext().removeHeader("Digest");
                }
            }
        } else if (msg != null && msg.getTransportResponseContext() != null) {
            if (this.tokenHeaderNames != null && !this.tokenHeaderNames.isEmpty()) {
                for (String hdr : this.tokenHeaderNames) {
                    msg.getTransportResponseContext().removeHeader(hdr);
                }
            }
            if (this.cleanDigest) {
                msg.getTransportResponseContext().removeHeader("Digest");
            }
        }
    }
}

