/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.pdd.config.ConfigurazionePdDConnectionResource;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.slf4j.Logger;

public class AbstractConfigurazionePdDConnectionResourceManager {
    protected OpenSPCoop2Properties openspcoopProperties;
    protected boolean configurazioneDinamica = false;
    protected boolean useConnectionPdD = false;
    protected DriverConfigurazioneDB driver;
    protected Logger log;

    public AbstractConfigurazionePdDConnectionResourceManager(OpenSPCoop2Properties openspcoopProperties, DriverConfigurazioneDB driver, boolean useConnectionPdD, Logger log) {
        this.openspcoopProperties = openspcoopProperties;
        this.configurazioneDinamica = this.openspcoopProperties.isConfigurazioneDinamica();
        this.useConnectionPdD = useConnectionPdD;
        this.driver = driver;
        this.log = log;
    }

    protected ConfigurazionePdDConnectionResource getConnection(Connection connectionPdD, String methodName) throws DriverConfigurazioneException {
        ConfigurazionePdDConnectionResource cr = new ConfigurazionePdDConnectionResource();
        if (connectionPdD != null && this.useConnectionPdD) {
            cr.connectionDB = connectionPdD;
            cr.connectionPdD = true;
        } else {
            cr.connectionDB = this.driver.getConnection(methodName);
            cr.connectionPdD = false;
        }
        return cr;
    }

    protected void releaseConnection(ConfigurazionePdDConnectionResource cr) {
        if (cr != null && cr.connectionDB != null && !cr.connectionPdD) {
            this.driver.releaseConnection(cr.connectionDB);
        }
    }
}

