/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAutenticazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.Attachments;
import org.openspcoop2.core.config.Cache;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazioneRegola;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.IndirizzoRisposta;
import org.openspcoop2.core.config.InoltroBusteNonRiscontrate;
import org.openspcoop2.core.config.IntegrationManager;
import org.openspcoop2.core.config.OpenspcoopAppender;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Risposte;
import org.openspcoop2.core.config.Route;
import org.openspcoop2.core.config.RouteGateway;
import org.openspcoop2.core.config.RouteRegistro;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.RoutingTableDefault;
import org.openspcoop2.core.config.RoutingTableDestinazione;
import org.openspcoop2.core.config.Tracciamento;
import org.openspcoop2.core.config.ValidazioneBuste;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.AlgoritmoCache;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.GestioneErroreComportamento;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoConnessioneRisposte;
import org.openspcoop2.core.config.constants.ValidazioneBusteTipoControllo;
import org.openspcoop2.core.config.constants.ValidazioneContenutiApplicativiTipo;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.InstanceProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class ConfigLocalProperties
extends InstanceProperties {
    private boolean configLocal = false;

    public ConfigLocalProperties(Logger log, String confDir, Properties prop) {
        super("GOVWAY_HOME", new Properties(), log);
        CollectionProperties properties = PropertiesUtilities.searchLocalImplementation((String)"GOVWAY_HOME", (Logger)log, (String)"OPENSPCOOP2_CONFIG_PROPERTIES", (String)"govway_local.config.properties", (String)confDir);
        if (properties != null) {
            this.configLocal = true;
            this.setLocalFileImplementation(properties);
        }
        if (prop != null) {
            this.configLocal = true;
            this.setLocalObjectImplementation(prop);
        }
    }

    public RoutingTable updateRouting(RoutingTable routingTable) throws Exception {
        if (!this.configLocal) {
            return routingTable;
        }
        try {
            int i;
            String enabled = this.getValue("routingTable.enabled");
            if (enabled != null && "false".equals(enabled = enabled.trim())) {
                if (routingTable == null) {
                    routingTable = new RoutingTable();
                }
                routingTable.setAbilitata(Boolean.valueOf(false));
                return routingTable;
            }
            String defaultRoutesTmp = this.getValue("routingTable.default.routes");
            String[] defaultRoutes = null;
            if (defaultRoutesTmp != null && defaultRoutesTmp.length() > 0 && (defaultRoutes = defaultRoutesTmp.split(",")) != null) {
                if (defaultRoutes.length > 0) {
                    for (int i2 = 0; i2 < defaultRoutes.length; ++i2) {
                        defaultRoutes[i2] = defaultRoutes[i2].trim();
                    }
                } else {
                    defaultRoutes = null;
                }
            }
            String staticRoutesTmp = this.getValue("routingTable.routes");
            String[] staticRoutes = null;
            if (staticRoutesTmp != null && staticRoutesTmp.length() > 0 && (staticRoutes = staticRoutesTmp.split(",")) != null) {
                if (staticRoutes.length > 0) {
                    for (i = 0; i < staticRoutes.length; ++i) {
                        staticRoutes[i] = staticRoutes[i].trim();
                    }
                } else {
                    staticRoutes = null;
                }
            }
            if (defaultRoutes != null || staticRoutesTmp != null) {
                if (enabled == null) {
                    throw new Exception("Indicazione se la tabella di routing e' abilitata o meno non fornita");
                }
                if (!"true".equals(enabled) && !"false".equals(enabled)) {
                    throw new Exception("Indicazione se la tabella di routing e' abilitata o meno fornita non correttamente");
                }
                if (routingTable == null) {
                    if (defaultRoutes == null) {
                        throw new Exception("Rotte di default non definite");
                    }
                    routingTable = new RoutingTable();
                }
                routingTable.setAbilitata(Boolean.valueOf("true".equals(enabled)));
            }
            if (defaultRoutes != null) {
                if (routingTable.getDefault() != null) {
                    while (routingTable.getDefault().sizeRouteList() > 0) {
                        routingTable.getDefault().removeRoute(0);
                    }
                }
                if (defaultRoutes.length > 0 && routingTable.getDefault() == null) {
                    routingTable.setDefault(new RoutingTableDefault());
                }
                for (i = 0; i < defaultRoutes.length; ++i) {
                    Route route = new Route();
                    String tipo = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo della rotta " + defaultRoutes[i] + " non definito");
                    }
                    if (!"registro".equals(tipo = tipo.trim()) && !"gateway".equals(tipo)) {
                        throw new Exception("Tipo della rotta " + defaultRoutes[i] + " non corretto");
                    }
                    if ("registro".equals(tipo)) {
                        RouteRegistro rr = new RouteRegistro();
                        String nome = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".registro.nome");
                        if (nome != null) {
                            nome = nome.trim();
                            rr.setNome(nome);
                        }
                        route.setRegistro(rr);
                    } else {
                        RouteGateway rg = new RouteGateway();
                        String tipoGW = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".gateway.tipo");
                        if (tipoGW == null) {
                            throw new Exception("Tipo del soggetto della rotta gateway " + defaultRoutes[i] + " non definito");
                        }
                        tipoGW = tipoGW.trim();
                        rg.setTipo(tipoGW);
                        String nomeGW = this.getValue("routingTable.default.route." + defaultRoutes[i] + ".gateway.nome");
                        if (nomeGW == null) {
                            throw new Exception("Tipo del soggetto della rotta gateway " + defaultRoutes[i] + " non definito");
                        }
                        nomeGW = nomeGW.trim();
                        rg.setNome(nomeGW);
                        route.setGateway(rg);
                    }
                    routingTable.getDefault().addRoute(route);
                }
            }
            if (staticRoutes != null) {
                block6: for (i = 0; i < staticRoutes.length; ++i) {
                    String tipoSoggettoDestinazione = this.getValue("routingTable.route." + staticRoutes[i] + ".soggetto.tipo");
                    if (tipoSoggettoDestinazione == null) {
                        throw new Exception("Tipo del soggetto della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    tipoSoggettoDestinazione = tipoSoggettoDestinazione.trim();
                    String nomeSoggettoDestinazione = this.getValue("routingTable.route." + staticRoutes[i] + ".soggetto.nome");
                    if (nomeSoggettoDestinazione == null) {
                        throw new Exception("Nome del soggetto della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    nomeSoggettoDestinazione = nomeSoggettoDestinazione.trim();
                    String valueEnable = this.getValue("routingTable.route." + staticRoutes[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        for (int j = 0; j < routingTable.sizeDestinazioneList(); ++j) {
                            if (!tipoSoggettoDestinazione.equals(routingTable.getDestinazione(j).getTipo()) || !nomeSoggettoDestinazione.equals(routingTable.getDestinazione(j).getNome())) continue;
                            routingTable.removeDestinazione(j);
                            continue block6;
                        }
                        continue;
                    }
                    RoutingTableDestinazione rtd = null;
                    for (int j = 0; j < routingTable.sizeDestinazioneList(); ++j) {
                        if (!tipoSoggettoDestinazione.equals(routingTable.getDestinazione(j).getTipo()) || !nomeSoggettoDestinazione.equals(routingTable.getDestinazione(j).getNome())) continue;
                        rtd = routingTable.removeDestinazione(j);
                        break;
                    }
                    if (rtd == null) {
                        rtd = new RoutingTableDestinazione();
                        rtd.setTipo(tipoSoggettoDestinazione);
                        rtd.setNome(nomeSoggettoDestinazione);
                    } else {
                        while (rtd.sizeRouteList() > 0) {
                            rtd.removeRoute(0);
                        }
                    }
                    Route route = new Route();
                    String tipo = this.getValue("routingTable.route." + staticRoutes[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo della rotta statica " + staticRoutes[i] + " non definito");
                    }
                    if (!"registro".equals(tipo = tipo.trim()) && !"gateway".equals(tipo)) {
                        throw new Exception("Tipo della rotta statica " + staticRoutes[i] + " non corretto");
                    }
                    if ("registro".equals(tipo)) {
                        RouteRegistro rr = new RouteRegistro();
                        String nome = this.getValue("routingTable.route." + staticRoutes[i] + ".registro.nome");
                        if (nome != null) {
                            nome = nome.trim();
                            rr.setNome(nome);
                        }
                        route.setRegistro(rr);
                    } else {
                        RouteGateway rg = new RouteGateway();
                        String tipoGW = this.getValue("routingTable.route." + staticRoutes[i] + ".gateway.tipo");
                        if (tipoGW == null) {
                            throw new Exception("Tipo del soggetto della rotta statica di tipo gateway " + staticRoutes[i] + " non definito");
                        }
                        tipoGW = tipoGW.trim();
                        rg.setTipo(tipoGW);
                        String nomeGW = this.getValue("routingTable.route." + staticRoutes[i] + ".gateway.nome");
                        if (nomeGW == null) {
                            throw new Exception("Tipo del soggetto della rotta statica di tipo gateway " + staticRoutes[i] + " non definito");
                        }
                        nomeGW = nomeGW.trim();
                        rg.setNome(nomeGW);
                        route.setGateway(rg);
                    }
                    rtd.addRoute(route);
                    routingTable.addDestinazione(rtd);
                }
            }
            return routingTable;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (RoutingTable): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (RoutingTable): " + e.getMessage(), e);
        }
    }

    private boolean isStatoCacheDisabilitata(String prefix) throws Exception {
        String cacheAbilitata = this.getValue(prefix + ".cache.enabled");
        boolean cacheDisabilitata = false;
        if (cacheAbilitata != null && "false".equalsIgnoreCase(cacheAbilitata.trim())) {
            cacheDisabilitata = true;
        }
        return cacheDisabilitata;
    }

    private Cache readDatiCache(String prefix, Cache cacheParam) throws Exception {
        Cache cache = cacheParam;
        if (!this.isStatoCacheDisabilitata(prefix)) {
            String cacheItemLifeSecond;
            String cacheAlgoritmo;
            String cacheDimensione = this.getValue(prefix + ".cache.dimensione");
            if (cacheDimensione != null) {
                cacheDimensione = cacheDimensione.trim();
                try {
                    Integer.parseInt(cacheDimensione);
                }
                catch (Exception e) {
                    throw new Exception("Valore impostato non corretto per " + prefix + ".cache.dimensione");
                }
            }
            if ((cacheAlgoritmo = this.getValue(prefix + ".cache.algoritmo")) != null && !CostantiConfigurazione.CACHE_LRU.equals(cacheAlgoritmo = cacheAlgoritmo.trim()) && !CostantiConfigurazione.CACHE_MRU.equals(cacheAlgoritmo)) {
                throw new Exception("Algoritmo impostato per la cache del " + prefix + " non corretto");
            }
            String cacheItemIdleTime = this.getValue(prefix + ".cache.item-idle-time");
            if (cacheItemIdleTime != null) {
                cacheItemIdleTime = cacheItemIdleTime.trim();
                try {
                    Integer.parseInt(cacheItemIdleTime);
                }
                catch (Exception e) {
                    throw new Exception("Valore impostato non corretto per " + prefix + ".cache.item-idle-time");
                }
            }
            if ((cacheItemLifeSecond = this.getValue(prefix + ".cache.item-life-second")) != null) {
                cacheItemLifeSecond = cacheItemLifeSecond.trim();
                try {
                    Integer.parseInt(cacheItemLifeSecond);
                }
                catch (Exception e) {
                    throw new Exception("Valore impostato non corretto per " + prefix + ".cache.item-life-second");
                }
            }
            if (cacheDimensione != null || cacheAlgoritmo != null || cacheItemIdleTime != null || cacheItemLifeSecond != null) {
                if (cache == null) {
                    cache = new Cache();
                }
                if (cacheDimensione != null) {
                    cache.setDimensione(cacheDimensione);
                }
                if (cacheAlgoritmo != null) {
                    cache.setAlgoritmo(AlgoritmoCache.toEnumConstant((String)cacheAlgoritmo));
                }
                if (cacheItemIdleTime != null) {
                    cache.setItemIdleTime(cacheItemIdleTime);
                }
                if (cacheItemLifeSecond != null) {
                    cache.setItemLifeSecond(cacheItemLifeSecond);
                }
            }
        }
        return cache;
    }

    public AccessoRegistro updateAccessoRegistro(AccessoRegistro accessoRegistro) throws Exception {
        if (!this.configLocal) {
            return accessoRegistro;
        }
        try {
            int i;
            if (this.isStatoCacheDisabilitata("registro")) {
                accessoRegistro.setCache(null);
            } else {
                accessoRegistro.setCache(this.readDatiCache("registro", accessoRegistro.getCache()));
            }
            String registriTmp = this.getValue("registri");
            String[] registri = null;
            if (registriTmp != null && (registri = (registriTmp = registriTmp.trim()).split(",")) != null) {
                if (registri.length > 0) {
                    for (i = 0; i < registri.length; ++i) {
                        registri[i] = registri[i].trim();
                    }
                } else {
                    registri = null;
                }
            }
            if (registri != null) {
                block3: for (i = 0; i < registri.length; ++i) {
                    String password;
                    String tipo;
                    String nomeRegistro = this.getValue("registro." + registri[i] + ".nome");
                    if (nomeRegistro == null) {
                        throw new Exception("Nome del registro " + registri[i] + " non definito");
                    }
                    nomeRegistro = nomeRegistro.trim();
                    String valueEnable = this.getValue("registro." + registri[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        for (int j = 0; j < accessoRegistro.sizeRegistroList(); ++j) {
                            if (!nomeRegistro.equals(accessoRegistro.getRegistro(j).getNome())) continue;
                            accessoRegistro.removeRegistro(j);
                            continue block3;
                        }
                        continue;
                    }
                    AccessoRegistroRegistro registro = null;
                    for (int j = 0; j < accessoRegistro.sizeRegistroList(); ++j) {
                        if (!nomeRegistro.equals(accessoRegistro.getRegistro(j).getNome())) continue;
                        registro = accessoRegistro.removeRegistro(j);
                        break;
                    }
                    if (registro == null) {
                        registro = new AccessoRegistroRegistro();
                        registro.setNome(nomeRegistro);
                    }
                    if ((tipo = this.getValue("registro." + registri[i] + ".tipo")) == null) {
                        throw new Exception("Tipo del registro " + registri[i] + " non definito");
                    }
                    if (!CostantiConfigurazione.REGISTRO_DB.equals(tipo = tipo.trim()) && !CostantiConfigurazione.REGISTRO_XML.equals(tipo)) {
                        throw new Exception("Tipo del registro " + registri[i] + " non corretto");
                    }
                    registro.setTipo(RegistroTipo.toEnumConstant((String)tipo));
                    String location = this.getValue("registro." + registri[i] + ".location");
                    if (location == null) {
                        throw new Exception("Location del registro " + registri[i] + " non definito");
                    }
                    location = location.trim();
                    registro.setLocation(location);
                    String username = this.getValue("registro." + registri[i] + ".user");
                    if (username != null) {
                        if ("".equals(username = username.trim())) {
                            registro.setUser(null);
                        } else {
                            registro.setUser(username);
                        }
                    }
                    if ((password = this.getValue("registro." + registri[i] + ".password")) != null) {
                        if ("".equals(password = password.trim())) {
                            registro.setPassword(null);
                        } else {
                            registro.setPassword(password);
                        }
                    }
                    accessoRegistro.addRegistro(registro);
                }
            }
            return accessoRegistro;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (AccessoRegistro): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (AccessoRegistro): " + e.getMessage(), e);
        }
    }

    public AccessoConfigurazione updateAccessoConfigurazione(AccessoConfigurazione accessoConfigurazione) throws Exception {
        if (!this.configLocal) {
            return accessoConfigurazione;
        }
        try {
            if (this.isStatoCacheDisabilitata("config")) {
                accessoConfigurazione.setCache(null);
            } else {
                accessoConfigurazione.setCache(this.readDatiCache("config", accessoConfigurazione.getCache()));
            }
            return accessoConfigurazione;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (AccessoConfigurazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (AccessoConfigurazione): " + e.getMessage(), e);
        }
    }

    public AccessoDatiAutorizzazione updateAccessoDatiAutorizzazione(AccessoDatiAutorizzazione accessoDatiConfigurazione) throws Exception {
        if (!this.configLocal) {
            return accessoDatiConfigurazione;
        }
        try {
            if (this.isStatoCacheDisabilitata("autorizzazione")) {
                accessoDatiConfigurazione.setCache(null);
            } else {
                accessoDatiConfigurazione.setCache(this.readDatiCache("autorizzazione", accessoDatiConfigurazione.getCache()));
            }
            return accessoDatiConfigurazione;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (AccessoDatiAutorizzazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (AccessoDatiAutorizzazione): " + e.getMessage(), e);
        }
    }

    public AccessoDatiAutenticazione updateAccessoDatiAutenticazione(AccessoDatiAutenticazione accessoDatiConfigurazione) throws Exception {
        if (!this.configLocal) {
            return accessoDatiConfigurazione;
        }
        try {
            if (this.isStatoCacheDisabilitata("autenticazione")) {
                accessoDatiConfigurazione.setCache(null);
            } else {
                accessoDatiConfigurazione.setCache(this.readDatiCache("autenticazione", accessoDatiConfigurazione.getCache()));
            }
            return accessoDatiConfigurazione;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (AccessoDatiAutenticazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (AccessoDatiAutenticazione): " + e.getMessage(), e);
        }
    }

    public GestioneErrore updateGestioneErroreCooperazione(GestioneErrore gestioneErrore) throws Exception {
        if (!this.configLocal) {
            return gestioneErrore;
        }
        try {
            return this.updateGestioneErrore(gestioneErrore, "cooperazione");
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (GestioneErrore Cooperazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (GestioneErrore Cooperazione): " + e.getMessage(), e);
        }
    }

    public GestioneErrore updateGestioneErroreIntegrazione(GestioneErrore gestioneErrore) throws Exception {
        if (!this.configLocal) {
            return gestioneErrore;
        }
        try {
            return this.updateGestioneErrore(gestioneErrore, "integrazione");
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (GestioneErrore Integrazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (GestioneErrore Integrazione): " + e.getMessage(), e);
        }
    }

    private GestioneErrore updateGestioneErrore(GestioneErrore gestioneErrore, String tipo) throws Exception {
        int i;
        String gestioneErroreDefaultComportamento = this.getValue("gestioneErrore." + tipo + ".comportamento");
        if (gestioneErroreDefaultComportamento != null && !CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG.equals(gestioneErroreDefaultComportamento = gestioneErroreDefaultComportamento.trim()) && !CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(gestioneErroreDefaultComportamento)) {
            throw new Exception("Comportamento di default per la gestione errore (" + tipo + ") non correttamento fornito");
        }
        String gestioneErroreDefaultCadenzaRispedizione = this.getValue("gestioneErrore." + tipo + ".cadenzaRispedizione");
        if (gestioneErroreDefaultCadenzaRispedizione != null) {
            gestioneErroreDefaultCadenzaRispedizione = gestioneErroreDefaultCadenzaRispedizione.trim();
            try {
                Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
            }
            catch (Exception e) {
                throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + ") non correttamento fornito");
            }
        }
        String gestioneErroreCodiciTrasportoTmp = this.getValue("gestioneErrore." + tipo + ".codiciTrasporto");
        String[] gestioneErroreCodiciTrasporto = null;
        if (gestioneErroreCodiciTrasportoTmp != null && (gestioneErroreCodiciTrasporto = (gestioneErroreCodiciTrasportoTmp = gestioneErroreCodiciTrasportoTmp.trim()).split(",")) != null) {
            if (gestioneErroreCodiciTrasporto.length > 0) {
                for (int i2 = 0; i2 < gestioneErroreCodiciTrasporto.length; ++i2) {
                    gestioneErroreCodiciTrasporto[i2] = gestioneErroreCodiciTrasporto[i2].trim();
                }
            } else {
                gestioneErroreCodiciTrasporto = null;
            }
        }
        String gestioneErroreFaultTmp = this.getValue("gestioneErrore." + tipo + ".soapFault");
        String[] gestioneErroreFault = null;
        if (gestioneErroreFaultTmp != null && (gestioneErroreFault = (gestioneErroreFaultTmp = gestioneErroreFaultTmp.trim()).split(",")) != null) {
            if (gestioneErroreFault.length > 0) {
                for (i = 0; i < gestioneErroreFault.length; ++i) {
                    gestioneErroreFault[i] = gestioneErroreFault[i].trim();
                }
            } else {
                gestioneErroreFault = null;
            }
        }
        if (gestioneErroreDefaultComportamento != null || gestioneErroreDefaultCadenzaRispedizione != null || gestioneErroreCodiciTrasporto != null || gestioneErroreFault != null) {
            if (gestioneErroreDefaultComportamento == null) {
                throw new Exception("Comportamento di default deve essere fornito");
            }
            gestioneErrore = new GestioneErrore();
            gestioneErrore.setComportamento(GestioneErroreComportamento.toEnumConstant((String)gestioneErroreDefaultComportamento));
            if (gestioneErroreDefaultCadenzaRispedizione != null) {
                gestioneErrore.setCadenzaRispedizione(gestioneErroreDefaultCadenzaRispedizione);
            }
            if (gestioneErroreCodiciTrasporto != null) {
                for (i = 0; i < gestioneErroreCodiciTrasporto.length; ++i) {
                    String codiceTrasportoCadenza;
                    String codiceTrasportoMassimo;
                    GestioneErroreCodiceTrasporto ct = new GestioneErroreCodiceTrasporto();
                    String codiceTrasportoMinimo = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".valoreMinimo");
                    if (codiceTrasportoMinimo != null) {
                        codiceTrasportoMinimo = codiceTrasportoMinimo.trim();
                        try {
                            Integer.parseInt(codiceTrasportoMinimo);
                        }
                        catch (Exception e) {
                            throw new Exception("Codice di trasporto minimo non correttaemnte definito la gestione errore (" + tipo + "), trasporto " + gestioneErroreCodiciTrasporto[i]);
                        }
                        ct.setValoreMinimo(Integer.valueOf(codiceTrasportoMinimo));
                    }
                    if ((codiceTrasportoMassimo = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".valoreMassimo")) != null) {
                        codiceTrasportoMassimo = codiceTrasportoMassimo.trim();
                        try {
                            Integer.parseInt(codiceTrasportoMassimo);
                        }
                        catch (Exception e) {
                            throw new Exception("Codice di trasporto massimo non correttaemnte definito la gestione errore (" + tipo + "), trasporto " + gestioneErroreCodiciTrasporto[i]);
                        }
                        ct.setValoreMassimo(Integer.valueOf(codiceTrasportoMassimo));
                    }
                    if (codiceTrasportoMinimo == null && codiceTrasportoMassimo == null) {
                        throw new Exception("Ne valore minimo, ne valore massimo fornito per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i]);
                    }
                    String codiceTrasportoComportamento = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".comportamento");
                    if (codiceTrasportoComportamento != null) {
                        if (!CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG.equals(codiceTrasportoComportamento = codiceTrasportoComportamento.trim()) && !CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(codiceTrasportoComportamento)) {
                            throw new Exception("Comportamento  per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i] + " non correttamento fornito");
                        }
                        ct.setComportamento(GestioneErroreComportamento.toEnumConstant((String)codiceTrasportoComportamento));
                    }
                    if ((codiceTrasportoCadenza = this.getValue("gestioneErrore." + tipo + ".codiceTrasporto." + gestioneErroreCodiciTrasporto[i] + ".cadenzaRispedizione")) != null) {
                        codiceTrasportoCadenza = codiceTrasportoCadenza.trim();
                        try {
                            Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
                        }
                        catch (Exception e) {
                            throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + "), codice di trasporto " + gestioneErroreCodiciTrasporto[i] + " non correttamento fornito");
                        }
                        ct.setCadenzaRispedizione(codiceTrasportoCadenza);
                    }
                    gestioneErrore.addCodiceTrasporto(ct);
                }
            }
            if (gestioneErroreFault != null) {
                for (i = 0; i < gestioneErroreFault.length; ++i) {
                    String faultCadenza;
                    String faultComportamento;
                    String faultString;
                    String faultCode;
                    GestioneErroreSoapFault fault = new GestioneErroreSoapFault();
                    String faultActor = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultActor");
                    if (faultActor != null) {
                        faultActor = faultActor.trim();
                        fault.setFaultActor(faultActor);
                    }
                    if ((faultCode = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultCode")) != null) {
                        faultCode = faultCode.trim();
                        fault.setFaultCode(faultCode);
                    }
                    if ((faultString = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".faultString")) != null) {
                        faultString = faultString.trim();
                        fault.setFaultString(faultString);
                    }
                    if ((faultComportamento = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".comportamento")) != null) {
                        if (!CostantiConfigurazione.GESTIONE_ERRORE_ACCETTA_MSG.equals(faultComportamento = faultComportamento.trim()) && !CostantiConfigurazione.GESTIONE_ERRORE_RISPEDISCI_MSG.equals(faultComportamento)) {
                            throw new Exception("Comportamento  per la gestione errore (" + tipo + "), soapFault " + gestioneErroreFault[i] + " non correttamento fornito");
                        }
                        fault.setComportamento(GestioneErroreComportamento.toEnumConstant((String)faultComportamento));
                    }
                    if ((faultCadenza = this.getValue("gestioneErrore." + tipo + ".soapFault." + gestioneErroreFault[i] + ".cadenzaRispedizione")) != null) {
                        faultCadenza = faultCadenza.trim();
                        try {
                            Integer.parseInt(gestioneErroreDefaultCadenzaRispedizione);
                        }
                        catch (Exception e) {
                            throw new Exception("Cadenza di rispedizione di default per la gestione errore (" + tipo + "), soapFault " + gestioneErroreFault[i] + " non correttamento fornito");
                        }
                        fault.setCadenzaRispedizione(faultCadenza);
                    }
                    gestioneErrore.addSoapFault(fault);
                }
            }
        }
        return gestioneErrore;
    }

    public Configurazione updateConfigurazione(Configurazione configurazione) throws Exception {
        if (!this.configLocal) {
            return configurazione;
        }
        try {
            String dumpStato;
            String tracciamentoBuste;
            int i;
            String msgDiagnostici_livelloSeverita;
            String msgDiagnostici_livelloSeveritaLog4J;
            String inoltroBuste_cadenza;
            String risposte_connection;
            String attachments_gestioneManifest;
            String indirizzoRisposta_utilizzo;
            String validazioneContenutiApplicativi_tipo;
            String validazioneContenutiApplicativi_stato;
            String validazioneBuste_controllo;
            String validazioneBuste_stato = this.getValue("validazione.protocol.stato");
            if (validazioneBuste_stato != null) {
                validazioneBuste_stato = validazioneBuste_stato.trim();
                if (!(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equals(validazioneBuste_stato) || CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equals(validazioneBuste_stato) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.toString().equals(validazioneBuste_stato))) {
                    throw new Exception("Stato della validazione protocol non corretto");
                }
            }
            if ((validazioneBuste_controllo = this.getValue("validazione.protocol.controllo")) != null && !CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_NORMALE.equals(validazioneBuste_controllo = validazioneBuste_controllo.trim()) && !CostantiConfigurazione.VALIDAZIONE_PROTOCOL_LIVELLO_RIGIDO.equals(validazioneBuste_controllo)) {
                throw new Exception("Tipo di controllo della validazione protocol non corretto");
            }
            String validazioneBuste_profiloCollaborazione = this.getValue("validazione.protocol.profiloCollaborazione");
            if (validazioneBuste_profiloCollaborazione != null && !CostantiConfigurazione.ABILITATO.equals(validazioneBuste_profiloCollaborazione = validazioneBuste_profiloCollaborazione.trim()) && !CostantiConfigurazione.DISABILITATO.equals(validazioneBuste_profiloCollaborazione)) {
                throw new Exception("Stato della validazione del profilo di collaborazione protocol non corretto");
            }
            String validazioneBuste_manifestAttachments = this.getValue("validazione.protocol.manifestAttachments");
            if (validazioneBuste_manifestAttachments != null && !CostantiConfigurazione.ABILITATO.equals(validazioneBuste_manifestAttachments = validazioneBuste_manifestAttachments.trim()) && !CostantiConfigurazione.DISABILITATO.equals(validazioneBuste_manifestAttachments)) {
                throw new Exception("Stato della validazione del manifest degli attachments non corretto");
            }
            if (validazioneBuste_stato != null || validazioneBuste_controllo != null || validazioneBuste_profiloCollaborazione != null || validazioneBuste_manifestAttachments != null) {
                if (configurazione.getValidazioneBuste() == null) {
                    configurazione.setValidazioneBuste(new ValidazioneBuste());
                }
                if (validazioneBuste_stato != null) {
                    configurazione.getValidazioneBuste().setStato(StatoFunzionalitaConWarning.toEnumConstant((String)validazioneBuste_stato));
                }
                if (validazioneBuste_controllo != null) {
                    configurazione.getValidazioneBuste().setControllo(ValidazioneBusteTipoControllo.toEnumConstant((String)validazioneBuste_controllo));
                }
                if (validazioneBuste_profiloCollaborazione != null) {
                    configurazione.getValidazioneBuste().setProfiloCollaborazione(StatoFunzionalita.toEnumConstant((String)validazioneBuste_profiloCollaborazione));
                }
                if (validazioneBuste_manifestAttachments != null) {
                    configurazione.getValidazioneBuste().setManifestAttachments(StatoFunzionalita.toEnumConstant((String)validazioneBuste_manifestAttachments));
                }
            }
            if ((validazioneContenutiApplicativi_stato = this.getValue("validazione.contenutiApplicativi.stato")) != null) {
                validazioneContenutiApplicativi_stato = validazioneContenutiApplicativi_stato.trim();
                if (!(CostantiConfigurazione.STATO_CON_WARNING_ABILITATO.toString().equals(validazioneContenutiApplicativi_stato) || CostantiConfigurazione.STATO_CON_WARNING_DISABILITATO.toString().equals(validazioneContenutiApplicativi_stato) || CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.toString().equals(validazioneContenutiApplicativi_stato))) {
                    throw new Exception("Stato della validazione dei contenuti applicativi non corretto");
                }
            }
            if (!((validazioneContenutiApplicativi_tipo = this.getValue("validazione.contenutiApplicativi.tipo")) == null || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_XSD.equals(validazioneContenutiApplicativi_tipo = validazioneContenutiApplicativi_tipo.trim()) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_INTERFACE.equals(validazioneContenutiApplicativi_tipo) || CostantiConfigurazione.VALIDAZIONE_CONTENUTI_APPLICATIVI_OPENSPCOOP.equals(validazioneContenutiApplicativi_tipo))) {
                throw new Exception("Tipo di controllo della validazione dei contenuti applicativi non corretto");
            }
            if (validazioneContenutiApplicativi_stato != null || validazioneContenutiApplicativi_tipo != null) {
                if (configurazione.getValidazioneContenutiApplicativi() == null) {
                    configurazione.setValidazioneContenutiApplicativi(new ValidazioneContenutiApplicativi());
                }
                if (validazioneContenutiApplicativi_stato != null) {
                    configurazione.getValidazioneContenutiApplicativi().setStato(StatoFunzionalitaConWarning.toEnumConstant((String)validazioneContenutiApplicativi_stato));
                }
                if (validazioneContenutiApplicativi_tipo != null) {
                    configurazione.getValidazioneContenutiApplicativi().setTipo(ValidazioneContenutiApplicativiTipo.toEnumConstant((String)validazioneContenutiApplicativi_tipo));
                }
            }
            if ((indirizzoRisposta_utilizzo = this.getValue("indirizzoRisposta.utilizzo")) != null) {
                if (!CostantiConfigurazione.ABILITATO.equals(indirizzoRisposta_utilizzo = indirizzoRisposta_utilizzo.trim()) && !CostantiConfigurazione.DISABILITATO.equals(indirizzoRisposta_utilizzo)) {
                    throw new Exception("Impostazione sull'utilizzo dell'indirizzo risposta non corretta");
                }
                if (configurazione.getIndirizzoRisposta() == null) {
                    configurazione.setIndirizzoRisposta(new IndirizzoRisposta());
                }
                configurazione.getIndirizzoRisposta().setUtilizzo(StatoFunzionalita.toEnumConstant((String)indirizzoRisposta_utilizzo));
            }
            if ((attachments_gestioneManifest = this.getValue("attachments.gestioneManifest")) != null) {
                if (!CostantiConfigurazione.ABILITATO.equals(attachments_gestioneManifest = attachments_gestioneManifest.trim()) && !CostantiConfigurazione.DISABILITATO.equals(attachments_gestioneManifest)) {
                    throw new Exception("Impostazione sulla gestione del manifest non corretta");
                }
                if (configurazione.getAttachments() == null) {
                    configurazione.setAttachments(new Attachments());
                }
                configurazione.getAttachments().setGestioneManifest(StatoFunzionalita.toEnumConstant((String)attachments_gestioneManifest));
            }
            if ((risposte_connection = this.getValue("risposte.connessione")) != null) {
                if (!CostantiConfigurazione.CONNECTION_REPLY.equals(risposte_connection = risposte_connection.trim()) && !CostantiConfigurazione.NEW_CONNECTION.equals(risposte_connection)) {
                    throw new Exception("Impostazione sulla gestione della connessione per le risposte non corretta");
                }
                if (configurazione.getRisposte() == null) {
                    configurazione.setRisposte(new Risposte());
                }
                configurazione.getRisposte().setConnessione(TipoConnessioneRisposte.toEnumConstant((String)risposte_connection));
            }
            if ((inoltroBuste_cadenza = this.getValue("inoltroBusteNonRiscontrate.cadenza")) != null) {
                inoltroBuste_cadenza = inoltroBuste_cadenza.trim();
                try {
                    Integer.parseInt(inoltroBuste_cadenza);
                }
                catch (Exception e) {
                    throw new Exception("Impostazione sulla cadenza per l'inoltro di buste non riscontrate non corretta");
                }
                if (configurazione.getInoltroBusteNonRiscontrate() == null) {
                    configurazione.setInoltroBusteNonRiscontrate(new InoltroBusteNonRiscontrate());
                }
                configurazione.getInoltroBusteNonRiscontrate().setCadenza(inoltroBuste_cadenza);
            }
            if ((msgDiagnostici_livelloSeveritaLog4J = this.getValue("messaggiDiagnostici.livelloSeveritaLog4j")) != null) {
                if (!("all".equals(msgDiagnostici_livelloSeveritaLog4J = msgDiagnostici_livelloSeveritaLog4J.trim()) || "debugHigh".equals(msgDiagnostici_livelloSeveritaLog4J) || "debugMedium".equals(msgDiagnostici_livelloSeveritaLog4J) || "debugLow".equals(msgDiagnostici_livelloSeveritaLog4J) || "errorIntegration".equals(msgDiagnostici_livelloSeveritaLog4J) || "errorProtocol".equals(msgDiagnostici_livelloSeveritaLog4J) || "fatal".equals(msgDiagnostici_livelloSeveritaLog4J) || "infoIntegration".equals(msgDiagnostici_livelloSeveritaLog4J) || "infoProtocol".equals(msgDiagnostici_livelloSeveritaLog4J) || "off".equals(msgDiagnostici_livelloSeveritaLog4J))) {
                    throw new Exception("Impostazione sul livello log4j di severita dei messsaggi diagnostici emessi non corretta");
                }
                configurazione.getMessaggiDiagnostici().setSeveritaLog4j(Severita.toEnumConstant((String)msgDiagnostici_livelloSeveritaLog4J));
            }
            if ((msgDiagnostici_livelloSeverita = this.getValue("messaggiDiagnostici.livelloSeverita")) != null) {
                if (!("all".equals(msgDiagnostici_livelloSeverita = msgDiagnostici_livelloSeverita.trim()) || "debugHigh".equals(msgDiagnostici_livelloSeverita) || "debugMedium".equals(msgDiagnostici_livelloSeverita) || "debugLow".equals(msgDiagnostici_livelloSeverita) || "errorIntegration".equals(msgDiagnostici_livelloSeverita) || "errorProtocol".equals(msgDiagnostici_livelloSeverita) || "fatal".equals(msgDiagnostici_livelloSeverita) || "infoIntegration".equals(msgDiagnostici_livelloSeverita) || "infoProtocol".equals(msgDiagnostici_livelloSeverita) || "off".equals(msgDiagnostici_livelloSeverita))) {
                    throw new Exception("Impostazione sul livello di severita dei messsaggi diagnostici emessi non corretta");
                }
                configurazione.getMessaggiDiagnostici().setSeverita(Severita.toEnumConstant((String)msgDiagnostici_livelloSeverita));
            }
            String msgDiagnosticiAppendersDisabledTmp = this.getValue("messaggiDiagnostici.appenders.disabled");
            boolean disabilitatiMsgDiagnosticiAppenderOriginali = false;
            if (msgDiagnosticiAppendersDisabledTmp != null && "true".equals(msgDiagnosticiAppendersDisabledTmp)) {
                disabilitatiMsgDiagnosticiAppenderOriginali = true;
                while (configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList() > 0) {
                    configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(0);
                }
            }
            String msgDiagnosticiAppendersTmp = this.getValue("messaggiDiagnostici.appenders");
            String[] msgDiagnosticiAppenders = null;
            if (msgDiagnosticiAppendersTmp != null && (msgDiagnosticiAppenders = (msgDiagnosticiAppendersTmp = msgDiagnosticiAppendersTmp.trim()).split(",")) != null) {
                if (msgDiagnosticiAppenders.length > 0) {
                    for (i = 0; i < msgDiagnosticiAppenders.length; ++i) {
                        msgDiagnosticiAppenders[i] = msgDiagnosticiAppenders[i].trim();
                    }
                } else {
                    msgDiagnosticiAppenders = null;
                }
            }
            if (msgDiagnosticiAppenders != null) {
                block6: for (i = 0; i < msgDiagnosticiAppenders.length; ++i) {
                    String tipo = this.getValue("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo dell'appender dei messaggi diagnostici " + msgDiagnosticiAppenders[i] + " non definito");
                    }
                    tipo = tipo.trim();
                    String valueEnable = this.getValue("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        if (disabilitatiMsgDiagnosticiAppenderOriginali) continue;
                        for (int j = 0; j < configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++j) {
                            if (!tipo.equals(configurazione.getMessaggiDiagnostici().getOpenspcoopAppender(j).getTipo())) continue;
                            configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(j);
                            continue block6;
                        }
                        continue;
                    }
                    OpenspcoopAppender appender = null;
                    for (int j = 0; j < configurazione.getMessaggiDiagnostici().sizeOpenspcoopAppenderList(); ++j) {
                        if (!tipo.equals(configurazione.getMessaggiDiagnostici().getOpenspcoopAppender(j).getTipo())) continue;
                        appender = configurazione.getMessaggiDiagnostici().removeOpenspcoopAppender(j);
                        break;
                    }
                    if (appender == null) {
                        appender = new OpenspcoopAppender();
                        appender.setTipo(tipo);
                    }
                    while (appender.sizePropertyList() > 0) {
                        appender.removeProperty(0);
                    }
                    Properties properties = this.readProperties("messaggiDiagnostici.appender." + msgDiagnosticiAppenders[i] + ".property.");
                    Enumeration<Object> keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Property ap = new Property();
                        ap.setNome(key);
                        ap.setValore(properties.getProperty(key));
                        appender.addProperty(ap);
                    }
                    configurazione.getMessaggiDiagnostici().addOpenspcoopAppender(appender);
                }
            }
            if ((tracciamentoBuste = this.getValue("tracciamento.stato")) != null && !CostantiConfigurazione.ABILITATO.equals(tracciamentoBuste = tracciamentoBuste.trim()) && !CostantiConfigurazione.DISABILITATO.equals(tracciamentoBuste)) {
                throw new Exception("Impostazione sul tracciamento buste non corretta");
            }
            String tracciamentoAppendersDisabledTmp = this.getValue("tracciamento.appenders.disabled");
            boolean disabilitatiTracciamentoAppenderOriginali = false;
            if (tracciamentoAppendersDisabledTmp != null && "true".equals(tracciamentoAppendersDisabledTmp)) {
                disabilitatiTracciamentoAppenderOriginali = true;
                if (configurazione.getTracciamento() != null) {
                    while (configurazione.getTracciamento().sizeOpenspcoopAppenderList() > 0) {
                        configurazione.getTracciamento().removeOpenspcoopAppender(0);
                    }
                }
            }
            String tracciamentoAppendersTmp = this.getValue("tracciamento.appenders");
            String[] tracciamentoAppenders = null;
            if (tracciamentoAppendersTmp != null && (tracciamentoAppenders = (tracciamentoAppendersTmp = tracciamentoAppendersTmp.trim()).split(",")) != null) {
                if (tracciamentoAppenders.length > 0) {
                    for (int i2 = 0; i2 < tracciamentoAppenders.length; ++i2) {
                        tracciamentoAppenders[i2] = tracciamentoAppenders[i2].trim();
                    }
                } else {
                    tracciamentoAppenders = null;
                }
            }
            if ((tracciamentoBuste != null || tracciamentoAppenders != null) && configurazione.getTracciamento() == null) {
                configurazione.setTracciamento(new Tracciamento());
                if (tracciamentoBuste == null) {
                    configurazione.getTracciamento().setStato(CostantiConfigurazione.ABILITATO);
                }
            }
            if (tracciamentoBuste != null) {
                configurazione.getTracciamento().setStato(StatoFunzionalita.toEnumConstant((String)tracciamentoBuste));
            }
            if (tracciamentoAppenders != null) {
                block13: for (int i3 = 0; i3 < tracciamentoAppenders.length; ++i3) {
                    String tipo = this.getValue("tracciamento.appender." + tracciamentoAppenders[i3] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo dell'appender delle tracce " + tracciamentoAppenders[i3] + " non definito");
                    }
                    tipo = tipo.trim();
                    String valueEnable = this.getValue("tracciamento.appender." + tracciamentoAppenders[i3] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        if (disabilitatiTracciamentoAppenderOriginali) continue;
                        for (int j = 0; j < configurazione.getTracciamento().sizeOpenspcoopAppenderList(); ++j) {
                            if (!tipo.equals(configurazione.getTracciamento().getOpenspcoopAppender(j).getTipo())) continue;
                            configurazione.getTracciamento().removeOpenspcoopAppender(j);
                            continue block13;
                        }
                        continue;
                    }
                    OpenspcoopAppender appender = null;
                    for (int j = 0; j < configurazione.getTracciamento().sizeOpenspcoopAppenderList(); ++j) {
                        if (!tipo.equals(configurazione.getTracciamento().getOpenspcoopAppender(j).getTipo())) continue;
                        appender = configurazione.getTracciamento().removeOpenspcoopAppender(j);
                        break;
                    }
                    if (appender == null) {
                        appender = new OpenspcoopAppender();
                        appender.setTipo(tipo);
                    }
                    while (appender.sizePropertyList() > 0) {
                        appender.removeProperty(0);
                    }
                    Properties properties = this.readProperties("tracciamento.appender." + tracciamentoAppenders[i3] + ".property.");
                    Enumeration<Object> keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Property ap = new Property();
                        ap.setNome(key);
                        ap.setValore(properties.getProperty(key));
                        appender.addProperty(ap);
                    }
                    configurazione.getTracciamento().addOpenspcoopAppender(appender);
                }
            }
            if ((dumpStato = this.getValue("dump.stato")) != null && !CostantiConfigurazione.ABILITATO.equals(dumpStato = dumpStato.trim()) && !CostantiConfigurazione.DISABILITATO.equals(dumpStato)) {
                throw new Exception("Impostazione sul dump applicativo non corretta");
            }
            String dumpBinarioPortaDelegata = this.getValue("dump.dumpBinarioPortaDelegata");
            if (dumpBinarioPortaDelegata != null && !CostantiConfigurazione.ABILITATO.equals(dumpBinarioPortaDelegata = dumpBinarioPortaDelegata.trim()) && !CostantiConfigurazione.DISABILITATO.equals(dumpBinarioPortaDelegata)) {
                throw new Exception("Impostazione sul dump binario della porta delegata non corretta");
            }
            String dumpBinarioPortaApplicativa = this.getValue("dump.dumpBinarioPortaApplicativa");
            if (dumpBinarioPortaApplicativa != null && !CostantiConfigurazione.ABILITATO.equals(dumpBinarioPortaApplicativa = dumpBinarioPortaApplicativa.trim()) && !CostantiConfigurazione.DISABILITATO.equals(dumpBinarioPortaApplicativa)) {
                throw new Exception("Impostazione sul dump binario della porta applicativa non corretta");
            }
            String dumpAppendersDisabledTmp = this.getValue("dump.appenders.disabled");
            boolean disabilitatiDumpAppenderOriginali = false;
            if (dumpAppendersDisabledTmp != null && "true".equals(dumpAppendersDisabledTmp)) {
                disabilitatiDumpAppenderOriginali = true;
                if (configurazione.getDump() != null) {
                    while (configurazione.getDump().sizeOpenspcoopAppenderList() > 0) {
                        configurazione.getDump().removeOpenspcoopAppender(0);
                    }
                }
            }
            String dumpAppendersTmp = this.getValue("dump.appenders");
            String[] dumpAppenders = null;
            if (dumpAppendersTmp != null && (dumpAppenders = (dumpAppendersTmp = dumpAppendersTmp.trim()).split(",")) != null) {
                if (dumpAppenders.length > 0) {
                    for (int i4 = 0; i4 < dumpAppenders.length; ++i4) {
                        dumpAppenders[i4] = dumpAppenders[i4].trim();
                    }
                } else {
                    dumpAppenders = null;
                }
            }
            if ((dumpStato != null || dumpBinarioPortaDelegata != null || dumpBinarioPortaApplicativa != null || dumpAppenders != null) && configurazione.getDump() == null) {
                configurazione.setDump(new Dump());
                if (dumpStato == null) {
                    configurazione.getDump().setStato(CostantiConfigurazione.DISABILITATO);
                }
            }
            if (dumpStato != null) {
                configurazione.getDump().setStato(StatoFunzionalita.toEnumConstant((String)dumpStato));
            }
            if (dumpBinarioPortaDelegata != null) {
                configurazione.getDump().setDumpBinarioPortaDelegata(StatoFunzionalita.toEnumConstant((String)dumpBinarioPortaDelegata));
            }
            if (dumpBinarioPortaApplicativa != null) {
                configurazione.getDump().setDumpBinarioPortaApplicativa(StatoFunzionalita.toEnumConstant((String)dumpBinarioPortaApplicativa));
            }
            if (dumpAppenders != null) {
                block20: for (int i5 = 0; i5 < dumpAppenders.length; ++i5) {
                    String tipo = this.getValue("dump.appender." + dumpAppenders[i5] + ".tipo");
                    if (tipo == null) {
                        throw new Exception("Tipo dell'appender del dump " + dumpAppenders[i5] + " non definito");
                    }
                    tipo = tipo.trim();
                    String valueEnable = this.getValue("dump.appender." + dumpAppenders[i5] + ".enabled");
                    if (valueEnable != null && "false".equalsIgnoreCase(valueEnable.trim())) {
                        if (disabilitatiDumpAppenderOriginali) continue;
                        for (int j = 0; j < configurazione.getDump().sizeOpenspcoopAppenderList(); ++j) {
                            if (!tipo.equals(configurazione.getDump().getOpenspcoopAppender(j).getTipo())) continue;
                            configurazione.getDump().removeOpenspcoopAppender(j);
                            continue block20;
                        }
                        continue;
                    }
                    OpenspcoopAppender appender = null;
                    for (int j = 0; j < configurazione.getDump().sizeOpenspcoopAppenderList(); ++j) {
                        if (!tipo.equals(configurazione.getDump().getOpenspcoopAppender(j).getTipo())) continue;
                        appender = configurazione.getDump().removeOpenspcoopAppender(j);
                        break;
                    }
                    if (appender == null) {
                        appender = new OpenspcoopAppender();
                        appender.setTipo(tipo);
                    }
                    while (appender.sizePropertyList() > 0) {
                        appender.removeProperty(0);
                    }
                    Properties properties = this.readProperties("dump.appender." + dumpAppenders[i5] + ".property.");
                    Enumeration<Object> keys = properties.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Property ap = new Property();
                        ap.setNome(key);
                        ap.setValore(properties.getProperty(key));
                        appender.addProperty(ap);
                    }
                    configurazione.getDump().addOpenspcoopAppender(appender);
                }
            }
            this.setDump(dumpStato, configurazione);
            this.setDump(dumpStato, configurazione, true);
            this.setDump(dumpStato, configurazione, false);
            String integrationManager_autenticazione = this.getValue("integrationManager.autenticazione");
            if (integrationManager_autenticazione != null) {
                integrationManager_autenticazione = integrationManager_autenticazione.trim();
                if (configurazione.getIntegrationManager() == null) {
                    configurazione.setIntegrationManager(new IntegrationManager());
                }
                configurazione.getIntegrationManager().setAutenticazione(integrationManager_autenticazione);
            }
            return configurazione;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del file govway_local.config.properties (Configurazione): " + e.getMessage(), (Throwable)e);
            throw new Exception("Errore durante la lettura del file govway_local.config.properties (Configurazione): " + e.getMessage(), e);
        }
    }

    private void setDump(String dumpStato, Configurazione configurazione) throws Exception {
        String dumpRealtime = this.getValue("dump.realtime");
        if (dumpRealtime != null) {
            dumpRealtime = dumpRealtime.trim();
            if (!CostantiConfigurazione.ABILITATO.equals(dumpStato) && !CostantiConfigurazione.DISABILITATO.equals(dumpStato)) {
                throw new Exception("Impostazione sul dump realtime non corretta");
            }
        }
        DumpConfigurazioneRegola regolaRequestIn = this.readRegola("request", "in", true);
        DumpConfigurazioneRegola regolaRequestOut = this.readRegola("request", "out", true);
        DumpConfigurazioneRegola regolaResponseIn = this.readRegola("response", "in", true);
        DumpConfigurazioneRegola regolaResponseOut = this.readRegola("response", "out", true);
        if (dumpRealtime != null || regolaRequestIn != null || regolaRequestOut != null || regolaResponseIn != null || regolaResponseOut != null) {
            if (configurazione.getDump() == null) {
                configurazione.setDump(new Dump());
                if (dumpStato == null) {
                    configurazione.getDump().setStato(CostantiConfigurazione.DISABILITATO);
                }
            }
            if (configurazione.getDump().getConfigurazione() == null) {
                configurazione.getDump().setConfigurazione(new DumpConfigurazione());
            }
        }
        if (dumpRealtime != null) {
            configurazione.getDump().getConfigurazione().setRealtime(StatoFunzionalita.toEnumConstant((String)dumpRealtime));
        }
        if (regolaRequestIn != null) {
            configurazione.getDump().getConfigurazione().setRichiestaIngresso(regolaRequestIn);
        }
        if (regolaRequestOut != null) {
            configurazione.getDump().getConfigurazione().setRichiestaUscita(regolaRequestOut);
        }
        if (regolaResponseIn != null) {
            configurazione.getDump().getConfigurazione().setRispostaIngresso(regolaResponseIn);
        }
        if (regolaResponseOut != null) {
            configurazione.getDump().getConfigurazione().setRispostaUscita(regolaResponseOut);
        }
    }

    private void setDump(String dumpStato, Configurazione configurazione, boolean erogazioni) throws Exception {
        String tipo = erogazioni ? "erogazioni" : "fruizioni";
        String dumpRealtime = this.getValue("dump." + tipo + ".realtime");
        if (dumpRealtime != null) {
            dumpRealtime = dumpRealtime.trim();
            if (!CostantiConfigurazione.ABILITATO.equals(dumpStato) && !CostantiConfigurazione.DISABILITATO.equals(dumpStato)) {
                throw new Exception("Impostazione sul dump realtime non corretta");
            }
        }
        DumpConfigurazioneRegola regolaRequestIn = this.readRegola(tipo + ".request", "in", false);
        DumpConfigurazioneRegola regolaRequestOut = this.readRegola(tipo + ".request", "out", false);
        DumpConfigurazioneRegola regolaResponseIn = this.readRegola(tipo + ".response", "in", false);
        DumpConfigurazioneRegola regolaResponseOut = this.readRegola(tipo + ".response", "out", false);
        if (dumpRealtime != null || regolaRequestIn != null || regolaRequestOut != null || regolaResponseIn != null || regolaResponseOut != null) {
            if (configurazione.getDump() == null) {
                configurazione.setDump(new Dump());
                if (dumpStato == null) {
                    configurazione.getDump().setStato(CostantiConfigurazione.DISABILITATO);
                }
            }
            if (erogazioni) {
                if (configurazione.getDump().getConfigurazionePortaApplicativa() == null) {
                    configurazione.getDump().setConfigurazionePortaApplicativa(new DumpConfigurazione());
                }
            } else if (configurazione.getDump().getConfigurazionePortaDelegata() == null) {
                configurazione.getDump().setConfigurazionePortaDelegata(new DumpConfigurazione());
            }
        }
        if (erogazioni) {
            if (dumpRealtime != null) {
                configurazione.getDump().getConfigurazionePortaApplicativa().setRealtime(StatoFunzionalita.toEnumConstant((String)dumpRealtime));
            }
            if (regolaRequestIn != null) {
                configurazione.getDump().getConfigurazionePortaApplicativa().setRichiestaIngresso(regolaRequestIn);
            }
            if (regolaRequestOut != null) {
                configurazione.getDump().getConfigurazionePortaApplicativa().setRichiestaUscita(regolaRequestOut);
            }
            if (regolaResponseIn != null) {
                configurazione.getDump().getConfigurazionePortaApplicativa().setRispostaIngresso(regolaResponseIn);
            }
            if (regolaResponseOut != null) {
                configurazione.getDump().getConfigurazionePortaApplicativa().setRispostaUscita(regolaResponseOut);
            }
        } else {
            if (dumpRealtime != null) {
                configurazione.getDump().getConfigurazionePortaDelegata().setRealtime(StatoFunzionalita.toEnumConstant((String)dumpRealtime));
            }
            if (regolaRequestIn != null) {
                configurazione.getDump().getConfigurazionePortaDelegata().setRichiestaIngresso(regolaRequestIn);
            }
            if (regolaRequestOut != null) {
                configurazione.getDump().getConfigurazionePortaDelegata().setRichiestaUscita(regolaRequestOut);
            }
            if (regolaResponseIn != null) {
                configurazione.getDump().getConfigurazionePortaDelegata().setRispostaIngresso(regolaResponseIn);
            }
            if (regolaResponseOut != null) {
                configurazione.getDump().getConfigurazionePortaDelegata().setRispostaUscita(regolaResponseOut);
            }
        }
    }

    private DumpConfigurazioneRegola readRegola(String flow, String inOut, boolean backwardCompatibility) throws Exception {
        DumpConfigurazioneRegola regola = null;
        String payload = this.getValue("dump." + flow + "." + inOut + ".payload");
        if (payload != null && !CostantiConfigurazione.ABILITATO.equals(payload = payload.trim()) && !CostantiConfigurazione.DISABILITATO.equals(payload)) {
            throw new Exception("Impostazione sul dump payload (" + flow + "." + inOut + ") non corretta");
        }
        String payload_parsing = this.getValue("dump." + flow + "." + inOut + ".payload-parsing");
        if (payload_parsing != null && !CostantiConfigurazione.ABILITATO.equals(payload_parsing = payload_parsing.trim()) && !CostantiConfigurazione.DISABILITATO.equals(payload_parsing)) {
            throw new Exception("Impostazione sul dump payload-parsing (" + flow + "." + inOut + ") non corretta");
        }
        String body = this.getValue("dump." + flow + "." + inOut + ".body");
        if (body != null && !CostantiConfigurazione.ABILITATO.equals(body = body.trim()) && !CostantiConfigurazione.DISABILITATO.equals(body)) {
            throw new Exception("Impostazione sul dump body (" + flow + "." + inOut + ") non corretta");
        }
        String attachments = this.getValue("dump." + flow + "." + inOut + ".attachments");
        if (attachments != null && !CostantiConfigurazione.ABILITATO.equals(attachments = attachments.trim()) && !CostantiConfigurazione.DISABILITATO.equals(attachments)) {
            throw new Exception("Impostazione sul dump attachments (" + flow + "." + inOut + ") non corretta");
        }
        String headers = this.getValue("dump." + flow + "." + inOut + ".headers");
        if (headers != null && !CostantiConfigurazione.ABILITATO.equals(headers = headers.trim()) && !CostantiConfigurazione.DISABILITATO.equals(headers)) {
            throw new Exception("Impostazione sul dump headers (" + flow + "." + inOut + ") non corretta");
        }
        if (backwardCompatibility) {
            if (body != null || attachments != null || headers != null) {
                regola = new DumpConfigurazioneRegola();
            }
            if (regola != null) {
                if (body != null) {
                    regola.setBody(StatoFunzionalita.toEnumConstant((String)body));
                }
                if (attachments != null) {
                    regola.setAttachments(StatoFunzionalita.toEnumConstant((String)attachments));
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)regola.getBody()) || StatoFunzionalita.ABILITATO.equals((Object)regola.getAttachments())) {
                    regola.setPayload(StatoFunzionalita.ABILITATO);
                    regola.setPayloadParsing(StatoFunzionalita.ABILITATO);
                } else {
                    regola.setPayload(StatoFunzionalita.DISABILITATO);
                    regola.setPayloadParsing(StatoFunzionalita.DISABILITATO);
                }
            }
        } else {
            if (payload != null || payload_parsing != null || body != null || attachments != null || headers != null) {
                regola = new DumpConfigurazioneRegola();
            }
            if (regola != null) {
                if (payload != null) {
                    regola.setPayload(StatoFunzionalita.toEnumConstant((String)payload));
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)regola.getPayload())) {
                    if (payload_parsing != null) {
                        regola.setPayloadParsing(StatoFunzionalita.toEnumConstant((String)payload_parsing));
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)regola.getPayloadParsing())) {
                        if (body != null) {
                            regola.setBody(StatoFunzionalita.toEnumConstant((String)body));
                        }
                        if (attachments != null) {
                            regola.setAttachments(StatoFunzionalita.toEnumConstant((String)attachments));
                        }
                    } else {
                        regola.setBody(StatoFunzionalita.DISABILITATO);
                        regola.setAttachments(StatoFunzionalita.DISABILITATO);
                    }
                } else {
                    regola.setPayloadParsing(StatoFunzionalita.DISABILITATO);
                    regola.setBody(StatoFunzionalita.DISABILITATO);
                    regola.setAttachments(StatoFunzionalita.DISABILITATO);
                }
            }
        }
        if (regola != null && headers != null) {
            regola.setHeaders(StatoFunzionalita.toEnumConstant((String)headers));
        }
        return regola;
    }
}

