/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.dao.IPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.AbstractConfigurazionePdDConnectionResourceManager;
import org.openspcoop2.pdd.config.ConfigurazionePdDConnectionResource;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.NameValue;
import org.slf4j.Logger;

public class ConfigurazionePdD_plugins
extends AbstractConfigurazionePdDConnectionResourceManager {
    private ServiceManagerProperties smp = new ServiceManagerProperties();

    public ConfigurazionePdD_plugins(OpenSPCoop2Properties openspcoopProperties, DriverConfigurazioneDB driver, boolean useConnectionPdD) {
        super(openspcoopProperties, driver, useConnectionPdD, OpenSPCoop2Logger.getLoggerOpenSPCoopPluginsSql(openspcoopProperties.isConfigurazionePluginsDebug()));
        this.smp.setShowSql(this.openspcoopProperties.isConfigurazionePluginsDebug());
        this.smp.setDatabaseType(this.driver.getTipoDB());
    }

    public int countPlugins(Connection connectionPdD) throws DriverConfigurazioneException {
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Plugins.countPlugins");
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IPluginServiceSearch search = sm.getPluginServiceSearch();
            IExpression expr = search.newExpression();
            int n = (int)search.count(expr).longValue();
            return n;
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la conta dei plugins registrati: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
        }
        finally {
            this.releaseConnection(cr);
        }
    }

    public List<IdPlugin> findAllPluginIds(Connection connectionPdD, int offset, int limit) throws DriverConfigurazioneException {
        List list;
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Plugins.findAllPluginIds_" + offset + "_" + limit);
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IPluginServiceSearch search = sm.getPluginServiceSearch();
            IPaginatedExpression pagExpr = search.newPaginatedExpression();
            pagExpr.offset(offset);
            pagExpr.limit(limit);
            pagExpr.addOrder(Plugin.model().TIPO_PLUGIN);
            pagExpr.addOrder(Plugin.model().TIPO);
            list = search.findAllIds(pagExpr);
        }
        catch (Exception e) {
            try {
                String errorMsg = "Errore durante la lettura degli idPlugin (offset:" + offset + " limit:" + limit + "): " + e.getMessage();
                this.log.error(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneException(errorMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(cr);
                throw throwable;
            }
        }
        this.releaseConnection(cr);
        return list;
    }

    public String getPluginClassName(Connection connectionPdD, String tipoPlugin, String tipo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPluginClassNameByFilter(connectionPdD, tipoPlugin, tipo, new NameValue[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPluginClassNameByFilter(Connection connectionPdD, String tipoPlugin, String tipo, NameValue ... filtri) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Plugin plugin;
        if (tipoPlugin == null || "".equals(tipoPlugin)) {
            throw new DriverConfigurazioneException("tipo plugin non fornito");
        }
        if (tipo == null || "".equals(tipo)) {
            throw new DriverConfigurazioneException("tipo non fornito");
        }
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Plugins.getPluginClassName_" + tipoPlugin + "#" + tipo);
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IPluginServiceSearch search = sm.getPluginServiceSearch();
            IdPlugin idPlugin = new IdPlugin();
            idPlugin.setTipoPlugin(tipoPlugin);
            idPlugin.setTipo(tipo);
            plugin = (Plugin)search.get((Object)idPlugin);
            if (filtri != null && filtri.length > 0) {
                for (int i = 0; i < filtri.length; ++i) {
                    NameValue filtro = filtri[i];
                    if (plugin.sizePluginProprietaCompatibilitaList() <= 0) continue;
                    for (int j = 0; j < plugin.sizePluginProprietaCompatibilitaList(); ++j) {
                        PluginProprietaCompatibilita ppc = plugin.getPluginProprietaCompatibilita(j);
                        if (!ppc.getNome().equals(filtro.getName()) || ppc.getValore().equals(filtro.getValue())) continue;
                        boolean isCasoSpecialeQualsiasi = false;
                        if ("Ruolo".equals(ppc.getNome()) && "Qualsiasi".equals(ppc.getValore())) {
                            isCasoSpecialeQualsiasi = true;
                        }
                        if ("Applicabilita".equals(ppc.getNome())) {
                            if ("Qualsiasi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            } else if ("Fruizione".equals(filtro.getValue()) && "ImplementazioneApi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            } else if ("Erogazione".equals(filtro.getValue()) && "ImplementazioneApi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            }
                        }
                        if (isCasoSpecialeQualsiasi) continue;
                        throw new NotFoundException("Filtro '" + ppc.getNome() + "' non soddisfatto (atteso:" + filtro.getValue() + " trovato:" + ppc.getValore() + ")");
                    }
                }
            }
        }
        catch (NotFoundException e) {
            try {
                String errorMsg = "Plugin (tipologia:" + tipoPlugin + " tipo:" + tipo + ") non trovato: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
                catch (Exception e2) {
                    errorMsg = "Errore durante la lettura del Plugin (tipologia:" + tipoPlugin + " tipo:" + tipo + "): " + e2.getMessage();
                    this.log.error(errorMsg, (Throwable)e2);
                    throw new DriverConfigurazioneException(errorMsg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(cr);
                throw throwable;
            }
        }
        String string = plugin.getClassName();
        this.releaseConnection(cr);
        return string;
    }

    public String getPluginTipo(Connection connectionPdD, String tipoPlugin, String className) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getPluginTipoByFilter(connectionPdD, tipoPlugin, className, new NameValue[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPluginTipoByFilter(Connection connectionPdD, String tipoPlugin, String className, NameValue ... filtri) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Plugin plugin;
        if (tipoPlugin == null || "".equals(tipoPlugin)) {
            throw new DriverConfigurazioneException("tipo plugin non fornito");
        }
        if (className == null || "".equals(className)) {
            throw new DriverConfigurazioneException("Classname non fornito");
        }
        ConfigurazionePdDConnectionResource cr = null;
        try {
            cr = this.getConnection(connectionPdD, "Plugins.getPluginTipo_" + tipoPlugin + "#" + className);
            IServiceManager sm = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), cr.connectionDB, this.smp, this.log);
            IPluginServiceSearch search = sm.getPluginServiceSearch();
            IExpression expr = search.newExpression();
            expr.equals(Plugin.model().TIPO_PLUGIN, (Object)tipoPlugin);
            expr.equals(Plugin.model().CLASS_NAME, (Object)className);
            plugin = (Plugin)search.find(expr);
            if (filtri != null && filtri.length > 0) {
                for (int i = 0; i < filtri.length; ++i) {
                    NameValue filtro = filtri[i];
                    if (plugin.sizePluginProprietaCompatibilitaList() <= 0) continue;
                    for (int j = 0; j < plugin.sizePluginProprietaCompatibilitaList(); ++j) {
                        PluginProprietaCompatibilita ppc = plugin.getPluginProprietaCompatibilita(j);
                        if (!ppc.getNome().equals(filtro.getName()) || ppc.getValore().equals(filtro.getValue())) continue;
                        boolean isCasoSpecialeQualsiasi = false;
                        if ("Ruolo".equals(ppc.getNome()) && "Qualsiasi".equals(ppc.getValore())) {
                            isCasoSpecialeQualsiasi = true;
                        }
                        if ("Applicabilita".equals(ppc.getNome())) {
                            if ("Qualsiasi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            } else if ("Fruizione".equals(filtro.getValue()) && "ImplementazioneApi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            } else if ("Erogazione".equals(filtro.getValue()) && "ImplementazioneApi".equals(ppc.getValore())) {
                                isCasoSpecialeQualsiasi = true;
                            }
                        }
                        if (isCasoSpecialeQualsiasi) continue;
                        throw new NotFoundException("Filtro '" + ppc.getNome() + "' non soddisfatto (atteso:" + filtro.getValue() + " trovato:" + ppc.getValore() + ")");
                    }
                }
            }
        }
        catch (NotFoundException e) {
            try {
                String errorMsg = "Plugin (tipologia:" + tipoPlugin + " className:" + className + ") non trovato: " + e.getMessage();
                this.log.debug(errorMsg, (Throwable)e);
                throw new DriverConfigurazioneNotFound(errorMsg, (Throwable)e);
                catch (Exception e2) {
                    errorMsg = "Errore durante la lettura del Plugin (tipologia:" + tipoPlugin + " className:" + className + "): " + e2.getMessage();
                    this.log.error(errorMsg, (Throwable)e2);
                    throw new DriverConfigurazioneException(errorMsg, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(cr);
                throw throwable;
            }
        }
        String string = plugin.getTipo();
        this.releaseConnection(cr);
        return string;
    }
}

