/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.UniqueIdentifierException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.slf4j.Logger;

public class DBManager
implements IMonitoraggioRisorsa {
    private static final String ID_MODULO = "DBManager";
    private static DBManager manager = null;
    private static volatile int transactionIsolationLevel = -1;
    private String dataSourceJndiName = null;
    private DataSource dataSource = null;
    private MsgDiagnostico msgDiag = MsgDiagnostico.newInstance("DBManager");
    private static ConcurrentHashMap<String, Resource> risorseInGestione = new ConcurrentHashMap();
    private static volatile boolean getConnectionCheckAutoCommitDisabled;
    private static volatile boolean getConnectionCheckTransactionIsolation;
    private static volatile int getConnectionCheckTransactionIsolationExpected;
    private static volatile boolean initialized;

    public static void setTransactionIsolationLevel(int transactionIsolationLevel) {
        DBManager.transactionIsolationLevel = transactionIsolationLevel;
    }

    public static String[] getStatoRisorse() {
        return DBManager.getStatoRisorse(risorseInGestione);
    }

    public static String[] getStatoRisorse(ConcurrentMap<String, Resource> risorseInGestione) {
        String[] sNull = null;
        Resource[] o = risorseInGestione.values().toArray(new Resource[0]);
        if (!(o instanceof Resource[])) {
            return sNull;
        }
        Resource[] resources = o;
        if (resources.length <= 0) {
            return sNull;
        }
        String[] r = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource rr = resources[i];
            r[i] = String.valueOf(rr.getIdentificativoPorta()) + "." + rr.getModuloFunzionale();
            if (rr.getIdTransazione() != null) {
                r[i] = r[i] + "." + rr.getIdTransazione();
            }
            SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
            r[i] = r[i] + " (" + dateformat.format(rr.getDate()) + ")";
        }
        return r;
    }

    private DBManager(String jndiName, Properties context) throws UtilsException, SQLException {
        GestoreJNDI jndi = new GestoreJNDI(context);
        Object oSearch = jndi.lookup(jndiName);
        if (oSearch == null) {
            throw new UtilsException("Lookup jndiResource [" + jndiName + "] not found");
        }
        try {
            this.dataSourceJndiName = jndiName;
            this.dataSource = (DataSource)oSearch;
        }
        catch (Throwable t) {
            StringBuilder bf = new StringBuilder();
            if (oSearch instanceof Reference) {
                Reference r = (Reference)oSearch;
                bf.append(" (Factory=");
                bf.append(r.getFactoryClassName());
                bf.append(" FactoryLocation=");
                bf.append(r.getFactoryClassLocation());
                Enumeration<RefAddr> enR = r.getAll();
                if (enR != null) {
                    while (enR.hasMoreElements()) {
                        RefAddr refAddr = enR.nextElement();
                        bf.append(" [").append("type=").append(refAddr.getType()).append(" content=").append(refAddr.getContent()).append("]");
                    }
                }
                bf.append(")");
            }
            throw new UtilsException("lookup failed (object class: " + oSearch.getClass().getName() + ")" + bf.toString() + ": " + t.getMessage(), t);
        }
        try (Connection connectionTest = this.dataSource.getConnection();){
            DBManager.setTransactionIsolationLevel(connectionTest.getTransactionIsolation());
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void setInitialized(boolean initialized) {
        DBManager.initialized = initialized;
    }

    public static void initialize(String jndiName, Properties context) throws UtilsException, SQLException {
        manager = new DBManager(jndiName, context);
        DBManager.setInitialized(true);
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        if (properties != null) {
            getConnectionCheckAutoCommitDisabled = properties.isDataSourceGetConnectionCheckAutoCommitDisabled();
            getConnectionCheckTransactionIsolation = properties.isDataSourceGetConnectionCheckTransactionIsolationLevel();
            if (getConnectionCheckTransactionIsolation) {
                getConnectionCheckTransactionIsolationExpected = properties.getDataSourceGetConnectionCheckTransactionIsolationLevelExpected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBManager getInstance() {
        if (manager == null) {
            Class<DBManager> clazz = DBManager.class;
            synchronized (DBManager.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return manager;
            }
        }
        return manager;
    }

    public static int getTransactionIsolationLevel() {
        return transactionIsolationLevel;
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione) throws UtilsException {
        return this.getResource(idPDD, modulo, idTransazione, true);
    }

    public Resource getResource(IDSoggetto idPDD, String modulo, String idTransazione, boolean logError) throws UtilsException {
        if (this.dataSource == null) {
            throw new UtilsException("Datasource non istanziato");
        }
        Resource risorsa = null;
        try {
            risorsa = DBManager.buildResource(this.dataSourceJndiName, this.dataSource, idPDD, modulo, idTransazione);
            risorseInGestione.put(risorsa.getId(), risorsa);
        }
        catch (Exception e) {
            if (logError) {
                this.msgDiag.aggiornaFiltri();
                this.msgDiag.setDominio(idPDD);
                this.msgDiag.setFunzione("DBManager." + modulo);
                this.msgDiag.logFatalError(e, "Richiesta connessione al datasource");
            }
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
        return risorsa;
    }

    public static Resource buildResource(String dataSourceJndiName, DataSource dataSource, IDSoggetto idPDD, String modulo, String idTransazione) throws UtilsException, SQLException, UniqueIdentifierException {
        if (dataSourceJndiName != null) {
            // empty if block
        }
        Connection connectionDB = dataSource.getConnection();
        DBManager.checkConnection(connectionDB);
        return DBManager.buildResource("DBRuntimeManager", connectionDB, idPDD, modulo, idTransazione);
    }

    private static void checkConnection(Connection connectionDB) throws UtilsException {
        if (connectionDB == null) {
            throw new UtilsException("is null");
        }
    }

    public static Resource buildResource(String managerId, Connection connectionDB, IDSoggetto idPDD, String modulo, String idTransazione) throws SQLException, UniqueIdentifierException {
        if (connectionDB != null) {
            String msg;
            Logger log;
            if (getConnectionCheckAutoCommitDisabled && !connectionDB.getAutoCommit() && (log = OpenSPCoop2Logger.getLoggerOpenSPCoopResources()) != null) {
                msg = DBManager.getPrefixLog(managerId, idPDD, modulo, idTransazione) + " Connessione ottenuta possiede autoCommit enabled ?";
                log.error(msg);
            }
            if (getConnectionCheckTransactionIsolation && getConnectionCheckTransactionIsolationExpected != connectionDB.getTransactionIsolation() && (log = OpenSPCoop2Logger.getLoggerOpenSPCoopResources()) != null) {
                msg = DBManager.getPrefixLog(managerId, idPDD, modulo, idTransazione) + " Connessione ottenuta possiede un transaction isolation level '" + connectionDB.getTransactionIsolation() + "' differente da quello atteso '" + getConnectionCheckTransactionIsolationExpected + "'";
                log.error(msg);
            }
        }
        Resource risorsa = new Resource();
        String idUnivoco = Resource.generaIdentificatoreUnivoco(idPDD, modulo);
        risorsa.setId(idUnivoco);
        risorsa.setDate(DateManager.getDate());
        risorsa.setIdentificativoPorta(idPDD);
        risorsa.setModuloFunzionale(modulo);
        risorsa.setResource(connectionDB);
        risorsa.setResourceType(Connection.class.getName());
        risorsa.setIdTransazione(idTransazione);
        return risorsa;
    }

    private static String getPrefixLog(String managerId, IDSoggetto idPDD, String modulo, String idTransazione) {
        StringBuilder sb = new StringBuilder("");
        if (managerId != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("[").append(managerId).append("]");
        }
        if (idTransazione != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("<").append(idTransazione).append(">");
        }
        if (modulo != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("modulo:").append(modulo);
        }
        if (idPDD != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append("soggetto:").append(idPDD.toString());
        }
        return sb.toString();
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource) {
        this.releaseResource(idPDD, modulo, resource, true);
    }

    public void releaseResource(IDSoggetto idPDD, String modulo, Resource resource, boolean logError) {
        block5: {
            try {
                if (resource != null) {
                    if (resource.getResource() != null) {
                        Connection connectionDB = (Connection)resource.getResource();
                        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopResources() != null ? OpenSPCoop2Logger.getLoggerOpenSPCoopResources() : LoggerWrapperFactory.getLogger(DBManager.class);
                        boolean checkAutocommit = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckAutocommit();
                        boolean checkIsClosed = OpenSPCoop2Properties.getInstance() == null || OpenSPCoop2Properties.getInstance().isJdbcCloseConnectionCheckIsClosed();
                        JDBCUtilities.closeConnection((Logger)log, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
                    }
                    if (risorseInGestione.containsKey(resource.getId())) {
                        risorseInGestione.remove(resource.getId());
                    }
                }
            }
            catch (SQLException e) {
                if (!logError) break block5;
                this.msgDiag.aggiornaFiltri();
                this.msgDiag.setDominio(idPDD);
                this.msgDiag.setFunzione("DBManager." + modulo);
                this.msgDiag.logFatalError(e, "Rilasciata connessione al datasource");
            }
        }
    }

    public void isAlive() throws CoreException {
        Resource resource = null;
        Statement stmtTest = null;
        IDSoggetto idSoggettAlive = new IDSoggetto();
        idSoggettAlive.setCodicePorta(ID_MODULO);
        idSoggettAlive.setTipo(ID_MODULO);
        idSoggettAlive.setNome(ID_MODULO);
        try {
            resource = this.getResource(idSoggettAlive);
            if (resource == null) {
                throw new CoreException("Resource is null");
            }
            if (resource.getResource() == null) {
                throw new CoreException("Connessione is null");
            }
            Connection con = (Connection)resource.getResource();
            stmtTest = con.createStatement();
            stmtTest.execute("SELECT * from db_info");
        }
        catch (Exception e) {
            throw new CoreException("Connessione al database GovWay non disponibile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
            try {
                this.releaseResource(idSoggettAlive, "CheckIsAlive", resource);
            }
            catch (Exception exception) {}
        }
    }

    private Resource getResource(IDSoggetto idSoggettAlive) throws CoreException {
        try {
            return this.getResource(idSoggettAlive, "CheckIsAlive", null, false);
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), (Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    static {
        initialized = false;
    }
}

