/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.pdd.config.ConfigurazionePdDReader;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.pdd.services.connector.proxy.ProxyOperation;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.id.apache.serial.MaxReachedException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DynamicClusterManager {
    private static DynamicClusterManager staticInstance = null;
    private DriverConfigurazioneDB driverConfigurazioneDB = null;
    private OpenSPCoop2Properties op2Properties = null;
    private volatile boolean rateLimitingGestioneCluster = false;
    private volatile int identificativoNumerico = -1;

    public static synchronized void initStaticInstance() throws CoreException {
        if (staticInstance == null) {
            staticInstance = new DynamicClusterManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicClusterManager getInstance() throws CoreException {
        if (staticInstance != null) return staticInstance;
        Class<DynamicClusterManager> clazz = DynamicClusterManager.class;
        synchronized (DynamicClusterManager.class) {
            DynamicClusterManager.initStaticInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    public static boolean isInitialized() {
        return staticInstance != null;
    }

    private DynamicClusterManager() throws CoreException {
        IDriverConfigurazioneGet oConfig = ConfigurazionePdDReader.getDriverConfigurazionePdD();
        if (!(oConfig instanceof DriverConfigurazioneDB)) {
            throw new CoreException("Modalit\u00e0 dinamica utilizzabile solamente con una configurazione su database");
        }
        this.driverConfigurazioneDB = (DriverConfigurazioneDB)oConfig;
        this.op2Properties = OpenSPCoop2Properties.getInstance();
    }

    public boolean isRateLimitingGestioneCluster() {
        return this.rateLimitingGestioneCluster;
    }

    public void setRateLimitingGestioneCluster(boolean rateLimitingGestioneCluster) {
        this.rateLimitingGestioneCluster = rateLimitingGestioneCluster;
    }

    public int getIdentificativoNumerico() {
        return this.identificativoNumerico;
    }

    private String getSuffixMessageUpdate(int row) {
        return " nella tabella 'nodi_runtime' (update-row: " + row + ")";
    }

    public void register(Logger log) throws CoreException {
        Connection con = null;
        int oldTransactionIsolation = -1;
        try {
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.register");
            boolean autoCommit = false;
            con.setAutoCommit(autoCommit);
            try {
                oldTransactionIsolation = con.getTransactionIsolation();
                JDBCUtilities.setTransactionIsolationSerializable((String)this.driverConfigurazioneDB.getTipoDB(), (Connection)con);
            }
            catch (Exception er) {
                throw new CoreException("(setIsolation) " + er.getMessage(), (Throwable)er);
            }
            boolean updateEffettuato = false;
            long gestioneSerializableDBattesaAttiva = this.op2Properties.getGestioneSerializableDBAttesaAttiva();
            int gestioneSerializableDBcheckInterval = this.op2Properties.getGestioneSerializableDBCheckInterval();
            long scadenzaWhile = DateManager.getTimeMillis() + gestioneSerializableDBattesaAttiva;
            Throwable eLast = null;
            while (!updateEffettuato && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    this.registerEngine(con, log);
                    updateEffettuato = true;
                }
                catch (MaxReachedException maxReached) {
                    throw maxReached;
                }
                catch (Exception e) {
                    eLast = e;
                }
                if (updateEffettuato) continue;
                try {
                    Utilities.sleep((long)ServicesUtils.getRandom().nextInt(gestioneSerializableDBcheckInterval));
                }
                catch (Exception exception) {}
            }
            if (!updateEffettuato) {
                throw new CoreException("Registrazione fallita: " + eLast.getMessage(), eLast);
            }
        }
        catch (Exception e) {
            throw new CoreException("[DynamicClusterManager.register] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                con.setTransactionIsolation(oldTransactionIsolation);
            }
            catch (Exception er) {
                if (log != null) {
                    log.error("(ripristinoIsolation) " + er.getMessage(), (Throwable)er);
                }
                LoggerWrapperFactory.getLogger(DynamicClusterManager.class).error("(ripristinoIsolation) " + er.getMessage(), (Throwable)er);
            }
            try {
                con.setAutoCommit(true);
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void registerEngine(Connection con, Logger log) throws MaxReachedException, SQLException, SQLQueryObjectException {
        try {
            boolean find = this.registerExistsId(con);
            if (find) {
                this.registerUpdate(con, log);
            } else {
                this.identificativoNumerico = this.getNextIdNumerico(con, log);
                this.registerInsert(con, log);
            }
            con.commit();
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerExistsId(Connection con) throws SQLException, SQLQueryObjectException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addFromTable("nodi_runtime");
            sqlQueryObject.addSelectField("id_numerico");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("hostname=?");
            String query = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setString(index++, this.op2Properties.getClusterHostname());
            rs = pstmt.executeQuery();
            boolean find = rs.next();
            if (find) {
                this.identificativoNumerico = rs.getInt("id_numerico");
            }
            boolean bl = find;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInsert(Connection con, Logger log) throws SQLException, SQLQueryObjectException {
        Statement pstmt = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addInsertTable("nodi_runtime");
            sqlQueryObject.addInsertField("hostname", "?");
            sqlQueryObject.addInsertField("gruppo", "?");
            sqlQueryObject.addInsertField("data_registrazione", "?");
            sqlQueryObject.addInsertField("data_refresh", "?");
            sqlQueryObject.addInsertField("id_numerico", "?");
            String insert = sqlQueryObject.createSQLInsert();
            pstmt = con.prepareStatement(insert);
            int index = 1;
            String hostname = this.op2Properties.getClusterHostname();
            if (hostname == null) {
                throw new SQLException("ClusterHostname non definito ne tramite propriet\u00e0 'org.openspcoop2.pdd.cluster_id.hostname' ne tramite propriet\u00e0 'org.openspcoop2.pdd.cluster_id'");
            }
            pstmt.setString(index++, this.op2Properties.getClusterHostname());
            pstmt.setString(index++, this.op2Properties.getGroupId(this.rateLimitingGestioneCluster));
            Timestamp now = DateManager.getTimestamp();
            pstmt.setTimestamp(index++, now);
            pstmt.setTimestamp(index++, now);
            pstmt.setInt(index++, this.identificativoNumerico);
            int row = pstmt.executeUpdate();
            String msg = "Registrato hostname '" + this.op2Properties.getClusterHostname() + "'" + this.getSuffixMessageUpdate(row);
            log.debug(msg);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUpdate(Connection con, Logger log) throws SQLException, SQLQueryObjectException {
        Statement pstmt = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addUpdateTable("nodi_runtime");
            sqlQueryObject.addUpdateField("gruppo", "?");
            sqlQueryObject.addUpdateField("data_registrazione", "?");
            sqlQueryObject.addUpdateField("data_refresh", "?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("hostname=?");
            String update = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(update);
            int index = 1;
            pstmt.setString(index++, this.op2Properties.getGroupId(this.rateLimitingGestioneCluster));
            Timestamp now = DateManager.getTimestamp();
            pstmt.setTimestamp(index++, now);
            pstmt.setTimestamp(index++, now);
            pstmt.setString(index++, this.op2Properties.getClusterHostname());
            int row = pstmt.executeUpdate();
            String msg = "Registrato con aggiormanento hostname '" + this.op2Properties.getClusterHostname() + "'" + this.getSuffixMessageUpdate(row);
            log.debug(msg);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIdNumerico(Connection con, Logger log) throws MaxReachedException, SQLException, SQLQueryObjectException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            int idNumerico = -1;
            int max = this.getMax();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addFromTable("nodi_runtime");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addSelectCountField("id_numerico", "countid");
            sqlQueryObject.addSelectMaxField("id_numerico", "maxid");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("gruppo=?");
            String query = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setString(index++, this.op2Properties.getGroupId(this.rateLimitingGestioneCluster));
            rs = pstmt.executeQuery();
            if (rs.next()) {
                int countid = rs.getInt("countid");
                int findId = rs.getInt("maxid");
                if (countid == 0) {
                    idNumerico = 0;
                } else if (findId + 1 <= max) {
                    idNumerico = findId + 1;
                }
            } else {
                idNumerico = 0;
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (idNumerico < 0) {
                try {
                    idNumerico = this.getIdNumerico(con, max);
                }
                catch (MaxReachedException maxReached) {
                    try {
                        this.deleteOldHostnames(con, log);
                    }
                    catch (Exception e) {
                        throw maxReached;
                    }
                    idNumerico = this.getIdNumerico(con, max);
                }
            }
            int n = idNumerico;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private int getMax() {
        int cifre = this.op2Properties.getClusterDinamicoIdNumericoCifre(this.rateLimitingGestioneCluster);
        StringBuilder sbCifre = new StringBuilder();
        for (int i = 0; i < cifre; ++i) {
            sbCifre.append("9");
        }
        return Integer.parseInt(sbCifre.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdNumerico(Connection con, int max) throws MaxReachedException, SQLException, SQLQueryObjectException {
        Statement pstmt = null;
        ResultSet rs = null;
        int idNumerico = -1;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addFromTable("nodi_runtime");
            sqlQueryObject.addSelectField("id_numerico");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("gruppo=?");
            sqlQueryObject.addOrderBy("id_numerico", true);
            String query = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setString(index++, this.op2Properties.getGroupId(this.rateLimitingGestioneCluster));
            rs = pstmt.executeQuery();
            int search = 0;
            while (rs.next()) {
                int idNumericoExists = rs.getInt("id_numerico");
                if (search != idNumericoExists) {
                    idNumerico = search;
                    break;
                }
                if (++search <= max) continue;
                throw new MaxReachedException("Numero massimo di nodi registrabili (" + (max + 1) + ") raggiunto");
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return idNumerico;
    }

    public void unregister(Logger log) throws CoreException {
        this.unregister(log, this.op2Properties.getClusterHostname());
    }

    private void unregister(Logger log, String hostname) throws CoreException {
        Connection con = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.unregister");
            this.unregister(con, log, hostname);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException("[DynamicClusterManager.unregister] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void unregister(Connection con, Logger log, String hostname) throws CoreException {
        Statement pstmt = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addDeleteTable("nodi_runtime");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("hostname=?");
            String query = sqlQueryObject.createSQLDelete();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setString(index++, hostname);
            int row = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            String msg = "Eliminato hostname '" + this.op2Properties.getClusterHostname() + "' dalla tabella 'nodi_runtime' (update-row: " + row + ")";
            log.debug(msg);
        }
        catch (Exception e) {
            throw new CoreException("[DynamicClusterManager.unregister] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void refresh(Logger log) throws CoreException {
        Connection con = null;
        Statement pstmt = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.refresh");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addUpdateTable("nodi_runtime");
            sqlQueryObject.addUpdateField("data_refresh", "?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("hostname=?");
            String update = sqlQueryObject.createSQLUpdate();
            pstmt = con.prepareStatement(update);
            int index = 1;
            Timestamp now = DateManager.getTimestamp();
            pstmt.setTimestamp(index++, now);
            pstmt.setString(index++, this.op2Properties.getClusterHostname());
            int row = pstmt.executeUpdate();
            pstmt.close();
            pstmt = null;
            if (!con.getAutoCommit()) {
                con.commit();
            }
            String msg = "Aggiornato hostname '" + this.op2Properties.getClusterHostname() + "'" + this.getSuffixMessageUpdate(row);
            log.debug(msg);
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException("[DynamicClusterManager.refresh] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteOldHostnames(Logger log) throws CoreException {
        Connection con = null;
        try {
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.deleteOldHostnames");
            this.deleteOldHostnames(con, log);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof CoreException) {
                throw (CoreException)e;
            }
            throw new CoreException("[DynamicClusterManager.deleteOldHostnames] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void deleteOldHostnames(Connection con, Logger log) throws CoreException {
        String gruppo = null;
        String oldData = null;
        try {
            gruppo = this.op2Properties.getGroupId(this.rateLimitingGestioneCluster);
            Timestamp oldest = DynamicClusterManager.getTimestampRefresh(this.op2Properties.getClusterDinamicoRefreshSecondsInterval());
            oldData = DateUtils.getSimpleDateFormatMs().format(oldest);
            List<String> listOldHostnames = DynamicClusterManager.getHostnames(con, this.driverConfigurazioneDB.getTipoDB(), gruppo, oldest, true);
            if (!listOldHostnames.isEmpty()) {
                for (String hostname : listOldHostnames) {
                    this.unregister(con, log, hostname);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException("[DynamicClusterManager.deleteOldHostnames] (groupId:" + gruppo + " oldestDate:" + oldData + ") failed: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getHostnames(Logger log) throws CoreException {
        List<String> list;
        Connection con = null;
        String gruppo = null;
        String oldData = null;
        try {
            gruppo = this.op2Properties.getGroupId(this.rateLimitingGestioneCluster);
            Timestamp oldest = DynamicClusterManager.getTimestampRefresh(this.op2Properties.getClusterDinamicoRefreshSecondsInterval());
            oldData = DateUtils.getSimpleDateFormatMs().format(oldest);
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.refresh");
            List<String> l = DynamicClusterManager.getHostnames(con, this.driverConfigurazioneDB.getTipoDB(), gruppo, oldest, false);
            if (l.isEmpty()) {
                throw new CoreException("nodes not found");
            }
            list = l;
        }
        catch (Exception e) {
            try {
                if (log == null) throw new CoreException("[DynamicClusterManager.getHostnames] (groupId:" + gruppo + " oldestDate:" + oldData + ") failed: " + e.getMessage(), (Throwable)e);
                throw new CoreException("[DynamicClusterManager.getHostnames] (groupId:" + gruppo + " oldestDate:" + oldData + ") failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (con == null) throw throwable;
                    this.driverConfigurazioneDB.releaseConnection(con);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (con == null) return list;
            this.driverConfigurazioneDB.releaseConnection(con);
            return list;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static Timestamp getTimestampRefresh(int refreshSecondsInterval) {
        int oldSeconds = refreshSecondsInterval * 2;
        return new Timestamp(System.currentTimeMillis() - (long)((oldSeconds += refreshSecondsInterval / 2) * 1000));
    }

    public static List<String> getHostnames(Connection con, String tipoDB, String gruppo, int refreshSecondsInterval) throws CoreException {
        Timestamp oldest = DynamicClusterManager.getTimestampRefresh(refreshSecondsInterval);
        return DynamicClusterManager.getHostnames(con, tipoDB, gruppo, oldest, false);
    }

    public static List<String> getHostnames(Connection con, String tipoDB, String gruppo, Timestamp oldest, boolean returnOldHostname) throws CoreException {
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("nodi_runtime");
            sqlQueryObject.addSelectField("hostname");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("gruppo=?");
            if (returnOldHostname) {
                sqlQueryObject.addWhereCondition("data_refresh<?");
            } else {
                sqlQueryObject.addWhereCondition("data_refresh>?");
            }
            sqlQueryObject.addOrderBy("data_refresh", true);
            String update = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(update);
            int index = 1;
            pstmt.setString(index++, gruppo);
            pstmt.setTimestamp(index++, oldest);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String hostname = rs.getString("hostname");
                list.add(hostname);
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new CoreException("[DynamicClusterManager.refresh] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String hashClusterId(String id) {
        return DigestUtils.sha256Hex((String)id);
    }

    public void registerOperation(Logger log, String descrizione, String operazione) throws CoreException {
        Connection con = null;
        Statement pstmt = null;
        try {
            if (descrizione == null) {
                throw new CoreException("Param 'descrizione' undefined");
            }
            if (operazione == null) {
                throw new CoreException("Param 'operazione' undefined");
            }
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.registerOperation");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addInsertTable("nodi_runtime_operations");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("operazione", "?");
            sqlQueryObject.addInsertField("data_registrazione", "?");
            String insert = sqlQueryObject.createSQLInsert();
            pstmt = con.prepareStatement(insert);
            int index = 1;
            pstmt.setString(index++, descrizione);
            pstmt.setString(index++, operazione);
            Timestamp now = DateManager.getTimestamp();
            pstmt.setTimestamp(index++, now);
            int row = pstmt.executeUpdate();
            String msg = "Registrata operazione '" + descrizione + "'" + this.getSuffixMessageUpdate(row);
            log.debug(msg);
            if (!con.getAutoCommit()) {
                con.commit();
            }
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException("[DynamicClusterManager.registerOperation] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<ProxyOperation> findRemoteOperations(Date dataRegistrazione, Date now, int offset, int limit) throws CoreException {
        Connection con = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            this.checkDate(dataRegistrazione, now);
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.findRemoteOperations");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addFromTable("nodi_runtime_operations");
            sqlQueryObject.addSelectField("descrizione");
            sqlQueryObject.addSelectField("operazione");
            sqlQueryObject.addSelectField("data_registrazione");
            sqlQueryObject.addWhereCondition("data_registrazione>=?");
            sqlQueryObject.addWhereCondition("data_registrazione<?");
            boolean asc = true;
            sqlQueryObject.addOrderBy("data_registrazione", asc);
            sqlQueryObject.setANDLogicOperator(true);
            if (offset >= 0) {
                sqlQueryObject.setOffset(offset);
            }
            if (limit > 0) {
                sqlQueryObject.setLimit(limit);
            }
            String query = sqlQueryObject.createSQLQuery();
            ArrayList<ProxyOperation> list = new ArrayList<ProxyOperation>();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setTimestamp(index++, new Timestamp(dataRegistrazione.getTime()));
            pstmt.setTimestamp(index++, new Timestamp(now.getTime()));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(this.readProxyOperation(rs));
            }
            ArrayList<ProxyOperation> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException("[DynamicClusterManager.findRemoteOperations] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }

    private void checkDate(Date dataRegistrazione, Date now) throws CoreException {
        if (dataRegistrazione == null) {
            throw new CoreException("Param 'dataRegistrazione' undefined");
        }
        if (now == null) {
            throw new CoreException("Param 'now' undefined");
        }
    }

    private ProxyOperation readProxyOperation(ResultSet rs) throws SQLException, CoreException {
        if (rs == null) {
            throw new CoreException("Param 'rs' undefined");
        }
        String descrizione = rs.getString("descrizione");
        String operazione = rs.getString("operazione");
        Timestamp dataRegistrazioneReaded = rs.getTimestamp("data_registrazione");
        ProxyOperation po = new ProxyOperation();
        po.setCommand(operazione);
        po.setDescription(descrizione);
        po.setRegistrationTime(dataRegistrazioneReaded);
        return po;
    }

    public int deleteRemoteOperations(Date dataRegistrazione) throws CoreException {
        Connection con = null;
        Statement pstmt = null;
        try {
            if (dataRegistrazione == null) {
                throw new CoreException("Param 'dataRegistrazione' undefined");
            }
            con = this.driverConfigurazioneDB.getConnection("DynamicClusterManager.deleteRemoteOperations");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driverConfigurazioneDB.getTipoDB());
            sqlQueryObject.addDeleteTable("nodi_runtime_operations");
            sqlQueryObject.addWhereCondition("data_registrazione<?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLDelete();
            pstmt = con.prepareStatement(query);
            int index = 1;
            pstmt.setTimestamp(index++, new Timestamp(dataRegistrazione.getTime()));
            int n = pstmt.executeUpdate();
            return n;
        }
        catch (Exception e) {
            try {
                if (con != null && !con.getAutoCommit()) {
                    con.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CoreException("[DynamicClusterManager.deleteRemoteOperations] failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (con != null) {
                    this.driverConfigurazioneDB.releaseConnection(con);
                }
            }
            catch (Exception exception) {}
        }
    }
}

