/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.pdd.config.PddInstanceProperties;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class PddProperties {
    private Logger log = OpenSPCoop2Startup.initialize ? OpenSPCoop2Logger.getLoggerOpenSPCoopCore() : LoggerWrapperFactory.getLogger(PddProperties.class);
    private PddInstanceProperties reader;
    private static PddProperties pddProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PddProperties(String location, String confDir) throws UtilsException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = location != null ? new FileInputStream(location) : PddProperties.class.getResourceAsStream("/govway.pdd.properties");
            if (properties == null) {
                throw new UtilsException("File '/govway.pdd.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.doError(e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new PddInstanceProperties(propertiesReader, this.log, confDir);
    }

    private void doError(Exception e) throws UtilsException {
        this.log.error("Riscontrato errore durante la lettura del file 'govway.pdd.properties': " + e.getMessage(), (Throwable)e);
        throw new UtilsException("PddProperties initialize error: " + e.getMessage(), (Throwable)e);
    }

    public static boolean initialize(String location, String confDir) {
        try {
            pddProperties = new PddProperties(location, confDir);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static PddProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (pddProperties == null) {
            Class<PddProperties> clazz = PddProperties.class;
            synchronized (PddProperties.class) {
                throw new OpenSPCoop2ConfigurationException("PddProperties non inizializzato");
            }
        }
        return pddProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        PddProperties.pddProperties.reader.setLocalObjectImplementation(prop);
    }

    public String getValidazioneBuste_Stato(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.stato");
    }

    public String getValidazioneBuste_Controllo(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.controllo");
    }

    public String getValidazioneBuste_ProfiloCollaborazione(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.profiloCollaborazione");
    }

    public String getValidazioneBuste_ManifestAttachments(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.manifestAttachments");
    }

    public String getValidazione_FiltroDuplicatiLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.filtroDuplicati.letturaRegistro");
    }

    public String getValidazione_ConfermaRicezioneLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.confermaRicezione.letturaRegistro");
    }

    public String getValidazione_ConsegnaInOrdineLetturaRegistro(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.consegnaInOrdine.letturaRegistro");
    }

    public String getValidazione_readQualifiedAttribute(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.readQualifiedAttribute");
    }

    public String getValidazione_ValidazioneIDBustaCompleta(String nomePdd) {
        return this.get(nomePdd, ".validazioneBuste.validazioneIDBustaCompleta");
    }

    public String getBusta_TempoTipo(String nomePdd) {
        return this.get(nomePdd, ".busta.tempo.tipo");
    }

    public String getBusta_AsincroniAttributiCorrelatiEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.asincroni.attributiCorrelati.enable");
    }

    public String getBusta_CollaborazioneEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.collaborazione.enable");
    }

    public String getBusta_IdRiferimentoRichiestaEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.idRiferimentoRichiesta.enable");
    }

    public String getBusta_ConsegnaInOrdineEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.consegnaInOrdine.enable");
    }

    public String getBusta_TrasmissioneEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.trasmissione.enable");
    }

    public String getBusta_RiscontriEnable(String nomePdd) {
        return this.get(nomePdd, ".busta.riscontri.enable");
    }

    public String getBusta_FiltroduplicatiGenerazioneBustaErrore(String nomePdd) {
        return this.get(nomePdd, ".busta.filtroduplicati.generazioneBustaErrore");
    }

    public String getValidazioneContenutiApplicativi_Stato(String nomePdd) {
        return this.get(nomePdd, ".validazioneContenutiApplicativi.stato");
    }

    public String getValidazioneContenutiApplicativi_Tipo(String nomePdd) {
        return this.get(nomePdd, ".validazioneContenutiApplicativi.tipo");
    }

    public String getValidazioneContenutiApplicativi_AcceptMtomMessage(String nomePdd) {
        return this.get(nomePdd, ".validazioneContenutiApplicativi.acceptMtomMessage");
    }

    public String getMessageSecurity_ActorDefaultEnable(String nomePdd) {
        return this.get(nomePdd, ".messageSecurity.actorDefault.enable");
    }

    public String getMessageSecurity_ActorDefaultValue(String nomePdd) {
        return this.get(nomePdd, ".messageSecurity.actorDefault.valore");
    }

    private String get(String nomePdd, String proprieta) {
        try {
            return this.reader.getValue(nomePdd + proprieta);
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura della proprieta' '" + nomePdd + proprieta + "': " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

