/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.SoggettoVirtualeServizioApplicativo;
import org.openspcoop2.pdd.core.GestoreMessaggi;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.behaviour.Behaviour;
import org.openspcoop2.pdd.core.behaviour.BehaviourForwardToFilter;
import org.openspcoop2.pdd.core.behaviour.BehaviourLoader;
import org.openspcoop2.pdd.core.behaviour.IBehaviour;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;

public class SoggettoVirtuale
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SoggettoVirtualeServizioApplicativo> soggettoVirtuale_serviziApplicativi = new ArrayList<SoggettoVirtualeServizioApplicativo>();
    private int count = 0;

    public synchronized void addServizioApplicativo(SoggettoVirtualeServizioApplicativo sa) {
        ++this.count;
        sa.setId("SoggettoVirtuale-SA-" + this.count);
        this.soggettoVirtuale_serviziApplicativi.add(sa);
    }

    public List<IDSoggetto> getSoggettiRealiSenzaDuplicati() {
        ArrayList<IDSoggetto> list = new ArrayList<IDSoggetto>();
        for (SoggettoVirtualeServizioApplicativo sa : this.soggettoVirtuale_serviziApplicativi) {
            boolean find = false;
            for (IDSoggetto giaTrovato : list) {
                if (!sa.getIdSoggettoReale().getTipo().equals(giaTrovato.getTipo()) || !sa.getIdSoggettoReale().getNome().equals(giaTrovato.getNome())) continue;
                find = true;
                break;
            }
            if (find) continue;
            list.add(sa.getIdSoggettoReale());
        }
        return list;
    }

    public List<String> getIdServiziApplicativi(boolean gestisciBehaviuorPerFiltri, GestoreMessaggi gestoreMessaggi, Busta busta, RequestInfo requestInfo, PdDContext pddContext, IProtocolFactory<?> protocolFactory, IState state) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (SoggettoVirtualeServizioApplicativo sa : this.soggettoVirtuale_serviziApplicativi) {
            boolean filtrato = false;
            if (gestisciBehaviuorPerFiltri && sa.getPortaApplicativa().getBehaviour() != null && sa.getPortaApplicativa().getBehaviour().getNome() != null) {
                BehaviourForwardToFilter filter;
                IBehaviour behaviourImpl = BehaviourLoader.newInstance(sa.getPortaApplicativa().getBehaviour(), null, pddContext, protocolFactory, state);
                Busta bustaConSoggettiReali = busta.newInstance();
                bustaConSoggettiReali.setMittente(busta.getDestinatario());
                bustaConSoggettiReali.setTipoMittente(busta.getTipoDestinatario());
                bustaConSoggettiReali.setDestinatario(sa.getIdSoggettoReale().getNome());
                bustaConSoggettiReali.setTipoDestinatario(sa.getIdSoggettoReale().getTipo());
                Behaviour behaviour = behaviourImpl.behaviour(gestoreMessaggi, bustaConSoggettiReali, sa.getPortaApplicativa(), requestInfo);
                if (behaviour != null && behaviour.getForwardTo() != null && behaviour.getForwardTo().size() == 1 && (filter = behaviour.getForwardTo().get(0).getFilter()) != null) {
                    ArrayList<IDServizioApplicativo> saAttuale = new ArrayList<IDServizioApplicativo>();
                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                    idSA.setIdSoggettoProprietario(sa.getIdSoggettoReale());
                    idSA.setNome(sa.getNomeServizioApplicativo());
                    saAttuale.add(idSA);
                    List<IDServizioApplicativo> saFiltrato = filter.aggiornaDestinatariAbilitati(saAttuale);
                    if (saFiltrato.size() <= 0) {
                        filtrato = true;
                    }
                }
            }
            if (filtrato) continue;
            list.add(sa.getId());
        }
        return list;
    }

    public String getNomeServizioApplicativo(String idServizioApplicativo) {
        for (SoggettoVirtualeServizioApplicativo sa : this.soggettoVirtuale_serviziApplicativi) {
            if (!sa.getId().equals(idServizioApplicativo)) continue;
            return sa.getNomeServizioApplicativo();
        }
        return null;
    }

    public IDSoggetto getSoggettoReale(String idServizioApplicativo) {
        for (SoggettoVirtualeServizioApplicativo sa : this.soggettoVirtuale_serviziApplicativi) {
            if (!sa.getId().equals(idServizioApplicativo)) continue;
            return sa.getIdSoggettoReale();
        }
        return null;
    }

    public IDPortaApplicativa getIDPortaApplicativa(String idServizioApplicativo) {
        for (SoggettoVirtualeServizioApplicativo sa : this.soggettoVirtuale_serviziApplicativi) {
            if (!sa.getId().equals(idServizioApplicativo)) continue;
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(sa.getPortaApplicativa().getNome());
            return idPA;
        }
        return null;
    }
}

