/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.slf4j.Logger;

public class SystemPropertiesManager {
    public static final String SYSTEM_PROPERTIES = "OpenSPCoop2SystemProperties";
    private ConfigurazionePdDManager configPdDManager;
    private Logger log;

    private void logInfo(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    public SystemPropertiesManager(ConfigurazionePdDManager configPdDManager, Logger log) {
        this.configPdDManager = configPdDManager;
        this.log = log;
    }

    private String getPrefixKey(String key) {
        return "Property[" + key + "] ";
    }

    public void updateSystemProperties() throws DriverConfigurazioneException {
        String oldProperties = System.getProperty(SYSTEM_PROPERTIES);
        if (oldProperties != null && oldProperties.length() > 0) {
            this.logInfo("Remove old properties: [" + oldProperties + "]");
            String[] names = oldProperties.split(",");
            for (int i = 0; i < names.length; ++i) {
                this.logInfo("RemoveProperty [" + names[i] + "]");
                System.clearProperty(names[i]);
            }
        }
        System.clearProperty(SYSTEM_PROPERTIES);
        SystemProperties sps = this.configPdDManager.getSystemPropertiesPdD();
        if (sps != null && sps.sizeSystemPropertyList() > 0) {
            StringBuilder bf = new StringBuilder();
            for (int i = 0; i < sps.sizeSystemPropertyList(); ++i) {
                Property sp = sps.getSystemProperty(i);
                String nome = sp.getNome();
                String valore = sp.getValore();
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(nome);
                this.logInfo("SetProperty [" + nome + "]=[" + valore + "]");
                System.setProperty(nome, valore);
            }
            this.logInfo("SetStoricoProperty [OpenSPCoop2SystemProperties]=[" + bf.toString() + "]");
            System.setProperty(SYSTEM_PROPERTIES, bf.toString());
        } else {
            this.logInfo("Non sono state rilevate propriet\u00e0 di sistema da impostare");
        }
    }

    public String getPropertyValue(String key) {
        return System.getProperty(key);
    }

    public String readAllSystemProperties(String separator) {
        return this.readAllSystemProperties(separator, false);
    }

    private String readAllSystemProperties(String separator, boolean onlyOpenSPCoop2) {
        Properties p = System.getProperties();
        if (p != null) {
            StringBuilder bf = new StringBuilder();
            Enumeration<Object> keys = p.keys();
            ArrayList<String> listKeys = new ArrayList<String>();
            while (keys.hasMoreElements()) {
                Object object = keys.nextElement();
                if (!(object instanceof String)) continue;
                listKeys.add((String)object);
            }
            Collections.sort(listKeys);
            this.addSystemProperties(p, listKeys, separator, onlyOpenSPCoop2, bf);
            return bf.toString();
        }
        return null;
    }

    private void addSystemProperties(Properties p, ArrayList<String> listKeys, String separator, boolean onlyOpenSPCoop2, StringBuilder bf) {
        for (int i = 0; i < listKeys.size(); ++i) {
            String key = listKeys.get(i);
            boolean isOpenSPCoop2SystemProperty = this.isOpenSPCoop2SystemProperty(key);
            if (!isOpenSPCoop2SystemProperty && onlyOpenSPCoop2) continue;
            if (bf.length() > 0) {
                bf.append(separator);
            }
            bf.append("[" + key + "]=[" + p.getProperty(key) + "]");
        }
    }

    private boolean isOpenSPCoop2SystemProperty(String key) {
        boolean isOpenSPCoop2SystemProperty = false;
        String oldProperties = System.getProperty(SYSTEM_PROPERTIES);
        if (oldProperties != null && oldProperties.length() > 0) {
            String[] names = oldProperties.split(",");
            for (int j = 0; j < names.length; ++j) {
                if (!key.equals(names[j])) continue;
                isOpenSPCoop2SystemProperty = true;
                break;
            }
        }
        return isOpenSPCoop2SystemProperty;
    }

    public String readOpenSPCoop2SystemProperties(String separator) {
        return this.readAllSystemProperties(separator, true);
    }

    public void removeProperty(String key) throws OpenSPCoop2ConfigurationException {
        if (!System.getProperties().containsKey(key)) {
            throw new OpenSPCoop2ConfigurationException(this.getPrefixKey(key) + "not found");
        }
        System.clearProperty(key);
        String oldProperties = System.getProperty(SYSTEM_PROPERTIES);
        StringBuilder bf = new StringBuilder();
        if (oldProperties != null && oldProperties.length() > 0) {
            String[] names = oldProperties.split(",");
            for (int j = 0; j < names.length; ++j) {
                if (key.equals(names[j])) continue;
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(names[j]);
            }
            System.clearProperty(SYSTEM_PROPERTIES);
            System.setProperty(SYSTEM_PROPERTIES, bf.toString());
        }
    }

    public void updateProperty(String key, String value) throws OpenSPCoop2ConfigurationException {
        if (!System.getProperties().containsKey(key)) {
            throw new OpenSPCoop2ConfigurationException(this.getPrefixKey(key) + "not found");
        }
        System.clearProperty(key);
        System.setProperty(key, value);
    }

    public void insertProperty(String key, String value) throws OpenSPCoop2ConfigurationException {
        if (System.getProperties().containsKey(key)) {
            throw new OpenSPCoop2ConfigurationException(this.getPrefixKey(key) + "already exists (actual value: " + System.getProperties().getProperty(key) + ")");
        }
        System.setProperty(key, value);
        Object props = System.getProperty(SYSTEM_PROPERTIES);
        props = props != null && ((String)props).length() > 0 ? (String)props + "," + key : key;
        System.clearProperty(SYSTEM_PROPERTIES);
        System.setProperty(SYSTEM_PROPERTIES, (String)props);
    }
}

