/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.util.ArrayList;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.autorizzazione.canali.CanaliUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.Utilities;

public class UrlInvocazioneAPIUtils {
    private UrlInvocazioneAPIUtils() {
    }

    public static UrlInvocazioneAPI getUrlInvocazioneObject(IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo, boolean rest, AccordoServizioParteComune aspc, RuoloContesto ruoloContesto, String nomePorta, IDSoggetto proprietarioPorta) throws ProtocolException {
        try {
            ArrayList<String> tags = new ArrayList<String>();
            if (aspc != null && aspc.getGruppi() != null && aspc.getGruppi().sizeGruppoList() > 0) {
                for (int i = 0; i < aspc.getGruppi().sizeGruppoList(); ++i) {
                    tags.add(aspc.getGruppi().getGruppo(i).getNome());
                }
            }
            IConfigIntegrationReader configReader = protocolFactory.getCachedConfigIntegrationReader(state, requestInfo);
            CanaliConfigurazione canaliConfigurazione = configReader.getCanaliConfigurazione();
            String canaleApi = null;
            if (aspc != null) {
                canaleApi = aspc.getCanale();
            }
            String canalePorta = null;
            if (nomePorta != null) {
                canalePorta = RuoloContesto.PORTA_APPLICATIVA.equals((Object)ruoloContesto) ? UrlInvocazioneAPIUtils.getCanalePortaPA(nomePorta, configReader) : UrlInvocazioneAPIUtils.getCanalePortaPD(nomePorta, configReader);
            }
            String canale = CanaliUtils.getCanale(canaliConfigurazione, canaleApi, canalePorta);
            return ConfigurazionePdDManager.getInstance().getConfigurazioneUrlInvocazione(protocolFactory, ruoloContesto, rest ? ServiceBinding.REST : ServiceBinding.SOAP, nomePorta, proprietarioPorta, tags, canale, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), (Throwable)e);
        }
    }

    private static String getCanalePortaPA(String nomePorta, IConfigIntegrationReader configReader) {
        try {
            IDPortaApplicativa idPA = new IDPortaApplicativa();
            idPA.setNome(nomePorta);
            PortaApplicativa pa = configReader.getPortaApplicativa(idPA);
            return pa.getCanale();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getCanalePortaPD(String nomePorta, IConfigIntegrationReader configReader) {
        try {
            IDPortaDelegata idPD = new IDPortaDelegata();
            idPD.setNome(nomePorta);
            PortaDelegata pd = configReader.getPortaDelegata(idPD);
            return pd.getCanale();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getUrlInvocazione(IProtocolFactory<?> protocolFactory, IState state, RequestInfo requestInfo, boolean rest, AccordoServizioParteComune aspc, RuoloContesto ruoloContesto, String nomePorta, IDSoggetto proprietarioPorta) throws ProtocolException {
        UrlInvocazioneAPI urlInvocazioneApi = UrlInvocazioneAPIUtils.getUrlInvocazioneObject(protocolFactory, state, requestInfo, rest, aspc, ruoloContesto, nomePorta, proprietarioPorta);
        String prefixGatewayUrl = urlInvocazioneApi.getBaseUrl();
        String contesto = urlInvocazioneApi.getContext();
        return Utilities.buildUrl((String)prefixGatewayUrl, (String)contesto);
    }
}

