/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.IOException;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.utils.transport.http.AbstractCORSFilter;
import org.openspcoop2.utils.transport.http.CORSFilterConfiguration;
import org.slf4j.Logger;

public class CORSFilter
extends AbstractCORSFilter {
    private CORSFilterConfiguration config;
    private Logger log;

    protected CORSFilterConfiguration getConfig() throws IOException {
        return this.config;
    }

    protected Logger getLog() {
        return this.log;
    }

    public CORSFilter(Logger log, CorsConfigurazione config) {
        this.log = log;
        this.config = CORSFilter.toCORSFilterConfiguration(config);
    }

    private static CORSFilterConfiguration toCORSFilterConfiguration(CorsConfigurazione config) {
        CORSFilterConfiguration cors = new CORSFilterConfiguration();
        cors.setAllowCredentials(Boolean.valueOf(StatoFunzionalita.ABILITATO.equals((Object)config.getAccessControlAllowCredentials())));
        cors.setAllowRequestHeader(Boolean.valueOf(StatoFunzionalita.ABILITATO.equals((Object)config.getAccessControlAllAllowHeaders())));
        if (!(cors.getAllowRequestHeader() != null && cors.getAllowRequestHeader().booleanValue() || config.getAccessControlAllowHeaders() == null || config.getAccessControlAllowHeaders().sizeHeaderList() <= 0)) {
            for (String header : config.getAccessControlAllowHeaders().getHeaderList()) {
                cors.addAllowHeader(header);
            }
        }
        cors.setAllowRequestMethod(Boolean.valueOf(StatoFunzionalita.ABILITATO.equals((Object)config.getAccessControlAllAllowMethods())));
        if (!(cors.getAllowRequestMethod() != null && cors.getAllowRequestMethod().booleanValue() || config.getAccessControlAllowMethods() == null || config.getAccessControlAllowMethods().sizeMethodList() <= 0)) {
            for (String method : config.getAccessControlAllowMethods().getMethodList()) {
                cors.addAllowMethod(method);
            }
        }
        cors.setAllowAllOrigin(Boolean.valueOf(StatoFunzionalita.ABILITATO.equals((Object)config.getAccessControlAllAllowOrigins())));
        if (!cors.getAllowAllOrigin().booleanValue() && config.getAccessControlAllowOrigins() != null && config.getAccessControlAllowOrigins().sizeOriginList() > 0) {
            for (String origin : config.getAccessControlAllowOrigins().getOriginList()) {
                cors.addAllowOrigin(origin);
            }
        }
        if (config.getAccessControlExposeHeaders() != null && config.getAccessControlExposeHeaders().sizeHeaderList() > 0) {
            for (String header : config.getAccessControlExposeHeaders().getHeaderList()) {
                cors.addExposeHeader(header);
            }
        }
        if (config.getAccessControlMaxAge() != null) {
            if (config.getAccessControlMaxAge() <= 0) {
                cors.setCachingAccessControl_disable(Boolean.valueOf(true));
            } else {
                cors.setCachingAccessControl_maxAgeSeconds(config.getAccessControlMaxAge());
            }
        }
        return cors;
    }
}

