/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.JMSObject;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.config.Resource;
import org.slf4j.Logger;

public class JMSSender {
    private QueueManager qmanager;
    private String idModulo = null;
    private IDSoggetto codicePorta = null;
    private String errore;
    private Exception exception;
    private Logger log;
    private String idTransazione;

    public JMSSender(IDSoggetto aCodicePorta, String aIDModulo, Logger log, String idTransazione) throws Exception {
        this.codicePorta = aCodicePorta;
        this.idModulo = "JMSSender." + aIDModulo;
        this.qmanager = QueueManager.getInstance();
        this.log = log;
        this.idTransazione = idTransazione;
    }

    public boolean send(String destinatario, Serializable objectToSend, String idBusta) {
        Properties prop = new Properties();
        prop.put("ID", idBusta);
        return this.send(destinatario, objectToSend, prop);
    }

    public boolean send(String destinatario, Serializable objectToSend, Properties properties) {
        Resource resource = null;
        MessageProducer sender = null;
        try {
            if (destinatario == null) {
                return true;
            }
            JMSObject jmsObject = null;
            try {
                resource = this.qmanager.getResource(this.codicePorta, this.idModulo, this.idTransazione);
                if (resource == null) {
                    throw new JMSException("Resource is null");
                }
                if (resource.getResource() == null) {
                    throw new JMSException("JMSObject is null");
                }
                jmsObject = (JMSObject)resource.getResource();
                if (jmsObject.getConnection() == null) {
                    throw new Exception("Connessione is null");
                }
                if (jmsObject.getSession() == null) {
                    throw new Exception("Sessione is null");
                }
            }
            catch (Exception e) {
                this.log.error("JMSObject non ottenibile dal Pool: " + e.getMessage(), (Throwable)e);
                this.errore = "JMSObject non ottenibile dal Pool: " + e.getMessage();
                this.exception = e;
                return false;
            }
            Queue queue = this.qmanager.getQueue(destinatario);
            if (queue == null) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.errore = "La coda [" + destinatario + "] non e' tra quelle registrate per OpenSPCoop";
                return false;
            }
            try {
                sender = jmsObject.getSession().createProducer((Destination)queue);
            }
            catch (JMSException e) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.log.error("Riscontrato errore durante la creazione del sender [" + destinatario + "] :" + e.getMessage(), (Throwable)e);
                this.errore = "Riscontrato errore durante la creazione del sender [" + destinatario + "] :" + e.getMessage();
                this.exception = e;
                return false;
            }
            ObjectMessage message = jmsObject.getSession().createObjectMessage(objectToSend);
            Enumeration<?> en = properties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = properties.getProperty(key);
                if ("true".equalsIgnoreCase(value)) {
                    message.setBooleanProperty(key, true);
                    continue;
                }
                if ("false".equalsIgnoreCase(value)) {
                    message.setBooleanProperty(key, false);
                    continue;
                }
                Long testLong = null;
                try {
                    testLong = Long.valueOf(value);
                }
                catch (Exception e) {
                    testLong = null;
                }
                if (testLong != null) {
                    message.setLongProperty(key, testLong.longValue());
                    continue;
                }
                message.setStringProperty(key, value);
            }
            sender.send((Message)message);
            sender.close();
            this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
            return true;
        }
        catch (Exception e) {
            try {
                if (sender != null) {
                    sender.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resource != null) {
                try {
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.log.error("Riscontrato errore durante la creazione/spedizione dell'oggetto :" + e.getMessage(), (Throwable)e);
            this.errore = "Riscontrato errore durante la creazione/spedizione dell'oggetto :" + e.getMessage();
            this.exception = e;
            return false;
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public Exception getException() {
        return this.exception;
    }
}

