/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.util.List;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.WSDLValidator;
import org.openspcoop2.core.registry.wsdl.WSDLValidatorConfig;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiException;
import org.openspcoop2.pdd.core.ValidatoreMessaggiApplicativiRest;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.ErroriProperties;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.wsdl.WSDLException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;

public class ValidatoreMessaggiApplicativi {
    private RegistroServiziManager registroServiziManager;
    private IDServizio idServizio;
    private OpenSPCoop2Message message;
    private AccordoServizioWrapper accordoServizioWrapper;
    private Logger logger;
    private MessageXMLUtils xmlUtils;
    private WSDLValidator wsdlValidator;
    private boolean rpcAcceptRootElementUnqualified;
    private boolean validateSoapAction;
    private boolean bufferMessage_readOnly;
    private PdDContext pddContext;
    private RequestInfo requestInfo;

    public static String getTipo(ValidazioneContenutiApplicativi validazioneContenutoApplicativoApplicativo) {
        Object tipo = validazioneContenutoApplicativoApplicativo.getTipo().getValue();
        if (validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage() != null) {
            if (StatoFunzionalita.ABILITATO.equals((Object)validazioneContenutoApplicativoApplicativo.getAcceptMtomMessage())) {
                tipo = (String)tipo + "-mtom/xop";
            }
            if (CostantiConfigurazione.STATO_CON_WARNING_WARNING_ONLY.equals((Object)validazioneContenutoApplicativoApplicativo.getStato())) {
                tipo = (String)tipo + "-warningOnly";
            }
        }
        return tipo;
    }

    public static String processValidationErrorMessage(String errorMsg, OpenSPCoop2Properties op2Properties) {
        boolean truncate = false;
        int first = -1;
        int last = -1;
        try {
            if (op2Properties != null && op2Properties.isValidazioneContenutiApplicativiErroreTroncaturaEnabled()) {
                first = op2Properties.getValidazioneContenutiApplicativiErroreTroncaturaCaratteriInizio();
                last = op2Properties.getValidazioneContenutiApplicativiErroreTroncaturaCaratteriFine();
                truncate = first > 0 && last > 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Utilities.sanitizeAndTruncate((String)errorMsg, (boolean)true, (boolean)truncate, (int)first, (int)last);
    }

    public boolean isServizioCorrelato() {
        try {
            return TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio());
        }
        catch (Exception e) {
            return false;
        }
    }

    public ValidatoreMessaggiApplicativi(RegistroServiziManager registro, IDServizio idServizio, OpenSPCoop2Message message, boolean readWSDLAccordoServizio, boolean gestioneXsiType_rpcLiteral, List<Proprieta> proprieta, PdDContext pddContext) throws ValidatoreMessaggiApplicativiException {
        boolean hasContent;
        block22: {
            this.accordoServizioWrapper = null;
            this.logger = null;
            this.xmlUtils = null;
            this.wsdlValidator = null;
            this.validateSoapAction = true;
            this.bufferMessage_readOnly = true;
            if (registro == null) {
                ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Reader del Registro dei Servizi non fornito");
                ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
                throw ex;
            }
            if (idServizio == null || idServizio.getSoggettoErogatore() == null || idServizio.getTipo() == null || idServizio.getNome() == null || idServizio.getVersione() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
                ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("ID del servizio da validare, non fornito");
                ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
                throw ex;
            }
            this.message = message;
            hasContent = false;
            try {
                if (ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                    OpenSPCoop2SoapMessage soapMessage = this.message.castAsSoap();
                    boolean bl = hasContent = !soapMessage.isSOAPBodyEmpty();
                    if (!hasContent) {
                        ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("SOAPBody non esistente");
                        ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
                        throw ex;
                    }
                    break block22;
                }
                if (MessageType.XML.equals((Object)this.message.getMessageType())) {
                    OpenSPCoop2RestXmlMessage xml = this.message.castAsRestXml();
                    hasContent = xml.hasContent();
                    break block22;
                }
                throw new Exception("Funzionalit\u00e0 non supportata con ServiceBinding REST e tipologia di messaggio [" + String.valueOf(this.message.getMessageType()) + "]");
            }
            catch (ValidatoreMessaggiApplicativiException e) {
                throw e;
            }
            catch (Exception e) {
                ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage(), e);
                ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
                throw ex;
            }
        }
        if (!hasContent) {
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Contenuto da validare non esistente");
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
            throw ex;
        }
        this.registroServiziManager = registro;
        this.idServizio = idServizio;
        this.logger = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.message.getFactory());
        this.pddContext = pddContext;
        if (this.pddContext != null && this.pddContext.containsKey(Costanti.REQUEST_INFO)) {
            this.requestInfo = (RequestInfo)this.pddContext.getObject(Costanti.REQUEST_INFO);
        }
        try {
            this.accordoServizioWrapper = readWSDLAccordoServizio ? this.registroServiziManager.getWsdlAccordoServizio(idServizio, InformationApiSource.SPECIFIC, true, false, this.requestInfo) : this.registroServiziManager.getWsdlAccordoServizio(idServizio, InformationApiSource.REGISTRY, true, true, this.requestInfo);
        }
        catch (DriverRegistroServiziNotFound e) {
            this.logger.error("Riscontrato errore durante la ricerca dei wsdl/xsd che definiscono l'accordo di servizio: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante la ricerca del Wsdl: " + e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_405_SERVIZIO_NON_TROVATO.getErroreIntegrazione());
            throw ex;
        }
        catch (DriverRegistroServiziException e) {
            this.logger.error("Riscontrato errore durante l'inizializzazione: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException("Riscontrato errore durante l'inizializzazione: " + e.getMessage(), e);
            if (e.getMessage() != null && e.getMessage().startsWith("[SchemaXSD]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita("Schema xsd dei messaggi"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-FRUITORE]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita("Wsdl fruitore"));
                throw ex;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("[WSDL-EROGATORE]")) {
                ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita("Wsdl erogatore"));
                throw ex;
            }
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_530_COSTRUZIONE_INTERFACCIA_FALLITA));
            throw ex;
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        this.bufferMessage_readOnly = op2Properties.isValidazioneContenutiApplicativiBufferContentRead();
        if (proprieta != null && !proprieta.isEmpty()) {
            boolean defaultBehaviour = this.bufferMessage_readOnly;
            this.bufferMessage_readOnly = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.buffer.enabled", defaultBehaviour);
        }
        this.rpcAcceptRootElementUnqualified = op2Properties.isValidazioneContenutiApplicativiRpcAcceptRootElementUnqualified();
        if (proprieta != null && !proprieta.isEmpty()) {
            boolean default_rpcAcceptRootElementUnqualified = this.rpcAcceptRootElementUnqualified;
            this.rpcAcceptRootElementUnqualified = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.rpc.rootElementUnqualified.accept", default_rpcAcceptRootElementUnqualified);
        }
        try {
            String idTransazione = null;
            if (this.pddContext != null) {
                idTransazione = (String)this.pddContext.getObject(Costanti.ID_TRANSAZIONE);
            }
            boolean addPrefixError = false;
            WSDLValidatorConfig config = new WSDLValidatorConfig();
            config.setGestioneXsiTypeRpcLiteral(gestioneXsiType_rpcLiteral);
            config.setRpcAcceptRootElementUnqualified(this.rpcAcceptRootElementUnqualified);
            config.setValidationXsdAddNamespaceXSITypeIfNotExists(op2Properties.isValidazioneContenutiApplicativiXsdAddNamespaceXSITypeIfNotExists());
            config.setValidationRpcAddNamespaceXSITypeIfNotExists(op2Properties.isValidazioneContenutiApplicativiRpcAddNamespaceXSITypeIfNotExists());
            config.setValidationDocumentAddNamespaceXSITypeIfNotExists(op2Properties.isValidazioneContenutiApplicativiDocumentAddNamespaceXSITypeIfNotExists());
            this.wsdlValidator = new WSDLValidator(this.message, (AbstractXMLUtils)this.xmlUtils, this.accordoServizioWrapper, this.logger, config, addPrefixError, this.bufferMessage_readOnly, idTransazione);
        }
        catch (Exception e) {
            this.logger.error("WSDLValidator initialized failed: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_531_VALIDAZIONE_TRAMITE_INTERFACCIA_FALLITA));
            throw ex;
        }
        this.validateSoapAction = op2Properties.isValidazioneContenutiApplicativiCheckSoapAction();
        if (proprieta != null && !proprieta.isEmpty()) {
            boolean defaultSoapAction = this.validateSoapAction;
            this.validateSoapAction = ValidatoreMessaggiApplicativiRest.readBooleanValueWithDefault(proprieta, "validation.soapAction.enabled", defaultSoapAction);
        }
    }

    public AccordoServizioWrapper getAccordoServizioWrapper() {
        return this.accordoServizioWrapper;
    }

    public void validateWithWsdlDefinitorio(boolean isRichiesta) throws ValidatoreMessaggiApplicativiException {
        try {
            this.wsdlValidator.validateAgainstXSDSchema(isRichiesta, this.idServizio.getAzione());
        }
        catch (WSDLException e) {
            this.logger.error("WSDL validate failed: " + e.getMessage(), (Throwable)e);
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException(e.getMessage(), e);
            ex.setErrore(ErroriIntegrazione.ERRORE_417_COSTRUZIONE_VALIDATORE_TRAMITE_INTERFACCIA_FALLITA.getErrore417_CostruzioneValidatoreTramiteInterfacciaFallita("Schema xsd dei messaggi"));
            throw ex;
        }
        catch (Exception e) {
            Object messaggioErrore = e.getMessage();
            boolean overwriteMessageError = false;
            try {
                messaggioErrore = ErroriProperties.getInstance((Logger)this.logger).getGenericDetails_noWrap(isRichiesta ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INVALID_RESPONSE_CONTENT);
                messaggioErrore = (String)messaggioErrore + ": " + ValidatoreMessaggiApplicativi.processValidationErrorMessage(e.getMessage(), OpenSPCoop2Properties.getInstance());
                overwriteMessageError = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException((String)messaggioErrore, e);
            if (isRichiesta) {
                ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Schema xsd dei messaggi", (String)messaggioErrore, overwriteMessageError));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Schema xsd dei messaggi", (String)messaggioErrore, overwriteMessageError));
            }
            throw ex;
        }
    }

    public void validateWithWsdlLogicoImplementativo(boolean isRichiesta) throws ValidatoreMessaggiApplicativiException {
        try {
            if (!ServiceBinding.SOAP.equals((Object)this.message.getServiceBinding())) {
                throw new Exception("Tipo di validazione non supportata con Service Binding REST");
            }
            this.wsdlValidator.wsdlConformanceCheck(isRichiesta, this.message.castAsSoap().getSoapAction(), this.idServizio.getAzione(), this.validateSoapAction, false);
        }
        catch (Exception e) {
            Object messaggioErrore = e.getMessage();
            boolean overwriteMessageError = false;
            try {
                messaggioErrore = ErroriProperties.getInstance((Logger)this.logger).getGenericDetails_noWrap(isRichiesta ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INVALID_RESPONSE_CONTENT);
                String processedErrorMsg = ValidatoreMessaggiApplicativi.processValidationErrorMessage(e.getMessage(), OpenSPCoop2Properties.getInstance());
                messaggioErrore = TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio()) ? (String)messaggioErrore + " 'response service': " + processedErrorMsg : (String)messaggioErrore + ": " + processedErrorMsg;
                overwriteMessageError = true;
            }
            catch (Exception processedErrorMsg) {
                // empty catch block
            }
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException((String)messaggioErrore, e);
            if (isRichiesta) {
                if (TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio())) {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Wsdl fruitore", (String)messaggioErrore, overwriteMessageError));
                } else {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Wsdl erogatore", (String)messaggioErrore, overwriteMessageError));
                }
            } else if (TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio())) {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Wsdl fruitore", (String)messaggioErrore, overwriteMessageError));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Wsdl erogatore", (String)messaggioErrore, overwriteMessageError));
            }
            throw ex;
        }
    }

    public void restoreOriginalDocument(boolean isRichiesta) throws ValidatoreMessaggiApplicativiException {
        try {
            this.wsdlValidator.wsdlConformanceCheck_restoreOriginalDocument();
        }
        catch (Exception e) {
            Object messaggioErrore = e.getMessage();
            boolean overwriteMessageError = false;
            try {
                messaggioErrore = ErroriProperties.getInstance((Logger)this.logger).getGenericDetails_noWrap(isRichiesta ? IntegrationFunctionError.INVALID_REQUEST_CONTENT : IntegrationFunctionError.INVALID_RESPONSE_CONTENT);
                String processedErrorMsg = ValidatoreMessaggiApplicativi.processValidationErrorMessage(e.getMessage(), OpenSPCoop2Properties.getInstance());
                messaggioErrore = TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio()) ? (String)messaggioErrore + " 'response service': " + processedErrorMsg : (String)messaggioErrore + ": " + processedErrorMsg;
                overwriteMessageError = true;
            }
            catch (Exception processedErrorMsg) {
                // empty catch block
            }
            ValidatoreMessaggiApplicativiException ex = new ValidatoreMessaggiApplicativiException((String)messaggioErrore, e);
            if (isRichiesta) {
                if (TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio())) {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Wsdl fruitore", (String)messaggioErrore, overwriteMessageError));
                } else {
                    ex.setErrore(ErroriIntegrazione.ERRORE_418_VALIDAZIONE_RICHIESTA_TRAMITE_INTERFACCIA_FALLITA.getErrore418_ValidazioneRichiestaTramiteInterfacciaFallita("Wsdl erogatore", (String)messaggioErrore, overwriteMessageError));
                }
            } else if (TipologiaServizio.CORRELATO.equals((Object)this.accordoServizioWrapper.getTipologiaServizio())) {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Wsdl fruitore", (String)messaggioErrore, overwriteMessageError));
            } else {
                ex.setErrore(ErroriIntegrazione.ERRORE_419_VALIDAZIONE_RISPOSTA_TRAMITE_INTERFACCIA_FALLITA.getErrore419_ValidazioneRispostaTramiteInterfacciaFallita("Wsdl erogatore", (String)messaggioErrore, overwriteMessageError));
            }
            throw ex;
        }
    }
}

