/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione;

import java.io.Serializable;
import java.security.SecureRandom;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.GestioneTokenAutenticazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.IdCredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.utils.CredenzialiMittente;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenziale;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractSearchCredenziale;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeApi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeEventi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeGruppi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchApi;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchClientAddress;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchEvento;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchGruppo;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchToken;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTokenClient;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeSearchTrasporto;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeToken;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenPDND;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTrasporto;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.message.utils.WWWAuthenticateGenerator;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autenticazione.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.EsitoAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.IAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.EsitoAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.autenticazione.pd.IAutenticazionePortaDelegata;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopState;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.SecurityTokenUtilities;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.PDNDTokenInfo;
import org.openspcoop2.protocol.sdk.SecurityToken;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class GestoreAutenticazione {
    private static final String AUTENTICAZIONE_CACHE_NAME = "autenticazione";
    private static Cache cacheAutenticazione = null;
    private static final Map<String, Semaphore> _lockAutenticazionePD = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockAutenticazionePA = new HashMap<String, Semaphore>();
    private static final Semaphore lockCredenzialiMittente = new Semaphore("GestoreCredenziali");
    private static final Semaphore lockCredenzialiMittenteCreazione = new Semaphore("GestoreCredenziali-Creazione");
    private static final Semaphore lockCredenzialiMittenteAggiornamento = new Semaphore("GestoreCredenziali-Aggiornamento");
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static Random _rnd = null;

    private static synchronized Semaphore initLockAutenticazionePD(String tipoAutenticazione) {
        Semaphore s = _lockAutenticazionePD.get(tipoAutenticazione);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutenticazioneLockPermits(tipoAutenticazione);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutenticazioneLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutenticazioneFruizioni_" + tipoAutenticazione, permits.intValue()) : new Semaphore("GestoreAutenticazioneFruizioni_" + tipoAutenticazione);
            _lockAutenticazionePD.put(tipoAutenticazione, s);
        }
        return s;
    }

    private static Semaphore getLockAutenticazionePD(String tipoAutenticazione) {
        Semaphore s = _lockAutenticazionePD.get(tipoAutenticazione);
        if (s == null) {
            s = GestoreAutenticazione.initLockAutenticazionePD(tipoAutenticazione);
        }
        return s;
    }

    private static synchronized Semaphore initLockAutenticazionePA(String tipoAutenticazione) {
        Semaphore s = _lockAutenticazionePA.get(tipoAutenticazione);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutenticazioneLockPermits(tipoAutenticazione);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutenticazioneLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutenticazioneErogazioni_" + tipoAutenticazione, permits.intValue()) : new Semaphore("GestoreAutenticazioneErogazioni_" + tipoAutenticazione);
            _lockAutenticazionePA.put(tipoAutenticazione, s);
        }
        return s;
    }

    private static Semaphore getLockAutenticazionePA(String tipoAutenticazione) {
        Semaphore s = _lockAutenticazionePA.get(tipoAutenticazione);
        if (s == null) {
            s = GestoreAutenticazione.initLockAutenticazionePA(tipoAutenticazione);
        }
        return s;
    }

    private static synchronized void initRandom() {
        if (_rnd == null) {
            _rnd = new SecureRandom();
        }
    }

    public static Random getRandom() {
        if (_rnd == null) {
            GestoreAutenticazione.initRandom();
        }
        return _rnd;
    }

    public static void resetCache() throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                cacheAutenticazione.clear();
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws AutenticazioneException {
        try {
            if (cacheAutenticazione != null) {
                return cacheAutenticazione.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new AutenticazioneException("Visualizzazione Statistiche riguardante la cache dell'autenticazione non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            throw new AutenticazioneException("Cache gia' abilitata");
        }
        GestoreAutenticazione._abilitaCache();
    }

    private static synchronized void _abilitaCache() throws AutenticazioneException {
        if (cacheAutenticazione == null) {
            try {
                cacheAutenticazione = new Cache(CacheType.JCS, AUTENTICAZIONE_CACHE_NAME);
                cacheAutenticazione.build();
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            throw new AutenticazioneException("Cache gia' abilitata");
        }
        try {
            int dimensioneCacheInt = -1;
            if (dimensioneCache != null) {
                dimensioneCacheInt = dimensioneCache.intValue();
            }
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
            long itemIdleTimeLong = -1L;
            if (itemIdleTime != null) {
                itemIdleTimeLong = itemIdleTime;
            }
            long itemLifeSecondLong = -1L;
            if (itemLifeSecond != null) {
                itemLifeSecondLong = itemLifeSecond;
            }
            GestoreAutenticazione.initCacheAutenticazione(CacheType.JCS, dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
        }
        catch (Exception e) {
            throw new AutenticazioneException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws AutenticazioneException {
        if (cacheAutenticazione == null) {
            throw new AutenticazioneException("Cache gia' disabilitata");
        }
        GestoreAutenticazione._disabilitaCache();
    }

    private static synchronized void _disabilitaCache() throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                cacheAutenticazione.clear();
                cacheAutenticazione = null;
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheAutenticazione != null;
    }

    public static String listKeysCache(String separator) throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                return cacheAutenticazione.printKeys(separator);
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
        throw new AutenticazioneException("Cache non abilitata");
    }

    public static List<String> listKeysCache() throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                return cacheAutenticazione.keys();
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
        throw new AutenticazioneException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                Object o = cacheAutenticazione.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
        throw new AutenticazioneException("Cache non abilitata");
    }

    public static Object getRawObjectCache(String key) throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                Object o = cacheAutenticazione.get(key);
                if (o != null) {
                    if (o instanceof CacheResponse) {
                        CacheResponse cR = (CacheResponse)o;
                        if (cR.getObject() != null) {
                            o = cR.getObject();
                        } else if (cR.getException() != null) {
                            o = cR.getException();
                        }
                    }
                    return o;
                }
                return null;
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        }
        throw new AutenticazioneException("Cache non abilitata");
    }

    public static void removeObjectCache(String key) throws AutenticazioneException {
        if (cacheAutenticazione != null) {
            try {
                cacheAutenticazione.remove(key);
            }
            catch (Exception e) {
                throw new AutenticazioneException(e.getMessage(), e);
            }
        } else {
            throw new AutenticazioneException("Cache non abilitata");
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreAutenticazione.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreAutenticazione.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        if (cacheAbilitata) {
            GestoreAutenticazione.initCacheAutenticazione(cacheType, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initCacheAutenticazione(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        String msg;
        if (log != null) {
            log.info("Inizializzazione cache Autenticazione");
        }
        cacheAutenticazione = new Cache(cacheType, AUTENTICAZIONE_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Autenticazione) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info(msg);
                    }
                    logConsole.info(msg);
                    cacheAutenticazione.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new AutenticazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Autenticazione) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheAutenticazione.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheAutenticazione.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (idleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (Autenticazione) impostato al valore: " + idleTime;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheAutenticazione.setItemIdleTime(idleTime);
            }
            catch (Exception error) {
                throw new AutenticazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), error);
            }
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (Autenticazione) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            cacheAutenticazione.setItemLifeTime(itemLifeSecond);
        }
        catch (Exception error) {
            throw new AutenticazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), error);
        }
        cacheAutenticazione.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cacheAutenticazione == null) {
            throw new UtilsException("Cache disabled");
        }
        cacheAutenticazione.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cacheAutenticazione == null) {
            throw new UtilsException("Cache disabled");
        }
        return cacheAutenticazione.isDisableSyncronizedGet();
    }

    public static void removePortaApplicativa(IDPortaApplicativa idPA) throws Exception {
        if (GestoreAutenticazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutenticazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String match = "PA:" + idPA.getNome() + " ";
                for (String key : keys) {
                    if (key == null || !key.contains(match)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutenticazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removePortaDelegata(IDPortaDelegata idPD) throws Exception {
        if (GestoreAutenticazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutenticazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String match = "PD:" + idPD.getNome() + " ";
                for (String key : keys) {
                    if (key == null || !key.contains(match)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutenticazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeSoggetto(IDSoggetto idSoggetto) throws Exception {
        if (GestoreAutenticazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutenticazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    EsitoAutenticazionePortaApplicativa esito;
                    Object o;
                    if (key == null || (o = GestoreAutenticazione.getRawObjectCache(key)) == null || !(o instanceof EsitoAutenticazionePortaApplicativa) || (esito = (EsitoAutenticazionePortaApplicativa)o).getIdSoggetto() == null || !esito.getIdSoggetto().equals((Object)idSoggetto)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutenticazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeApplicativo(IDServizioApplicativo idApplicativo) throws Exception {
        if (GestoreAutenticazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutenticazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                for (String key : keys) {
                    EsitoAutenticazione esito;
                    Object o;
                    if (key == null || (o = GestoreAutenticazione.getRawObjectCache(key)) == null) continue;
                    if (o instanceof EsitoAutenticazionePortaDelegata) {
                        esito = (EsitoAutenticazionePortaDelegata)o;
                        if (((EsitoAutenticazionePortaDelegata)esito).getIdServizioApplicativo() == null || !((EsitoAutenticazionePortaDelegata)esito).getIdServizioApplicativo().equals((Object)idApplicativo)) continue;
                        keyForClean.add(key);
                        continue;
                    }
                    if (!(o instanceof EsitoAutenticazionePortaApplicativa) || ((EsitoAutenticazionePortaApplicativa)(esito = (EsitoAutenticazionePortaApplicativa)o)).getIdServizioApplicativo() == null || !((EsitoAutenticazionePortaApplicativa)esito).getIdServizioApplicativo().equals((Object)idApplicativo)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutenticazione.removeObjectCache(key);
                }
            }
        }
    }

    public static EsitoAutenticazionePortaDelegata verificaAutenticazionePortaDelegata(String tipoAutenticazione, DatiInvocazionePortaDelegata datiInvocazione, ParametriAutenticazione parametriAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        return GestoreAutenticazione._verificaAutenticazionePortaDelegata(false, tipoAutenticazione, datiInvocazione, parametriAutenticazione, pddContext, protocolFactory, msg);
    }

    public static EsitoAutenticazionePortaDelegata verificaAutenticazioneMessageBox(String tipoAutenticazione, DatiInvocazionePortaDelegata datiInvocazione, ParametriAutenticazione parametriAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws Exception {
        return GestoreAutenticazione._verificaAutenticazionePortaDelegata(true, tipoAutenticazione, datiInvocazione, parametriAutenticazione, pddContext, protocolFactory, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EsitoAutenticazionePortaDelegata _verificaAutenticazionePortaDelegata(boolean messageBox, String tipoAutenticazione, DatiInvocazionePortaDelegata datiInvocazione, ParametriAutenticazione parametriAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        GestoreAutenticazione.checkDatiPortaDelegata(messageBox, datiInvocazione);
        IAutenticazionePortaDelegata auth = GestoreAutenticazione.newInstanceAuthPortaDelegata(tipoAutenticazione, pddContext, protocolFactory);
        auth.initParametri(parametriAutenticazione);
        if (messageBox) {
            auth.setLogError(false);
        }
        try {
            if (cacheAutenticazione == null || !auth.saveAuthenticationResultInCache()) {
                EsitoAutenticazionePortaDelegata esitoAutenticazionePortaDelegata = auth.process(datiInvocazione);
                return esitoAutenticazionePortaDelegata;
            }
            String keyCache = GestoreAutenticazione.buildCacheKey(messageBox, true, tipoAutenticazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthenticationResultInCache(datiInvocazione));
            CacheResponse response = (CacheResponse)cacheAutenticazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaDelegata) in cache.");
                    EsitoAutenticazionePortaDelegata esito = (EsitoAutenticazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutenticazionePortaDelegata esitoAutenticazionePortaDelegata = esito;
                    return esitoAutenticazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutenticazionePD = GestoreAutenticazione.getLockAutenticazionePD(tipoAutenticazione);
            SemaphoreLock lock = lockAutenticazionePD.acquire("verificaAutenticazionePortaDelegata", idTransazione);
            response = (CacheResponse)cacheAutenticazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaDelegata) in cache.");
                    EsitoAutenticazionePortaDelegata esito = (EsitoAutenticazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutenticazionePortaDelegata esitoAutenticazionePortaDelegata = esito;
                    return esitoAutenticazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutenticazionePortaDelegata) ricerco nella configurazione...");
            EsitoAutenticazionePortaDelegata esito = auth.process(datiInvocazione);
            if (esito == null) throw new AutenticazioneException("Metodo (GestoreAutenticazione.autenticazionePortaDelegata.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutenticazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutenticazionePortaDelegata esitoAutenticazionePortaDelegata = esito;
            return esitoAutenticazionePortaDelegata;
            finally {
                lockAutenticazionePD.release(lock, "verificaAutenticazionePortaDelegata", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EsitoAutenticazionePortaApplicativa verificaAutenticazionePortaApplicativa(String tipoAutenticazione, DatiInvocazionePortaApplicativa datiInvocazione, ParametriAutenticazione parametriAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        GestoreAutenticazione.checkDatiPortaApplicativa(datiInvocazione);
        IAutenticazionePortaApplicativa auth = GestoreAutenticazione.newInstanceAuthPortaApplicativa(tipoAutenticazione, pddContext, protocolFactory);
        auth.initParametri(parametriAutenticazione);
        try {
            if (cacheAutenticazione == null || !auth.saveAuthenticationResultInCache()) {
                EsitoAutenticazionePortaApplicativa esitoAutenticazionePortaApplicativa = auth.process(datiInvocazione);
                return esitoAutenticazionePortaApplicativa;
            }
            String keyCache = GestoreAutenticazione.buildCacheKey(false, false, tipoAutenticazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthenticationResultInCache(datiInvocazione));
            CacheResponse response = (CacheResponse)cacheAutenticazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaApplicativa) in cache.");
                    EsitoAutenticazionePortaApplicativa esito = (EsitoAutenticazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutenticazionePortaApplicativa esitoAutenticazionePortaApplicativa = esito;
                    return esitoAutenticazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutenticazionePA = GestoreAutenticazione.getLockAutenticazionePA(tipoAutenticazione);
            SemaphoreLock lock = lockAutenticazionePA.acquire("verificaAutenticazionePortaApplicativa", idTransazione);
            response = (CacheResponse)cacheAutenticazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaApplicativa) in cache.");
                    EsitoAutenticazionePortaApplicativa esito = (EsitoAutenticazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutenticazionePortaApplicativa esitoAutenticazionePortaApplicativa = esito;
                    return esitoAutenticazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutenticazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutenticazionePortaApplicativa) ricerco nella configurazione...");
            EsitoAutenticazionePortaApplicativa esito = auth.process(datiInvocazione);
            if (esito == null) throw new AutenticazioneException("Metodo (GestoreAutenticazione.autenticazionePortaApplicativa.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutenticazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutenticazionePortaApplicativa esitoAutenticazionePortaApplicativa = esito;
            return esitoAutenticazionePortaApplicativa;
            finally {
                lockAutenticazionePA.release(lock, "verificaAutenticazionePortaApplicativa", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    private static void checkDatiPortaDelegata(boolean messageBox, DatiInvocazionePortaDelegata datiInvocazione) throws AutenticazioneException {
        InfoConnettoreIngresso infoConnettoreIngresso = datiInvocazione.getInfoConnettoreIngresso();
        if (infoConnettoreIngresso == null) {
            throw new AutenticazioneException("(Parametri) InfoConnettoreIngresso non definito");
        }
        if (infoConnettoreIngresso.getCredenziali() == null) {
            throw new AutenticazioneException("(Parametri) InfoConnettoreIngresso.credenziali non definito");
        }
        if (!messageBox) {
            IDPortaDelegata idPD = datiInvocazione.getIdPD();
            if (idPD == null) {
                throw new AutenticazioneException("(Parametri) IDPortaDelegata non definito");
            }
            if (idPD.getNome() == null) {
                throw new AutenticazioneException("(Parametri) IDPortaDelegata.nome non definito");
            }
            PortaDelegata pd = datiInvocazione.getPd();
            if (pd == null) {
                throw new AutenticazioneException("(Parametri) PortaDelegata non definito");
            }
        }
    }

    private static void checkDatiPortaApplicativa(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        InfoConnettoreIngresso infoConnettoreIngresso = datiInvocazione.getInfoConnettoreIngresso();
        if (infoConnettoreIngresso == null) {
            throw new AutenticazioneException("(Parametri) InfoConnettoreIngresso non definito");
        }
        if (infoConnettoreIngresso.getCredenziali() == null) {
            throw new AutenticazioneException("(Parametri) InfoConnettoreIngresso.credenziali non definito");
        }
    }

    private static String buildCacheKey(boolean messageBox, boolean portaDelegata, String tipoAutenticazione, String keyCache, String suffixKeyCache) throws AutenticazioneException {
        StringBuilder bf = new StringBuilder();
        if (portaDelegata) {
            if (messageBox) {
                bf.append("MessageBox ");
            } else {
                bf.append("PD ");
            }
        } else {
            bf.append("PA ");
        }
        bf.append(" Auth:").append(tipoAutenticazione).append(" ");
        bf.append(keyCache);
        if (suffixKeyCache != null && !"".equals(suffixKeyCache)) {
            bf.append(" ");
            bf.append(suffixKeyCache);
        }
        return bf.toString();
    }

    private static IAutenticazionePortaDelegata newInstanceAuthPortaDelegata(String tipoAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutenticazioneException {
        IAutenticazionePortaDelegata auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutenticazionePortaDelegata(tipoAutenticazione);
        }
        catch (Exception e) {
            throw new AutenticazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutenticazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autenticazione della fruizione: " + e.getMessage(), e);
        }
    }

    private static IAutenticazionePortaApplicativa newInstanceAuthPortaApplicativa(String tipoAutenticazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutenticazioneException {
        IAutenticazionePortaApplicativa auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutenticazionePortaApplicativa(tipoAutenticazione);
        }
        catch (Exception e) {
            throw new AutenticazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutenticazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autenticazione della erogazione: " + e.getMessage(), e);
        }
    }

    public static boolean isAutenticazioneTokenEnabled(GestioneTokenAutenticazione gestioneTokenAutenticazione) {
        return StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getIssuer()) || StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getClientId()) || StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getSubject()) || StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getUsername()) || StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getEmail());
    }

    public static String getLabel(GestioneTokenAutenticazione gestioneTokenAutenticazione) {
        return GestoreAutenticazione._getActions(gestioneTokenAutenticazione);
    }

    public static String getActions(GestioneTokenAutenticazione gestioneTokenAutenticazione) {
        return GestoreAutenticazione._getActions(gestioneTokenAutenticazione);
    }

    private static String _getActions(GestioneTokenAutenticazione gestioneTokenAutenticazione) {
        StringBuilder bf = new StringBuilder();
        if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getIssuer())) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append("Issuer");
        }
        if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getClientId())) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append("ClientId");
        }
        if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getSubject())) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append("Subject");
        }
        if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getUsername())) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append("Username");
        }
        if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenAutenticazione.getEmail())) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append("eMail");
        }
        return bf.toString();
    }

    public static EsitoAutenticazionePortaDelegata verificaAutenticazioneTokenPortaDelegata(GestioneTokenAutenticazione tipoAutenticazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        EsitoAutenticazionePortaDelegata esito = new EsitoAutenticazionePortaDelegata();
        esito.setClientAuthenticated(true);
        esito = (EsitoAutenticazionePortaDelegata)GestoreAutenticazione.autenticazioneToken(tipoAutenticazione, esito, pddContext, datiInvocazione);
        if (!esito.isClientAuthenticated()) {
            esito.setErroreIntegrazione(IntegrationFunctionError.TOKEN_REQUIRED_CLAIMS_NOT_FOUND, ErroriIntegrazione.ERRORE_445_TOKEN_AUTORIZZAZIONE_FALLITA.getErroreIntegrazione());
        }
        return esito;
    }

    public static EsitoAutenticazionePortaApplicativa verificaAutenticazioneTokenPortaApplicativa(GestioneTokenAutenticazione tipoAutenticazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        esito.setClientAuthenticated(true);
        esito = (EsitoAutenticazionePortaApplicativa)GestoreAutenticazione.autenticazioneToken(tipoAutenticazione, esito, pddContext, datiInvocazione);
        if (!esito.isClientAuthenticated()) {
            esito.setErroreCooperazione(IntegrationFunctionError.TOKEN_REQUIRED_CLAIMS_NOT_FOUND, ErroriCooperazione.TOKEN_AUTORIZZAZIONE_FALLITA.getErroreCooperazione());
        }
        return esito;
    }

    private static EsitoAutenticazione autenticazioneToken(GestioneTokenAutenticazione tipoAutenticazione, EsitoAutenticazione esito, PdDContext pddContext, AbstractDatiInvocazione datiInvocazione) throws Exception {
        boolean autenticato = true;
        String errorMessage = null;
        if (tipoAutenticazione != null) {
            boolean issuer = StatoFunzionalita.ABILITATO.equals((Object)tipoAutenticazione.getIssuer());
            boolean clientId = StatoFunzionalita.ABILITATO.equals((Object)tipoAutenticazione.getClientId());
            boolean subject = StatoFunzionalita.ABILITATO.equals((Object)tipoAutenticazione.getSubject());
            boolean username = StatoFunzionalita.ABILITATO.equals((Object)tipoAutenticazione.getUsername());
            boolean email = StatoFunzionalita.ABILITATO.equals((Object)tipoAutenticazione.getEmail());
            if (issuer || clientId || subject || username || email) {
                InformazioniToken informazioniTokenNormalizzate = null;
                Object oInformazioniTokenNormalizzate = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
                if (oInformazioniTokenNormalizzate != null) {
                    informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
                }
                if (issuer && (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getIss() == null || "".equals(informazioniTokenNormalizzate.getIss()))) {
                    autenticato = false;
                    errorMessage = "Token without issuer claim";
                }
                if (clientId && (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getClientId() == null || "".equals(informazioniTokenNormalizzate.getClientId()))) {
                    autenticato = false;
                    errorMessage = "Token without clientId claim";
                }
                if (subject && (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getSub() == null || "".equals(informazioniTokenNormalizzate.getSub()))) {
                    autenticato = false;
                    errorMessage = "Token without subject claim";
                }
                if (username && (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getUsername() == null || "".equals(informazioniTokenNormalizzate.getUsername()))) {
                    autenticato = false;
                    errorMessage = "Token without username claim";
                }
                if (email && (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getUserInfo() == null || informazioniTokenNormalizzate.getUserInfo().getEMail() == null || "".equals(informazioniTokenNormalizzate.getUserInfo().getEMail()))) {
                    autenticato = false;
                    errorMessage = "Token without email claim";
                }
            }
        }
        if (!autenticato) {
            esito.setDetails(errorMessage);
            String realm = "OpenSPCoop";
            Object oRealm = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_REALM);
            if (oRealm != null) {
                realm = (String)oRealm;
            }
            boolean emptyMessage = false;
            Object oEmptyMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_BODY_EMPTY);
            if (oEmptyMessage != null) {
                emptyMessage = (Boolean)oEmptyMessage;
            }
            boolean genericMessage = false;
            Object oGenericMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_GENERIC_MESSAGE);
            if (oGenericMessage != null) {
                genericMessage = (Boolean)oGenericMessage;
            }
            esito.setClientAuthenticated(false);
            if (emptyMessage) {
                esito.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, errorMessage, (String[])new String[0]));
            } else {
                esito.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, errorMessage, (String[])new String[0]));
            }
        }
        return esito;
    }

    private static boolean isCredenzialiMittenteEnabled(TipoCredenzialeMittente tipo, List<Proprieta> proprietaPorta) {
        boolean defaultValue = OpenSPCoop2Properties.getInstance().isTransazioniCredenzialiMittenteEnabled(tipo);
        if (proprietaPorta != null && !proprietaPorta.isEmpty()) {
            return CostantiProprieta.isTraceIndexEnabled(proprietaPorta, tipo, defaultValue);
        }
        return defaultValue;
    }

    public static void updateCredenzialiTrasporto(IDSoggetto dominio, String modulo, String idTransazione, String tipoAutenticazione, String credential, CredenzialiMittente credenzialiMittente, IOpenSPCoopState openspcoopState, String identitaChiamante, RequestInfo requestInfo, List<Proprieta> proprietaPorta) throws Exception {
        if (!GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TRASPORTO, proprietaPorta)) {
            return;
        }
        CredenzialeSearchTrasporto trasportoSearch = new CredenzialeSearchTrasporto(tipoAutenticazione);
        trasportoSearch.disableConvertToDBValue();
        CredenzialeTrasporto trasporto = new CredenzialeTrasporto(tipoAutenticazione, credential);
        credenzialiMittente.setTrasporto(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)trasportoSearch, (AbstractCredenziale)trasporto, openspcoopState, identitaChiamante, null, requestInfo));
    }

    public static void updateCredenzialiToken(IDSoggetto dominio, String modulo, String idTransazione, InformazioniToken informazioniTokenNormalizzate, IDServizioApplicativo idApplicativoToken, CredenzialiMittente credenzialiMittente, IOpenSPCoopState openspcoopState, String identitaChiamante, RequestInfo requestInfo, Context context, List<Proprieta> proprietaPorta) throws Exception {
        CredenzialeToken token;
        CredenzialeSearchToken tokenSearch;
        if (informazioniTokenNormalizzate.getIss() != null && GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TOKEN_ISSUER, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_ISSUER);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_ISSUER, informazioniTokenNormalizzate.getIss());
            credenzialiMittente.setTokenIssuer(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        if (informazioniTokenNormalizzate.getClientId() != null && GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TOKEN_CLIENT_ID, proprietaPorta)) {
            if (idApplicativoToken == null) {
                tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_CLIENT_ID);
                tokenSearch.disableConvertToDBValue();
                token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_CLIENT_ID, informazioniTokenNormalizzate.getClientId());
                credenzialiMittente.setTokenClientId(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
            } else {
                tokenSearch = new CredenzialeSearchTokenClient(true, true, true);
                tokenSearch.disableConvertToDBValue();
                token = new CredenzialeTokenClient(informazioniTokenNormalizzate.getClientId(), idApplicativoToken);
                credenzialiMittente.setTokenClientId(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
            }
        }
        if (informazioniTokenNormalizzate.getSub() != null && GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TOKEN_SUBJECT, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_SUBJECT);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_SUBJECT, informazioniTokenNormalizzate.getSub());
            credenzialiMittente.setTokenSubject(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        if (informazioniTokenNormalizzate.getUsername() != null && GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TOKEN_USERNAME, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_USERNAME);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_USERNAME, informazioniTokenNormalizzate.getUsername());
            credenzialiMittente.setTokenUsername(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        if (informazioniTokenNormalizzate.getUserInfo() != null && informazioniTokenNormalizzate.getUserInfo().getEMail() != null && GestoreAutenticazione.isCredenzialiMittenteEnabled(TipoCredenzialeMittente.TOKEN_EMAIL, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_EMAIL);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_EMAIL, informazioniTokenNormalizzate.getUserInfo().getEMail());
            credenzialiMittente.setTokenEMail(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        GestoreAutenticazione.updateCredenzialiTokenPDND(dominio, modulo, idTransazione, informazioniTokenNormalizzate, credenzialiMittente, openspcoopState, identitaChiamante, requestInfo, context);
    }

    private static boolean isCredenzialiMittenteModIAuthEnabled(TipoCredenzialeMittente tipo, List<Proprieta> proprietaPorta) {
        boolean defaultValue = OpenSPCoop2Properties.getInstance().isTransazioniCredenzialiMittenteModIAuthEnabled(tipo);
        if (proprietaPorta != null && !proprietaPorta.isEmpty()) {
            return CostantiProprieta.isTraceIndexModIAuthEnabled(proprietaPorta, tipo, defaultValue);
        }
        return defaultValue;
    }

    public static void updateCredenzialiModIAuthorizationToken(IDSoggetto dominio, String modulo, String idTransazione, String iss, String sub, String clientId, CredenzialiMittente credenzialiMittente, IOpenSPCoopState openspcoopState, String identitaChiamante, RequestInfo requestInfo, List<Proprieta> proprietaPorta) throws Exception {
        CredenzialeToken token;
        CredenzialeSearchToken tokenSearch;
        if (iss != null && GestoreAutenticazione.isCredenzialiMittenteModIAuthEnabled(TipoCredenzialeMittente.TOKEN_ISSUER, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_ISSUER);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_ISSUER, iss);
            credenzialiMittente.setTokenIssuer(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        if (clientId != null && GestoreAutenticazione.isCredenzialiMittenteModIAuthEnabled(TipoCredenzialeMittente.TOKEN_CLIENT_ID, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_CLIENT_ID);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_CLIENT_ID, clientId);
            credenzialiMittente.setTokenClientId(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
        if (sub != null && GestoreAutenticazione.isCredenzialiMittenteModIAuthEnabled(TipoCredenzialeMittente.TOKEN_SUBJECT, proprietaPorta)) {
            tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.TOKEN_SUBJECT);
            tokenSearch.disableConvertToDBValue();
            token = new CredenzialeToken(TipoCredenzialeMittente.TOKEN_SUBJECT, sub);
            credenzialiMittente.setTokenSubject(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
        }
    }

    public static void updateCredenzialiTokenPDND(IDSoggetto dominio, String modulo, String idTransazione, InformazioniToken informazioniTokenNormalizzate, CredenzialiMittente credenzialiMittente, IOpenSPCoopState openspcoopState, String identitaChiamante, RequestInfo requestInfo, Context context) throws Exception {
        SecurityToken securityTokenForContext = SecurityTokenUtilities.readSecurityToken((Context)context);
        Long refClientIdCredenzialieMittente = null;
        if (credenzialiMittente != null && credenzialiMittente.getTokenClientId() != null && credenzialiMittente.getTokenClientId().getId() != null && credenzialiMittente.getTokenClientId().getId() > 0L) {
            refClientIdCredenzialieMittente = credenzialiMittente.getTokenClientId().getId();
        }
        if (refClientIdCredenzialieMittente == null) {
            return;
        }
        if (securityTokenForContext != null && securityTokenForContext.getPdnd() != null || informazioniTokenNormalizzate.getPdnd() != null && !informazioniTokenNormalizzate.getPdnd().isEmpty()) {
            String organizationJson;
            CredenzialeTokenPDND token;
            CredenzialeSearchToken tokenSearch;
            String clientJson;
            OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
            if (credenzialiMittente.getTokenPdndClientJson() == null && properties.isGestoreChiaviPDNDclientsTraceJsonResponse() && securityTokenForContext != null && securityTokenForContext.getPdnd() != null && (clientJson = securityTokenForContext.getPdnd().getClientJson()) != null && StringUtils.isNotEmpty((CharSequence)clientJson)) {
                tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_CLIENT_JSON);
                tokenSearch.disableConvertToDBValue();
                token = new CredenzialeTokenPDND(TipoCredenzialeMittente.PDND_CLIENT_JSON, clientJson, refClientIdCredenzialieMittente);
                credenzialiMittente.setTokenPdndClientJson(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
            }
            if (credenzialiMittente.getTokenPdndOrganizationJson() == null && properties.isGestoreChiaviPDNDorganizationsTraceJsonResponse() && securityTokenForContext != null && securityTokenForContext.getPdnd() != null && (organizationJson = securityTokenForContext.getPdnd().getOrganizationJson()) != null && StringUtils.isNotEmpty((CharSequence)organizationJson)) {
                tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON);
                tokenSearch.disableConvertToDBValue();
                token = new CredenzialeTokenPDND(TipoCredenzialeMittente.PDND_ORGANIZATION_JSON, organizationJson, refClientIdCredenzialieMittente);
                credenzialiMittente.setTokenPdndOrganizationJson(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
            }
            if (credenzialiMittente.getTokenPdndOrganizationName() == null && properties.isGestoreChiaviPDNDorganizationsTraceName()) {
                String organizationName = null;
                if (securityTokenForContext != null && securityTokenForContext.getPdnd() != null) {
                    try {
                        organizationName = securityTokenForContext.getPdnd().getOrganizationName(logger);
                    }
                    catch (Exception tokenSearch2) {
                        // empty catch block
                    }
                }
                if (organizationName == null && informazioniTokenNormalizzate.getPdnd() != null) {
                    organizationName = PDNDTokenInfo.readOrganizationNameFromPDNDMap(informazioniTokenNormalizzate.getPdnd());
                }
                if (organizationName != null && StringUtils.isNotEmpty(organizationName)) {
                    tokenSearch = new CredenzialeSearchToken(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME);
                    tokenSearch.disableConvertToDBValue();
                    token = new CredenzialeTokenPDND(TipoCredenzialeMittente.PDND_ORGANIZATION_NAME, organizationName, refClientIdCredenzialieMittente);
                    credenzialiMittente.setTokenPdndOrganizationName(GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)tokenSearch, (AbstractCredenziale)token, openspcoopState, identitaChiamante, null, requestInfo));
                }
            }
        }
    }

    public static CredenzialeMittente convertGruppiToCredenzialiMittenti(IDSoggetto dominio, String modulo, String idTransazione, List<String> gruppiList, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo) throws Exception {
        if (gruppiList != null && !gruppiList.isEmpty()) {
            CredenzialeSearchGruppo gruppiSearch = new CredenzialeSearchGruppo();
            gruppiSearch.disableConvertToDBValue();
            CredenzialeGruppi gruppi = new CredenzialeGruppi(gruppiList);
            return GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)gruppiSearch, (AbstractCredenziale)gruppi, openspcoopState, identitaChiamante, sbConflict, requestInfo);
        }
        return null;
    }

    public static CredenzialeMittente convertAPIToCredenzialiMittenti(IDSoggetto dominio, String modulo, String idTransazione, String uriAccordoServizio, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo) throws Exception {
        if (uriAccordoServizio != null && !"".equals(uriAccordoServizio)) {
            CredenzialeSearchApi apiSearch = new CredenzialeSearchApi();
            apiSearch.disableConvertToDBValue();
            CredenzialeApi api = new CredenzialeApi(uriAccordoServizio);
            return GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)apiSearch, (AbstractCredenziale)api, openspcoopState, identitaChiamante, sbConflict, requestInfo);
        }
        return null;
    }

    public static CredenzialeMittente convertEventiToCredenzialiMittenti(IDSoggetto dominio, String modulo, String idTransazione, List<String> eventiList, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo) throws Exception {
        if (eventiList != null && !eventiList.isEmpty()) {
            CredenzialeSearchEvento eventiSearch = new CredenzialeSearchEvento();
            eventiSearch.disableConvertToDBValue();
            CredenzialeEventi eventi = new CredenzialeEventi(eventiList);
            return GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)eventiSearch, (AbstractCredenziale)eventi, openspcoopState, identitaChiamante, sbConflict, requestInfo);
        }
        return null;
    }

    public static CredenzialeMittente convertClientCredentialToCredenzialiMittenti(IDSoggetto dominio, String modulo, String idTransazione, String socketAddress, String transportAddress, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo) throws Exception {
        boolean transportAddressDefined;
        boolean socketAddressDefined = socketAddress != null && !"".equals(socketAddress);
        boolean bl = transportAddressDefined = transportAddress != null && !"".equals(transportAddress);
        if (socketAddressDefined || transportAddressDefined) {
            CredenzialeSearchClientAddress clientAddressSearch = new CredenzialeSearchClientAddress(socketAddressDefined, transportAddressDefined, true);
            clientAddressSearch.disableConvertToDBValue();
            CredenzialeClientAddress clientAddress = new CredenzialeClientAddress(socketAddress, transportAddress);
            return GestoreAutenticazione.getCredenzialeMittente(dominio, modulo, idTransazione, (AbstractSearchCredenziale)clientAddressSearch, (AbstractCredenziale)clientAddress, openspcoopState, identitaChiamante, sbConflict, requestInfo);
        }
        return null;
    }

    private static CredenzialeMittente getCredenzialeMittente(IDSoggetto dominio, String modulo, String idTransazione, AbstractSearchCredenziale searchCredential, AbstractCredenziale credentialParam, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo) throws Exception {
        CredenzialeMittente c;
        if (dominio == null) {
            throw new AutenticazioneException("(Parametri) dominio non definito");
        }
        if (modulo == null) {
            throw new AutenticazioneException("(Parametri) modulo non definito");
        }
        if (idTransazione == null) {
            throw new AutenticazioneException("(Parametri) idTransazione non definito");
        }
        if (searchCredential == null) {
            throw new AutenticazioneException("(Parametri) searchCredential non definito");
        }
        if (credentialParam == null) {
            throw new AutenticazioneException("(Parametri) credenziali non definite");
        }
        String credential = credentialParam.getCredenziale();
        int maxLengthCredenziali = OpenSPCoop2Properties.getInstance().getTransazioniCredenzialiMittenteMaxLength();
        if (credential.length() > maxLengthCredenziali) {
            logger.error("Attenzione: credenziale '" + searchCredential.getTipo() + "' ricevuta supera la dimensione massima consentita '" + maxLengthCredenziali + "'. Verr\u00e0 salvata troncata a tale dimensione. Credenziale: '" + credential + "'");
            credential = credential.substring(0, maxLengthCredenziali);
            try {
                credentialParam.updateCredenziale(credential);
            }
            catch (Exception e) {
                logger.error("Non \u00e8 possibile troncare la credenziale di tipo '" + searchCredential.getTipo() + "', l'informazione non verr\u00e0 salvata");
            }
        }
        boolean useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null;
        String keyCache = GestoreAutenticazione.buildCacheKey(searchCredential, credential);
        int maxLifeSeconds = OpenSPCoop2Properties.getInstance().getTransazioniCredenzialiMittenteLifeSeconds();
        Date scadenzaEntry = new Date(DateManager.getTimeMillis() - (long)(maxLifeSeconds * 1000));
        if (useRequestInfo && (c = requestInfo.getRequestConfig().getCredenzialeMittente(searchCredential.getTipoCredenzialeMittente(), keyCache)) != null && c.getOraRegistrazione().after(scadenzaEntry)) {
            return c;
        }
        c = GestoreAutenticazione._getCredenzialeMittente(dominio, modulo, idTransazione, searchCredential, credentialParam, openspcoopState, identitaChiamante, sbConflict, requestInfo, keyCache, scadenzaEntry);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addCredenzialeMittente(searchCredential.getTipoCredenzialeMittente(), keyCache, c, idTransazione, scadenzaEntry);
        }
        return c;
    }

    private static CredenzialeMittente _getCredenzialeMittente(IDSoggetto dominio, String modulo, String idTransazione, AbstractSearchCredenziale searchCredential, AbstractCredenziale credentialParam, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict, RequestInfo requestInfo, String keyCache, Date scadenzaEntry) throws Exception {
        if (cacheAutenticazione == null) {
            return GestoreAutenticazione._getCredenzialeMittente(dominio, modulo, idTransazione, scadenzaEntry, searchCredential, credentialParam, openspcoopState, identitaChiamante, sbConflict);
        }
        CacheResponse response = (CacheResponse)cacheAutenticazione.get(keyCache);
        if (response != null) {
            if (response.getObject() != null) {
                logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getCredenzialeMittente) in cache.");
                CredenzialeMittente credenziale = (CredenzialeMittente)response.getObject();
                if (credenziale.getOraRegistrazione().after(scadenzaEntry)) {
                    return credenziale;
                }
            } else {
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getCredenzialeMittente) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
        }
        SemaphoreLock lock = lockCredenzialiMittente.acquire("getCredenzialeMittente", idTransazione);
        try {
            CredenzialeMittente credenziale;
            response = (CacheResponse)cacheAutenticazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:getCredenzialeMittente) in cache.");
                    credenziale = (CredenzialeMittente)response.getObject();
                    if (credenziale.getOraRegistrazione().after(scadenzaEntry)) {
                        CredenzialeMittente credenzialeMittente = credenziale;
                        return credenzialeMittente;
                    }
                } else {
                    if (response.getException() != null) {
                        logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:getCredenzialeMittente) in cache.");
                        throw (Exception)response.getException();
                    }
                    logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
                }
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:getCredenzialeMittente) ricerco nella configurazione...");
            credenziale = GestoreAutenticazione._getCredenzialeMittente(dominio, modulo, idTransazione, scadenzaEntry, searchCredential, credentialParam, openspcoopState, identitaChiamante, sbConflict);
            if (credenziale != null) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)credenziale);
                    cacheAutenticazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
                CredenzialeMittente credenzialeMittente = credenziale;
                return credenzialeMittente;
            }
            throw new AutenticazioneException("Metodo (GestoreAutenticazione.getCredenzialeMittente) ha ritornato un valore di esito null");
        }
        finally {
            lockCredenzialiMittente.release(lock, "getCredenzialeMittente", idTransazione);
        }
    }

    private static String buildCacheKey(AbstractSearchCredenziale searchCredential, String credential) throws AutenticazioneException {
        StringBuilder bf = new StringBuilder();
        bf.append(searchCredential.getTipo()).append(" ");
        bf.append(credential);
        return bf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CredenzialeMittente _getCredenzialeMittente(IDSoggetto dominio, String modulo, String idTransazione, Date scadenzaEntry, AbstractSearchCredenziale searchCredential, AbstractCredenziale credential, IOpenSPCoopState openspcoopState, String identitaChiamante, StringBuilder sbConflict) throws Exception {
        CredenzialeMittente credenzialeMittente;
        block27: {
            CredenzialeMittente credenziale;
            ICredenzialeMittenteService credenzialiMittenteService;
            boolean useConnectionRuntime;
            Resource r;
            DBTransazioniManager dbManager;
            block25: {
                CredenzialeMittente credenzialeMittente2;
                block26: {
                    List list;
                    block23: {
                        CredenzialeTrasporto cTrasporto;
                        block24: {
                            dbManager = null;
                            r = null;
                            useConnectionRuntime = false;
                            try {
                                OpenSPCoopState s;
                                Connection con = null;
                                OpenSPCoop2Properties openspcoopProperties = OpenSPCoop2Properties.getInstance();
                                if (openspcoopProperties.isTransazioniUsePddRuntimeDatasource() && openspcoopState != null && openspcoopState instanceof OpenSPCoopState && (s = (OpenSPCoopState)openspcoopState).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                                    con = s.getConnectionDB();
                                    useConnectionRuntime = true;
                                }
                                if (!useConnectionRuntime) {
                                    dbManager = DBTransazioniManager.getInstance();
                                    r = dbManager.getResource(dominio, modulo + ".credenzialeMittente", idTransazione);
                                    if (r == null) {
                                        throw new Exception("Risorsa al database non disponibile");
                                    }
                                    con = (Connection)r.getResource();
                                }
                                if (con == null) {
                                    throw new Exception("Connessione non disponibile");
                                }
                                boolean debug = OpenSPCoop2Properties.getInstance().isTransazioniDebug();
                                Logger logSql = OpenSPCoop2Logger.getLoggerOpenSPCoopTransazioniSql(debug);
                                DAOFactory daoFactory = DAOFactory.getInstance((Logger)logSql);
                                DAOFactoryProperties daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)logSql);
                                ServiceManagerProperties daoFactoryServiceManagerPropertiesTransazioni = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
                                daoFactoryServiceManagerPropertiesTransazioni.setShowSql(debug);
                                daoFactoryServiceManagerPropertiesTransazioni.setDatabaseType(DBTransazioniManager.getInstance().getTipoDatabase());
                                IServiceManager transazioniSM = (IServiceManager)daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, daoFactoryServiceManagerPropertiesTransazioni, logSql);
                                credenzialiMittenteService = transazioniSM.getCredenzialeMittenteService();
                                boolean ricercaEsatta = true;
                                boolean caseSensitive = true;
                                IPaginatedExpression pagExpression = searchCredential.createExpression(credenzialiMittenteService, credential.getCredenziale(), ricercaEsatta, caseSensitive);
                                list = credenzialiMittenteService.findAll(pagExpression);
                                if (list != null && !list.isEmpty() && credential instanceof CredenzialeTrasporto && (cTrasporto = (CredenzialeTrasporto)credential).isSsl()) {
                                    list = CredenzialeSearchTrasporto.filterList((List)list, (String)credential.getCredenziale(), (Logger)logSql);
                                }
                                if (list != null && list.size() > 0) break block23;
                                cTrasporto = GestoreAutenticazione.createCredenzialeMittente(credenzialiMittenteService, scadenzaEntry, searchCredential, credential, logSql);
                                if (useConnectionRuntime) break block24;
                            }
                            catch (Throwable throwable) {
                                if (!useConnectionRuntime) {
                                    try {
                                        if (r != null) {
                                            dbManager.releaseResource(dominio, modulo, r);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                if (r != null) {
                                    dbManager.releaseResource(dominio, modulo, r);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return cTrasporto;
                    }
                    if (list.size() > 1) {
                        throw new Exception("Trovata pi\u00f9 di un'occorrenza di credenziale di tipo '" + searchCredential.getTipo() + "'; credenziale: [" + credential.getCredenziale() + "]");
                    }
                    credenziale = (CredenzialeMittente)list.get(0);
                    if (!credenziale.getOraRegistrazione().after(scadenzaEntry)) break block25;
                    credenzialeMittente2 = credenziale;
                    if (useConnectionRuntime) break block26;
                    try {
                        if (r != null) {
                            dbManager.releaseResource(dominio, modulo, r);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return credenzialeMittente2;
            }
            credenzialeMittente = GestoreAutenticazione.updateDataCredenzialeMittente(credenzialiMittenteService, scadenzaEntry, credenziale, sbConflict);
            if (useConnectionRuntime) break block27;
            try {
                if (r != null) {
                    dbManager.releaseResource(dominio, modulo, r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return credenzialeMittente;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CredenzialeMittente createCredenzialeMittente(ICredenzialeMittenteService credenzialeMittentiService, Date scadenzaEntry, AbstractSearchCredenziale searchCredential, AbstractCredenziale credential, Logger log) throws Exception {
        SemaphoreLock lock = lockCredenzialiMittenteCreazione.acquire("createCredenzialeMittente");
        try {
            CredenzialeMittente credenzialeMittente = GestoreAutenticazione._createCredenzialeMittente(credenzialeMittentiService, scadenzaEntry, searchCredential, credential, log);
            return credenzialeMittente;
        }
        finally {
            lockCredenzialiMittenteCreazione.release(lock, "createCredenzialeMittente");
        }
    }

    private static CredenzialeMittente _createCredenzialeMittente(ICredenzialeMittenteService credenzialeMittentiService, Date scadenzaEntry, AbstractSearchCredenziale searchCredential, AbstractCredenziale credential, Logger log) throws Exception {
        CredenzialeTrasporto cTrasporto;
        boolean ricercaEsatta = true;
        boolean caseSensitive = true;
        IPaginatedExpression pagEpression = searchCredential.createExpression(credenzialeMittentiService, credential.getCredenziale(), ricercaEsatta, caseSensitive);
        List list = credenzialeMittentiService.findAll(pagEpression);
        if (list != null && !list.isEmpty() && credential instanceof CredenzialeTrasporto && (cTrasporto = (CredenzialeTrasporto)credential).isSsl()) {
            list = CredenzialeSearchTrasporto.filterList((List)list, (String)credential.getCredenziale(), (Logger)log);
        }
        if (list == null || list.size() <= 0) {
            CredenzialeMittente credenzialeMittente = new CredenzialeMittente();
            credenzialeMittente.setTipo(credential.getTipo());
            credenzialeMittente.setRefCredenziale(credential.getReferenceId());
            credenzialeMittente.setOraRegistrazione(DateManager.getDate());
            credenzialeMittente.setCredenziale(credential.getCredenziale());
            try {
                credenzialeMittentiService.create((Object)credenzialeMittente);
            }
            catch (Throwable t) {
                CredenzialeTrasporto cTrasporto2;
                list = credenzialeMittentiService.findAll(pagEpression);
                if (list != null && !list.isEmpty() && credential instanceof CredenzialeTrasporto && (cTrasporto2 = (CredenzialeTrasporto)credential).isSsl()) {
                    list = CredenzialeSearchTrasporto.filterList((List)list, (String)credential.getCredenziale(), (Logger)log);
                }
                if (list == null || list.size() <= 0) {
                    throw new Exception(t.getMessage(), t);
                }
                if (list.size() > 1) {
                    throw new Exception("Trovata pi\u00f9 di un'occorrenza di credenziale di tipo '" + searchCredential.getTipo() + "'; credenziale: [" + credential.getCredenziale() + "]");
                }
                CredenzialeMittente credenziale = (CredenzialeMittente)list.get(0);
                return credenziale;
            }
            return credenzialeMittente;
        }
        if (list.size() > 1) {
            throw new Exception("Trovata pi\u00f9 di un'occorrenza di credenziale di tipo '" + searchCredential.getTipo() + "'; credenziale: [" + credential.getCredenziale() + "]");
        }
        CredenzialeMittente credenziale = (CredenzialeMittente)list.get(0);
        if (credenziale.getOraRegistrazione().after(scadenzaEntry)) {
            return credenziale;
        }
        return credenziale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CredenzialeMittente updateDataCredenzialeMittente(ICredenzialeMittenteService credenzialeMittentiService, Date scadenzaEntry, CredenzialeMittente credenziale, StringBuilder sbConflict) throws Exception {
        long gestioneSerializableDB_AttesaAttiva = OpenSPCoop2Properties.getInstance().getGestioneSerializableDBAttesaAttiva();
        int gestioneSerializableDB_CheckInterval = OpenSPCoop2Properties.getInstance().getGestioneSerializableDBCheckInterval();
        long scadenzaWhile = DateManager.getTimeMillis() + gestioneSerializableDB_AttesaAttiva;
        Throwable lastT = null;
        while (DateManager.getTimeMillis() < scadenzaWhile) {
            CredenzialeMittente credenzialeMittente;
            int conflict = 0;
            SemaphoreLock lock = lockCredenzialiMittenteAggiornamento.acquire("updateDataCredenzialeMittente");
            try {
                CredenzialeMittente c = GestoreAutenticazione._updateDataCredenzialeMittente(credenzialeMittentiService, scadenzaEntry, credenziale);
                if (sbConflict != null) {
                    sbConflict.append(conflict);
                }
                credenzialeMittente = c;
            }
            catch (Throwable throwable) {
                try {
                    lockCredenzialiMittenteAggiornamento.release(lock, "updateDataCredenzialeMittente");
                    throw throwable;
                }
                catch (Throwable e) {
                    lastT = e;
                    ++conflict;
                    try {
                        Utilities.sleep((long)GestoreAutenticazione.getRandom().nextInt(gestioneSerializableDB_CheckInterval));
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            lockCredenzialiMittenteAggiornamento.release(lock, "updateDataCredenzialeMittente");
            return credenzialeMittente;
        }
        if (lastT != null) {
            throw new Exception("Aggiornamento credenziali non riuscito: " + lastT.getMessage(), lastT);
        }
        throw new Exception("Aggiornamento credenziali non riuscito");
    }

    private static CredenzialeMittente _updateDataCredenzialeMittente(ICredenzialeMittenteService credenzialeMittentiService, Date scadenzaEntry, CredenzialeMittente credenziale) throws Exception {
        IdCredenzialeMittente id = (IdCredenzialeMittente)credenzialeMittentiService.convertToId((Object)credenziale);
        CredenzialeMittente credenzialeCheck = (CredenzialeMittente)credenzialeMittentiService.get((Object)id);
        if (credenziale.getOraRegistrazione().after(scadenzaEntry)) {
            return credenzialeCheck;
        }
        credenzialeCheck.setOraRegistrazione(DateManager.getDate());
        credenzialeMittentiService.update((Object)id, (Object)credenzialeCheck);
        return credenzialeCheck;
    }
}

