/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pa;

import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneUtils;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazione;
import org.openspcoop2.pdd.core.autenticazione.ParametriAutenticazioneBasic;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pa.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.crypt.CryptConfig;

public class AutenticazioneBasic
extends AbstractAutenticazioneBase {
    protected boolean cleanHeaderAuthorization = true;
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public void initParametri(ParametriAutenticazione parametri) throws AutenticazioneException {
        super.initParametri(parametri);
        ParametriAutenticazioneBasic authBasic = new ParametriAutenticazioneBasic(this.parametri);
        BooleanNullable cleanNullable = authBasic.getCleanHeaderAuthorization();
        if (cleanNullable != null && cleanNullable.getValue() != null) {
            this.cleanHeaderAuthorization = cleanNullable.getValue();
        }
    }

    @Override
    public EsitoAutenticazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        Credenziali credenziali = datiInvocazione.getInfoConnettoreIngresso().getCredenziali();
        String user = credenziali.getUsername();
        String password = credenziali.getPassword();
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        CryptConfig cryptConfigApplicativi = op2Properties.getCryptConfigAutenticazioneApplicativi();
        CryptConfig cryptConfigSoggetti = op2Properties.getCryptConfigAutenticazioneSoggetti();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazioneBasicWWWAuthenticateConfig();
        if (user == null || "".equals(user) || password == null || "".equals(password)) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        esito.setCredential(user);
        IDSoggetto idSoggetto = null;
        try {
            idSoggetto = RegistroServiziManager.getInstance((IState)datiInvocazione.getState()).getIdSoggettoByCredenzialiBasic(user, password, cryptConfigSoggetti, null);
        }
        catch (DriverRegistroServiziNotFound notFound) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("AutenticazioneBasic (Soggetti) non ha trovato risultati", (Throwable)notFound);
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneBasic (Soggetti) non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            if (idSoggetto == null && this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && (idServizioApplicativo = ConfigurazionePdDManager.getInstance(datiInvocazione.getState()).getIdServizioApplicativoByCredenzialiBasic(user, password, cryptConfigApplicativi)) != null && idSoggetto == null) {
                idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneBasic (Applicativi) non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idSoggetto == null) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
            }
            return esito;
        }
        esito.setClientAuthenticated(true);
        esito.setClientIdentified(true);
        esito.setIdSoggetto(idSoggetto);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }

    @Override
    public void cleanPostAuth(OpenSPCoop2Message message) throws AutenticazioneException {
        AutenticazioneUtils.finalizeProcessHeaderAuthorization(message, this.cleanHeaderAuthorization);
    }
}

