/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autenticazione.pa;

import java.security.cert.CertStore;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.autenticazione.AutenticazioneException;
import org.openspcoop2.pdd.core.autenticazione.WWWAuthenticateConfig;
import org.openspcoop2.pdd.core.autenticazione.pa.AbstractAutenticazioneBase;
import org.openspcoop2.pdd.core.autenticazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autenticazione.pa.EsitoAutenticazionePortaApplicativa;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.transport.http.OCSPResponseException;

public class AutenticazioneSsl
extends AbstractAutenticazioneBase {
    private boolean logError = true;

    @Override
    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    @Override
    public EsitoAutenticazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) throws AutenticazioneException {
        EsitoAutenticazionePortaApplicativa esito = new EsitoAutenticazionePortaApplicativa();
        if (datiInvocazione == null) {
            throw new AutenticazioneException("Param datiInvocazione is null");
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        WWWAuthenticateConfig wwwAuthenticateConfig = op2Properties.getRealmAutenticazioneHttpsWWWAuthenticateConfig();
        Credenziali credenziali = datiInvocazione.getInfoConnettoreIngresso().getCredenziali();
        RequestInfo requestInfo = datiInvocazione.getRequestInfo();
        String subject = credenziali.getSubject();
        String issuer = credenziali.getIssuer();
        CertificateInfo certificate = null;
        if (subject == null || "".equals(subject)) {
            esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_CREDENTIALS_NOT_FOUND, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            if (wwwAuthenticateConfig != null) {
                esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_notFound());
            }
            return esito;
        }
        if (credenziali.getCertificate() != null) {
            GestoreOCSPValidator ocspValidator;
            block64: {
                CertStore trustStoreCertificatiX509crls;
                KeyStore trustStoreCertificatiX509;
                boolean checkValid;
                block63: {
                    certificate = credenziali.getCertificate().getCertificate();
                    List proprieta = null;
                    if (datiInvocazione.getPa() != null) {
                        proprieta = datiInvocazione.getPa().getProprietaList();
                    } else if (datiInvocazione.getPd() != null) {
                        proprieta = datiInvocazione.getPd().getProprietaList();
                    }
                    checkValid = false;
                    boolean trustStore = false;
                    trustStoreCertificatiX509 = null;
                    trustStoreCertificatiX509crls = null;
                    ocspValidator = null;
                    try {
                        checkValid = CostantiProprieta.isAutenticazioneHttpsValidityCheck(proprieta, op2Properties.isAutenticazioneHttpsPortaApplicativaValidityCheck());
                        trustStore = CostantiProprieta.isAutenticazioneHttpsTrustStore(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststorePath());
                        if (!trustStore) break block63;
                        String path = CostantiProprieta.getAutenticazioneHttpsTrustStorePath(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststorePath());
                        if (path != null) {
                            try {
                                String password = CostantiProprieta.getAutenticazioneHttpsTrustStorePassword(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststorePassword());
                                String type = CostantiProprieta.getAutenticazioneHttpsTrustStoreType(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststoreType());
                                trustStoreCertificatiX509 = GestoreKeystoreCaching.getMerlinTruststore(requestInfo, path, type, password).getTrustStore();
                            }
                            catch (Exception e) {
                                throw new CoreException("Errore durante la lettura del truststore indicato (" + path + "): " + e.getMessage());
                            }
                        }
                        if (trustStoreCertificatiX509 == null) break block63;
                        String crl = CostantiProprieta.getAutenticazioneHttpsTrustStoreCRLs(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststoreCRLs());
                        boolean crlByOcsp = false;
                        String ocspPolicy = CostantiProprieta.getAutenticazioneHttpsTrustStoreOCSPPolicy(proprieta, op2Properties.getAutenticazioneHttpsPortaApplicativaTruststoreOCSPPolicy());
                        if (ocspPolicy != null) {
                            GestoreOCSPValidator gOcspValidator;
                            LoggerBuffer lb = new LoggerBuffer();
                            lb.setLogDebug(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                            lb.setLogError(OpenSPCoop2Logger.getLoggerOpenSPCoopCore());
                            GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                            try {
                                ocspValidator = new GestoreOCSPValidator(requestInfo, lb, trustStoreCertificatiX509, crl, ocspPolicy, (IOCSPResourceReader)ocspResourceReader);
                            }
                            catch (Exception e) {
                                throw new CoreException("Errore durante l'inizializzazione del gestore della policy OCSP (" + ocspPolicy + "): " + e.getMessage());
                            }
                            if (ocspValidator != null && (gOcspValidator = ocspValidator).getOcspConfig() != null) {
                                crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                            }
                        }
                        if (crl == null || crlByOcsp) break block63;
                        try {
                            trustStoreCertificatiX509crls = GestoreKeystoreCaching.getCRLCertstore(requestInfo, crl).getCertStore();
                        }
                        catch (Exception e) {
                            throw new CoreException("Errore durante la lettura delle CRLs (" + crl + "): " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        if (this.logError) {
                            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneSsl non riuscita", (Throwable)e);
                        }
                        esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
                        esito.setClientIdentified(false);
                        esito.setEccezioneProcessamento(e);
                        return esito;
                    }
                }
                if (checkValid && trustStoreCertificatiX509crls == null) {
                    try {
                        certificate.checkValid();
                    }
                    catch (Exception e) {
                        esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCredenzialiForniteNonCorrette(e.getMessage()));
                        esito.setClientAuthenticated(false);
                        esito.setClientIdentified(false);
                        if (wwwAuthenticateConfig != null) {
                            esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                        }
                        return esito;
                    }
                }
                if (trustStoreCertificatiX509 != null) {
                    try {
                        if (!certificate.isVerified(trustStoreCertificatiX509, true)) {
                            throw new CoreException("Certificato non verificabile rispetto alle CA conosciute");
                        }
                        if (trustStoreCertificatiX509crls == null) break block64;
                        try {
                            certificate.checkValid(trustStoreCertificatiX509crls, trustStoreCertificatiX509);
                        }
                        catch (Throwable t) {
                            throw new CoreException("Certificato non valido: " + t.getMessage());
                        }
                    }
                    catch (Exception e) {
                        esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCredenzialiForniteNonCorrette(e.getMessage()));
                        esito.setClientAuthenticated(false);
                        esito.setClientIdentified(false);
                        if (wwwAuthenticateConfig != null) {
                            esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                        }
                        return esito;
                    }
                }
            }
            if (ocspValidator != null) {
                try {
                    ocspValidator.valid(certificate.getCertificate());
                }
                catch (Throwable t) {
                    esito.setErroreCooperazione(IntegrationFunctionError.AUTHENTICATION_INVALID_CREDENTIALS, ErroriCooperazione.AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.getErroreCredenzialiForniteNonCorrette(t.getMessage()));
                    esito.setClientAuthenticated(false);
                    esito.setClientIdentified(false);
                    if (!(t instanceof OCSPResponseException)) {
                        esito.setNoCache(true);
                    }
                    if (wwwAuthenticateConfig != null) {
                        esito.setWwwAuthenticateErrorHeader(wwwAuthenticateConfig.buildWWWAuthenticateHeaderValue_invalid());
                    }
                    return esito;
                }
            }
        }
        esito.setClientAuthenticated(true);
        esito.setCredential(subject);
        IDSoggetto idSoggetto = null;
        try {
            RegistroServiziManager registroServiziManager = RegistroServiziManager.getInstance((IState)datiInvocazione.getState());
            ArrayList<DriverRegistroServiziNotFound> notFoundExceptions = new ArrayList<DriverRegistroServiziNotFound>();
            if (certificate != null) {
                try {
                    idSoggetto = registroServiziManager.getIdSoggettoByCredenzialiSsl(certificate, true, null);
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    notFoundExceptions.add(notFound);
                }
            }
            if (idSoggetto == null && certificate != null) {
                try {
                    idSoggetto = registroServiziManager.getIdSoggettoByCredenzialiSsl(certificate, false, null);
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    notFoundExceptions.add(notFound);
                }
            }
            if (idSoggetto == null) {
                try {
                    idSoggetto = registroServiziManager.getIdSoggettoByCredenzialiSsl(subject, issuer, null);
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    notFoundExceptions.add(notFound);
                }
            }
            if (idSoggetto == null) {
                try {
                    idSoggetto = registroServiziManager.getIdSoggettoByCredenzialiSsl(subject, null, null);
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    notFoundExceptions.add(notFound);
                }
            }
            if (idSoggetto == null && !notFoundExceptions.isEmpty()) {
                throw new UtilsMultiException(notFoundExceptions.toArray(new Throwable[1]));
            }
        }
        catch (UtilsMultiException notFound) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().debug("AutenticazioneSsl non ha trovato risultati", (Throwable)notFound);
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneSsl non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        IDServizioApplicativo idServizioApplicativo = null;
        try {
            if (idSoggetto == null && this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && !"modipa".equals(this.getProtocolFactory().getProtocol())) {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                ConfigurazioneFiltroServiziApplicativi filtroHttps = ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps();
                if (certificate != null) {
                    idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, true, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
                }
                if (idServizioApplicativo == null && certificate != null) {
                    idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(certificate, false, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
                }
                if (idServizioApplicativo == null) {
                    idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, issuer, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
                }
                if (idServizioApplicativo == null) {
                    idServizioApplicativo = configurazionePdDManager.getIdServizioApplicativoByCredenzialiSsl(subject, null, (List<String>)filtroHttps.getTipiSoggetti(), filtroHttps.isIncludiApplicativiNonModI(), filtroHttps.isIncludiApplicativiModIEsterni(), filtroHttps.isIncludiApplicativiModIInterni());
                }
                if (idServizioApplicativo != null && idSoggetto == null) {
                    idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
                }
            }
        }
        catch (Exception e) {
            if (this.logError) {
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("AutenticazioneSsl (Applicativi) non riuscita", (Throwable)e);
            }
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione());
            esito.setClientAuthenticated(false);
            esito.setClientIdentified(false);
            esito.setEccezioneProcessamento(e);
            return esito;
        }
        if (idSoggetto == null) {
            esito.setClientIdentified(false);
            return esito;
        }
        esito.setClientIdentified(true);
        esito.setIdSoggetto(idSoggetto);
        esito.setIdServizioApplicativo(idServizioApplicativo);
        return esito;
    }
}

