/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Scope;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.RuoloTipologia;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.utils.WWWAuthenticateErrorCode;
import org.openspcoop2.message.utils.WWWAuthenticateGenerator;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.dynamic.PddPluginLoader;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.EsitoAutorizzazione;
import org.openspcoop2.pdd.core.autorizzazione.pa.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazioneContenutoPortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.IAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazioneContenutoPortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.IAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.token.Costanti;
import org.openspcoop2.pdd.core.token.InformazioniToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.constants.RuoloBusta;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class GestoreAutorizzazione {
    private static final String AUTORIZZAZIONE_CACHE_NAME = "autorizzazione";
    private static Cache cacheAutorizzazione = null;
    private static final Map<String, Semaphore> _lockAutorizzazionePD = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockAutorizzazionePA = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockAutorizzazioneContenutiPD = new HashMap<String, Semaphore>();
    private static final Map<String, Semaphore> _lockAutorizzazioneContenutiPA = new HashMap<String, Semaphore>();
    private static Logger logger = null;
    private static Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
    private static final String ATTRIBUTE_AUTHORITY_PREFIX = "aa.";
    private static final String ATTRIBUTE_PREFIX = "attribute.";

    private static synchronized Semaphore initLockAutorizzazionePD(String tipoAutorizzazione) {
        Semaphore s = _lockAutorizzazionePD.get(tipoAutorizzazione);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneLockPermits(tipoAutorizzazione);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutorizzazioneFruizioni_" + tipoAutorizzazione, permits.intValue()) : new Semaphore("GestoreAutorizzazioneFruizioni_" + tipoAutorizzazione);
            _lockAutorizzazionePD.put(tipoAutorizzazione, s);
        }
        return s;
    }

    private static Semaphore getLockAutorizzazionePD(String tipoAutorizzazione) {
        Semaphore s = _lockAutorizzazionePD.get(tipoAutorizzazione);
        if (s == null) {
            s = GestoreAutorizzazione.initLockAutorizzazionePD(tipoAutorizzazione);
        }
        return s;
    }

    private static synchronized Semaphore initLockAutorizzazionePA(String tipoAutorizzazione) {
        Semaphore s = _lockAutorizzazionePA.get(tipoAutorizzazione);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneLockPermits(tipoAutorizzazione);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutorizzazioneErogazioni_" + tipoAutorizzazione, permits.intValue()) : new Semaphore("GestoreAutorizzazioneErogazioni_" + tipoAutorizzazione);
            _lockAutorizzazionePA.put(tipoAutorizzazione, s);
        }
        return s;
    }

    private static Semaphore getLockAutorizzazionePA(String tipoAutorizzazione) {
        Semaphore s = _lockAutorizzazionePA.get(tipoAutorizzazione);
        if (s == null) {
            s = GestoreAutorizzazione.initLockAutorizzazionePA(tipoAutorizzazione);
        }
        return s;
    }

    private static synchronized Semaphore initLockAutorizzazioneContenutiPD(String tipoAutorizzazioneContenuti) {
        Semaphore s = _lockAutorizzazioneContenutiPD.get(tipoAutorizzazioneContenuti);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneContenutiLockPermits(tipoAutorizzazioneContenuti);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneContenutiLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutorizzazioneContenutiFruizioni_" + tipoAutorizzazioneContenuti, permits.intValue()) : new Semaphore("GestoreAutorizzazioneContenutiFruizioni_" + tipoAutorizzazioneContenuti);
            _lockAutorizzazioneContenutiPD.put(tipoAutorizzazioneContenuti, s);
        }
        return s;
    }

    private static Semaphore getLockAutorizzazioneContenutiPD(String tipoAutorizzazioneContenuti) {
        Semaphore s = _lockAutorizzazioneContenutiPD.get(tipoAutorizzazioneContenuti);
        if (s == null) {
            s = GestoreAutorizzazione.initLockAutorizzazioneContenutiPD(tipoAutorizzazioneContenuti);
        }
        return s;
    }

    private static synchronized Semaphore initLockAutorizzazioneContenutiPA(String tipoAutorizzazioneContenuti) {
        Semaphore s = _lockAutorizzazioneContenutiPA.get(tipoAutorizzazioneContenuti);
        if (s == null) {
            Integer permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneContenutiLockPermits(tipoAutorizzazioneContenuti);
            if (permits == null) {
                permits = OpenSPCoop2Properties.getInstance().getAutorizzazioneContenutiLockPermits();
            }
            s = permits != null && permits > 1 ? new Semaphore("GestoreAutorizzazioneContenutiErogazioni_" + tipoAutorizzazioneContenuti, permits.intValue()) : new Semaphore("GestoreAutorizzazioneContenutiErogazioni_" + tipoAutorizzazioneContenuti);
            _lockAutorizzazioneContenutiPA.put(tipoAutorizzazioneContenuti, s);
        }
        return s;
    }

    private static Semaphore getLockAutorizzazioneContenutiPA(String tipoAutorizzazioneContenuti) {
        Semaphore s = _lockAutorizzazioneContenutiPA.get(tipoAutorizzazioneContenuti);
        if (s == null) {
            s = GestoreAutorizzazione.initLockAutorizzazioneContenutiPA(tipoAutorizzazioneContenuti);
        }
        return s;
    }

    public static void resetCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                cacheAutorizzazione.clear();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws AutorizzazioneException {
        try {
            if (cacheAutorizzazione != null) {
                return cacheAutorizzazione.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Visualizzazione Statistiche riguardante la cache delle autorizzazioni non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        GestoreAutorizzazione._abilitaCache();
    }

    private static synchronized void _abilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione == null) {
            try {
                cacheAutorizzazione = new Cache(CacheType.JCS, AUTORIZZAZIONE_CACHE_NAME);
                cacheAutorizzazione.build();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            throw new AutorizzazioneException("Cache gia' abilitata");
        }
        try {
            int dimensioneCacheInt = -1;
            if (dimensioneCache != null) {
                dimensioneCacheInt = dimensioneCache.intValue();
            }
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU != null ? (algoritmoCacheLRU.booleanValue() ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString()) : CostantiConfigurazione.CACHE_LRU.toString();
            long itemIdleTimeLong = -1L;
            if (itemIdleTime != null) {
                itemIdleTimeLong = itemIdleTime;
            }
            long itemLifeSecondLong = -1L;
            if (itemLifeSecond != null) {
                itemLifeSecondLong = itemLifeSecond;
            }
            GestoreAutorizzazione.initCacheAutorizzazione(CacheType.JCS, dimensioneCacheInt, algoritmoCache, itemIdleTimeLong, itemLifeSecondLong, null);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione == null) {
            throw new AutorizzazioneException("Cache gia' disabilitata");
        }
        GestoreAutorizzazione._disabilitaCache();
    }

    private static synchronized void _disabilitaCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                cacheAutorizzazione.clear();
                cacheAutorizzazione = null;
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheAutorizzazione != null;
    }

    public static String listKeysCache(String separator) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                return cacheAutorizzazione.printKeys(separator);
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static List<String> listKeysCache() throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                return cacheAutorizzazione.keys();
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                Object o = cacheAutorizzazione.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static Object getRawObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                Object o = cacheAutorizzazione.get(key);
                if (o != null) {
                    if (o instanceof CacheResponse) {
                        CacheResponse cR = (CacheResponse)o;
                        if (cR.getObject() != null) {
                            o = cR.getObject();
                        } else if (cR.getException() != null) {
                            o = cR.getException();
                        }
                    }
                    return o;
                }
                return null;
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        }
        throw new AutorizzazioneException("Cache non abilitata");
    }

    public static void removeObjectCache(String key) throws AutorizzazioneException {
        if (cacheAutorizzazione != null) {
            try {
                cacheAutorizzazione.remove(key);
            }
            catch (Exception e) {
                throw new AutorizzazioneException(e.getMessage(), e);
            }
        } else {
            throw new AutorizzazioneException("Cache non abilitata");
        }
    }

    public static void initialize(Logger log) throws Exception {
        GestoreAutorizzazione.initialize(null, false, -1, null, -1L, -1L, log);
    }

    public static void initialize(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        GestoreAutorizzazione.initialize(cacheType, true, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
    }

    private static void initialize(CacheType cacheType, boolean cacheAbilitata, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        logger = log;
        if (cacheAbilitata) {
            GestoreAutorizzazione.initCacheAutorizzazione(cacheType, dimensioneCache, algoritmoCache, idleTime, itemLifeSecond, log);
        }
    }

    public static void initCacheAutorizzazione(CacheType cacheType, int dimensioneCache, String algoritmoCache, long idleTime, long itemLifeSecond, Logger log) throws Exception {
        String msg;
        if (log != null) {
            log.info("Inizializzazione cache Autorizzazione");
        }
        cacheAutorizzazione = new Cache(cacheType, AUTORIZZAZIONE_CACHE_NAME);
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Autorizzazione) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info(msg);
                    }
                    logConsole.info(msg);
                    cacheAutorizzazione.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new AutorizzazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage(), error);
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Autorizzazione) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheAutorizzazione.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheAutorizzazione.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (idleTime > 0L) {
            try {
                msg = "Attributo 'IdleTime' (Autorizzazione) impostato al valore: " + idleTime;
                if (log != null) {
                    log.info(msg);
                }
                logConsole.info(msg);
                cacheAutorizzazione.setItemIdleTime(idleTime);
            }
            catch (Exception error) {
                throw new AutorizzazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage(), error);
            }
        }
        try {
            msg = "Attributo 'MaxLifeSecond' (Autorizzazione) impostato al valore: " + itemLifeSecond;
            if (log != null) {
                log.info(msg);
            }
            logConsole.info(msg);
            cacheAutorizzazione.setItemLifeTime(itemLifeSecond);
        }
        catch (Exception error) {
            throw new AutorizzazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage(), error);
        }
        cacheAutorizzazione.build();
    }

    @Deprecated
    public static void disableSyncronizedGet() throws UtilsException {
        if (cacheAutorizzazione == null) {
            throw new UtilsException("Cache disabled");
        }
        cacheAutorizzazione.disableSyncronizedGet();
    }

    @Deprecated
    public static boolean isDisableSyncronizedGet() throws UtilsException {
        if (cacheAutorizzazione == null) {
            throw new UtilsException("Cache disabled");
        }
        return cacheAutorizzazione.isDisableSyncronizedGet();
    }

    public static void removePortaApplicativa(IDPortaApplicativa idPA) throws Exception {
        if (GestoreAutorizzazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutorizzazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String match = "PA:" + idPA.getNome() + " ";
                for (String key : keys) {
                    if (key == null || !key.contains(match)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutorizzazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removePortaDelegata(IDPortaDelegata idPD) throws Exception {
        if (GestoreAutorizzazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutorizzazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String match = "PD:" + idPD.getNome() + " ";
                for (String key : keys) {
                    if (key == null || !key.contains(match)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutorizzazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeSoggetto(IDSoggetto idSoggetto) throws Exception {
        if (GestoreAutorizzazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutorizzazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String matchSoggettoFruitore = " IDSoggettoFruitore(" + idSoggetto.toString() + ")";
                for (String key : keys) {
                    if (key == null || !key.contains(matchSoggettoFruitore)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutorizzazione.removeObjectCache(key);
                }
            }
        }
    }

    public static void removeApplicativo(IDServizioApplicativo idApplicativo) throws Exception {
        if (GestoreAutorizzazione.isCacheAbilitata()) {
            ArrayList<String> keyForClean = new ArrayList<String>();
            List<String> keys = GestoreAutorizzazione.listKeysCache();
            if (keys != null && !keys.isEmpty()) {
                String matchApplicativoFruitore = " IDServizioApplicativoFruitore(" + idApplicativo.toString() + ")";
                String matchApplicativo = " IDServizioApplicativo(" + idApplicativo.toString() + ")";
                for (String key : keys) {
                    if (key == null || !key.contains(matchApplicativoFruitore) && !key.contains(matchApplicativo)) continue;
                    keyForClean.add(key);
                }
            }
            if (keyForClean != null && !keyForClean.isEmpty()) {
                for (String key : keyForClean) {
                    GestoreAutorizzazione.removeObjectCache(key);
                }
            }
        }
    }

    public static EsitoAutorizzazionePortaDelegata verificaAutorizzazionePortaDelegata(String tipoAutorizzazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg, Logger log) throws Exception {
        EsitoAutorizzazionePortaDelegata esitoNew;
        EsitoAutorizzazionePortaDelegata esitoNew2;
        GestoreAutorizzazione.checkDatiPortaDelegata(datiInvocazione);
        EsitoAutorizzazionePortaDelegata esito = GestoreAutorizzazione._verificaAutorizzazionePortaDelegata(tipoAutorizzazione, datiInvocazione, pddContext, protocolFactory, msg);
        if (!esito.isAutorizzato()) {
            return esito;
        }
        boolean verificaAutorizzazioneRichiedenti = false;
        boolean verificaAutorizzazioneRuoli = false;
        if (datiInvocazione.getPd() != null && datiInvocazione.getPd().getAutorizzazioneToken() != null) {
            if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                verificaAutorizzazioneRichiedenti = true;
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                verificaAutorizzazioneRuoli = true;
            }
        }
        IDServizioApplicativo idSAToken = null;
        if (pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN)) {
            idSAToken = (IDServizioApplicativo)pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN);
        }
        boolean authRichiedenti = true;
        if (verificaAutorizzazioneRichiedenti) {
            authRichiedenti = false;
            if (idSAToken != null && datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi() != null && datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                for (PortaDelegataServizioApplicativo sa : datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                    if (!idSAToken.getNome().equals(sa.getNome())) continue;
                    authRichiedenti = true;
                    break;
                }
            }
        }
        boolean authRuoli = true;
        StringBuilder detailsBufferRuoli = null;
        if (verificaAutorizzazioneRuoli) {
            boolean checkRuoloRegistro = false;
            boolean checkRuoloEsterno = false;
            if (datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli() == null || RuoloTipologia.QUALSIASI.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                checkRuoloRegistro = true;
                checkRuoloEsterno = true;
            } else if (RuoloTipologia.INTERNO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                checkRuoloRegistro = true;
            } else if (RuoloTipologia.ESTERNO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                checkRuoloEsterno = true;
            }
            detailsBufferRuoli = new StringBuilder();
            ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
            ServizioApplicativo sa = null;
            if (idSAToken != null) {
                sa = configurazionePdDManager.getServizioApplicativo(idSAToken, datiInvocazione.getRequestInfo());
            }
            authRuoli = configurazionePdDManager.autorizzazioneTokenRoles(datiInvocazione.getPd(), sa, datiInvocazione.getInfoConnettoreIngresso(), pddContext, datiInvocazione.getRequestInfo(), checkRuoloRegistro, checkRuoloEsterno, detailsBufferRuoli);
        }
        if (verificaAutorizzazioneRichiedenti && verificaAutorizzazioneRuoli) {
            if (!authRichiedenti && !authRuoli) {
                EsitoAutorizzazionePortaDelegata esitoNew3 = esito;
                if (idSAToken != null) {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(idSAToken.getNome()));
                } else {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA_ANONIMO.getErrore404_AutorizzazioneFallitaServizioApplicativoAnonimo());
                }
                esito.setAutorizzato(false);
                if (detailsBufferRuoli.length() > 0) {
                    esito.setDetails(detailsBufferRuoli.toString());
                }
                return esitoNew3;
            }
        } else {
            if (verificaAutorizzazioneRichiedenti && !authRichiedenti) {
                EsitoAutorizzazionePortaDelegata esitoNew4 = esito;
                esitoNew4.setAutorizzato(false);
                esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(idSAToken != null ? idSAToken.getNome() : "Anonimo"));
                return esitoNew4;
            }
            if (verificaAutorizzazioneRuoli && !authRuoli) {
                EsitoAutorizzazionePortaDelegata esitoNew5 = esito;
                if (idSAToken != null) {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(idSAToken.getNome()));
                } else {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA_ANONIMO.getErrore404_AutorizzazioneFallitaServizioApplicativoAnonimo());
                }
                esito.setAutorizzato(false);
                if (detailsBufferRuoli.length() > 0) {
                    esito.setDetails(detailsBufferRuoli.toString());
                }
                return esitoNew5;
            }
        }
        AutorizzazioneScope authScope = null;
        if (datiInvocazione.getPd() != null) {
            authScope = datiInvocazione.getPd().getScope();
        }
        if (authScope != null && authScope.sizeScopeList() > 0 && !(esitoNew2 = (EsitoAutorizzazionePortaDelegata)GestoreAutorizzazione.autorizzazioneScope(authScope, esito, pddContext, datiInvocazione)).isAutorizzato()) {
            esitoNew2.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_SCOPE, ErroriIntegrazione.ERRORE_445_TOKEN_AUTORIZZAZIONE_FALLITA.getErroreIntegrazione());
            return esitoNew2;
        }
        if (datiInvocazione.getPd() != null && datiInvocazione.getPd().getGestioneToken() != null && datiInvocazione.getPd().getGestioneToken().getOptions() != null && !(esitoNew = (EsitoAutorizzazionePortaDelegata)GestoreAutorizzazione.autorizzazioneTokenOptions(datiInvocazione.getPd().getGestioneToken().getOptions(), esito, pddContext, datiInvocazione, log, msg)).isAutorizzato()) {
            esitoNew.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_TOKEN_DENY, ErroriIntegrazione.ERRORE_445_TOKEN_AUTORIZZAZIONE_FALLITA.getErroreIntegrazione());
            return esitoNew;
        }
        return esito;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EsitoAutorizzazionePortaDelegata _verificaAutorizzazionePortaDelegata(String tipoAutorizzazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        IAutorizzazionePortaDelegata auth = GestoreAutorizzazione.newInstanceAuthPortaDelegata(tipoAutorizzazione, pddContext, protocolFactory);
        try {
            if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
                EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = auth.process(datiInvocazione);
                return esitoAutorizzazionePortaDelegata;
            }
            String keyCache = GestoreAutorizzazione.buildCacheKey(true, tipoAutorizzazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthorizationResultInCache(datiInvocazione));
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    EsitoAutorizzazionePortaDelegata esito = (EsitoAutorizzazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
                    return esitoAutorizzazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutorizzazionePD = GestoreAutorizzazione.getLockAutorizzazionePD(tipoAutorizzazione);
            SemaphoreLock lock = lockAutorizzazionePD.acquire("verificaAutorizzazionePortaDelegata", idTransazione);
            response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    EsitoAutorizzazionePortaDelegata esito = (EsitoAutorizzazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
                    return esitoAutorizzazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) ricerco nella configurazione...");
            EsitoAutorizzazionePortaDelegata esito = auth.process(datiInvocazione);
            if (esito == null) throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaDelegata.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutorizzazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
            return esitoAutorizzazionePortaDelegata;
            finally {
                lockAutorizzazionePD.release(lock, "verificaAutorizzazionePortaDelegata", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    public static EsitoAutorizzazionePortaApplicativa verificaAutorizzazionePortaApplicativa(String tipoAutorizzazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg, Logger log) throws Exception {
        EsitoAutorizzazionePortaApplicativa esitoNew;
        EsitoAutorizzazionePortaApplicativa esitoNew2;
        GestoreAutorizzazione.checkDatiPortaApplicativa(datiInvocazione);
        EsitoAutorizzazionePortaApplicativa esito = GestoreAutorizzazione._verificaAutorizzazionePortaApplicativa(tipoAutorizzazione, datiInvocazione, pddContext, protocolFactory, msg);
        if (!esito.isAutorizzato()) {
            return esito;
        }
        boolean skipProfiloModi = false;
        if (protocolFactory != null && "modipa".equals(protocolFactory.getProtocol())) {
            skipProfiloModi = true;
        }
        if (!skipProfiloModi) {
            boolean verificaAutorizzazioneRichiedenti = false;
            boolean verificaAutorizzazioneRuoli = false;
            if (datiInvocazione.getPa() != null) {
                if (datiInvocazione.getPa().getAutorizzazioneToken() != null) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPa().getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                        verificaAutorizzazioneRichiedenti = true;
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPa().getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                        verificaAutorizzazioneRuoli = true;
                    }
                }
            } else if (datiInvocazione.getPd() != null && datiInvocazione.getPd().getAutorizzazioneToken() != null) {
                if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                    verificaAutorizzazioneRichiedenti = true;
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getAutorizzazioneRuoli())) {
                    verificaAutorizzazioneRuoli = true;
                }
            }
            IDServizioApplicativo idSAToken = null;
            if (pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN)) {
                idSAToken = (IDServizioApplicativo)pddContext.getObject(org.openspcoop2.core.constants.Costanti.ID_APPLICATIVO_TOKEN);
            }
            boolean authRichiedenti = true;
            if (datiInvocazione.getPa() != null) {
                if (verificaAutorizzazioneRichiedenti) {
                    authRichiedenti = false;
                    if (idSAToken != null && datiInvocazione.getPa().getAutorizzazioneToken().getServiziApplicativi() != null && datiInvocazione.getPa().getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        for (PortaApplicativaAutorizzazioneServizioApplicativo sa : datiInvocazione.getPa().getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                            if (!idSAToken.getNome().equals(sa.getNome()) || !idSAToken.getIdSoggettoProprietario().getTipo().equals(sa.getTipoSoggettoProprietario()) || !idSAToken.getIdSoggettoProprietario().getNome().equals(sa.getNomeSoggettoProprietario())) continue;
                            authRichiedenti = true;
                            break;
                        }
                    }
                }
            } else if (datiInvocazione.getPd() != null && verificaAutorizzazioneRichiedenti) {
                authRichiedenti = false;
                if (idSAToken != null && datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi() != null && datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                    for (PortaApplicativaAutorizzazioneServizioApplicativo sa : datiInvocazione.getPd().getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativoList()) {
                        if (!idSAToken.getNome().equals(sa.getNome())) continue;
                        authRichiedenti = true;
                        break;
                    }
                }
            }
            boolean authRuoli = true;
            StringBuilder detailsBufferRuoli = null;
            if (datiInvocazione.getPa() != null) {
                if (verificaAutorizzazioneRuoli) {
                    checkRuoloRegistro = false;
                    checkRuoloEsterno = false;
                    if (datiInvocazione.getPa().getAutorizzazioneToken().getTipologiaRuoli() == null || RuoloTipologia.QUALSIASI.equals((Object)datiInvocazione.getPa().getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloRegistro = true;
                        checkRuoloEsterno = true;
                    } else if (RuoloTipologia.INTERNO.equals((Object)datiInvocazione.getPa().getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloRegistro = true;
                    } else if (RuoloTipologia.ESTERNO.equals((Object)datiInvocazione.getPa().getAutorizzazioneToken().getTipologiaRuoli())) {
                        checkRuoloEsterno = true;
                    }
                    detailsBufferRuoli = new StringBuilder();
                    configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                    ServizioApplicativo sa = null;
                    if (idSAToken != null) {
                        sa = configurazionePdDManager.getServizioApplicativo(idSAToken, datiInvocazione.getRequestInfo());
                    }
                    authRuoli = configurazionePdDManager.autorizzazioneTokenRoles(datiInvocazione.getPa(), sa, datiInvocazione.getInfoConnettoreIngresso(), pddContext, datiInvocazione.getRequestInfo(), checkRuoloRegistro, checkRuoloEsterno, detailsBufferRuoli);
                }
            } else if (datiInvocazione.getPd() != null && verificaAutorizzazioneRuoli) {
                checkRuoloRegistro = false;
                checkRuoloEsterno = false;
                if (datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli() == null || RuoloTipologia.QUALSIASI.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                    checkRuoloRegistro = true;
                    checkRuoloEsterno = true;
                } else if (RuoloTipologia.INTERNO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                    checkRuoloRegistro = true;
                } else if (RuoloTipologia.ESTERNO.equals((Object)datiInvocazione.getPd().getAutorizzazioneToken().getTipologiaRuoli())) {
                    checkRuoloEsterno = true;
                }
                detailsBufferRuoli = new StringBuilder();
                configurazionePdDManager = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
                ServizioApplicativo sa = null;
                if (idSAToken != null) {
                    sa = configurazionePdDManager.getServizioApplicativo(idSAToken, datiInvocazione.getRequestInfo());
                }
                authRuoli = configurazionePdDManager.autorizzazioneTokenRoles(datiInvocazione.getPd(), sa, datiInvocazione.getInfoConnettoreIngresso(), pddContext, datiInvocazione.getRequestInfo(), checkRuoloRegistro, checkRuoloEsterno, detailsBufferRuoli);
            }
            if (verificaAutorizzazioneRichiedenti && verificaAutorizzazioneRuoli) {
                if (!authRichiedenti && !authRuoli) {
                    EsitoAutorizzazionePortaApplicativa esitoNew3 = esito;
                    String errore = "";
                    esitoNew3.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                    esitoNew3.setAutorizzato(false);
                    if (detailsBufferRuoli.length() > 0) {
                        esitoNew3.setDetails(detailsBufferRuoli.toString());
                    }
                    return esitoNew3;
                }
            } else {
                if (verificaAutorizzazioneRichiedenti && !authRichiedenti) {
                    EsitoAutorizzazionePortaApplicativa esitoNew4 = esito;
                    esitoNew4.setAutorizzato(false);
                    IDServizio idServizio = datiInvocazione.getIdServizio();
                    Object errore = AbstractAutorizzazioneBase.getErrorString(idSAToken, null, idServizio);
                    if (esitoNew4.getDetails() != null) {
                        errore = (String)errore + " (" + esitoNew4.getDetails() + ")";
                    }
                    esitoNew4.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                    return esitoNew4;
                }
                if (verificaAutorizzazioneRuoli && !authRuoli) {
                    EsitoAutorizzazionePortaApplicativa esitoNew5 = esito;
                    String errore = "";
                    esitoNew5.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                    esitoNew5.setAutorizzato(false);
                    if (detailsBufferRuoli.length() > 0) {
                        esitoNew5.setDetails(detailsBufferRuoli.toString());
                    }
                    return esitoNew5;
                }
            }
        }
        AutorizzazioneScope authScope = null;
        if (datiInvocazione.getPa() != null) {
            authScope = datiInvocazione.getPa().getScope();
        } else if (datiInvocazione.getPd() != null) {
            authScope = datiInvocazione.getPd().getScope();
        }
        if (authScope != null && authScope.sizeScopeList() > 0 && !(esitoNew2 = (EsitoAutorizzazionePortaApplicativa)GestoreAutorizzazione.autorizzazioneScope(authScope, esito, pddContext, datiInvocazione)).isAutorizzato()) {
            esitoNew2.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_MISSING_SCOPE, ErroriCooperazione.TOKEN_AUTORIZZAZIONE_FALLITA.getErroreCooperazione());
            return esitoNew2;
        }
        String tokenOptions = null;
        if (datiInvocazione.getPa() != null) {
            if (datiInvocazione.getPa().getGestioneToken() != null) {
                tokenOptions = datiInvocazione.getPa().getGestioneToken().getOptions();
            }
        } else if (datiInvocazione.getPd() != null && datiInvocazione.getPd().getGestioneToken() != null) {
            tokenOptions = datiInvocazione.getPd().getGestioneToken().getOptions();
        }
        if (tokenOptions != null && !(esitoNew = (EsitoAutorizzazionePortaApplicativa)GestoreAutorizzazione.autorizzazioneTokenOptions(tokenOptions, esito, pddContext, datiInvocazione, log, msg)).isAutorizzato()) {
            esitoNew.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_TOKEN_DENY, ErroriCooperazione.TOKEN_AUTORIZZAZIONE_FALLITA.getErroreCooperazione());
            return esitoNew;
        }
        return esito;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EsitoAutorizzazionePortaApplicativa _verificaAutorizzazionePortaApplicativa(String tipoAutorizzazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        IAutorizzazionePortaApplicativa auth = GestoreAutorizzazione.newInstanceAuthPortaApplicativa(tipoAutorizzazione, pddContext, protocolFactory);
        try {
            if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
                EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = auth.process(datiInvocazione);
                return esitoAutorizzazionePortaApplicativa;
            }
            String keyCache = GestoreAutorizzazione.buildCacheKey(false, tipoAutorizzazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthorizationResultInCache(datiInvocazione));
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    EsitoAutorizzazionePortaApplicativa esito = (EsitoAutorizzazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
                    return esitoAutorizzazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutorizzazionePA = GestoreAutorizzazione.getLockAutorizzazionePA(tipoAutorizzazione);
            SemaphoreLock lock = lockAutorizzazionePA.acquire("verificaAutorizzazionePortaApplicativa", idTransazione);
            response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    EsitoAutorizzazionePortaApplicativa esito = (EsitoAutorizzazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
                    return esitoAutorizzazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) ricerco nella configurazione...");
            EsitoAutorizzazionePortaApplicativa esito = auth.process(datiInvocazione);
            if (esito == null) throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaApplicativa.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutorizzazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
            return esitoAutorizzazionePortaApplicativa;
            finally {
                lockAutorizzazionePA.release(lock, "verificaAutorizzazionePortaApplicativa", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    private static void checkDatiPortaDelegata(DatiInvocazionePortaDelegata datiInvocazione) throws AutorizzazioneException {
        IDServizio idServizio = datiInvocazione.getIdServizio();
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipo() == null || idServizio.getNome() == null || idServizio.getVersione() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        IDPortaDelegata idPD = datiInvocazione.getIdPD();
        if (idPD == null) {
            throw new AutorizzazioneException("(Parametri) IDPortaDelegata non definito");
        }
        if (idPD.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDPortaDelegata.nome non definito");
        }
        PortaDelegata pd = datiInvocazione.getPd();
        if (pd == null) {
            throw new AutorizzazioneException("(Parametri) PortaDelegata non definito");
        }
        IDServizioApplicativo idSA = datiInvocazione.getIdServizioApplicativo();
        if (idSA == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo non definito");
        }
        if (idSA.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo.nome non definito");
        }
        IDSoggetto idSoggettoProprietario = idSA.getIdSoggettoProprietario();
        if (idSoggettoProprietario == null || idSoggettoProprietario.getTipo() == null || idSoggettoProprietario.getNome() == null) {
            throw new AutorizzazioneException("(Parametri) IDServizioApplicativo.Soggetto non definito");
        }
    }

    private static void checkDatiPortaApplicativa(DatiInvocazionePortaApplicativa datiInvocazione) throws AutorizzazioneException {
        IDServizio idServizio = datiInvocazione.getIdServizio();
        if (idServizio == null) {
            throw new AutorizzazioneException("(Parametri) IDServizio non definito");
        }
        if (idServizio.getTipo() == null || idServizio.getNome() == null || idServizio.getVersione() == null) {
            throw new AutorizzazioneException("(Parametri) Servizio non definito");
        }
        if (idServizio.getSoggettoErogatore() == null || idServizio.getSoggettoErogatore().getTipo() == null || idServizio.getSoggettoErogatore().getNome() == null) {
            throw new AutorizzazioneException("(Parametri) Soggetto erogatore non definito");
        }
        RuoloBusta ruolo = datiInvocazione.getRuoloBusta();
        if (ruolo == null) {
            throw new AutorizzazioneException("(Parametri) RuoloBusta non definito");
        }
    }

    private static String buildCacheKey(boolean portaDelegata, String tipoAutorizzazione, String keyCache, String suffixKeyCache) throws AutorizzazioneException {
        StringBuilder bf = new StringBuilder();
        if (portaDelegata) {
            bf.append("PD ");
        } else {
            bf.append("PA ");
        }
        bf.append(" Auth:").append(tipoAutorizzazione).append(" ");
        bf.append(keyCache);
        if (suffixKeyCache != null && !"".equals(suffixKeyCache)) {
            bf.append(" ");
            bf.append(suffixKeyCache);
        }
        return bf.toString();
    }

    private static IAutorizzazionePortaDelegata newInstanceAuthPortaDelegata(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutorizzazioneException {
        IAutorizzazionePortaDelegata auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutorizzazionePortaDelegata(tipoAutorizzazione);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autorizzazione della fruizione: " + e.getMessage(), e);
        }
    }

    private static IAutorizzazionePortaApplicativa newInstanceAuthPortaApplicativa(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutorizzazioneException {
        IAutorizzazionePortaApplicativa auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutorizzazionePortaApplicativa(tipoAutorizzazione);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autorizzazione della erogazione: " + e.getMessage(), e);
        }
    }

    private static EsitoAutorizzazione autorizzazioneScope(AutorizzazioneScope authScope, EsitoAutorizzazione esito, PdDContext pddContext, AbstractDatiInvocazione datiInvocazione) throws Exception {
        if (authScope != null && authScope.sizeScopeList() > 0) {
            InformazioniToken informazioniTokenNormalizzate = null;
            Object oInformazioniTokenNormalizzate = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
            if (oInformazioniTokenNormalizzate != null) {
                informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
            }
            boolean autorizzato = true;
            Object errorMessage = null;
            if (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getScopes() == null || informazioniTokenNormalizzate.getScopes().size() <= 0) {
                errorMessage = "Token without scopes";
                autorizzato = false;
            } else {
                boolean foundAlmostOne = false;
                for (Scope scope : authScope.getScopeList()) {
                    org.openspcoop2.core.registry.Scope scopeOp2Registry = RegistroServiziManager.getInstance((IState)datiInvocazione.getState()).getScope(scope.getNome(), null, datiInvocazione.getRequestInfo());
                    String nomeScope = scopeOp2Registry.getNome();
                    if (scopeOp2Registry.getNomeEsterno() != null && !"".equals(scopeOp2Registry.getNomeEsterno())) {
                        nomeScope = scopeOp2Registry.getNomeEsterno();
                    }
                    if (!informazioniTokenNormalizzate.getScopes().contains(nomeScope)) {
                        if (!ScopeTipoMatch.ALL.equals((Object)authScope.getMatch())) continue;
                        autorizzato = false;
                        errorMessage = "Scope '" + nomeScope + "' not found";
                        break;
                    }
                    foundAlmostOne = true;
                }
                if (!foundAlmostOne) {
                    autorizzato = false;
                    errorMessage = "Scopes not found";
                }
            }
            if (!autorizzato) {
                String realm = "OpenSPCoop";
                Object oRealm = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_REALM);
                if (oRealm != null) {
                    realm = (String)oRealm;
                }
                boolean emptyMessage = false;
                Object oEmptyMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_BODY_EMPTY);
                if (oEmptyMessage != null) {
                    emptyMessage = (Boolean)oEmptyMessage;
                }
                boolean genericMessage = false;
                Object oGenericMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_GENERIC_MESSAGE);
                if (oGenericMessage != null) {
                    genericMessage = (Boolean)oGenericMessage;
                }
                if (genericMessage) {
                    esito.setDetails((String)errorMessage);
                }
                String[] scopes = new String[authScope.sizeScopeList()];
                for (int i = 0; i < authScope.sizeScopeList(); ++i) {
                    org.openspcoop2.core.registry.Scope scopeOp2Registry = RegistroServiziManager.getInstance((IState)datiInvocazione.getState()).getScope(authScope.getScope(i).getNome(), null, datiInvocazione.getRequestInfo());
                    String nomeScope = scopeOp2Registry.getNome();
                    if (scopeOp2Registry.getNomeEsterno() != null) {
                        nomeScope = scopeOp2Registry.getNomeEsterno();
                    }
                    scopes[i] = nomeScope;
                }
                esito.setAutorizzato(false);
                if (emptyMessage) {
                    esito.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, (String)errorMessage, (String[])scopes));
                } else {
                    esito.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, (String)errorMessage, (String[])scopes));
                }
            }
        }
        return esito;
    }

    private static EsitoAutorizzazione autorizzazioneTokenOptions(String tokenOptions, EsitoAutorizzazione esito, PdDContext pddContext, AbstractDatiInvocazione datiInvocazione, Logger log, OpenSPCoop2Message message) throws Exception {
        SortedMap properties;
        boolean autorizzato = true;
        Object errorMessage = null;
        if (tokenOptions != null && (properties = PropertiesUtilities.convertTextToSortedListMap((String)tokenOptions)) != null && properties.size() > 0) {
            InformazioniToken informazioniTokenNormalizzate = null;
            Object oInformazioniTokenNormalizzate = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_INFORMAZIONI_NORMALIZZATE);
            if (oInformazioniTokenNormalizzate != null) {
                informazioniTokenNormalizzate = (InformazioniToken)oInformazioniTokenNormalizzate;
            }
            if (informazioniTokenNormalizzate == null || informazioniTokenNormalizzate.getClaims() == null || informazioniTokenNormalizzate.getClaims().size() <= 0) {
                autorizzato = false;
                errorMessage = "Token without claims";
            } else {
                boolean bufferMessageReadOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
                Map<String, Object> dynamicMap = DynamicUtils.buildDynamicMap(message, pddContext, datiInvocazione.getBusta(), log, bufferMessageReadOnly);
                List keys = properties.keys();
                block2: for (String key : keys) {
                    List expectedValues = (List)properties.get(key);
                    if (expectedValues == null || expectedValues.isEmpty()) continue;
                    for (String expectedValue : expectedValues) {
                        boolean ok;
                        String nomeClaimAttribute;
                        String attributeAuthorityName = null;
                        String attributeName = null;
                        boolean findAttribute = false;
                        Serializable valueAttributeObject = null;
                        log.debug("Verifico presenza '" + key + "' nel token ...");
                        if (!informazioniTokenNormalizzate.getClaims().containsKey(key)) {
                            if (key.startsWith(ATTRIBUTE_AUTHORITY_PREFIX) && key.length() > ATTRIBUTE_AUTHORITY_PREFIX.length()) {
                                int indexOf;
                                String tmp = key.substring(ATTRIBUTE_AUTHORITY_PREFIX.length());
                                if (tmp != null && tmp.contains(".") && (indexOf = tmp.indexOf(".")) > 0 && indexOf < tmp.length()) {
                                    attributeAuthorityName = tmp.substring(0, indexOf);
                                    if ((tmp = tmp.substring(indexOf)).startsWith(".attribute.") && tmp.length() > ".attribute.".length() && (indexOf = tmp.indexOf(".", 1)) > 0 && indexOf < tmp.length() && (attributeName = tmp.substring(indexOf)).startsWith(".") && attributeName.length() > 1) {
                                        attributeName = attributeName.substring(1);
                                    }
                                }
                            } else if (key.startsWith(ATTRIBUTE_PREFIX) && key.length() > ATTRIBUTE_PREFIX.length()) {
                                attributeName = key.substring(ATTRIBUTE_PREFIX.length());
                            }
                            if (attributeAuthorityName != null && attributeName != null) {
                                Map map;
                                Serializable o;
                                if (informazioniTokenNormalizzate.getAa() != null && informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities() != null && informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities().getValue() != null && informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities().getValue().booleanValue() && informazioniTokenNormalizzate.getAa().getAttributes() != null && informazioniTokenNormalizzate.getAa().getAttributes().containsKey(attributeAuthorityName) && (o = informazioniTokenNormalizzate.getAa().getAttributes().get(attributeAuthorityName)) instanceof Map && (map = (Map)((Object)o)).containsKey(attributeName)) {
                                    findAttribute = true;
                                    valueAttributeObject = map.get(attributeName);
                                }
                            } else if (attributeName != null && informazioniTokenNormalizzate.getAa() != null && (informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities() == null || informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities().getValue() == null || !informazioniTokenNormalizzate.getAa().isMultipleAttributeAuthorities().getValue().booleanValue()) && informazioniTokenNormalizzate.getAa().getAttributes() != null && informazioniTokenNormalizzate.getAa().getAttributes().containsKey(attributeName)) {
                                findAttribute = true;
                                valueAttributeObject = informazioniTokenNormalizzate.getAa().getAttributes().get(attributeName);
                            }
                            if (!findAttribute) {
                                if ("${undefined}".equalsIgnoreCase(expectedValue)) continue;
                                autorizzato = false;
                                if (attributeName != null) {
                                    errorMessage = "Token without attribute '" + key + "'";
                                    continue block2;
                                }
                                errorMessage = "Token without claim '" + key + "'";
                                continue block2;
                            }
                        }
                        List<String> lClaimValues = null;
                        if (findAttribute && valueAttributeObject != null) {
                            lClaimValues = TokenUtilities.getClaimValues(valueAttributeObject);
                        } else {
                            Serializable valueClaimObject = informazioniTokenNormalizzate.getClaims().get(key);
                            lClaimValues = TokenUtilities.getClaimValues(valueClaimObject);
                        }
                        String string = nomeClaimAttribute = attributeName != null ? attributeName : key;
                        if (lClaimValues == null || lClaimValues.isEmpty()) {
                            if ("${undefined}".equalsIgnoreCase(expectedValue)) continue;
                            autorizzato = false;
                            if (attributeName != null) {
                                errorMessage = "Token with attribute '" + nomeClaimAttribute + "' without value";
                                continue block2;
                            }
                            errorMessage = "Token with claim '" + nomeClaimAttribute + "' without value";
                            continue block2;
                        }
                        String object = attributeName != null ? "Attribute" : "Claim";
                        log.debug("Verifico valore '" + expectedValue + "' per " + object.toLowerCase() + " '" + nomeClaimAttribute + "' nel token ...");
                        if (expectedValue == null) {
                            throw new Exception(object + " '" + nomeClaimAttribute + "' without expected value");
                        }
                        if ("${anyValue}".equalsIgnoreCase(expectedValue = expectedValue.trim())) {
                            log.debug("Verifico valore " + object.toLowerCase() + " '" + nomeClaimAttribute + "' che non sia null e non sia vuoto ...");
                            ok = false;
                            for (String v : lClaimValues) {
                                if (v == null || "".equals(v)) continue;
                                ok = true;
                                break;
                            }
                            if (ok) continue;
                            autorizzato = false;
                            errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' with unexpected empty value";
                            continue block2;
                        }
                        if ("${undefined}".equalsIgnoreCase(expectedValue)) {
                            log.debug("Verifico valore " + object.toLowerCase() + " '" + nomeClaimAttribute + "' sia null o sia vuoto ...");
                            ok = false;
                            for (String v : lClaimValues) {
                                if (v == null || "".equals(v)) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) continue;
                            autorizzato = false;
                            errorMessage = "Token unexpected " + object.toLowerCase() + " '" + nomeClaimAttribute + "'";
                            continue block2;
                        }
                        if ((expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpFind:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotFind:".toLowerCase())) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                            String tipo;
                            boolean match = expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase());
                            boolean not = expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotFind:".toLowerCase());
                            String regexpPattern = null;
                            if (match) {
                                length = -1;
                                length = expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) ? "${regExpMatch:".length() : "${regExpNotMatch:".length();
                                if (expectedValue.length() <= length + "}".length()) {
                                    throw new Exception(object + " '" + nomeClaimAttribute + "' without expected regexp match");
                                }
                                regexpPattern = expectedValue.substring(length, expectedValue.length() - "}".length());
                            } else {
                                length = -1;
                                length = expectedValue.toLowerCase().startsWith("${regExpFind:".toLowerCase()) ? "${regExpFind:".length() : "${regExpNotFind:".length();
                                if (expectedValue.length() <= length + "}".length()) {
                                    throw new Exception(object + " '" + nomeClaimAttribute + "' without expected regexp find");
                                }
                                regexpPattern = expectedValue.substring(length, expectedValue.length() - "}".length());
                            }
                            regexpPattern = regexpPattern.trim();
                            log.debug("Verifico valore del " + object.toLowerCase() + " '" + nomeClaimAttribute + "' tramite espressione regolare (match:" + match + ") '" + regexpPattern + "' ...");
                            boolean ok2 = false;
                            for (String v : lClaimValues) {
                                if (!(match ? RegularExpressionEngine.isMatch((String)v, (String)regexpPattern) : RegularExpressionEngine.isFind((String)v, (String)regexpPattern))) continue;
                                ok2 = true;
                                break;
                            }
                            if (not) {
                                if (!ok2) continue;
                                autorizzato = false;
                                tipo = match ? "match" : "find";
                                errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' with unexpected value (regExpr not " + tipo + " failed)";
                                continue block2;
                            }
                            if (ok2) continue;
                            autorizzato = false;
                            tipo = match ? "match" : "find";
                            errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' with unexpected value (regExpr " + tipo + " failed)";
                            continue block2;
                        }
                        boolean not = false;
                        if (expectedValue.toLowerCase().startsWith("${not:".toLowerCase()) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                            not = true;
                            if (expectedValue.length() <= "${not:".length() + "}".length()) {
                                throw new Exception(object + " '" + nomeClaimAttribute + "' without value in not condition");
                            }
                            expectedValue = expectedValue.substring("${not:".length(), expectedValue.length() - "}".length());
                        }
                        boolean ignoreCase = false;
                        if (expectedValue.toLowerCase().startsWith("${ignoreCase:".toLowerCase()) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                            ignoreCase = true;
                            if (expectedValue.length() <= "${ignoreCase:".length() + "}".length()) {
                                throw new Exception(object + " '" + nomeClaimAttribute + "' without value in ignore case condition");
                            }
                            expectedValue = expectedValue.substring("${ignoreCase:".length(), expectedValue.length() - "}".length());
                        }
                        try {
                            expectedValue = DynamicUtils.convertDynamicPropertyValue(key, expectedValue, dynamicMap, pddContext);
                        }
                        catch (Exception e) {
                            String msg = "Conversione valore per " + object.toLowerCase() + " '" + nomeClaimAttribute + "' non riuscita (valore: " + expectedValue + "): " + e.getMessage();
                            log.error(msg, (Throwable)e);
                            autorizzato = false;
                            errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' not verifiable; unprocessable dynamic value '" + expectedValue + "': " + e.getMessage();
                            continue block2;
                        }
                        boolean ok3 = false;
                        if (expectedValue.contains(",")) {
                            String[] values = expectedValue.split(",");
                            ok3 = false;
                            for (int i = 0; i < values.length; ++i) {
                                String v;
                                v = values[i].trim();
                                if (ignoreCase) {
                                    boolean find = false;
                                    for (String claim : lClaimValues) {
                                        if (!claim.equalsIgnoreCase(v)) continue;
                                        find = true;
                                        break;
                                    }
                                    if (!find) continue;
                                    ok3 = true;
                                } else {
                                    if (!lClaimValues.contains(v)) continue;
                                    ok3 = true;
                                }
                                break;
                            }
                        } else if (ignoreCase) {
                            boolean find = false;
                            for (String claim : lClaimValues) {
                                if (!claim.equalsIgnoreCase(expectedValue)) continue;
                                find = true;
                                break;
                            }
                            ok3 = find;
                        } else {
                            ok3 = lClaimValues.contains(expectedValue);
                        }
                        if (not) {
                            if (!ok3) continue;
                            autorizzato = false;
                            errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' with unauthorized value";
                            continue block2;
                        }
                        if (ok3) continue;
                        autorizzato = false;
                        errorMessage = "Token " + object.toLowerCase() + " '" + nomeClaimAttribute + "' with unexpected value";
                        continue block2;
                    }
                }
            }
        }
        if (!autorizzato) {
            String realm = "GovWay";
            Object oRealm = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_REALM);
            if (oRealm != null) {
                realm = (String)oRealm;
            }
            boolean emptyMessage = false;
            Object oEmptyMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_BODY_EMPTY);
            if (oEmptyMessage != null) {
                emptyMessage = (Boolean)oEmptyMessage;
            }
            boolean genericMessage = false;
            Object oGenericMessage = pddContext.getObject(Costanti.PDD_CONTEXT_TOKEN_MESSAGE_ERROR_GENERIC_MESSAGE);
            if (oGenericMessage != null) {
                genericMessage = (Boolean)oGenericMessage;
            }
            if (genericMessage) {
                esito.setDetails((String)errorMessage);
            }
            esito.setAutorizzato(false);
            if (emptyMessage) {
                esito.setErrorMessage(WWWAuthenticateGenerator.buildErrorMessage((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, (String)errorMessage, (String[])new String[0]));
            } else {
                esito.setWwwAuthenticateErrorHeader(WWWAuthenticateGenerator.buildHeaderValue((WWWAuthenticateErrorCode)WWWAuthenticateErrorCode.insufficient_scope, (String)realm, (boolean)genericMessage, (String)errorMessage, (String[])new String[0]));
            }
        }
        return esito;
    }

    public static EsitoAutorizzazionePortaDelegata verificaAutorizzazioneContenutoPortaDelegata(String tipoAutorizzazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg, Logger log) throws Exception {
        GestoreAutorizzazione.checkDatiPortaDelegataAuthContenuto(datiInvocazione, msg);
        EsitoAutorizzazionePortaDelegata esito = GestoreAutorizzazione._verificaAutorizzazioneContenutoPortaDelegata(tipoAutorizzazione, datiInvocazione, pddContext, protocolFactory, msg);
        if (!esito.isAutorizzato()) {
            return esito;
        }
        return esito;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EsitoAutorizzazionePortaDelegata _verificaAutorizzazioneContenutoPortaDelegata(String tipoAutorizzazione, DatiInvocazionePortaDelegata datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        IAutorizzazioneContenutoPortaDelegata auth = GestoreAutorizzazione.newInstanceAuthContenutoPortaDelegata(tipoAutorizzazione, pddContext, protocolFactory);
        try {
            if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
                EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = auth.process(datiInvocazione, msg);
                return esitoAutorizzazionePortaDelegata;
            }
            String keyCache = GestoreAutorizzazione.buildCacheKeyContenuto(true, tipoAutorizzazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthorizationResultInCache(datiInvocazione, msg));
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    EsitoAutorizzazionePortaDelegata esito = (EsitoAutorizzazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
                    return esitoAutorizzazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutorizzazioneContenutiPD = GestoreAutorizzazione.getLockAutorizzazioneContenutiPD(tipoAutorizzazione);
            SemaphoreLock lock = lockAutorizzazioneContenutiPD.acquire("verificaAutorizzazioneContenutoPortaDelegata", idTransazione);
            response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    EsitoAutorizzazionePortaDelegata esito = (EsitoAutorizzazionePortaDelegata)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
                    return esitoAutorizzazionePortaDelegata;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaDelegata) ricerco nella configurazione...");
            EsitoAutorizzazionePortaDelegata esito = auth.process(datiInvocazione, msg);
            if (esito == null) throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaDelegata.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutorizzazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutorizzazionePortaDelegata esitoAutorizzazionePortaDelegata = esito;
            return esitoAutorizzazionePortaDelegata;
            finally {
                lockAutorizzazioneContenutiPD.release(lock, "verificaAutorizzazioneContenutoPortaDelegata", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    public static EsitoAutorizzazionePortaApplicativa verificaAutorizzazioneContenutoPortaApplicativa(String tipoAutorizzazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg, Logger log) throws Exception {
        GestoreAutorizzazione.checkDatiPortaApplicativaAuthContenuto(datiInvocazione, msg);
        EsitoAutorizzazionePortaApplicativa esito = GestoreAutorizzazione._verificaAutorizzazioneContenutoPortaApplicativa(tipoAutorizzazione, datiInvocazione, pddContext, protocolFactory, msg);
        if (!esito.isAutorizzato()) {
            return esito;
        }
        return esito;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EsitoAutorizzazionePortaApplicativa _verificaAutorizzazioneContenutoPortaApplicativa(String tipoAutorizzazione, DatiInvocazionePortaApplicativa datiInvocazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory, OpenSPCoop2Message msg) throws Exception {
        IAutorizzazioneContenutoPortaApplicativa auth = GestoreAutorizzazione.newInstanceAuthContenutoPortaApplicativa(tipoAutorizzazione, pddContext, protocolFactory);
        try {
            if (cacheAutorizzazione == null || !auth.saveAuthorizationResultInCache()) {
                EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = auth.process(datiInvocazione, msg);
                return esitoAutorizzazionePortaApplicativa;
            }
            String keyCache = GestoreAutorizzazione.buildCacheKeyContenuto(false, tipoAutorizzazione, datiInvocazione.getKeyCache(), auth.getSuffixKeyAuthorizationResultInCache(datiInvocazione, msg));
            CacheResponse response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    EsitoAutorizzazionePortaApplicativa esito = (EsitoAutorizzazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
                    return esitoAutorizzazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            String idTransazione = pddContext != null && pddContext.containsKey(org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE) ? PdDContext.getValue((MapKey<String>)org.openspcoop2.core.constants.Costanti.ID_TRANSAZIONE, pddContext) : null;
            Semaphore lockAutorizzazioneContenutiPA = GestoreAutorizzazione.getLockAutorizzazioneContenutiPA(tipoAutorizzazione);
            SemaphoreLock lock = lockAutorizzazioneContenutiPA.acquire("verificaAutorizzazioneContenutoPortaApplicativa", idTransazione);
            response = (CacheResponse)cacheAutorizzazione.get(keyCache);
            if (response != null) {
                if (response.getObject() != null) {
                    logger.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    EsitoAutorizzazionePortaApplicativa esito = (EsitoAutorizzazionePortaApplicativa)response.getObject();
                    esito.setEsitoPresenteInCache(true);
                    EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
                    return esitoAutorizzazionePortaApplicativa;
                }
                if (response.getException() != null) {
                    logger.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) in cache.");
                    throw (Exception)response.getException();
                }
                logger.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            logger.debug("oggetto con chiave [" + keyCache + "] (method:verificaAutorizzazionePortaApplicativa) ricerco nella configurazione...");
            EsitoAutorizzazionePortaApplicativa esito = auth.process(datiInvocazione, msg);
            if (esito == null) throw new AutorizzazioneException("Metodo (GestoreAutorizzazione.autorizzazionePortaApplicativa.process) ha ritornato un valore di esito null");
            if (!esito.isNoCache()) {
                logger.info("Aggiungo oggetto [" + keyCache + "] in cache");
                try {
                    CacheResponse responseCache = new CacheResponse();
                    responseCache.setObject((Serializable)esito);
                    cacheAutorizzazione.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    logger.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
            EsitoAutorizzazionePortaApplicativa esitoAutorizzazionePortaApplicativa = esito;
            return esitoAutorizzazionePortaApplicativa;
            finally {
                lockAutorizzazioneContenutiPA.release(lock, "verificaAutorizzazioneContenutoPortaApplicativa", idTransazione);
            }
        }
        finally {
            if (msg != null) {
                auth.cleanPostAuth(msg);
            }
        }
    }

    private static void checkDatiPortaDelegataAuthContenuto(DatiInvocazionePortaDelegata datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        GestoreAutorizzazione.checkDatiPortaDelegata(datiInvocazione);
    }

    private static void checkDatiPortaApplicativaAuthContenuto(DatiInvocazionePortaApplicativa datiInvocazione, OpenSPCoop2Message msg) throws AutorizzazioneException {
        GestoreAutorizzazione.checkDatiPortaApplicativa(datiInvocazione);
    }

    private static String buildCacheKeyContenuto(boolean portaDelegata, String tipoAutorizzazione, String keyCache, String suffixKeyCache) throws AutorizzazioneException {
        StringBuilder bf = new StringBuilder();
        if (portaDelegata) {
            bf.append("PD ");
        } else {
            bf.append("PA ");
        }
        bf.append(" AuthContenuti:").append(tipoAutorizzazione).append(" ");
        bf.append(keyCache);
        if (suffixKeyCache == null || "".equals(suffixKeyCache)) {
            throw new AutorizzazioneException("Per salvare in cache l'esito dell'autorizzazione sui contenuti \u00e8 richiesta la definizione di un suffisso per la chiave");
        }
        bf.append(" ");
        bf.append(suffixKeyCache);
        return bf.toString();
    }

    private static IAutorizzazioneContenutoPortaDelegata newInstanceAuthContenutoPortaDelegata(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutorizzazioneException {
        IAutorizzazioneContenutoPortaDelegata auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutorizzazioneContenutiPortaDelegata(tipoAutorizzazione);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autorizzazione dei contenuti della fruizione: " + e.getMessage(), e);
        }
    }

    private static IAutorizzazioneContenutoPortaApplicativa newInstanceAuthContenutoPortaApplicativa(String tipoAutorizzazione, PdDContext pddContext, IProtocolFactory<?> protocolFactory) throws AutorizzazioneException {
        IAutorizzazioneContenutoPortaApplicativa auth = null;
        try {
            PddPluginLoader pluginLoader = PddPluginLoader.getInstance();
            auth = pluginLoader.newAutorizzazioneContenutiPortaApplicativa(tipoAutorizzazione);
        }
        catch (Exception e) {
            throw new AutorizzazioneException(e.getMessage(), e);
        }
        String classType = null;
        try {
            classType = auth.getClass().getName();
            AbstractCore.init(auth, pddContext, protocolFactory, new Object[0]);
            return auth;
        }
        catch (Exception e) {
            throw new AutorizzazioneException("Riscontrato errore durante l'inizializzazione della classe [" + classType + "] che definisce l'autorizzazione dei contenuti della erogazione: " + e.getMessage(), e);
        }
    }
}

