/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.utils.ConfigUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.autorizzazione.AbstractDatiInvocazione;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class GestoreAutorizzazioneContenutiBuiltIn {
    private boolean autorizzato = true;
    private String errorMessage = null;

    public boolean isAutorizzato() {
        return this.autorizzato;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void process(OpenSPCoop2Message msg, AbstractDatiInvocazione datiInvocazione, PdDContext pddContext, List<Proprieta> regole) throws Exception {
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        boolean bufferMessage_readOnly = OpenSPCoop2Properties.getInstance().isReadByPathBufferEnabled();
        Map<String, Object> dynamicMap = DynamicUtils.buildDynamicMap(msg, pddContext, datiInvocazione.getBusta(), log, bufferMessage_readOnly);
        if (regole == null || regole.size() <= 0) {
            throw new Exception("Non sono state definite regole di autorizzazione contenuto");
        }
        SortedMap map = ConfigUtils.toSortedListMap(regole);
        if (map == null || map.isEmpty()) {
            throw new Exception("Non sono state definite regole di autorizzazione contenuto");
        }
        List keys = map.keys();
        block4: for (String risorsa : keys) {
            List expectedValues = (List)map.get(risorsa);
            if (expectedValues == null || expectedValues.isEmpty()) continue;
            for (String expectedValue : expectedValues) {
                String valoreRisorsa;
                block30: {
                    if (risorsa == null) {
                        throw new Exception("Trovata una regola di autorizzazione senza risorsa");
                    }
                    if ((risorsa = risorsa.trim()).startsWith("#")) continue;
                    if (expectedValue == null) {
                        throw new Exception("Trovata una regola di autorizzazione senza valore atteso");
                    }
                    expectedValue = expectedValue.trim();
                    valoreRisorsa = null;
                    try {
                        valoreRisorsa = DynamicUtils.convertDynamicPropertyValue(risorsa, risorsa, dynamicMap, pddContext);
                    }
                    catch (Exception e) {
                        String msgError = "Conversione valore della risorsa '" + risorsa + "' non riuscita: " + e.getMessage();
                        if ("${undefined}".equalsIgnoreCase(expectedValue)) break block30;
                        log.error(msgError, (Throwable)e);
                        this.autorizzato = false;
                        this.errorMessage = "Resource '" + risorsa + "' not verifiable; unprocessable dynamic value '" + expectedValue + "': " + e.getMessage();
                        continue block4;
                    }
                }
                if ("${anyValue}".equalsIgnoreCase(expectedValue)) {
                    log.debug("Verifico valore della risorsa '" + risorsa + "' non sia null e non sia vuoto ...");
                    if (valoreRisorsa != null && !"".equals(valoreRisorsa)) continue;
                    this.autorizzato = false;
                    this.errorMessage = "Resource '" + risorsa + "' with unexpected empty value";
                    continue block4;
                }
                if ("${undefined}".equalsIgnoreCase(expectedValue)) {
                    log.debug("Verifico valore della risorsa '" + risorsa + "' sia null o sia vuoto ...");
                    if (valoreRisorsa == null || "".equals(valoreRisorsa)) continue;
                    this.autorizzato = false;
                    this.errorMessage = "Unexpected resource '" + risorsa + "'";
                    continue block4;
                }
                if ((expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpFind:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotFind:".toLowerCase())) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                    boolean ok;
                    boolean match = expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase());
                    boolean not = expectedValue.toLowerCase().startsWith("${regExpNotMatch:".toLowerCase()) || expectedValue.toLowerCase().startsWith("${regExpNotFind:".toLowerCase());
                    String regexpPattern = null;
                    if (match) {
                        length = -1;
                        length = expectedValue.toLowerCase().startsWith("${regExpMatch:".toLowerCase()) ? "${regExpMatch:".length() : "${regExpNotMatch:".length();
                        if (expectedValue.length() <= length + "}".length()) {
                            throw new Exception("Resource '" + risorsa + "' configuration without expected regexp match");
                        }
                        regexpPattern = expectedValue.substring(length, expectedValue.length() - "}".length());
                    } else {
                        length = -1;
                        length = expectedValue.toLowerCase().startsWith("${regExpFind:".toLowerCase()) ? "${regExpFind:".length() : "${regExpNotFind:".length();
                        if (expectedValue.length() <= length + "}".length()) {
                            throw new Exception("Resource '" + risorsa + "' configuration without expected regexp find");
                        }
                        regexpPattern = expectedValue.substring(length, expectedValue.length() - "}".length());
                    }
                    regexpPattern = regexpPattern.trim();
                    log.debug("Verifico valore dela risorsa '" + risorsa + "' tramite espressione regolare (match:" + match + ") '" + regexpPattern + "' ...");
                    if (valoreRisorsa == null || StringUtils.isEmpty((CharSequence)valoreRisorsa)) {
                        this.autorizzato = false;
                        this.errorMessage = "Unable to locate the resource '" + risorsa + "' or the resource is empty.";
                        continue block4;
                    }
                    boolean bl = ok = match ? RegularExpressionEngine.isMatch((String)valoreRisorsa, (String)regexpPattern) : RegularExpressionEngine.isFind((String)valoreRisorsa, (String)regexpPattern);
                    if (not) {
                        if (!ok) continue;
                        String tipo = match ? "match" : "find";
                        this.autorizzato = false;
                        this.errorMessage = "Resource '" + risorsa + "' with unexpected value '" + valoreRisorsa + "' (regExpr not " + tipo + " failed)";
                        continue block4;
                    }
                    if (ok) continue;
                    String tipo = match ? "match" : "find";
                    this.autorizzato = false;
                    this.errorMessage = "Resource '" + risorsa + "' with unexpected value '" + valoreRisorsa + "' (regExpr " + tipo + " failed)";
                    continue block4;
                }
                boolean not = false;
                if (expectedValue.toLowerCase().startsWith("${not:".toLowerCase()) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                    not = true;
                    if (expectedValue.length() <= "${not:".length() + "}".length()) {
                        throw new Exception("Resource '" + risorsa + "' configuration without value in not condition");
                    }
                    expectedValue = expectedValue.substring("${not:".length(), expectedValue.length() - "}".length());
                }
                boolean ignoreCase = false;
                if (expectedValue.toLowerCase().startsWith("${ignoreCase:".toLowerCase()) && expectedValue.toLowerCase().endsWith("}".toLowerCase())) {
                    ignoreCase = true;
                    if (expectedValue.length() <= "${ignoreCase:".length() + "}".length()) {
                        throw new Exception("Resource '" + risorsa + "' configuration without value in ignore case condition");
                    }
                    expectedValue = expectedValue.substring("${ignoreCase:".length(), expectedValue.length() - "}".length());
                }
                try {
                    expectedValue = DynamicUtils.convertDynamicPropertyValue(risorsa, expectedValue, dynamicMap, pddContext);
                }
                catch (Exception e) {
                    String msgErrore = "Conversione valore per risorsa '" + risorsa + "' non riuscita (valore: " + expectedValue + "): " + e.getMessage();
                    log.error(msgErrore, (Throwable)e);
                    this.autorizzato = false;
                    this.errorMessage = "Resource '" + risorsa + "' not verifiable; unprocessable dynamic value '" + expectedValue + "': " + e.getMessage();
                    continue block4;
                }
                if (expectedValue != null) {
                    boolean ok = false;
                    if (expectedValue.contains(",")) {
                        String[] values = expectedValue.split(",");
                        for (int i = 0; i < values.length; ++i) {
                            String v = values[i].trim();
                            if (v == null) continue;
                            if (ignoreCase) {
                                if (!v.equalsIgnoreCase(valoreRisorsa)) continue;
                                ok = true;
                            } else {
                                if (!v.equals(valoreRisorsa)) continue;
                                ok = true;
                            }
                            break;
                        }
                    } else {
                        ok = ignoreCase ? expectedValue.equalsIgnoreCase(valoreRisorsa) : expectedValue.equals(valoreRisorsa);
                    }
                    if (not) {
                        if (!ok) continue;
                        this.autorizzato = false;
                        this.errorMessage = "Resource '" + risorsa + "' with unauthorized value '" + valoreRisorsa + "'";
                        continue block4;
                    }
                    if (ok) continue;
                    this.autorizzato = false;
                    this.errorMessage = "Resource '" + risorsa + "' with unexpected value '" + valoreRisorsa + "'";
                    continue block4;
                }
                if (valoreRisorsa == null) continue;
                this.autorizzato = false;
                this.errorMessage = "Resource '" + risorsa + "' with unexpected value; expected null value";
                continue block4;
            }
        }
    }
}

