/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.container;

import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import org.openspcoop2.pdd.core.autorizzazione.container.AutorizzazioneSecurityContainerPrincipal;
import org.openspcoop2.pdd.core.autorizzazione.container.IAutorizzazioneSecurityContainer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.WrappedHttpServletRequest;
import org.openspcoop2.utils.xacml.XacmlRequest;

public class AutorizzazioneHttpServletRequest
extends WrappedHttpServletRequest {
    private IAutorizzazioneSecurityContainer authEngine;

    public AutorizzazioneHttpServletRequest(HttpServletRequest httpServletRequest, IAutorizzazioneSecurityContainer authEngine) throws UtilsException {
        super(httpServletRequest);
        this.authEngine = authEngine;
    }

    public Principal getUserPrincipal() {
        String p = this.authEngine.getUserPrincipal();
        if (p != null) {
            return new AutorizzazioneSecurityContainerPrincipal(p);
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        return this.authEngine.isUserInRole(role);
    }

    public void fillXacmlRequest(XacmlRequest request) {
        this.authEngine.fillXacmlRequest(request);
    }
}

