/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pa;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziServizioNotFound;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.autorizzazione.pa.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pa.DatiInvocazionePortaApplicativa;
import org.openspcoop2.pdd.core.autorizzazione.pa.EsitoAutorizzazionePortaApplicativa;
import org.openspcoop2.pdd.core.credenziali.Credenziali;
import org.openspcoop2.protocol.registry.EsitoAutorizzazioneRegistro;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.IState;

public class AutorizzazioneAuthenticated
extends AbstractAutorizzazioneBase {
    @Override
    public EsitoAutorizzazionePortaApplicativa process(DatiInvocazionePortaApplicativa datiInvocazione) {
        EsitoAutorizzazionePortaApplicativa esito = new EsitoAutorizzazionePortaApplicativa();
        try {
            RegistroServiziManager reg = RegistroServiziManager.getInstance((IState)datiInvocazione.getState());
            ConfigurazionePdDManager config = ConfigurazionePdDManager.getInstance(datiInvocazione.getState());
            Credenziali credenzialiPdDMittente = datiInvocazione.getCredenzialiPdDMittente();
            String pdd = null;
            if (credenzialiPdDMittente != null && credenzialiPdDMittente.getSubject() != null) {
                pdd = credenzialiPdDMittente.getSubject();
            }
            IDServizioApplicativo idSA = null;
            String identitaServizioApplicativoFruitore = null;
            if (!"modipa".equals(this.getProtocolFactory().getProtocol())) {
                idSA = datiInvocazione.getIdentitaServizioApplicativoFruitore();
            }
            if (idSA != null) {
                identitaServizioApplicativoFruitore = idSA.getNome();
            }
            IDSoggetto idSoggetto = datiInvocazione.getIdSoggettoFruitore();
            if ("modipa".equals(this.getProtocolFactory().getProtocol()) && this.getPddContext() != null && this.getPddContext().containsKey(CostantiPdD.INTERMEDIARIO)) {
                idSoggetto = (IDSoggetto)this.getPddContext().get(CostantiPdD.INTERMEDIARIO);
            }
            IDServizio idServizio = datiInvocazione.getIdServizio();
            boolean autorizzazioneSoggettiMittenti = config.autorizzazione(datiInvocazione.getPa(), idSoggetto);
            boolean autorizzazioneApplicativiMittenti = false;
            if (this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni() && !"modipa".equals(this.getProtocolFactory().getProtocol())) {
                autorizzazioneApplicativiMittenti = config.autorizzazione(datiInvocazione.getPa(), datiInvocazione.getIdentitaServizioApplicativoFruitore());
            }
            if (!autorizzazioneSoggettiMittenti && !autorizzazioneApplicativiMittenti) {
                String errore = AbstractAutorizzazioneBase.getErrorString(idSA, idSoggetto, idServizio);
                esito.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setAutorizzato(false);
            } else {
                boolean isSupportoAutenticazioneSoggetti = this.getProtocolFactory().createProtocolConfiguration().isSupportoAutenticazioneSoggetti();
                boolean isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni = this.getProtocolFactory().createProtocolConfiguration().isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni();
                if (isSupportoAutenticazioneSoggetti && !isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni) {
                    esito.setAutorizzato(true);
                } else {
                    EsitoAutorizzazioneRegistro esitoAutorizzazione = reg.isFruitoreServizioAutorizzato(pdd, identitaServizioApplicativoFruitore, idSoggetto, idServizio);
                    if (!esitoAutorizzazione.isServizioAutorizzato()) {
                        Object errore = AbstractAutorizzazioneBase.getErrorString(idSA, idSoggetto, idServizio);
                        if (esitoAutorizzazione.getDetails() != null) {
                            errore = (String)errore + " (" + esitoAutorizzazione.getDetails() + ")";
                        }
                        esito.setErroreCooperazione(IntegrationFunctionError.AUTHORIZATION_DENY, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione((String)errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                        esito.setAutorizzato(false);
                    } else {
                        esito.setAutorizzato(true);
                        if (esitoAutorizzazione.getDetails() != null) {
                            esito.setDetails(esitoAutorizzazione.getDetails());
                        }
                    }
                }
            }
        }
        catch (DriverRegistroServiziServizioNotFound e) {
            esito.setErroreCooperazione(IntegrationFunctionError.NOT_FOUND, ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione("Errore durante il processo di autorizzazione (ServizioNotFound): " + e.getMessage()));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
        }
        catch (Exception e) {
            String errore = "Errore durante il processo di autorizzazione: " + e.getMessage();
            esito.setErroreCooperazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento(e);
        }
        return esito;
    }
}

