/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione.pd;

import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.core.autorizzazione.AutorizzazioneException;
import org.openspcoop2.pdd.core.autorizzazione.pd.AbstractAutorizzazioneBase;
import org.openspcoop2.pdd.core.autorizzazione.pd.DatiInvocazionePortaDelegata;
import org.openspcoop2.pdd.core.autorizzazione.pd.EsitoAutorizzazionePortaDelegata;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;

abstract class AbstractAutorizzazioneRoles
extends AbstractAutorizzazioneBase {
    private boolean checkRuoloRegistro;
    private boolean checkRuoloEsterno;
    private String nomeAutorizzazione;

    protected AbstractAutorizzazioneRoles(boolean checkRuoloRegistro, boolean checkRuoloEsterno, String nomeAutorizzazione) {
        this.checkRuoloRegistro = checkRuoloRegistro;
        this.checkRuoloEsterno = checkRuoloEsterno;
        this.nomeAutorizzazione = nomeAutorizzazione;
    }

    @Override
    public EsitoAutorizzazionePortaDelegata process(DatiInvocazionePortaDelegata datiInvocazione) throws AutorizzazioneException {
        EsitoAutorizzazionePortaDelegata esito = new EsitoAutorizzazionePortaDelegata();
        String servizioApplicativo = null;
        if (datiInvocazione.getIdServizioApplicativo() != null) {
            servizioApplicativo = datiInvocazione.getIdServizioApplicativo().getNome();
        }
        try {
            StringBuilder detailsBuffer = new StringBuilder();
            if (!ConfigurazionePdDManager.getInstance(datiInvocazione.getState()).autorizzazioneTrasportoRoles(datiInvocazione.getPd(), datiInvocazione.getServizioApplicativo(), datiInvocazione.getInfoConnettoreIngresso(), this.getPddContext(), datiInvocazione.getRequestInfo(), this.checkRuoloRegistro, this.checkRuoloEsterno, detailsBuffer)) {
                if (servizioApplicativo != null) {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(servizioApplicativo));
                } else {
                    esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativoAnonimo());
                }
                esito.setAutorizzato(false);
                if (detailsBuffer.length() > 0) {
                    esito.setDetails(detailsBuffer.toString());
                }
                return esito;
            }
        }
        catch (DriverConfigurazioneNotFound e) {
            if (servizioApplicativo != null) {
                esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativo(servizioApplicativo, e.getMessage()));
            } else {
                esito.setErroreIntegrazione(IntegrationFunctionError.AUTHORIZATION_MISSING_ROLE, ErroriIntegrazione.ERRORE_404_AUTORIZZAZIONE_FALLITA_SA.getErrore404_AutorizzazioneFallitaServizioApplicativoAnonimo(e.getMessage()));
            }
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
            return esito;
        }
        catch (DriverConfigurazioneException e) {
            OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("Autorizzazione " + this.nomeAutorizzazione + " non riuscita", (Throwable)e);
            esito.setErroreIntegrazione(IntegrationFunctionError.INTERNAL_REQUEST_ERROR, ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_536_CONFIGURAZIONE_NON_DISPONIBILE));
            esito.setAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
            return esito;
        }
        esito.setAutorizzato(true);
        return esito;
    }
}

