/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.load_balance.health_check;

import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.BehaviourPropertiesUtils;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.health_check.HealthCheckConfigurazione;
import org.slf4j.Logger;

public class HealthCheckUtils {
    public static HealthCheckConfigurazione read(PortaApplicativa pa, Logger log) throws BehaviourException {
        HealthCheckConfigurazione config = new HealthCheckConfigurazione();
        if (pa.getBehaviour() == null || pa.getBehaviour().sizeProprietaList() <= 0) {
            throw new BehaviourException("Configurazione sticky non disponibile");
        }
        for (Proprieta p : pa.getBehaviour().getProprietaList()) {
            String nome = p.getNome();
            String valore = p.getValore().trim();
            try {
                if ("passiveHealthCheck".equals(nome)) {
                    config.setPassiveCheckEnabled("true".equals(valore));
                    continue;
                }
                if (!"passiveHealthCheckExcludeForSeconds".equals(nome)) continue;
                config.setPassiveHealthCheck_excludeForSeconds(Integer.valueOf(valore));
            }
            catch (Exception e) {
                throw new BehaviourException("Configurazione health check non corretta (propriet\u00e0:" + p.getNome() + " valore:'" + p.getValore() + "'): " + e.getMessage(), e);
            }
        }
        return config;
    }

    public static void save(PortaApplicativa pa, HealthCheckConfigurazione configurazione) throws BehaviourException {
        if (pa.getBehaviour() == null) {
            throw new BehaviourException("Configurazione behaviour non abilitata");
        }
        if (configurazione == null) {
            throw new BehaviourException("Configurazione health check non fornita");
        }
        BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "passiveHealthCheck", "" + configurazione.isPassiveCheckEnabled());
        BehaviourPropertiesUtils.removeProprieta(pa.getBehaviour(), "passiveHealthCheckExcludeForSeconds");
        if (configurazione.isPassiveCheckEnabled() && configurazione.getPassiveHealthCheck_excludeForSeconds() != null && configurazione.getPassiveHealthCheck_excludeForSeconds() > 0) {
            BehaviourPropertiesUtils.addProprieta(pa.getBehaviour(), "passiveHealthCheckExcludeForSeconds", "" + configurazione.getPassiveHealthCheck_excludeForSeconds());
        }
    }
}

