/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver;

import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.GestioneErroreCodiceTrasporto;
import org.openspcoop2.core.config.GestioneErroreSoapFault;
import org.openspcoop2.core.config.constants.GestioneErroreComportamento;
import org.openspcoop2.pdd.core.behaviour.BehaviourException;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.ConfigurazioneGestioneConsegnaNotifiche;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.TipoGestioneNotificaFault;
import org.openspcoop2.pdd.core.behaviour.built_in.multi_deliver.TipoGestioneNotificaTrasporto;

public class GestioneConsegnaNotificheUtils {
    public static final String LABEL_CODE = "Code";
    public static final String LABEL_ACTOR = "Actor";
    public static final String LABEL_MESSAGE = "Message";
    public static final String LABEL_TYPE = "Type";
    public static final String LABEL_STATUS = "Status";
    public static final String LABEL_CLAIMS = "Claims";

    public static ConfigurazioneGestioneConsegnaNotifiche getGestioneDefault() throws BehaviourException {
        ConfigurazioneGestioneConsegnaNotifiche config = new ConfigurazioneGestioneConsegnaNotifiche();
        config.setGestioneTrasporto2xx(TipoGestioneNotificaTrasporto.CONSEGNA_COMPLETATA);
        config.setGestioneTrasporto3xx(TipoGestioneNotificaTrasporto.CONSEGNA_FALLITA);
        config.setGestioneTrasporto4xx(TipoGestioneNotificaTrasporto.CONSEGNA_FALLITA);
        config.setGestioneTrasporto5xx(TipoGestioneNotificaTrasporto.CONSEGNA_FALLITA);
        config.setFault(TipoGestioneNotificaFault.CONSEGNA_COMPLETATA);
        return config;
    }

    public static GestioneErrore toGestioneErrore(ConfigurazioneGestioneConsegnaNotifiche config) throws BehaviourException {
        Object codiceTrasporto;
        GestioneErroreCodiceTrasporto codiceTrasporto2;
        GestioneErroreCodiceTrasporto codiceTrasportoFallita;
        GestioneErroreCodiceTrasporto codiceTrasportoCompletata;
        GestioneErrore gestioneErrore = new GestioneErrore();
        gestioneErrore.setComportamento(GestioneErroreComportamento.RISPEDISCI);
        if (config.getCadenzaRispedizione() != null) {
            gestioneErrore.setCadenzaRispedizione("" + config.getCadenzaRispedizione());
        }
        if (config.getGestioneTrasporto2xx() != null) {
            switch (config.getGestioneTrasporto2xx()) {
                case CONSEGNA_COMPLETATA: {
                    codiceTrasportoCompletata = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoCompletata.setValoreMinimo(Integer.valueOf(200));
                    codiceTrasportoCompletata.setValoreMassimo(Integer.valueOf(299));
                    codiceTrasportoCompletata.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoCompletata);
                    break;
                }
                case CONSEGNA_FALLITA: {
                    codiceTrasportoFallita = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoFallita.setValoreMinimo(Integer.valueOf(200));
                    codiceTrasportoFallita.setValoreMassimo(Integer.valueOf(299));
                    codiceTrasportoFallita.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoFallita);
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto2xx_codes() == null || config.getGestioneTrasporto2xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 2xx) non fornita");
                    }
                    for (Integer code : config.getGestioneTrasporto2xx_codes()) {
                        codiceTrasporto2 = new GestioneErroreCodiceTrasporto();
                        codiceTrasporto2.setValoreMinimo(code);
                        codiceTrasporto2.setValoreMassimo(code);
                        codiceTrasporto2.setComportamento(GestioneErroreComportamento.ACCETTA);
                        gestioneErrore.addCodiceTrasporto(codiceTrasporto2);
                    }
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto2xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 2xx) non definito");
                    }
                    if (config.getGestioneTrasporto2xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 2xx) non definito");
                    }
                    codiceTrasporto = new GestioneErroreCodiceTrasporto();
                    codiceTrasporto.setValoreMinimo(config.getGestioneTrasporto2xx_leftInterval());
                    codiceTrasporto.setValoreMassimo(config.getGestioneTrasporto2xx_rightInterval());
                    codiceTrasporto.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto((GestioneErroreCodiceTrasporto)codiceTrasporto);
                }
            }
        }
        if (config.getGestioneTrasporto3xx() != null) {
            switch (config.getGestioneTrasporto3xx()) {
                case CONSEGNA_COMPLETATA: {
                    codiceTrasportoCompletata = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoCompletata.setValoreMinimo(Integer.valueOf(300));
                    codiceTrasportoCompletata.setValoreMassimo(Integer.valueOf(399));
                    codiceTrasportoCompletata.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoCompletata);
                    break;
                }
                case CONSEGNA_FALLITA: {
                    codiceTrasportoFallita = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoFallita.setValoreMinimo(Integer.valueOf(300));
                    codiceTrasportoFallita.setValoreMassimo(Integer.valueOf(399));
                    codiceTrasportoFallita.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoFallita);
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto3xx_codes() == null || config.getGestioneTrasporto3xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 3xx) non fornita");
                    }
                    for (Integer code : config.getGestioneTrasporto3xx_codes()) {
                        codiceTrasporto2 = new GestioneErroreCodiceTrasporto();
                        codiceTrasporto2.setValoreMinimo(code);
                        codiceTrasporto2.setValoreMassimo(code);
                        codiceTrasporto2.setComportamento(GestioneErroreComportamento.ACCETTA);
                        gestioneErrore.addCodiceTrasporto(codiceTrasporto2);
                    }
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto3xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 3xx) non definito");
                    }
                    if (config.getGestioneTrasporto3xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 3xx) non definito");
                    }
                    codiceTrasporto = new GestioneErroreCodiceTrasporto();
                    codiceTrasporto.setValoreMinimo(config.getGestioneTrasporto3xx_leftInterval());
                    codiceTrasporto.setValoreMassimo(config.getGestioneTrasporto3xx_rightInterval());
                    codiceTrasporto.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto((GestioneErroreCodiceTrasporto)codiceTrasporto);
                }
            }
        }
        if (config.getGestioneTrasporto4xx() != null) {
            switch (config.getGestioneTrasporto4xx()) {
                case CONSEGNA_COMPLETATA: {
                    codiceTrasportoCompletata = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoCompletata.setValoreMinimo(Integer.valueOf(400));
                    codiceTrasportoCompletata.setValoreMassimo(Integer.valueOf(499));
                    codiceTrasportoCompletata.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoCompletata);
                    break;
                }
                case CONSEGNA_FALLITA: {
                    codiceTrasportoFallita = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoFallita.setValoreMinimo(Integer.valueOf(400));
                    codiceTrasportoFallita.setValoreMassimo(Integer.valueOf(499));
                    codiceTrasportoFallita.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoFallita);
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto4xx_codes() == null || config.getGestioneTrasporto4xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 4xx) non fornita");
                    }
                    for (Integer code : config.getGestioneTrasporto4xx_codes()) {
                        codiceTrasporto2 = new GestioneErroreCodiceTrasporto();
                        codiceTrasporto2.setValoreMinimo(code);
                        codiceTrasporto2.setValoreMassimo(code);
                        codiceTrasporto2.setComportamento(GestioneErroreComportamento.ACCETTA);
                        gestioneErrore.addCodiceTrasporto(codiceTrasporto2);
                    }
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto4xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 4xx) non definito");
                    }
                    if (config.getGestioneTrasporto4xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 4xx) non definito");
                    }
                    codiceTrasporto = new GestioneErroreCodiceTrasporto();
                    codiceTrasporto.setValoreMinimo(config.getGestioneTrasporto4xx_leftInterval());
                    codiceTrasporto.setValoreMassimo(config.getGestioneTrasporto4xx_rightInterval());
                    codiceTrasporto.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto((GestioneErroreCodiceTrasporto)codiceTrasporto);
                }
            }
        }
        if (config.getGestioneTrasporto5xx() != null) {
            switch (config.getGestioneTrasporto5xx()) {
                case CONSEGNA_COMPLETATA: {
                    codiceTrasportoCompletata = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoCompletata.setValoreMinimo(Integer.valueOf(500));
                    codiceTrasportoCompletata.setValoreMassimo(Integer.valueOf(599));
                    codiceTrasportoCompletata.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoCompletata);
                    break;
                }
                case CONSEGNA_FALLITA: {
                    codiceTrasportoFallita = new GestioneErroreCodiceTrasporto();
                    codiceTrasportoFallita.setValoreMinimo(Integer.valueOf(500));
                    codiceTrasportoFallita.setValoreMassimo(Integer.valueOf(599));
                    codiceTrasportoFallita.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    gestioneErrore.addCodiceTrasporto(codiceTrasportoFallita);
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto5xx_codes() == null || config.getGestioneTrasporto5xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 5xx) non fornita");
                    }
                    for (Integer code : config.getGestioneTrasporto5xx_codes()) {
                        codiceTrasporto2 = new GestioneErroreCodiceTrasporto();
                        codiceTrasporto2.setValoreMinimo(code);
                        codiceTrasporto2.setValoreMassimo(code);
                        codiceTrasporto2.setComportamento(GestioneErroreComportamento.ACCETTA);
                        gestioneErrore.addCodiceTrasporto(codiceTrasporto2);
                    }
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto5xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 5xx) non definito");
                    }
                    if (config.getGestioneTrasporto5xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 5xx) non definito");
                    }
                    codiceTrasporto = new GestioneErroreCodiceTrasporto();
                    codiceTrasporto.setValoreMinimo(config.getGestioneTrasporto5xx_leftInterval());
                    codiceTrasporto.setValoreMassimo(config.getGestioneTrasporto5xx_rightInterval());
                    codiceTrasporto.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addCodiceTrasporto((GestioneErroreCodiceTrasporto)codiceTrasporto);
                }
            }
        }
        if (config.getFault() != null) {
            switch (config.getFault()) {
                case CONSEGNA_COMPLETATA: {
                    GestioneErroreSoapFault faultCompletata = new GestioneErroreSoapFault();
                    faultCompletata.setComportamento(GestioneErroreComportamento.ACCETTA);
                    gestioneErrore.addSoapFault(faultCompletata);
                    break;
                }
                case CONSEGNA_FALLITA: {
                    GestioneErroreSoapFault faultFallita = new GestioneErroreSoapFault();
                    faultFallita.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    gestioneErrore.addSoapFault(faultFallita);
                    break;
                }
                case CONSEGNA_COMPLETATA_PERSONALIZZATA: 
                case CONSEGNA_FALLITA_PERSONALIZZATA: {
                    GestioneErroreSoapFault faultCustom = new GestioneErroreSoapFault();
                    if (TipoGestioneNotificaFault.CONSEGNA_FALLITA_PERSONALIZZATA.equals(config.getFault())) {
                        faultCustom.setComportamento(GestioneErroreComportamento.RISPEDISCI);
                    } else {
                        faultCustom.setComportamento(GestioneErroreComportamento.ACCETTA);
                    }
                    if (config.getFaultCode() != null && !"".equals(config.getFaultCode())) {
                        faultCustom.setFaultCode(config.getFaultCode());
                    }
                    if (config.getFaultActor() != null && !"".equals(config.getFaultActor())) {
                        faultCustom.setFaultActor(config.getFaultActor());
                    }
                    if (config.getFaultMessage() != null && !"".equals(config.getFaultMessage())) {
                        faultCustom.setFaultString(config.getFaultMessage());
                    }
                    gestioneErrore.addSoapFault(faultCustom);
                }
            }
        }
        return gestioneErrore;
    }

    public static String toString(ConfigurazioneGestioneConsegnaNotifiche config, boolean soap) throws BehaviourException {
        String s;
        int index;
        StringBuilder bf = new StringBuilder("Consegna ");
        if (config.getMessaggioDaNotificare() != null) {
            switch (config.getMessaggioDaNotificare()) {
                case RICHIESTA: {
                    bf.append("della richiesta ");
                    break;
                }
                case RISPOSTA: {
                    bf.append("della risposta ");
                    break;
                }
            }
        } else {
            bf.append("della richiesta ");
        }
        bf.append("completata con codice");
        boolean first = true;
        if (config.getGestioneTrasporto2xx() != null) {
            switch (config.getGestioneTrasporto2xx()) {
                case CONSEGNA_COMPLETATA: {
                    bf.append(" 200-299");
                    first = false;
                    break;
                }
                case CONSEGNA_FALLITA: {
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto2xx_codes() == null || config.getGestioneTrasporto2xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 2xx) non fornita");
                    }
                    bf.append(" ");
                    index = 0;
                    for (Integer code : config.getGestioneTrasporto2xx_codes()) {
                        if (index > 0) {
                            bf.append(",");
                        }
                        bf.append(code);
                        ++index;
                    }
                    first = false;
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto2xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 2xx) non definito");
                    }
                    if (config.getGestioneTrasporto2xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 2xx) non definito");
                    }
                    bf.append(" ").append(config.getGestioneTrasporto2xx_leftInterval()).append("-").append(config.getGestioneTrasporto2xx_rightInterval());
                    first = false;
                }
            }
        }
        if (config.getGestioneTrasporto3xx() != null) {
            switch (config.getGestioneTrasporto3xx()) {
                case CONSEGNA_COMPLETATA: {
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" 300-399");
                    first = false;
                    break;
                }
                case CONSEGNA_FALLITA: {
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto3xx_codes() == null || config.getGestioneTrasporto3xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 3xx) non fornita");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ");
                    index = 0;
                    for (Integer code : config.getGestioneTrasporto3xx_codes()) {
                        if (index > 0) {
                            bf.append(",");
                        }
                        bf.append(code);
                        ++index;
                    }
                    first = false;
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto3xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 3xx) non definito");
                    }
                    if (config.getGestioneTrasporto3xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 3xx) non definito");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ").append(config.getGestioneTrasporto3xx_leftInterval()).append("-").append(config.getGestioneTrasporto3xx_rightInterval());
                    first = false;
                }
            }
        }
        if (config.getGestioneTrasporto4xx() != null) {
            switch (config.getGestioneTrasporto4xx()) {
                case CONSEGNA_COMPLETATA: {
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" 400-499");
                    first = false;
                    break;
                }
                case CONSEGNA_FALLITA: {
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto4xx_codes() == null || config.getGestioneTrasporto4xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 4xx) non fornita");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ");
                    index = 0;
                    for (Integer code : config.getGestioneTrasporto4xx_codes()) {
                        if (index > 0) {
                            bf.append(",");
                        }
                        bf.append(code);
                        ++index;
                    }
                    first = false;
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto4xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 4xx) non definito");
                    }
                    if (config.getGestioneTrasporto4xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 4xx) non definito");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ").append(config.getGestioneTrasporto4xx_leftInterval()).append("-").append(config.getGestioneTrasporto4xx_rightInterval());
                    first = false;
                }
            }
        }
        if (config.getGestioneTrasporto5xx() != null) {
            switch (config.getGestioneTrasporto5xx()) {
                case CONSEGNA_COMPLETATA: {
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" 500-599");
                    first = false;
                    break;
                }
                case CONSEGNA_FALLITA: {
                    break;
                }
                case CODICI_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto5xx_codes() == null || config.getGestioneTrasporto5xx_codes().isEmpty()) {
                        throw new BehaviourException("Lista dei codici accettati (classe 5xx) non fornita");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ");
                    index = 0;
                    for (Integer code : config.getGestioneTrasporto5xx_codes()) {
                        if (index > 0) {
                            bf.append(",");
                        }
                        bf.append(code);
                        ++index;
                    }
                    first = false;
                    break;
                }
                case INTERVALLO_CONSEGNA_COMPLETATA: {
                    if (config.getGestioneTrasporto5xx_leftInterval() == null) {
                        throw new BehaviourException("Intervallo sinistro (classe 5xx) non definito");
                    }
                    if (config.getGestioneTrasporto5xx_rightInterval() == null) {
                        throw new BehaviourException("Intervallo destro (classe 5xx) non definito");
                    }
                    if (!first) {
                        bf.append(" o");
                    }
                    bf.append(" ").append(config.getGestioneTrasporto5xx_leftInterval()).append("-").append(config.getGestioneTrasporto5xx_rightInterval());
                    first = false;
                }
            }
        }
        if (config.getFault() != null) {
            switch (config.getFault()) {
                case CONSEGNA_COMPLETATA: {
                    if (!first) {
                        bf.append(" o");
                    }
                    if (soap) {
                        bf.append(" SOAP Fault");
                        break;
                    }
                    bf.append(" Problem Detail");
                    break;
                }
                case CONSEGNA_FALLITA: {
                    break;
                }
                case CONSEGNA_FALLITA_PERSONALIZZATA: {
                    break;
                }
                case CONSEGNA_COMPLETATA_PERSONALIZZATA: {
                    String label;
                    if (!first) {
                        bf.append(" o");
                    }
                    if (soap) {
                        bf.append(" SOAP Fault");
                    } else {
                        bf.append(" Problem Detail");
                    }
                    Object tipoFaultCompletato = null;
                    if (!StringUtils.isEmpty((CharSequence)config.getFaultCode())) {
                        label = soap ? LABEL_CODE : LABEL_TYPE;
                        tipoFaultCompletato = label;
                    }
                    if (!StringUtils.isEmpty((CharSequence)config.getFaultActor())) {
                        label = soap ? LABEL_ACTOR : LABEL_STATUS;
                        tipoFaultCompletato = tipoFaultCompletato != null ? (String)tipoFaultCompletato + ", " : "";
                        tipoFaultCompletato = (String)tipoFaultCompletato + label;
                    }
                    if (!StringUtils.isEmpty((CharSequence)config.getFaultMessage())) {
                        label = soap ? LABEL_MESSAGE : LABEL_CLAIMS;
                        tipoFaultCompletato = tipoFaultCompletato != null ? (String)tipoFaultCompletato + ", " : "";
                        tipoFaultCompletato = (String)tipoFaultCompletato + label;
                    }
                    String prefix = "";
                    tipoFaultCompletato = tipoFaultCompletato != null ? prefix + " contenente le personalizzazioni definite per " + (String)tipoFaultCompletato : prefix + " contenente le personalizzazioni indicate";
                    bf.append((String)tipoFaultCompletato);
                }
            }
        }
        if ((s = bf.toString()) != null) {
            String errorMsg = null;
            String replaceMsg = null;
            if (soap) {
                errorMsg = "codice SOAP Fault";
                replaceMsg = "SOAP Fault";
            } else {
                errorMsg = "codice Problem Detail";
                replaceMsg = "Problem Detail";
            }
            if (s.contains(errorMsg)) {
                s = s.replace(errorMsg, replaceMsg);
            }
        }
        return s;
    }
}

