/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.byok;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.pdd.core.byok.DriverBYOK;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.properties.MapProperties;
import org.slf4j.Logger;

public class BYOKMapProperties
extends MapProperties {
    public static final String FILE_NAME = "govway.secrets.properties";
    private static final String PROP_KMS_PREFIX = "kms.";
    private static final String ENV_KMS_PREFIX = "env.kms.";
    private static final String JAVA_KMS_PREFIX = "java.kms.";
    private static final String PROP_KSM_PREFIX_DEPRECATED = "ksm.";
    private static final String ENV_KSM_PREFIX_DEPRECATED = "env.ksm.";
    private static final String JAVA_KSM_PREFIX_DEPRECATED = "java.ksm.";
    private static final String PROP_SECURITY_PREFIX = "security.";
    private static final String ENV_SECURITY_PREFIX = "env.security.";
    private static final String JAVA_SECURITY_PREFIX = "java.security.";
    private static final String PROP_WRAPPED_PREFIX = "wrapped.";
    private static final String ENV_WRAPPED_PREFIX = "env.wrapped.";
    private static final String JAVA_WRAPPED_PREFIX = "java.wrapped.";
    private static final String PROP_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX = "govway-run-only.unwrap-after-startup.";
    private static final String ENV_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX = "env.govway-run-only.unwrap-after-startup.";
    private static final String JAVA_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX = "java.govway-run-only.unwrap-after-startup.";
    private static final String UNWRAP_DEFAULT_MODE = "unwrap.default.mode";
    private static final String UNWRAP_DEFAULT_ID = "unwrap.default.id";
    private static final String UNWRAP_MODE_SECURITY = "security";
    private static final String UNWRAP_MODE_KMS = "kms";
    private static final String UNWRAP_MODE_KSM_DEPRECATED = "ksm";
    private static final String KMS_PREFIX = "kms.";
    private static final String KMS_PARAM_PREFIX = ".param.";
    private static final String KSM_PREFIX_DEPRECATED = "ksm.";
    private static final String KSM_PARAM_PREFIX_DEPRECATED = ".param.";
    private static final String ERROR_SUFFIX_UNKNOW = "' unknown";
    private static final String ERROR_DEFAULT_MODE_NOT_FOUND = ") an unwrap mode has not been defined (security/kms); specifying the mode is mandatory if a default unwrap mode is not defined.";
    private String defaultUnwrapId = null;
    private Boolean defaultUnwrapModeSecurity = null;
    private boolean useSecurityEngine = false;
    private String securityPolicy;
    private String securityRemotePolicy;
    private Map<String, DriverBYOK> mapDriverSecurity = new HashMap<String, DriverBYOK>();
    private Map<String, Map<String, String>> mapKmsInput = new HashMap<String, Map<String, String>>();
    private Map<String, Object> dynamicMap = null;
    private boolean checkJmxPrefixOperazioneNonRiuscita = false;
    private volatile boolean existsUnwrapPropertiesAfterGovWayStartup = false;
    private volatile boolean isGovWayStarted = false;
    private static BYOKMapProperties secretsProperties = null;

    private static String getKmsParamPrefixPropertyName(String kmsId) {
        return "kms." + kmsId + ".param.";
    }

    private static String getKsmParamPrefixPropertyNameDeprecated(String ksmId) {
        return "ksm." + ksmId + ".param.";
    }

    public boolean isExistsUnwrapPropertiesAfterGovWayStartup() {
        return this.existsUnwrapPropertiesAfterGovWayStartup;
    }

    public boolean isGovWayStarted() {
        return this.isGovWayStarted;
    }

    public void setGovWayStarted(boolean isGovWayStarted) {
        this.isGovWayStarted = isGovWayStarted;
    }

    private BYOKMapProperties(Logger log, String fileName, boolean throwNotFound, boolean useSecurityEngine, Map<String, Object> dynamicMapParam, boolean checkJmxPrefixOperazioneNonRiuscita) throws UtilsException {
        super(log, fileName, throwNotFound);
        this.init(useSecurityEngine, dynamicMapParam, checkJmxPrefixOperazioneNonRiuscita);
    }

    private void init(boolean useSecurityEngine, Map<String, Object> dynamicMapParam, boolean checkJmxPrefixOperazioneNonRiuscita) {
        String securityPolicyB = BYOKManager.getSecurityEngineGovWayPolicy();
        String securityRemotePolicyB = BYOKManager.getSecurityRemoteEngineGovWayPolicy();
        if (securityPolicyB != null && StringUtils.isNotEmpty((CharSequence)securityPolicyB)) {
            this.securityPolicy = securityPolicyB;
        }
        if (securityRemotePolicyB != null && StringUtils.isNotEmpty((CharSequence)securityRemotePolicyB)) {
            this.securityRemotePolicy = securityRemotePolicyB;
        }
        this.useSecurityEngine = useSecurityEngine;
        this.dynamicMap = dynamicMapParam;
        this.checkJmxPrefixOperazioneNonRiuscita = checkJmxPrefixOperazioneNonRiuscita;
    }

    public static boolean initialize(Logger log, String fileName, boolean throwNotFound, boolean useSecurityEngine, Map<String, Object> dynamicMapParam, boolean checkJmxPrefixOperazioneNonRiuscita) {
        try {
            secretsProperties = new BYOKMapProperties(log, fileName, throwNotFound, useSecurityEngine, dynamicMapParam, checkJmxPrefixOperazioneNonRiuscita);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BYOKMapProperties getInstance() {
        if (secretsProperties != null) return secretsProperties;
        Class<BYOKMapProperties> clazz = BYOKMapProperties.class;
        synchronized (BYOKMapProperties.class) {
            if (secretsProperties != null) return secretsProperties;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public void loadPropertyInEnvironment(String key) throws UtilsException {
        this.loadDefaultUnwrap();
        if (!(!key.startsWith("env.") || key.length() <= "env.".length() || key.startsWith(ENV_KSM_PREFIX_DEPRECATED) || key.startsWith(ENV_KMS_PREFIX) || key.startsWith(ENV_SECURITY_PREFIX) || key.startsWith(ENV_WRAPPED_PREFIX) || key.startsWith(ENV_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX))) {
            this.loadEnvPropertyInEnvironment(key);
        } else if (!(!key.startsWith("java.") || key.length() <= "java.".length() || key.startsWith(JAVA_KSM_PREFIX_DEPRECATED) || key.startsWith(JAVA_KMS_PREFIX) || key.startsWith(JAVA_SECURITY_PREFIX) || key.startsWith(JAVA_WRAPPED_PREFIX) || key.startsWith(JAVA_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX))) {
            this.loadJavaPropertyInEnvironment(key);
        }
    }

    public void loadEnvPropertyInEnvironment(String key) throws UtilsException {
        String envKey = key.substring("env.".length());
        String value = this.reader.getValue_convertEnvProperties(key);
        if (this.isUnwrapAfterGovWayStartup(false, envKey)) {
            this.existsUnwrapPropertiesAfterGovWayStartup = true;
            if (!this.isGovWayStarted) {
                return;
            }
        }
        if (this.isWrapped(false, envKey)) {
            this.processWrappedValue(key, envKey, value, false);
        } else {
            this.setEnvProperty(envKey, value);
        }
    }

    public void loadJavaPropertyInEnvironment(String key) throws UtilsException {
        String envKey = key.substring("java.".length());
        String value = this.reader.getValue_convertEnvProperties(key);
        if (this.isUnwrapAfterGovWayStartup(true, envKey)) {
            this.existsUnwrapPropertiesAfterGovWayStartup = true;
            if (!this.isGovWayStarted) {
                return;
            }
        }
        if (this.isWrapped(true, envKey)) {
            this.processWrappedValue(key, envKey, value, true);
        } else {
            this.setJavaProperty(envKey, value);
        }
    }

    private void processWrappedValue(String key, String envKey, String value, boolean javaProperty) throws UtilsException {
        String plainValue = null;
        String securityId = this.getUnwrapId(javaProperty, envKey);
        try {
            if (this.isWrappedBySecurity(javaProperty, envKey)) {
                String p;
                String string = p = this.securityRemotePolicy != null ? this.securityRemotePolicy : this.securityPolicy;
                if (!this.useSecurityEngine && securityId != null && securityId.equals(p)) {
                    return;
                }
                plainValue = this.getDriverBYOK(securityId).unwrapAsString(value, securityId, true);
            } else {
                plainValue = this.unwrapByKmsId(value, securityId);
            }
        }
        catch (Exception e) {
            throw new UtilsException("[" + key + "] " + e.getMessage(), (Throwable)e);
        }
        if (plainValue == null) {
            throw new UtilsException("(" + key + ") unwrapped value null");
        }
        if (javaProperty) {
            this.setJavaProperty(envKey, plainValue);
        } else {
            this.setEnvProperty(envKey, plainValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadDefaultUnwrap() throws UtilsException {
        String tmp = this.reader.getValue_convertEnvProperties(UNWRAP_DEFAULT_ID);
        if (tmp != null) {
            this.defaultUnwrapId = tmp.trim();
            if (StringUtils.isEmpty((CharSequence)this.defaultUnwrapId)) {
                this.defaultUnwrapId = null;
            }
        }
        if (this.defaultUnwrapId == null) return;
        tmp = this.reader.getValue_convertEnvProperties(UNWRAP_DEFAULT_MODE);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            if (UNWRAP_MODE_SECURITY.equals(tmp.trim())) {
                this.defaultUnwrapModeSecurity = true;
                return;
            } else {
                if (!UNWRAP_MODE_KMS.equals(tmp.trim()) && !UNWRAP_MODE_KSM_DEPRECATED.equals(tmp.trim())) throw new UtilsException("unwrap.default.mode '" + tmp.trim() + ERROR_SUFFIX_UNKNOW);
                this.defaultUnwrapModeSecurity = false;
            }
            return;
        } else {
            this.defaultUnwrapModeSecurity = true;
        }
    }

    private boolean isWrapped(boolean javaProperty, String key) throws UtilsException {
        if (this.reader == null) {
            return false;
        }
        String prefix = javaProperty ? JAVA_WRAPPED_PREFIX : ENV_WRAPPED_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(prefix + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            if ("true".equals(tmp.trim())) {
                return true;
            }
            if ("false".equals(tmp.trim())) {
                return false;
            }
            throw new UtilsException(prefix + key + " with value '" + tmp.trim() + ERROR_SUFFIX_UNKNOW);
        }
        return true;
    }

    private boolean isUnwrapAfterGovWayStartup(boolean javaProperty, String key) throws UtilsException {
        if (this.reader == null) {
            return false;
        }
        String prefix = javaProperty ? JAVA_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX : ENV_UNWRAP_AFTER_GOVWAY_STARTUP_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(prefix + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            if ("true".equals(tmp.trim())) {
                return true;
            }
            if ("false".equals(tmp.trim())) {
                return false;
            }
            throw new UtilsException(prefix + key + " with value '" + tmp.trim() + ERROR_SUFFIX_UNKNOW);
        }
        return false;
    }

    protected boolean obfuscate(boolean java, String key) {
        try {
            return this.isWrapped(java, key);
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isWrappedBySecurity(boolean javaProperty, String key) throws UtilsException {
        if (this.reader == null) {
            return false;
        }
        String pSecurityName = javaProperty ? JAVA_SECURITY_PREFIX : ENV_SECURITY_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(pSecurityName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return true;
        }
        return this.isWrappedBySecurityKms(javaProperty, key);
    }

    private boolean isWrappedBySecurityKms(boolean javaProperty, String key) throws UtilsException {
        String pKmsName = javaProperty ? JAVA_KMS_PREFIX : ENV_KMS_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(pKmsName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return false;
        }
        pKmsName = javaProperty ? JAVA_KSM_PREFIX_DEPRECATED : ENV_KSM_PREFIX_DEPRECATED;
        tmp = this.reader.getValue_convertEnvProperties(pKmsName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return false;
        }
        if (this.defaultUnwrapModeSecurity != null) {
            return this.defaultUnwrapModeSecurity;
        }
        String prefix = javaProperty ? "java." : "env.";
        throw new UtilsException("(" + prefix + key + ERROR_DEFAULT_MODE_NOT_FOUND);
    }

    private String getUnwrapId(boolean javaProperty, String key) throws UtilsException {
        if (this.reader == null) {
            return null;
        }
        String pSecurityName = javaProperty ? JAVA_SECURITY_PREFIX : ENV_SECURITY_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(pSecurityName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return tmp.trim();
        }
        return this.getUnwrapIdByKms(javaProperty, key);
    }

    private String getUnwrapIdByKms(boolean javaProperty, String key) throws UtilsException {
        String pKmsName = javaProperty ? JAVA_KMS_PREFIX : ENV_KMS_PREFIX;
        String tmp = this.reader.getValue_convertEnvProperties(pKmsName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return tmp.trim();
        }
        pKmsName = javaProperty ? JAVA_KSM_PREFIX_DEPRECATED : ENV_KSM_PREFIX_DEPRECATED;
        tmp = this.reader.getValue_convertEnvProperties(pKmsName + key);
        if (tmp != null && StringUtils.isNotEmpty((CharSequence)tmp.trim())) {
            return tmp.trim();
        }
        if (this.defaultUnwrapId != null) {
            return this.defaultUnwrapId;
        }
        String prefix = javaProperty ? "java." : "env.";
        throw new UtilsException("(" + prefix + key + ERROR_DEFAULT_MODE_NOT_FOUND);
    }

    private DriverBYOK getDriverBYOK(String securityId) {
        if (!this.mapDriverSecurity.containsKey(securityId)) {
            this.initDriverBYOK(securityId);
        }
        return this.mapDriverSecurity.get(securityId);
    }

    private synchronized void initDriverBYOK(String securityId) {
        this.mapDriverSecurity.computeIfAbsent(securityId, k -> new DriverBYOK(this.log, this.securityPolicy, this.securityRemotePolicy, this.newDynamicMap(), this.checkJmxPrefixOperazioneNonRiuscita));
    }

    private Map<String, Object> newDynamicMap() {
        if (this.dynamicMap == null) {
            this.initDynamicMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty()) {
            map.putAll(this.dynamicMap);
        }
        return map;
    }

    private synchronized void initDynamicMap() {
        if (this.dynamicMap == null) {
            this.dynamicMap = DriverBYOK.buildDynamicMap(this.log);
        }
    }

    private Map<String, String> readKmsInputMap(String kmsId) throws UtilsException {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties p = this.reader.readProperties_convertEnvProperties(BYOKMapProperties.getKmsParamPrefixPropertyName(kmsId));
        if (p == null || p.isEmpty()) {
            p = this.reader.readProperties_convertEnvProperties(BYOKMapProperties.getKsmParamPrefixPropertyNameDeprecated(kmsId));
        }
        if (p != null && !p.isEmpty()) {
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    private Map<String, String> getKmsInputMap(String kmsId) {
        if (!this.mapKmsInput.containsKey(kmsId)) {
            this.initKmsInputMap(kmsId);
        }
        return this.mapKmsInput.get(kmsId);
    }

    private synchronized void initKmsInputMap(String kmsId) {
        this.mapKmsInput.computeIfAbsent(kmsId, k -> {
            try {
                return this.readKmsInputMap(kmsId);
            }
            catch (UtilsException e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        });
    }

    private String unwrapByKmsId(String value, String kmsId) throws UtilsException {
        Map<String, String> inputMap = this.getKmsInputMap(kmsId);
        BYOKRequestParams params = DriverBYOK.getBYOKRequestParamsByKmsId(kmsId, inputMap, this.newDynamicMap());
        if (!BYOKMode.UNWRAP.equals((Object)params.getConfig().getMode())) {
            throw new UtilsException("Kms '" + kmsId + "' unusable in unwrap operation");
        }
        BYOKInstance instance = BYOKInstance.newInstance((Logger)this.log, (BYOKRequestParams)params, (byte[])value.getBytes());
        byte[] unwrappedValue = DriverBYOK.processInstance(instance, this.checkJmxPrefixOperazioneNonRiuscita);
        return new String(unwrappedValue);
    }
}

