/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.message.AbstractBaseOpenSPCoop2MessageDynamicContent;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.rest.RestUtilities;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.config.ForwardProxy;
import org.openspcoop2.pdd.config.ForwardProxyConfigurazione;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.CostantiPdD;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPSProperties;
import org.openspcoop2.pdd.core.connettori.ConnettoreHTTPUrlHttpsKeystoreRepository;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.dynamic.DynamicMapBuilderUtils;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.keystore.GestoreKeystoreCaching;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.security.keystore.SSLSocketFactory;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.slf4j.Logger;

public abstract class ConnettoreBaseHTTP
extends ConnettoreBaseWithResponse {
    private HttpRequestMethod forceHttpMethod = null;
    protected HttpRequestMethod httpMethod = null;
    protected boolean connettoreHttps = false;
    protected SSLConfig sslContextProperties;
    protected String resultHTTPMessage;
    protected boolean encodingRFC2047 = false;
    protected Charset charsetRFC2047 = null;
    protected RFC2047Encoding encodingAlgorithmRFC2047 = null;
    protected boolean validazioneHeaderRFC2047 = false;
    protected boolean proxyPassReverseEnabled = false;
    protected boolean proxyPassReverseLocation = false;
    protected boolean proxyPassReverseSetCookiePath = false;
    protected boolean proxyPassReverseSetCookieDomain = false;
    protected boolean proxyPassReverseUsePrefixProtocol = false;
    protected List<String> proxyPassReverseHeaders = null;
    protected List<String> proxyPassReverseSetCookieHeaders = null;
    private boolean forceDisableProxyPassReverse = false;
    protected ForwardProxy forwardProxy;
    protected String forwardProxyHeaderName;
    protected String forwardProxyHeaderValue;
    protected boolean supportSSE = true;
    private boolean proxyPassReverseDone = false;

    @Override
    public String getProtocollo() {
        return "HTTP";
    }

    public void setForceHttpMethod(HttpRequestMethod forceHttpMethod) {
        this.forceHttpMethod = forceHttpMethod;
    }

    public HttpRequestMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpRequestMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHttpMethod(OpenSPCoop2Message msg) throws ConnettoreException {
        if (this.forceHttpMethod != null) {
            this.httpMethod = this.forceHttpMethod;
        } else if (ServiceBinding.SOAP.equals((Object)msg.getServiceBinding())) {
            this.httpMethod = HttpRequestMethod.POST;
        } else {
            if (msg.getTransportRequestContext() == null || msg.getTransportRequestContext().getRequestType() == null) {
                throw new ConnettoreException("HttpRequestMethod non definito");
            }
            this.httpMethod = HttpRequestMethod.valueOf((String)msg.getTransportRequestContext().getRequestType().toUpperCase());
            if (this.httpMethod == null) {
                throw new ConnettoreException("HttpRequestMethod sconosciuto (" + String.valueOf(this.httpMethod) + ")");
            }
        }
    }

    public String getResultHTTPMessage() {
        return this.resultHTTPMessage;
    }

    public void setResultHTTPMessage(String resultHTTPMessage) {
        this.resultHTTPMessage = resultHTTPMessage;
    }

    public void setForceDisableProxyPassReverse(boolean forceDisableProxyPassReverseParam) {
        this.forceDisableProxyPassReverse = forceDisableProxyPassReverseParam;
    }

    public void configureSSE() {
        OpenSPCoop2Message openSPCoop2Message = this.responseMsg;
        if (openSPCoop2Message instanceof AbstractBaseOpenSPCoop2MessageDynamicContent) {
            AbstractBaseOpenSPCoop2MessageDynamicContent mdc = (AbstractBaseOpenSPCoop2MessageDynamicContent)openSPCoop2Message;
            mdc.setSupportSSE(this.supportSSE);
            if (this.msgDiagnostico != null) {
                this.msgDiagnostico.logPersonalizzato("consegnaRispostaSSE");
            }
        }
    }

    protected ConnettoreBaseHTTP() {
        this.connettoreHttps = false;
    }

    protected ConnettoreBaseHTTP(boolean https) {
        this.connettoreHttps = https;
    }

    @Override
    protected boolean initialize(ConnettoreMsg request, boolean connectorPropertiesRequired, ResponseCachingConfigurazione responseCachingConfig) {
        boolean init = super.initialize(request, connectorPropertiesRequired, responseCachingConfig);
        this.updateForwardProxy(request.getForwardProxy());
        if (this.properties.get("location") == null) {
            this.errore = "Proprieta' 'location' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        if (this.idModulo != null) {
            if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                this.encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                this.charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                this.encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueConsegnaContenutiApplicativi();
                this.validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueConsegnaContenutiApplicativi();
                this.supportSSE = this.openspcoopProperties.isEnabledSupportServerSentEventsConsegnaContenutiApplicativi();
            } else {
                this.encodingRFC2047 = this.openspcoopProperties.isEnabledEncodingRFC2047HeaderValueInoltroBuste();
                this.charsetRFC2047 = this.openspcoopProperties.getCharsetEncodingRFC2047HeaderValueInoltroBuste();
                this.encodingAlgorithmRFC2047 = this.openspcoopProperties.getEncodingRFC2047HeaderValueInoltroBuste();
                this.validazioneHeaderRFC2047 = this.openspcoopProperties.isEnabledValidazioneRFC2047HeaderNameValueInoltroBuste();
                this.supportSSE = this.openspcoopProperties.isEnabledSupportServerSentEventsInoltroBuste();
            }
            this.encodingRFC2047 = CostantiProprieta.isConnettoriHeaderValueEncodingRFC2047RequestEnabled(this.proprietaPorta, this.encodingRFC2047);
            this.charsetRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047RequestCharset(this.proprietaPorta, this.charsetRFC2047);
            this.encodingAlgorithmRFC2047 = CostantiProprieta.getConnettoriHeaderValueEncodingRFC2047RequestType(this.proprietaPorta, this.encodingAlgorithmRFC2047);
            this.validazioneHeaderRFC2047 = CostantiProprieta.isConnettoriHeaderValidationRequestEnabled(this.proprietaPorta, this.validazioneHeaderRFC2047);
            this.supportSSE = CostantiProprieta.isConnettoriSupportServerSentEventsEnabled(this.proprietaPorta, this.supportSSE);
        }
        if (!this.forceDisableProxyPassReverse) {
            if (this.isRest) {
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    this.proxyPassReverseLocation = this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse();
                    this.proxyPassReverseSetCookiePath = this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie() && this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_path();
                    this.proxyPassReverseSetCookieDomain = this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie() && this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_domain();
                    this.proxyPassReverseUsePrefixProtocol = this.openspcoopProperties.isRESTServices_consegnaContenutiApplicativi_proxyPassReverse_useProtocolPrefix();
                    try {
                        this.proxyPassReverseHeaders = this.openspcoopProperties.getRESTServices_consegnaContenutiApplicativi_proxyPassReverse_headers();
                        this.proxyPassReverseSetCookieHeaders = this.openspcoopProperties.getRESTServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_headers();
                    }
                    catch (Exception e) {
                        this.errore = e.getMessage();
                        return false;
                    }
                } else {
                    this.proxyPassReverseLocation = this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse();
                    this.proxyPassReverseSetCookiePath = this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse_setCookie() && this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse_setCookie_path();
                    this.proxyPassReverseSetCookieDomain = this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse_setCookie() && this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse_setCookie_domain();
                    this.proxyPassReverseUsePrefixProtocol = this.openspcoopProperties.isRESTServices_inoltroBuste_proxyPassReverse_useProtocolPrefix();
                    try {
                        this.proxyPassReverseHeaders = this.openspcoopProperties.getRESTServices_inoltroBuste_proxyPassReverse_headers();
                        this.proxyPassReverseSetCookieHeaders = this.openspcoopProperties.getRESTServices_inoltroBuste_proxyPassReverse_setCookie_headers();
                    }
                    catch (Exception e) {
                        this.errore = e.getMessage();
                        return false;
                    }
                }
            } else {
                if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
                    this.proxyPassReverseLocation = this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse();
                    this.proxyPassReverseSetCookiePath = this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie() && this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_path();
                    this.proxyPassReverseSetCookieDomain = this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie() && this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_domain();
                    this.proxyPassReverseUsePrefixProtocol = this.openspcoopProperties.isSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_useProtocolPrefix();
                    try {
                        this.proxyPassReverseHeaders = this.openspcoopProperties.getSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_headers();
                        this.proxyPassReverseSetCookieHeaders = this.openspcoopProperties.getSOAPServices_consegnaContenutiApplicativi_proxyPassReverse_setCookie_headers();
                    }
                    catch (Exception e) {
                        this.errore = e.getMessage();
                        return false;
                    }
                }
                this.proxyPassReverseLocation = this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse();
                this.proxyPassReverseSetCookiePath = this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse_setCookie() && this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse_setCookie_path();
                this.proxyPassReverseSetCookieDomain = this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse_setCookie() && this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse_setCookie_domain();
                this.proxyPassReverseUsePrefixProtocol = this.openspcoopProperties.isSOAPServices_inoltroBuste_proxyPassReverse_useProtocolPrefix();
                try {
                    this.proxyPassReverseHeaders = this.openspcoopProperties.getSOAPServices_inoltroBuste_proxyPassReverse_headers();
                    this.proxyPassReverseSetCookieHeaders = this.openspcoopProperties.getSOAPServices_inoltroBuste_proxyPassReverse_setCookie_headers();
                }
                catch (Exception e) {
                    this.errore = e.getMessage();
                    return false;
                }
            }
            if (this.proprietaPorta != null && !this.proprietaPorta.isEmpty()) {
                try {
                    this.proxyPassReverseLocation = CostantiProprieta.isConnettoriProxyPassReverseEnabled(this.proprietaPorta, this.proxyPassReverseLocation);
                    if (this.proxyPassReverseLocation) {
                        this.proxyPassReverseHeaders = CostantiProprieta.getConnettoriProxyPassReverseHeaders(this.proprietaPorta, this.proxyPassReverseHeaders);
                    }
                    this.proxyPassReverseSetCookiePath = CostantiProprieta.isConnettoriProxyPassReverseSetCookiePathEnabled(this.proprietaPorta, this.proxyPassReverseSetCookiePath);
                    this.proxyPassReverseSetCookieDomain = CostantiProprieta.isConnettoriProxyPassReverseSetCookieDomainEnabled(this.proprietaPorta, this.proxyPassReverseSetCookieDomain);
                    if (this.proxyPassReverseSetCookiePath || this.proxyPassReverseSetCookieDomain) {
                        this.proxyPassReverseSetCookieHeaders = CostantiProprieta.getConnettoriProxyPassReverseHeaders(this.proprietaPorta, this.proxyPassReverseSetCookieHeaders);
                    }
                    if (this.proxyPassReverseLocation || this.proxyPassReverseSetCookiePath || this.proxyPassReverseSetCookieDomain) {
                        this.proxyPassReverseUsePrefixProtocol = CostantiProprieta.isConnettoriProxyPassReverseUseProtocolPrefix(this.proprietaPorta, this.proxyPassReverseUsePrefixProtocol);
                    }
                }
                catch (Exception e) {
                    this.errore = e.getMessage();
                    return false;
                }
            }
            if (this.proxyPassReverseLocation) {
                boolean bl = this.proxyPassReverseLocation = this.proxyPassReverseHeaders != null && !this.proxyPassReverseHeaders.isEmpty();
            }
            if (this.proxyPassReverseSetCookiePath) {
                boolean bl = this.proxyPassReverseSetCookiePath = this.proxyPassReverseSetCookieHeaders != null && !this.proxyPassReverseSetCookieHeaders.isEmpty();
            }
            if (this.proxyPassReverseSetCookieDomain) {
                this.proxyPassReverseSetCookieDomain = this.proxyPassReverseSetCookieHeaders != null && !this.proxyPassReverseSetCookieHeaders.isEmpty();
            }
            this.proxyPassReverseEnabled = this.proxyPassReverseLocation || this.proxyPassReverseSetCookiePath || this.proxyPassReverseSetCookieDomain;
        }
        return init;
    }

    protected void setSSLContext() throws ConnettoreException {
        if (this.connettoreHttps) {
            this.sslContextProperties = ConnettoreHTTPSProperties.readProperties(this.properties);
        } else {
            String location = (String)this.properties.get("location");
            if (!location.trim().startsWith("https")) {
                if (this.debug) {
                    this.logger.debug("Location non richiede gestione https [" + location.trim() + "]");
                }
                return;
            }
            boolean urlHttpsOverrideJvmConfiguration = ConnettoreHTTPUrlHttpsKeystoreRepository.isEnabled(this.idModulo, this.proprietaPorta);
            if (!urlHttpsOverrideJvmConfiguration) {
                if (this.debug) {
                    this.logger.debug("Location https [" + location.trim() + "]; gestione personalizzata dei keystore disabilitata");
                }
                return;
            }
            ConnettoreHTTPUrlHttpsKeystoreRepository utils = new ConnettoreHTTPUrlHttpsKeystoreRepository(this.debug, this.logger, this.idModulo);
            utils.init(this.proprietaPorta, this.busta, this.dynamicMap, this.getPddContext());
            this.sslContextProperties = utils.readSSLContext(this.requestInfo);
        }
        this.setSecureRandomSSLContext();
    }

    private void setSecureRandomSSLContext() {
        if (this.sslContextProperties != null && !this.sslContextProperties.isSecureRandomSet() && this.openspcoopProperties.isConnettoreHttpsUseSecureRandom()) {
            this.sslContextProperties.setSecureRandom(true);
            if (this.openspcoopProperties.getConnettoreHttpsSecureRandomAlgo() != null) {
                this.sslContextProperties.setSecureRandomAlgorithm(this.openspcoopProperties.getConnettoreHttpsSecureRandomAlgo());
            }
        }
    }

    protected SSLSocketFactory buildSSLContextFactory() throws UtilsException {
        if (this.sslContextProperties != null) {
            StringBuilder sbError = null;
            StringBuilder sbDebug = null;
            try {
                sbError = new StringBuilder();
                this.sslContextProperties.setSbError(sbError);
                if (this.debug) {
                    sbDebug = new StringBuilder();
                    this.sslContextProperties.setSbDebug(sbDebug);
                }
                this.sslContextProperties.setLogger(this.logger.getLogger());
                Map<String, Object> dynamicMap = DynamicMapBuilderUtils.buildDynamicMap(this.busta, this.requestInfo, this.getPddContext(), this.logger != null ? this.logger.getLogger() : null);
                this.sslContextProperties.setDynamicMap(dynamicMap);
                SSLSocketFactory sSLSocketFactory = GestoreKeystoreCaching.getSSLSocketFactory(this.requestInfo, this.sslContextProperties);
                return sSLSocketFactory;
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.error("Lettura SSLSocketFactory '" + this.sslContextProperties.toString() + "' dalla cache fallita: " + e.getMessage(), e);
                }
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (sbError != null && sbError.length() > 0 && this.logger != null) {
                    this.logger.error(sbError.toString());
                }
                if (sbDebug != null && sbDebug.length() > 0 && this.logger != null) {
                    this.logger.info(sbDebug.toString(), false);
                }
            }
        }
        return null;
    }

    protected void updateForwardProxy(ForwardProxy forwardProxy) {
        if (this.forwardProxy == null) {
            this.forwardProxy = forwardProxy;
        }
    }

    protected boolean updateLocationForwardProxy(String location) throws ConnettoreException {
        if (this.forwardProxy != null && this.forwardProxy.isEnabled()) {
            ForwardProxyConfigurazione config = this.forwardProxy.getConfig();
            String base64Location = null;
            if (config.getHeader() != null) {
                this.forwardProxyHeaderName = config.getHeader();
                if (config.isHeaderBase64()) {
                    this.forwardProxyHeaderValue = base64Location = Base64Utilities.encodeAsString((byte[])location.getBytes());
                } else {
                    this.forwardProxyHeaderValue = location;
                    if (this.encodingRFC2047) {
                        try {
                            if (!RFC2047Utilities.isAllCharactersInCharset((String)this.forwardProxyHeaderValue, (Charset)this.charsetRFC2047)) {
                                String encoded = RFC2047Utilities.encode((String)this.forwardProxyHeaderValue, (Charset)this.charsetRFC2047, (RFC2047Encoding)this.encodingAlgorithmRFC2047);
                                if (this.debug) {
                                    this.logger.info("RFC2047 Encoded value [" + this.forwardProxyHeaderValue + "] in [" + encoded + "] (charset:" + String.valueOf(this.charsetRFC2047) + " encoding-algorithm:" + String.valueOf(this.encodingAlgorithmRFC2047) + ")", false);
                                }
                                this.forwardProxyHeaderValue = encoded;
                            }
                        }
                        catch (Exception e) {
                            throw new ConnettoreException(e.getMessage(), e);
                        }
                    }
                }
            }
            HashMap queryParameters = new HashMap();
            if (config.getQuery() != null) {
                if (config.isQueryBase64()) {
                    if (base64Location == null) {
                        base64Location = Base64Utilities.encodeAsString((byte[])location.getBytes());
                    }
                    TransportUtils.addParameter(queryParameters, (String)config.getQuery(), (String)base64Location);
                } else {
                    TransportUtils.addParameter(queryParameters, (String)config.getQuery(), (String)location);
                }
            }
            String newUrl = this.forwardProxy.getUrl();
            if (this.dynamicMap != null) {
                try {
                    newUrl = DynamicUtils.convertDynamicPropertyValue("forwardProxyUrl", newUrl, this.dynamicMap, this.getPddContext(), false);
                }
                catch (Exception e) {
                    this.logger.error("Errore durante la costruzione della url per la funzionalit\u00e0 di 'forwardProxy' (dynamic): " + e.getMessage(), e);
                }
            }
            boolean encodeBaseLocation = true;
            this.location = TransportUtils.buildUrlWithParameters(queryParameters, (String)newUrl, (boolean)encodeBaseLocation, (Logger)(this.logger != null ? this.logger.getLogger() : OpenSPCoop2Logger.getLoggerOpenSPCoopCore()));
            return true;
        }
        return false;
    }

    @Override
    public boolean dumpResponse(Map<String, List<String>> trasporto) throws Exception {
        if (this.isRest) {
            if (this.proxyPassReverseEnabled) {
                this.checkProxyPassReverse();
            }
        } else {
            if (!this.checkSoapHtmlResponse()) {
                return false;
            }
            if (this.proxyPassReverseEnabled) {
                this.checkProxyPassReverse();
            }
        }
        return super.dumpResponse(trasporto);
    }

    @Override
    public boolean doSoapResponse() throws ConnettoreException {
        if (this.debug) {
            this.logger.debug("gestione WS/SOAP in corso (check HTML) ...");
        }
        try {
            if (!this.checkSoapHtmlResponse()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new ConnettoreException(e.getMessage(), e);
        }
        if (this.proxyPassReverseEnabled) {
            this.checkProxyPassReverse();
        }
        return super.doSoapResponse();
    }

    private boolean checkSoapHtmlResponse() throws UtilsException, IOException {
        if (this.codice >= 400 && (this.tipoRisposta != null && this.tipoRisposta.contains("text/html") || this.tipoRisposta == null || StringUtils.isEmpty((CharSequence)this.tipoRisposta))) {
            String tmpResultHTTPMessage = this.resultHTTPMessage;
            if (tmpResultHTTPMessage == null) {
                tmpResultHTTPMessage = HttpUtilities.getHttpReason((int)this.codice);
            }
            String tipoLetturaRisposta = "(" + this.codice + ") " + tmpResultHTTPMessage;
            String htmlRicevuto = null;
            if (this.isResponse != null) {
                this.emitDiagnosticResponseRead(this.isResponse);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                CopyStream.copy((InputStream)this.isResponse, (OutputStream)bout);
                this.isResponse.close();
                bout.flush();
                bout.close();
                htmlRicevuto = bout.toString();
            }
            this.errore = htmlRicevuto != null && !"".equals(htmlRicevuto) ? tipoLetturaRisposta + "\nhttp response: " + htmlRicevuto : tipoLetturaRisposta;
            return false;
        }
        return true;
    }

    @Override
    public boolean doRestResponse() throws ConnettoreException {
        if (this.proxyPassReverseEnabled) {
            this.checkProxyPassReverse();
        }
        return super.doRestResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProxyPassReverse() throws ConnettoreException {
        block43: {
            if (!this.proxyPassReverseDone) {
                try {
                    if (this.debug) {
                        this.logger.debug("gestione (rest:" + this.isRest + ") - proxyPassReverse:" + this.proxyPassReverseEnabled + " (location:" + this.proxyPassReverseLocation + " setCookie-path:" + this.proxyPassReverseSetCookiePath + " setCookie-domain:" + this.proxyPassReverseSetCookieDomain + ") ...");
                    }
                    if (!this.proxyPassReverseEnabled) break block43;
                    String baseUrl = null;
                    String prefixGatewayUrl = null;
                    String contesto = null;
                    try {
                        baseUrl = (String)this.properties.get("location");
                        if (baseUrl == null) {
                            throw new ConnettoreException("BaseURL undefined");
                        }
                        if (this.debug) {
                            this.logger.debug("Base URL: [" + baseUrl + "]");
                        }
                        String interfaceName = null;
                        if (this.requestMsg != null) {
                            Object porta = this.requestMsg.getContextProperty(CostantiPdD.NOME_PORTA_INVOCATA);
                            if (porta instanceof String) {
                                String s;
                                interfaceName = s = (String)porta;
                            }
                            if (interfaceName == null && this.requestMsg.getTransportRequestContext() != null) {
                                interfaceName = this.requestMsg.getTransportRequestContext().getInterfaceName();
                            }
                            if (interfaceName == null) {
                                if (this.pa != null) {
                                    interfaceName = this.pa.getNome();
                                } else if (this.pd != null) {
                                    interfaceName = this.pd.getNome();
                                }
                            }
                        }
                        if (this.proxyPassReverseUsePrefixProtocol) {
                            UrlInvocazioneAPI urlInvocazioneApi = ConfigurazionePdDManager.getInstance().getConfigurazioneUrlInvocazione(this.getProtocolFactory(), "ConsegnaContenutiApplicativi".equals(this.idModulo) ? RuoloContesto.PORTA_APPLICATIVA : RuoloContesto.PORTA_DELEGATA, this.requestMsg != null ? this.requestMsg.getServiceBinding() : null, interfaceName, this.requestInfo != null ? this.requestInfo.getIdentitaPdD() : null, this.getIdAccordo(), this.requestInfo);
                            prefixGatewayUrl = urlInvocazioneApi.getBaseUrl();
                            contesto = urlInvocazioneApi.getContext();
                        }
                    }
                    catch (Exception e) {
                        throw new ConnettoreException("Errore durante la raccolta delle informazioni necessarie alla funzione di proxy pass reverse: " + e.getMessage(), e);
                    }
                    if (this.proxyPassReverseLocation) {
                        for (String header : this.proxyPassReverseHeaders) {
                            String redirectLocation = TransportUtils.getFirstValue((Map)this.propertiesTrasportoRisposta, (String)header);
                            if (redirectLocation == null) continue;
                            if (this.debug) {
                                this.logger.debug("Trovato Header '" + header + "':[" + redirectLocation + "]");
                            }
                            try {
                                String newRedirectLocation = RestUtilities.buildPassReverseUrl((TransportRequestContext)this.requestMsg.getTransportRequestContext(), (String)baseUrl, (String)redirectLocation, (String)prefixGatewayUrl, (String)contesto);
                                if (this.debug) {
                                    this.logger.debug("Nuovo Header '" + header + "':[" + newRedirectLocation + "]");
                                }
                                if (redirectLocation.equals(newRedirectLocation)) continue;
                                TransportUtils.removeObject((Map)this.propertiesTrasportoRisposta, (String)header);
                                TransportUtils.addHeader((Map)this.propertiesTrasportoRisposta, (String)header, (String)newRedirectLocation);
                            }
                            catch (Exception e) {
                                throw new ConnettoreException("Errore durante l'aggiornamento dell'header '" + header + "' attraverso la funzione di proxy pass reverse: " + e.getMessage(), e);
                            }
                        }
                    }
                    if (!this.proxyPassReverseSetCookiePath && !this.proxyPassReverseSetCookieDomain) break block43;
                    for (String header : this.proxyPassReverseSetCookieHeaders) {
                        List cookieValues = TransportUtils.getValues((Map)this.propertiesTrasportoRisposta, (String)header);
                        ArrayList<String> newCookieValues = null;
                        boolean modify = false;
                        if (cookieValues != null && !cookieValues.isEmpty()) {
                            newCookieValues = new ArrayList<String>();
                            for (String cookieValue : cookieValues) {
                                if (cookieValue == null) continue;
                                if (this.debug) {
                                    this.logger.debug("Trovato CookieHeader '" + header + "':[" + cookieValue + "]");
                                }
                                ArrayList<String> cookieNames = new ArrayList<String>();
                                ArrayList<String> cookiePaths = new ArrayList<String>();
                                ArrayList<String> cookieDomains = new ArrayList<String>();
                                try {
                                    List<HttpCookie> l = HttpCookie.parse(cookieValue);
                                    for (HttpCookie httpCookie : l) {
                                        if (httpCookie.getPath() == null) continue;
                                        cookieNames.add(httpCookie.getName());
                                        cookiePaths.add(httpCookie.getPath());
                                        cookieDomains.add(httpCookie.getDomain());
                                    }
                                }
                                catch (Exception e) {
                                    this.logger.error("Errore durante il parsing del valore dell'header '" + header + "' (gestione cookie): " + e.getMessage(), e);
                                }
                                if (cookieNames.isEmpty()) continue;
                                for (int i = 0; i < cookieNames.size(); ++i) {
                                    String cName = (String)cookieNames.get(i);
                                    String cPath = (String)cookiePaths.get(i);
                                    String cDomain = (String)cookieDomains.get(i);
                                    String newValue = cookieValue;
                                    if (this.proxyPassReverseSetCookiePath) {
                                        try {
                                            if (cPath != null) {
                                                String newPath = RestUtilities.buildCookiePassReversePath((TransportRequestContext)this.requestMsg.getTransportRequestContext(), (String)baseUrl, (String)cPath, (String)prefixGatewayUrl, (String)contesto);
                                                if (this.debug) {
                                                    this.logger.debug("Nuovo Path '" + cName + "' (header:" + header + "):[" + newPath + "] ...");
                                                }
                                                if (!cPath.equals(newPath)) {
                                                    newValue = newValue.replace(cPath, newPath);
                                                    modify = true;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            throw new ConnettoreException("Errore durante l'aggiornamento del cookie '" + cName + "' (header:" + header + ") attraverso la funzione di proxy pass reverse: " + e.getMessage(), e);
                                        }
                                    }
                                    if (this.proxyPassReverseSetCookieDomain) {
                                        try {
                                            if (cDomain != null) {
                                                String newDomain = RestUtilities.buildCookiePassReverseDomain((TransportRequestContext)this.requestMsg.getTransportRequestContext(), (String)baseUrl, (String)cDomain, (String)prefixGatewayUrl);
                                                if (this.debug) {
                                                    this.logger.debug("Nuovo Domain '" + cDomain + "' (header:" + header + "):[" + newDomain + "] ...");
                                                }
                                                if (!cDomain.equals(newDomain)) {
                                                    newValue = newValue.replace(cDomain, newDomain);
                                                    modify = true;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            throw new ConnettoreException("Errore durante l'aggiornamento del cookie '" + cName + "' (header:" + header + ") attraverso la funzione di proxy pass reverse: " + e.getMessage(), e);
                                        }
                                    }
                                    newCookieValues.add(newValue);
                                }
                            }
                        }
                        if (!modify) continue;
                        TransportUtils.removeObject((Map)this.propertiesTrasportoRisposta, (String)header);
                        this.propertiesTrasportoRisposta.put(header, newCookieValues);
                    }
                }
                finally {
                    this.proxyPassReverseDone = true;
                }
            }
        }
    }
}

