/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.io.ByteArrayOutputStream;
import java.net.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseHTTP;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.RFC2047Utilities;

public abstract class ConnettoreExtBaseHTTP
extends ConnettoreBaseHTTP {
    public ByteArrayOutputStream outByte = new ByteArrayOutputStream();
    protected Proxy.Type proxyType = null;
    protected String proxyHostname = null;
    protected int proxyPort;
    protected String proxyUsername;
    protected String proxyPassword;
    protected boolean followRedirects = false;
    protected String routeRedirect = null;
    protected int numberRedirect = 0;
    protected int maxNumberRedirects = 5;
    protected String redirectLocation = null;
    protected String originalAbsolutePrefixForRelativeRedirectLocation = null;
    protected TransferLengthModes tlm = null;
    protected int chunkLength = -1;

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public String getRouteRedirect() {
        return this.routeRedirect;
    }

    public int getNumberRedirect() {
        return this.numberRedirect;
    }

    public int getMaxNumberRedirects() {
        return this.maxNumberRedirects;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setOriginalAbsolutePrefixForRelativeRedirectLocation(String originalAbsolutePrefixForRelativeRedirectLocation) {
        this.originalAbsolutePrefixForRelativeRedirectLocation = originalAbsolutePrefixForRelativeRedirectLocation;
    }

    public String getOriginalAbsolutePrefixForRelativeRedirectLocation() {
        return this.originalAbsolutePrefixForRelativeRedirectLocation;
    }

    public ConnettoreExtBaseHTTP() {
    }

    public ConnettoreExtBaseHTTP(boolean https) {
        super(https);
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, true, responseCachingConfig);
    }

    @Override
    public boolean send(ConnettoreMsg request) {
        try {
            this.setSSLContext();
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            this.logger.error("[HTTPS error]" + this.readExceptionMessageFromException(e), e);
            this.errore = "[HTTPS error]" + this.readExceptionMessageFromException(e);
            return false;
        }
        if (this.properties.get("proxyType") != null) {
            String tipo = ((String)this.properties.get("proxyType")).trim();
            if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP.equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else if (CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS.equals(tipo)) {
                this.proxyType = Proxy.Type.HTTP;
            } else {
                this.errore = "Proprieta' 'proxyType' non corretta. Impostato un tipo sconosciuto [" + tipo + "] (valori ammessi: " + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP + "," + CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTPS + ")";
                return false;
            }
            this.proxyHostname = (String)this.properties.get("proxyHostname");
            if (this.proxyHostname == null) {
                this.errore = "Proprieta' 'proxyHostname' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            this.proxyHostname = this.proxyHostname.trim();
            String proxyPortTmp = (String)this.properties.get("proxyPort");
            if (proxyPortTmp == null) {
                this.errore = "Proprieta' 'proxyPort' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyType'";
                return false;
            }
            proxyPortTmp = proxyPortTmp.trim();
            try {
                this.proxyPort = Integer.parseInt(proxyPortTmp);
            }
            catch (Exception e) {
                this.errore = "Proprieta' 'proxyPort' non corretta: " + this.readExceptionMessageFromException(e);
                return false;
            }
            this.proxyUsername = (String)this.properties.get("proxyUsername");
            if (this.proxyUsername != null) {
                this.proxyUsername = this.proxyUsername.trim();
            }
            this.proxyPassword = (String)this.properties.get("proxyPassword");
            if (this.proxyPassword != null) {
                this.proxyPassword = this.proxyPassword.trim();
            } else if (this.proxyUsername != null) {
                this.errore = "Proprieta' 'proxyPassword' non impostata, obbligatoria in presenza della propriet\u00e0 'proxyUsername'";
                return false;
            }
        }
        if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
            this.tlm = this.openspcoopProperties.getTransferLengthModes_consegnaContenutiApplicativi();
            this.chunkLength = this.openspcoopProperties.getChunkLength_consegnaContenutiApplicativi();
        } else {
            this.tlm = this.openspcoopProperties.getTransferLengthModes_inoltroBuste();
            this.chunkLength = this.openspcoopProperties.getChunkLength_inoltroBuste();
        }
        String tlmTmp = (String)this.properties.get("dataTransferMode");
        if (tlmTmp != null) {
            tlmTmp = tlmTmp.trim();
            try {
                this.tlm = TransferLengthModes.getTransferLengthModes((String)tlmTmp);
            }
            catch (Exception e) {
                this.errore = "Proprieta' 'dataTransferMode' non impostata correttamente: " + e.getMessage();
                return false;
            }
        }
        if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.equals((Object)this.tlm) && (tlmTmp = (String)this.properties.get("transferChunkSize")) != null) {
            tlmTmp = tlmTmp.trim();
            this.chunkLength = Integer.parseInt(tlmTmp);
        }
        if ("ConsegnaContenutiApplicativi".equals(this.idModulo)) {
            this.followRedirects = this.isSoap ? this.openspcoopProperties.isFollowRedirects_consegnaContenutiApplicativi_soap() : this.openspcoopProperties.isFollowRedirects_consegnaContenutiApplicativi_rest();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_consegnaContenutiApplicativi();
        } else {
            this.followRedirects = this.isSoap ? this.openspcoopProperties.isFollowRedirects_inoltroBuste_soap() : this.openspcoopProperties.isFollowRedirects_inoltroBuste_rest();
            this.maxNumberRedirects = this.openspcoopProperties.getFollowRedirectsMaxHop_inoltroBuste();
        }
        String redirectTmp = (String)this.properties.get("followRedirects");
        if (redirectTmp != null) {
            boolean bl = this.followRedirects = "true".equalsIgnoreCase(redirectTmp = redirectTmp.trim()) || CostantiConfigurazione.ABILITATO.getValue().equalsIgnoreCase(redirectTmp);
        }
        if (this.followRedirects) {
            redirectTmp = (String)this.properties.get("maxHopRedirect");
            if (redirectTmp != null) {
                redirectTmp = redirectTmp.trim();
                this.maxNumberRedirects = Integer.parseInt(redirectTmp);
            }
            if ((redirectTmp = (String)this.properties.get("numberRedirect")) != null) {
                redirectTmp = redirectTmp.trim();
                this.numberRedirect = Integer.parseInt(redirectTmp);
            }
            if ((redirectTmp = (String)this.properties.get("routeRedirect")) != null) {
                this.routeRedirect = redirectTmp = redirectTmp.trim();
            }
        }
        return this.sendHTTP(request);
    }

    protected abstract boolean sendHTTP(ConnettoreMsg var1);

    @Override
    public String getLocation() {
        if (this.location == null) {
            try {
                this.buildLocation();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.location != null) {
            Object l = new String(this.location);
            if (this.routeRedirect != null) {
                l = (String)l + " [redirects route path: " + this.routeRedirect + "]";
            }
            if (this.proxyType != null) {
                l = (String)l + " [proxy: " + this.proxyHostname + ":" + this.proxyPort + "]";
            }
            return l;
        }
        return null;
    }

    protected String getTipoImplConnettore() {
        if (this.tipoConnettore != null && StringUtils.isNotEmpty((CharSequence)this.tipoConnettore)) {
            return this.tipoConnettore;
        }
        return this.connettoreHttps ? TipiConnettore.HTTPS.toString() : TipiConnettore.HTTP.toString();
    }

    protected void buildLocation() throws ConnettoreException {
        NameValue dpopNv;
        this.location = this.redirectLocation != null ? this.redirectLocation : TransportUtils.getObjectAsString((Map)this.properties, (String)"location");
        String nameTokenQueryParameter = this.getNameTokenQueryParameter();
        if (nameTokenQueryParameter != null && !StringUtils.isEmpty((CharSequence)nameTokenQueryParameter) && this.requestMsg != null && this.requestMsg.getTransportRequestContext() != null) {
            this.requestMsg.getTransportRequestContext().removeParameter(nameTokenQueryParameter);
        }
        if (this.redirectLocation == null) {
            this.location = ConnettoreUtils.buildLocationWithURLBasedParameter(this.logger != null ? this.logger.getLogger() : null, this.requestMsg, this.getTipoImplConnettore(), this.propertiesUrlBased, this.location, this.getProtocolFactory(), this.idModulo);
        }
        this.updateLocationForwardProxy(this.location);
        this.ensureTokenNegotiated(this.httpMethod);
        HashMap newPropertiesUrlBased = null;
        NameValue nv = this.getTokenQueryParameter();
        if (nv != null) {
            newPropertiesUrlBased = new HashMap();
            TransportUtils.setParameter(newPropertiesUrlBased, (String)nv.getName(), (String)nv.getValue());
        }
        if ((dpopNv = this.getDpopBackendQueryParameter()) != null) {
            if (newPropertiesUrlBased == null) {
                newPropertiesUrlBased = new HashMap();
            }
            TransportUtils.setParameter(newPropertiesUrlBased, (String)dpopNv.getName(), (String)dpopNv.getValue());
        }
        this.location = TransportUtils.buildUrlWithParameters(newPropertiesUrlBased, (String)this.location, this.logger != null ? this.logger.getLogger() : null);
    }

    protected void setRequestHeader(boolean validazioneHeaderRFC2047, String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (validazioneHeaderRFC2047) {
            try {
                RFC2047Utilities.validHeader((String)key, values);
                this.setRequestHeader(key, values, propertiesTrasportoDebug);
            }
            catch (UtilsException e) {
                logger.error(e.getMessage(), e);
            }
        } else {
            this.setRequestHeader(key, values, propertiesTrasportoDebug);
        }
    }

    @Override
    protected abstract void setRequestHeader(String var1, List<String> var2) throws ConnettoreException;
}

