/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import java.util.Date;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreDirectVM;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.services.connector.ConnectorException;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorInMessage;
import org.openspcoop2.pdd.services.connector.messages.DirectVMConnectorOutMessage;
import org.openspcoop2.pdd.services.service.RicezioneContenutiApplicativiService;
import org.openspcoop2.protocol.sdk.constants.IDService;
import org.openspcoop2.utils.date.DateManager;

public class ConnettoreRicezioneContenutiApplicativiDirectVM
extends AbstractConnettoreDirectVM {
    public static final String TIPO = "vmPD";
    private String nomePD;

    @Override
    public String getIdModulo() {
        return "RicezioneContenutiApplicativi_VM";
    }

    @Override
    public IDService getIdModuloAsIDService() {
        return IDService.PORTA_DELEGATA;
    }

    @Override
    public String getFunction() {
        return "PD";
    }

    @Override
    public void process(DirectVMConnectorInMessage inMessage, DirectVMConnectorOutMessage outMessage) throws ConnectorException {
        RicezioneContenutiApplicativiService soapConnector = new RicezioneContenutiApplicativiService(null);
        Date dataAccettazioneRichiesta = DateManager.getDate();
        soapConnector.process(inMessage, outMessage, dataAccettazioneRichiesta, false);
    }

    @Override
    public boolean validate(ConnettoreMsg request) {
        if (request.getConnectorProperties().get("pd") == null) {
            this.errore = "Proprieta' 'pd' non fornita e richiesta da questo tipo di connettore [" + request.getTipoConnettore() + "]";
            return false;
        }
        this.nomePD = request.getConnectorProperties().get("pd").trim();
        return true;
    }

    @Override
    public String getFunctionParameters() {
        return super.normalizeFunctionParamters(this.nomePD);
    }
}

