/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori;

import jakarta.xml.soap.SOAPBody;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.TunnelSoapUtils;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.Utilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreBaseWithResponse;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.ConnettoreMsg;
import org.openspcoop2.pdd.core.connettori.ConnettoreStatusResponseType;
import org.openspcoop2.pdd.core.controllo_traffico.policy.GestoreCacheControlloTraffico;
import org.openspcoop2.protocol.engine.builder.Imbustamento;
import org.openspcoop2.protocol.engine.builder.Sbustamento;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.validator.Validatore;
import org.openspcoop2.protocol.engine.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Integrazione;
import org.openspcoop2.protocol.sdk.ProtocolMessage;
import org.openspcoop2.protocol.sdk.Riscontro;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.FaseImbustamento;
import org.openspcoop2.protocol.sdk.constants.FaseSbustamento;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoOraRegistrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazione;
import org.openspcoop2.protocol.sdk.validator.ProprietaValidazioneErrori;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;
import org.openspcoop2.utils.rest.problem.XmlSerializer;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.w3c.dom.Node;

public class ConnettoreStatus
extends ConnettoreBaseWithResponse {
    public static final String LOCATION = "govway://status";
    private DumpByteArrayOutputStream requestBout = null;

    @Override
    public String getProtocollo() {
        return "";
    }

    public static String getMessage(ConnettoreStatusResponseType statusResponseType, MessageType messageTypeRequest) throws UtilsException {
        ProblemRFC7807 problemRFC7807 = new ProblemRFC7807();
        problemRFC7807.setStatus(Integer.valueOf(200));
        problemRFC7807.setDetail("Il servizio funziona correttamente");
        problemRFC7807.setTitle("Success");
        problemRFC7807.setType("https://httpstatuses.com/200");
        switch (statusResponseType) {
            case MODI: {
                return ConnettoreStatus.getMessageModI(messageTypeRequest, problemRFC7807);
            }
            case VUOTO: {
                return "";
            }
            case XML: {
                XmlSerializer xmlSerializer = new XmlSerializer();
                return xmlSerializer.toString(problemRFC7807).replace("problem", "status");
            }
            case JSON: {
                JsonSerializer jsonSerializer = new JsonSerializer();
                return jsonSerializer.toString(problemRFC7807);
            }
            case TEXT: {
                return "Il servizio funziona correttamente";
            }
        }
        return null;
    }

    private static String getMessageModI(MessageType messageTypeRequest, ProblemRFC7807 problemRFC7807) throws UtilsException {
        switch (messageTypeRequest) {
            case SOAP_11: 
            case SOAP_12: {
                XmlSerializer xmlSerializer = new XmlSerializer();
                String p = xmlSerializer.toString(problemRFC7807, true);
                return "<?xml version='1.0' encoding='UTF-8'?><soapenv:Envelope xmlns:soapenv=\"" + (MessageType.SOAP_11.equals((Object)messageTypeRequest) ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope") + "\"><soapenv:Body>" + p + "</soapenv:Body></soapenv:Envelope>";
            }
            case XML: {
                XmlSerializer xmlSerializer = new XmlSerializer();
                return xmlSerializer.toString(problemRFC7807);
            }
            case JSON: 
            case BINARY: 
            case MIME_MULTIPART: {
                JsonSerializer jsonSerializer = new JsonSerializer();
                return jsonSerializer.toString(problemRFC7807);
            }
        }
        throw new UtilsException("Message type unknown");
    }

    public static String getContentType(ConnettoreStatusResponseType statusResponseType, MessageType messageTypeRequest) throws UtilsException {
        switch (statusResponseType) {
            case MODI: {
                return ConnettoreStatus.getContentTypeModI(messageTypeRequest);
            }
            case VUOTO: {
                return null;
            }
            case XML: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
            case TEXT: {
                return "text/plain";
            }
        }
        return null;
    }

    private static String getContentTypeModI(MessageType messageTypeRequest) throws UtilsException {
        switch (messageTypeRequest) {
            case SOAP_11: {
                return "text/xml";
            }
            case SOAP_12: {
                return "application/soap+xml";
            }
            case XML: {
                return "application/xml";
            }
            case JSON: 
            case BINARY: 
            case MIME_MULTIPART: {
                return "application/json";
            }
        }
        throw new UtilsException("Message type unknown");
    }

    private void testConnectivityErogazione(Map<Long, String> connettoriServizio, Map<Long, String> connettoriServizioNomeConnettoreMultiplo) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazionePdDManager configurazioneManager = ConfigurazionePdDManager.getInstance();
        IDServizio idServizio = this.getServizio();
        List<MappingErogazionePortaApplicativa> mappings = configurazioneManager.getMappingErogazionePortaApplicativaList(idServizio, this.requestInfo);
        for (MappingErogazionePortaApplicativa mapping : mappings) {
            PortaApplicativa pa = configurazioneManager.getPortaApplicativaSafeMethod(mapping.getIdPortaApplicativa(), this.requestInfo);
            if (pa.equals((Object)this.pa)) continue;
            List serviziApplicativi = pa.getServizioApplicativo();
            for (PortaApplicativaServizioApplicativo sa : serviziApplicativi) {
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setNome(sa.getNome());
                idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                ServizioApplicativo servizioApplicativo = configurazioneManager.getServizioApplicativo(idServizioApplicativo, this.requestInfo);
                this.testConnectivityErogazione(connettoriServizio, connettoriServizioNomeConnettoreMultiplo, mapping, sa, servizioApplicativo);
            }
        }
    }

    private void testConnectivityErogazione(Map<Long, String> connettoriServizio, Map<Long, String> connettoriServizioNomeConnettoreMultiplo, MappingErogazionePortaApplicativa mapping, PortaApplicativaServizioApplicativo sa, ServizioApplicativo servizioApplicativo) {
        if (servizioApplicativo.getInvocazioneServizio() != null && servizioApplicativo.getInvocazioneServizio().getConnettore() != null && servizioApplicativo.getInvocazioneServizio().getConnettore().getId() != null) {
            this.testConnectivityErogazione(servizioApplicativo.getInvocazioneServizio().getConnettore(), mapping, connettoriServizio);
            if (sa.getDatiConnettore() != null && sa.getDatiConnettore().getNome() != null && StringUtils.isNotEmpty((CharSequence)sa.getDatiConnettore().getNome())) {
                connettoriServizioNomeConnettoreMultiplo.put(servizioApplicativo.getInvocazioneServizio().getConnettore().getId(), sa.getDatiConnettore().getNome());
            }
        }
        if (servizioApplicativo.getRispostaAsincrona() != null && servizioApplicativo.getRispostaAsincrona().getConnettore() != null && servizioApplicativo.getRispostaAsincrona().getConnettore().getId() != null) {
            this.testConnectivityErogazione(servizioApplicativo.getRispostaAsincrona().getConnettore(), mapping, connettoriServizio);
            connettoriServizioNomeConnettoreMultiplo.put(servizioApplicativo.getRispostaAsincrona().getConnettore().getId(), "Risposta asincrona");
        }
    }

    private void testConnectivityErogazione(Connettore connettore, MappingErogazionePortaApplicativa mapping, Map<Long, String> connettoriServizio) {
        if (connettore != null && connettore.getId() != null && this.checkConnectivitySupported(connettore.getTipo())) {
            String labelGruppo = mapping.getDescrizione();
            if (mapping.isDefault() && (labelGruppo == null || StringUtils.isEmpty((CharSequence)labelGruppo))) {
                labelGruppo = "Predefinito";
            }
            connettoriServizio.put(connettore.getId(), labelGruppo);
        }
    }

    private void testConnectivityFruizione(Map<Long, String> connettoriServizio) throws DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ConfigurazionePdDManager configurazioneManager = ConfigurazionePdDManager.getInstance();
        IDServizio idServizio = this.getServizio();
        IDSoggetto idFruitore = new IDSoggetto(this.pd.getTipoSoggettoProprietario(), this.pd.getNomeSoggettoProprietario());
        List<MappingFruizionePortaDelegata> mappings = configurazioneManager.getMappingFruizionePortaDelegataList(idFruitore, idServizio, this.requestInfo);
        for (MappingFruizionePortaDelegata mapping : mappings) {
            PortaDelegata pd = configurazioneManager.getPortaDelegataSafeMethod(mapping.getIdPortaDelegata(), null);
            if (pd.equals((Object)this.pd)) continue;
            PortaDelegataAzione azioni = pd.getAzione();
            for (String azione : azioni.getAzioneDelegataList()) {
                if (idServizio != null) {
                    idServizio.setAzione(azione);
                }
                Connettore connettore = configurazioneManager.getForwardRoute(idFruitore, idServizio, false, null);
                this.testConnectivityFruizione(connettore, mapping, connettoriServizio);
            }
        }
    }

    private void testConnectivityFruizione(Connettore connettore, MappingFruizionePortaDelegata mapping, Map<Long, String> connettoriServizio) {
        if (connettore != null && connettore.getId() != null && this.checkConnectivitySupported(connettore.getTipo())) {
            String labelGruppo = mapping.getDescrizione();
            if (mapping.isDefault() && (labelGruppo == null || StringUtils.isEmpty((CharSequence)labelGruppo))) {
                labelGruppo = "Predefinito";
            }
            connettoriServizio.put(connettore.getId(), labelGruppo);
        }
    }

    private boolean checkConnectivitySupported(String tipoConnettore) {
        TipiConnettore tipo = TipiConnettore.toEnumFromName((String)tipoConnettore);
        return tipo != null && (TipiConnettore.HTTP.equals((Object)tipo) || TipiConnettore.HTTPS.equals((Object)tipo));
    }

    private void testConnectivity() throws DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound, ConnettoreException {
        HashMap<Long, String> connettoriServizio = new HashMap<Long, String>();
        HashMap<Long, String> connettoriServizioNomeConnettoreMultiplo = new HashMap<Long, String>();
        if (this.pd != null) {
            this.testConnectivityFruizione(connettoriServizio);
        }
        if (this.pa != null) {
            this.testConnectivityErogazione(connettoriServizio, connettoriServizioNomeConnettoreMultiplo);
        }
        if (this.debug) {
            this.logger.debug("Inizio test connettivita sul servizio: " + String.valueOf(this.getServizio()) + ", id connettori: {" + String.valueOf(connettoriServizio.keySet()) + "}");
        }
        for (Map.Entry entry : connettoriServizio.entrySet()) {
            try {
                ConnettoreCheck.check((Long)entry.getKey(), this.pd != null, null);
            }
            catch (ConnettoreException e) {
                Object nomeConnettore = (String)connettoriServizioNomeConnettoreMultiplo.get(entry.getKey());
                nomeConnettore = nomeConnettore == null || StringUtils.isEmpty((CharSequence)nomeConnettore) ? "" : " '" + (String)nomeConnettore + "'";
                throw new ConnettoreException("connettivit\u00e0 fallita verso il connettore" + (String)nomeConnettore + " del gruppo '" + (String)entry.getValue() + "': " + e.getMessage());
            }
        }
    }

    private IDServizio getServizio() throws DriverRegistroServiziException {
        if (this.pd != null) {
            return IDServizioFactory.getInstance().getIDServizioFromValues(this.pd.getServizio().getTipo(), this.pd.getServizio().getNome(), this.getSoggettoErogatore(), this.pd.getServizio().getVersione().intValue());
        }
        if (this.pa != null) {
            return IDServizioFactory.getInstance().getIDServizioFromValues(this.pa.getServizio().getTipo(), this.pa.getServizio().getNome(), this.getSoggettoErogatore(), this.pa.getServizio().getVersione().intValue());
        }
        return null;
    }

    private IDSoggetto getSoggettoFruitore() {
        return this.pd == null ? null : new IDSoggetto(this.pd.getTipoSoggettoProprietario(), this.pd.getNomeSoggettoProprietario());
    }

    private IDSoggetto getSoggettoErogatore() {
        if (this.pd != null) {
            return new IDSoggetto(this.pd.getSoggettoErogatore().getTipo(), this.pd.getSoggettoErogatore().getNome());
        }
        if (this.pa != null) {
            return new IDSoggetto(this.pa.getTipoSoggettoProprietario(), this.pa.getNomeSoggettoProprietario());
        }
        return null;
    }

    private List<String> getOperations() {
        List<String> l = null;
        if (this.pd != null) {
            return this.pd.getAzione().getAzioneDelegata();
        }
        if (this.pa != null) {
            return this.pa.getAzione().getAzioneDelegata();
        }
        return l;
    }

    private void testStatistics() throws Exception {
        DatiTransazione datiTransazioni = new DatiTransazione();
        datiTransazioni.setDominio(this.getSoggettoErogatore());
        datiTransazioni.setIdTransazione(this.idTransazione);
        datiTransazioni.setModulo(this.idModulo);
        String periodRaw = this.getDynamicProperty(this.tipoConnettore, false, "period", this.dynamicMap);
        String periodValueRaw = this.getDynamicProperty(this.tipoConnettore, false, "periodValue", this.dynamicMap);
        String lifetimeRaw = this.getDynamicProperty(this.tipoConnettore, false, "statLifetime", this.dynamicMap);
        if (periodRaw == null) {
            throw new ConnettoreException("il tipo del periodo statistico non corretto, valori possibili: " + Arrays.toString(TipoPeriodoStatistico.toArray()));
        }
        TipoPeriodoStatistico period = TipoPeriodoStatistico.valueOf((String)periodRaw.toUpperCase());
        Integer periodValue = Integer.valueOf(periodValueRaw);
        Integer lifeTime = lifetimeRaw != null ? Integer.valueOf(lifetimeRaw) : Integer.MAX_VALUE;
        if (periodValue <= 0) {
            throw new ConnettoreException("il valore del periodo deve essere un valore > 1");
        }
        if (this.debug) {
            this.logger.debug("Inizio analisi statistica sulle transazioni del servizio:" + String.valueOf(this.getServizio()));
        }
        Date now = new Date();
        RisultatoStatistico numOk = GestoreCacheControlloTraffico.getInstance().readNumeroEsiti(period, periodValue, now, List.of(Integer.valueOf(0)), this.getServizio(), this.getSoggettoFruitore(), this.getOperations(), datiTransazioni, this.state, lifeTime);
        RisultatoStatistico numTot = GestoreCacheControlloTraffico.getInstance().readNumeroEsiti(period, periodValue, now, null, this.getServizio(), this.getSoggettoFruitore(), this.getOperations(), datiTransazioni, this.state, lifeTime);
        if (numOk.getRisultato() == 0L && numTot.getRisultato() > 0L) {
            throw new ConnettoreException("trovate: " + numTot.getRisultato() + " transazioni con errore, nessuna transazione ok");
        }
    }

    @Override
    protected boolean initializePreSend(ResponseCachingConfigurazione responseCachingConfig, ConnettoreMsg request) {
        return this.initialize(request, false, responseCachingConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean send(ConnettoreMsg request) {
        boolean generaTrasmissione = false;
        if (this.properties.get("generaTrasmissione") != null) {
            generaTrasmissione = "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissione")).trim());
        }
        boolean generaTrasmissioneInvertita = false;
        if (this.properties.get("generaTrasmissioneInvertita") != null) {
            generaTrasmissioneInvertita = "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissioneInvertita")).trim());
        }
        boolean generaTrasmissioneAndataRitorno = false;
        if (this.properties.get("generaTrasmissioneAndataRitorno") != null) {
            generaTrasmissioneAndataRitorno = "true".equalsIgnoreCase(((String)this.properties.get("generaTrasmissioneAndataRitorno")).trim());
        }
        ConnettoreStatusResponseType statusResponseType = null;
        boolean isStatisticalAnalysis = false;
        boolean isTestConnectivity = false;
        try {
            String statusResponseTypeRaw = this.getDynamicProperty(this.tipoConnettore, true, "statusResponseType", this.dynamicMap);
            String statisticalAnalysisRaw = this.getDynamicProperty(this.tipoConnettore, false, "period", this.dynamicMap);
            String testConnectivityRaw = this.getDynamicProperty(this.tipoConnettore, false, "testConnectivity", this.dynamicMap);
            isStatisticalAnalysis = statisticalAnalysisRaw != null;
            isTestConnectivity = testConnectivityRaw != null && testConnectivityRaw.equals(Boolean.TRUE.toString());
            statusResponseType = ConnettoreStatusResponseType.fromString(statusResponseTypeRaw);
        }
        catch (ConnettoreException e) {
            statusResponseType = null;
            this.logger.error("Tipologia risposta del connettore status non impostata");
        }
        if (this.debug) {
            this.logger.debug("connettoreStatus: [type: " + String.valueOf(statusResponseType) + ", test connectivity: " + isTestConnectivity + ", statistical analysis: " + isStatisticalAnalysis);
        }
        this.codice = 200;
        DBManager dbManager = DBManager.getInstance();
        Resource resource = null;
        StatefulMessage state = new StatefulMessage(null, this.logger.getLogger());
        ValidazioneSintattica validatoreSintattico = null;
        Validatore validatoreProtocollo = null;
        BustaRawContent headerProtocolloRisposta = null;
        String protocol = null;
        try {
            OpenSPCoop2MessageParseResult pr;
            IProtocolFactory<?> protocolFactory = this.getProtocolFactory();
            IProtocolManager protocolManager = protocolFactory.createProtocolManager();
            protocol = protocolFactory.getProtocol();
            MessageType requestMessageType = this.requestMsg.getMessageType();
            OpenSPCoop2SoapMessage soapMessageRequest = null;
            if (this.debug) {
                this.logger.debug("Tipologia Servizio: " + String.valueOf(this.requestMsg.getServiceBinding()));
            }
            if (this.isSoap) {
                soapMessageRequest = this.requestMsg.castAsSoap();
            }
            HashMap<String, List<String>> propertiesTrasportoDebug = null;
            if (this.isDumpBinarioRichiesta()) {
                propertiesTrasportoDebug = new HashMap<String, List<String>>();
            }
            String contentTypeRichiesta = null;
            if (this.debug) {
                this.logger.debug("Impostazione content type...");
            }
            if (this.isSoap) {
                contentTypeRichiesta = this.sbustamentoSoap && soapMessageRequest.countAttachments() > 0 && TunnelSoapUtils.isTunnelOpenSPCoopSoap((OpenSPCoop2SoapMessage)soapMessageRequest) ? TunnelSoapUtils.getContentTypeTunnelOpenSPCoopSoap((SOAPBody)soapMessageRequest.getSOAPBody()) : this.requestMsg.getContentType();
                if (contentTypeRichiesta == null) {
                    throw new ConnettoreException("Content-Type del messaggio da spedire non definito");
                }
            } else {
                contentTypeRichiesta = this.requestMsg.getContentType();
            }
            if (this.debug) {
                this.logger.info("Impostazione Content-Type [" + contentTypeRichiesta + "]", false);
            }
            if (contentTypeRichiesta != null) {
                this.setRequestHeader("Content-Type", contentTypeRichiesta, this.logger, propertiesTrasportoDebug);
            }
            if (this.debug) {
                this.logger.debug("Impostazione timeout...");
            }
            int readConnectionTimeout = -1;
            boolean readConnectionTimeoutConfigurazioneGlobale = true;
            if (this.properties.get("readConnectionTimeout") != null) {
                try {
                    readConnectionTimeout = Integer.parseInt((String)this.properties.get("readConnectionTimeout"));
                    readConnectionTimeoutConfigurazioneGlobale = this.properties.containsKey("readConnectionTimeoutGlobale");
                }
                catch (Exception e) {
                    this.logger.error("Parametro readConnectionTimeout errato", e);
                }
            }
            if (readConnectionTimeout == -1) {
                readConnectionTimeout = 120000;
            }
            if (this.debug) {
                this.logger.info("Impostazione read timeout [" + readConnectionTimeout + "]", false);
            }
            if (this.debug) {
                this.logger.debug("Impostazione header di trasporto...");
            }
            this.forwardHttpRequestHeader();
            if (this.propertiesTrasporto != null) {
                for (String key : this.propertiesTrasporto.keySet()) {
                    List values = (List)this.propertiesTrasporto.get(key);
                    if (this.debug && values != null && !values.isEmpty()) {
                        for (String value : values) {
                            this.logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
                        }
                    }
                    this.setRequestHeader(key, values, this.logger, propertiesTrasportoDebug);
                }
            }
            if (this.isSoap && !this.sbustamentoSoap) {
                if (this.debug) {
                    this.logger.debug("Impostazione soap action...");
                }
                boolean existsTransportProperties = false;
                if (TransportUtils.containsKey((Map)this.propertiesTrasporto, (String)"SOAPAction")) {
                    this.soapAction = TransportUtils.getFirstValue((Map)this.propertiesTrasporto, (String)"SOAPAction");
                    boolean bl = existsTransportProperties = this.soapAction != null;
                }
                if (!existsTransportProperties) {
                    this.soapAction = soapMessageRequest.getSoapAction();
                }
                if (this.soapAction == null) {
                    this.soapAction = "\"OpenSPCoop\"";
                }
                if (MessageType.SOAP_11.equals((Object)this.requestMsg.getMessageType()) && !existsTransportProperties) {
                    this.setRequestHeader("SOAPAction", this.soapAction, propertiesTrasportoDebug);
                }
                if (this.debug) {
                    this.logger.info("SOAP Action inviata [" + this.soapAction + "]", false);
                }
            }
            boolean consumeRequestMessage = true;
            if (this.debug) {
                this.logger.debug("Serializzazione (consume-request-message:" + consumeRequestMessage + ")...");
            }
            if (this.isDumpBinarioRichiesta()) {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinarioSoglia, this.dumpBinarioRepositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                this.emitDiagnosticStartDumpBinarioRichiestaUscita();
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
                this.dumpBinarioRichiestaUscita(this.requestBout, requestMessageType, contentTypeRichiesta, this.location, propertiesTrasportoDebug);
            } else {
                this.requestBout = new DumpByteArrayOutputStream(this.dumpBinarioSoglia, this.dumpBinarioRepositoryFile, this.idTransazione, "NullEcho-" + TipoMessaggio.RICHIESTA_USCITA_DUMP_BINARIO.getValue());
                if (this.isSoap && this.sbustamentoSoap) {
                    this.logger.debug("Sbustamento...");
                    TunnelSoapUtils.sbustamentoMessaggio((OpenSPCoop2Message)soapMessageRequest, (OutputStream)this.requestBout);
                } else {
                    this.requestMsg.writeTo((OutputStream)this.requestBout, consumeRequestMessage);
                }
                this.requestBout.flush();
                this.requestBout.close();
                this.dataRichiestaInoltrata = DateManager.getDate();
            }
            this.postOutRequest();
            this.preInResponse();
            NotifierInputStreamParams notifierInputStreamParams = null;
            if (this.preInResponseContext != null) {
                notifierInputStreamParams = this.preInResponseContext.getNotifierInputStreamParams();
            }
            if (isTestConnectivity) {
                this.testConnectivity();
            }
            if (isStatisticalAnalysis) {
                this.testStatistics();
            }
            this.isResponse = new ByteArrayInputStream(ConnettoreStatus.getMessage(statusResponseType, this.requestMsg.getMessageType()).getBytes());
            this.tipoRisposta = ConnettoreStatus.getContentType(statusResponseType, this.requestMsg.getMessageType());
            this.normalizeInputStreamResponse(readConnectionTimeout, readConnectionTimeoutConfigurazioneGlobale);
            this.initCheckContentTypeConfiguration();
            this.messageTypeResponse = this.requestMsg.getMessageType();
            if (this.isDumpBinarioRisposta()) {
                this.dumpResponse(this.propertiesTrasportoRisposta);
            }
            if (this.isResponse != null) {
                this.emitDiagnosticResponseRead(this.isResponse);
            }
            OpenSPCoop2MessageFactory messageFactory = Utilities.getOpenspcoop2MessageFactory(this.logger.getLogger(), this.requestMsg, this.requestInfo, MessageRole.RESPONSE);
            if (this.isResponse != null) {
                pr = messageFactory.createMessage(this.messageTypeResponse, MessageRole.RESPONSE, this.tipoRisposta, this.isResponse, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
            } else {
                TransportResponseContext responseContext = new TransportResponseContext(this.logger.getLogger());
                responseContext.setCodiceTrasporto("" + this.codice);
                responseContext.setContentLength(0L);
                pr = messageFactory.createMessage(this.messageTypeResponse, responseContext, this.isResponse, notifierInputStreamParams, this.openspcoopProperties.getAttachmentsProcessingMode());
            }
            if (pr.getParseException() != null) {
                this.getPddContext().addObject(Costanti.CONTENUTO_RISPOSTA_NON_RICONOSCIUTO_PARSE_EXCEPTION, pr.getParseException());
            }
            this.responseMsg = pr.getMessage_throwParseException();
            validatoreSintattico = new ValidazioneSintattica((Context)this.getPddContext(), (IState)state, this.responseMsg, this.openspcoopProperties.isReadQualifiedAttribute("standard"), protocolFactory);
            if (validatoreSintattico.verifyProtocolPresence(TipoPdD.APPLICATIVA, null, RuoloMessaggio.RISPOSTA) && !"sdi".equals(protocolFactory.getProtocol())) {
                OpenSPCoop2SoapMessage soapMessage;
                ProprietaValidazione property = new ProprietaValidazione();
                property.setValidazioneConSchema(false);
                property.setValidazioneProfiloCollaborazione(false);
                property.setValidazioneManifestAttachments(false);
                validatoreProtocollo = new Validatore(this.responseMsg, (Context)this.getPddContext(), property, null, this.openspcoopProperties.isReadQualifiedAttribute("standard"), protocolFactory);
                if (!validatoreProtocollo.validazioneSintattica()) {
                    throw new ConnettoreException("Busta non presente: " + validatoreProtocollo.getErrore().getDescrizione(protocolFactory));
                }
                Busta busta = validatoreProtocollo.getBusta();
                IValidatoreErrori validatoreErrori = protocolFactory.createValidatoreErrori((IState)state);
                ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(protocolManager.isIgnoraEccezioniNonGravi());
                boolean isBustaSPCoopErrore = validatoreErrori.isBustaErrore(busta, this.responseMsg, pValidazioneErrori);
                boolean gestioneManifest = false;
                Sbustamento sbustatore = new Sbustamento(protocolFactory, (IState)state);
                ProtocolMessage protocolMessage = sbustatore.sbustamento(this.responseMsg, (Context)this.getPddContext(), busta, RuoloMessaggio.RICHIESTA, gestioneManifest, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseSbustamento.PRE_CONSEGNA_RICHIESTA, this.requestInfo);
                if (protocolMessage != null) {
                    headerProtocolloRisposta = protocolMessage.getBustaRawContent();
                    this.responseMsg = protocolMessage.getMessage();
                }
                if (!isBustaSPCoopErrore) {
                    Trasmissione t;
                    TipoOraRegistrazione tipoOraRegistrazione = this.openspcoopProperties.getTipoTempoBusta("standard");
                    Busta bustaRisposta = busta.invertiBusta(tipoOraRegistrazione, protocolFactory.createTraduttore().toString(tipoOraRegistrazione));
                    bustaRisposta.setProfiloDiCollaborazione(busta.getProfiloDiCollaborazione());
                    bustaRisposta.setServizio(busta.getServizio());
                    bustaRisposta.setVersioneServizio(busta.getVersioneServizio());
                    bustaRisposta.setTipoServizio(busta.getTipoServizio());
                    bustaRisposta.setAzione(busta.getAzione());
                    bustaRisposta.setInoltro(busta.getInoltro(), busta.getInoltroValue());
                    bustaRisposta.setConfermaRicezione(busta.isConfermaRicezione());
                    if (ProfiloDiCollaborazione.ONEWAY.equals((Object)busta.getProfiloDiCollaborazione()) && busta.isConfermaRicezione() && this.openspcoopProperties.isGestioneRiscontri("standard")) {
                        Riscontro r = new Riscontro();
                        r.setID(busta.getID());
                        r.setOraRegistrazione(DateManager.getDate());
                        r.setTipoOraRegistrazione(TipoOraRegistrazione.SINCRONIZZATO);
                        bustaRisposta.addRiscontro(r);
                    } else if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        bustaRisposta.setTipoServizioCorrelato("SPC");
                        bustaRisposta.setServizioCorrelato(busta.getServizio() + "Correlato");
                    } else if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals((Object)busta.getProfiloDiCollaborazione()) && busta.getRiferimentoMessaggio() == null) {
                        try {
                            resource = dbManager.getResource(this.openspcoopProperties.getIdentitaPortaDefault(protocolFactory.getProtocol(), this.requestInfo), "ConnettoreStatus", busta.getID());
                        }
                        catch (Exception e) {
                            throw new ConnettoreException("Risorsa non ottenibile", e);
                        }
                        if (resource == null) {
                            throw new ConnettoreException("Risorsa is null");
                        }
                        if (resource.getResource() == null) {
                            throw new ConnettoreException("Connessione is null");
                        }
                        Connection connectionDB = (Connection)resource.getResource();
                        state.setConnectionDB(connectionDB);
                        RepositoryBuste repositoryBuste = new RepositoryBuste((IState)state, true, protocolFactory);
                        repositoryBuste.registraBustaIntoInBox(busta, new ArrayList(), OpenSPCoop2Properties.getInstance().getRepositoryIntervalloScadenzaMessaggi());
                        Integrazione infoIntegrazione = new Integrazione();
                        infoIntegrazione.setIdModuloInAttesa(null);
                        repositoryBuste.aggiornaInfoIntegrazioneIntoInBox(busta.getID(), infoIntegrazione);
                        org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione profiloCollaborazione = new org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione((IState)state, protocolFactory);
                        profiloCollaborazione.asincronoSimmetrico_registraRichiestaRicevuta(busta.getID(), busta.getCollaborazione(), busta.getTipoServizioCorrelato(), busta.getServizioCorrelato(), busta.getVersioneServizioCorrelato(), true, this.openspcoopProperties.getRepositoryIntervalloScadenzaMessaggi());
                        try {
                            connectionDB.setAutoCommit(false);
                            state.executePreparedStatement();
                            connectionDB.commit();
                            connectionDB.setAutoCommit(true);
                        }
                        catch (Exception e) {
                            this.logger.error("Riscontrato errore durante la gestione transazione del DB per la richiesta: " + e.getMessage());
                            try {
                                connectionDB.rollback();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            state.closePreparedStatement();
                        }
                        finally {
                            try {
                                connectionDB.setAutoCommit(true);
                            }
                            catch (Exception e) {}
                        }
                    }
                    bustaRisposta.setRiferimentoMessaggio(busta.getID());
                    String dominio = null;
                    if (request.getConnectorProperties() != null) {
                        dominio = request.getConnectorProperties().get("identificativo-porta");
                    }
                    if (dominio == null) {
                        dominio = protocolFactory.createTraduttore().getIdentificativoPortaDefault(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario()));
                    }
                    String idBustaRisposta = null;
                    Imbustamento imbustatore = new Imbustamento(this.logger.getLogger(), protocolFactory, (IState)state);
                    try {
                        idBustaRisposta = imbustatore.buildID(new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario(), dominio), null, this.openspcoopProperties.getGestioneSerializableDBAttesaAttiva(), this.openspcoopProperties.getGestioneSerializableDBCheckInterval(), RuoloMessaggio.RISPOSTA);
                    }
                    catch (Exception e) {
                        throw new ConnettoreException(e);
                    }
                    bustaRisposta.setID(idBustaRisposta);
                    if (generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        t.setTipoOrigine(busta.getTipoMittente());
                        t.setOrigine(busta.getMittente());
                        t.setIdentificativoPortaOrigine(busta.getIdentificativoPortaMittente());
                        t.setIndirizzoOrigine(busta.getIndirizzoMittente());
                        t.setTipoDestinazione(busta.getTipoDestinatario());
                        t.setDestinazione(busta.getDestinatario());
                        t.setIdentificativoPortaDestinazione(busta.getIdentificativoPortaDestinatario());
                        t.setIndirizzoDestinazione(busta.getIndirizzoDestinatario());
                        t.setOraRegistrazione(busta.getOraRegistrazione());
                        t.setTempo(busta.getTipoOraRegistrazione(), busta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    if (generaTrasmissione || generaTrasmissioneInvertita || generaTrasmissioneAndataRitorno) {
                        t = new Trasmissione();
                        if (generaTrasmissione || generaTrasmissioneAndataRitorno) {
                            t.setTipoOrigine(bustaRisposta.getTipoMittente());
                            t.setOrigine(bustaRisposta.getMittente());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoMittente());
                            t.setTipoDestinazione(bustaRisposta.getTipoDestinatario());
                            t.setDestinazione(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoDestinatario());
                        }
                        if (generaTrasmissioneInvertita) {
                            t.setTipoOrigine(bustaRisposta.getTipoDestinatario());
                            t.setOrigine(bustaRisposta.getDestinatario());
                            t.setIdentificativoPortaOrigine(bustaRisposta.getIdentificativoPortaDestinatario());
                            t.setIndirizzoOrigine(bustaRisposta.getIndirizzoDestinatario());
                            t.setTipoDestinazione(bustaRisposta.getTipoMittente());
                            t.setDestinazione(bustaRisposta.getMittente());
                            t.setIdentificativoPortaDestinazione(bustaRisposta.getIdentificativoPortaMittente());
                            t.setIndirizzoDestinazione(bustaRisposta.getIndirizzoMittente());
                        }
                        t.setOraRegistrazione(bustaRisposta.getOraRegistrazione());
                        t.setTempo(bustaRisposta.getTipoOraRegistrazione(), bustaRisposta.getTipoOraRegistrazioneValue());
                        bustaRisposta.addTrasmissione(t);
                    }
                    Integrazione integrazione = new Integrazione();
                    integrazione.setStateless(true);
                    ProtocolMessage protocolMessageRisposta = imbustatore.imbustamentoRisposta(this.responseMsg, (Context)this.getPddContext(), bustaRisposta, busta, integrazione, gestioneManifest, false, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseImbustamento.PRIMA_SICUREZZA_MESSAGGIO);
                    if (protocolMessageRisposta != null && !protocolMessageRisposta.isPhaseUnsupported()) {
                        this.responseMsg = protocolMessageRisposta.getMessage();
                    }
                    if ((protocolMessageRisposta = imbustatore.imbustamentoRisposta(this.responseMsg, (Context)this.getPddContext(), bustaRisposta, busta, integrazione, gestioneManifest, false, this.openspcoopProperties.getProprietaManifestAttachments("standard"), FaseImbustamento.DOPO_SICUREZZA_MESSAGGIO)) != null && !protocolMessageRisposta.isPhaseUnsupported()) {
                        this.responseMsg = protocolMessageRisposta.getMessage();
                    }
                } else if (this.responseMsg instanceof OpenSPCoop2SoapMessage && (soapMessage = this.responseMsg.castAsSoap()).hasSOAPFault()) {
                    soapMessage.getSOAPBody().removeChild((Node)soapMessage.getSOAPBody().getFault());
                }
            }
            if (this.responseMsg != null) {
                this.contentLength = this.responseMsg.getIncomingMessageContentLength();
            }
        }
        catch (Exception e) {
            this.eccezioneProcessamento = e;
            String msgErrore = this.readExceptionMessageFromException(e);
            this.errore = this.generateErrorWithConnectorPrefix ? "rilevata anomalia; " + msgErrore : msgErrore;
            this.logger.error("Rilevata anomalia: " + msgErrore, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (validatoreSintattico != null) {
                validatoreSintattico.setHeaderSOAP(null);
            }
            validatoreSintattico = null;
            if (validatoreProtocollo != null) {
                if (validatoreProtocollo.getValidatoreSintattico() != null) {
                    validatoreProtocollo.getValidatoreSintattico().setHeaderSOAP(null);
                }
                validatoreProtocollo.setValidatoreSintattico(null);
            }
            validatoreProtocollo = null;
            headerProtocolloRisposta = null;
            dbManager.releaseResource(this.openspcoopProperties.getIdentitaPortaDefault(protocol, this.requestInfo), "ConnettoreStatus", resource);
        }
        return true;
    }

    private void setRequestHeader(String key, String value, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(value);
        this.setRequestHeader(key, list, logger, propertiesTrasportoDebug);
    }

    private void setRequestHeader(String key, List<String> values, ConnettoreLogger logger, Map<String, List<String>> propertiesTrasportoDebug) throws Exception {
        if (this.debug && values != null && !values.isEmpty()) {
            for (String value : values) {
                logger.info("Set propriet\u00e0 trasporto [" + key + "]=[" + value + "]", false);
            }
        }
        this.setRequestHeader(key, values, propertiesTrasportoDebug);
    }

    @Override
    protected void setRequestHeader(String key, List<String> values) throws ConnettoreException {
        this.propertiesTrasportoRisposta.put(key, values);
    }

    @Override
    public String getLocation() throws ConnettoreException {
        return LOCATION;
    }

    @Override
    public void disconnect() throws ConnettoreException {
        try {
            if (this.requestBout != null) {
                this.requestBout.clearResources();
            }
        }
        catch (Exception e) {
            this.logger.error("Release resources failed: " + e.getMessage(), e);
        }
    }
}

