/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.connettori.httpcore5.nio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.connettori.AbstractConnettoreConnectionConfig;
import org.openspcoop2.pdd.core.connettori.ConnettoreException;
import org.openspcoop2.pdd.core.connettori.ConnettoreHttpPoolParams;
import org.openspcoop2.pdd.core.connettori.ConnettoreLogger;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHTTPCOREUtils;
import org.openspcoop2.pdd.core.connettori.httpcore5.ConnettoreHttpRequestInterceptor;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREConnection;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREConnectionConfig;
import org.openspcoop2.pdd.core.connettori.httpcore5.nio.ConnettoreHTTPCOREConnectionEvictor;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.transport.http.SSLConfig;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.slf4j.Logger;

public class ConnettoreHTTPCOREConnectionManager {
    private static final Semaphore semaphorePoolingConnectionManager = new Semaphore("HTTPCore5-NIO-PoolingConnectionManager");
    public static final boolean USE_POOL_CONNECTION = true;
    private static final Semaphore semaphoreConnection = new Semaphore("HTTPCore5-NIO-ConnectionManager");
    static Map<String, PoolingAsyncClientConnectionManager> mapPoolingConnectionManager = new HashMap<String, PoolingAsyncClientConnectionManager>();
    static Map<String, ConnettoreHTTPCOREConnection> mapConnection = new HashMap<String, ConnettoreHTTPCOREConnection>();
    private static ConnettoreHTTPCOREConnectionEvictor idleConnectionEvictor;

    private ConnettoreHTTPCOREConnectionManager() {
    }

    public static synchronized void initialize() throws ConnettoreException {
        try {
            if (idleConnectionEvictor == null) {
                boolean idleConnectionEvictorEnabled;
                OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
                Integer closeIdleConnectionsAfterSeconds = op2Properties.getNIOConfigAsyncClientCloseIdleConnectionsAfterSeconds();
                boolean bl = idleConnectionEvictorEnabled = closeIdleConnectionsAfterSeconds != null && closeIdleConnectionsAfterSeconds > 0;
                if (idleConnectionEvictorEnabled) {
                    int sleepTimeSeconds = op2Properties.getNIOConfigAsyncClientCloseIdleConnectionsCheckIntervalSeconds();
                    boolean debug = op2Properties.isNIOConfigAsyncClientCloseIdleConnectionsDebug();
                    idleConnectionEvictor = new ConnettoreHTTPCOREConnectionEvictor(debug, sleepTimeSeconds, closeIdleConnectionsAfterSeconds);
                    idleConnectionEvictor.start();
                }
            }
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    public static String getHttpClientConnectionManagerStatus() {
        if (idleConnectionEvictor != null) {
            StringBuilder sb = new StringBuilder();
            idleConnectionEvictor.internalCheck(sb);
            return sb.toString();
        }
        return null;
    }

    public static String getNIOHttpClientConnectionManagerIOThreadCount() {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Integer numeroThread = op2Properties.getNIOConfigAsyncHttpclientIoReactorThread();
        if (numeroThread != null && numeroThread > 0) {
            return "" + numeroThread;
        }
        return "[default] availableProcessors:" + Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String key, TlsStrategy tlsStrategy, ConnettoreHTTPCOREConnectionConfig connectionConfig, ConnettoreLogger logger) throws ConnettoreException {
        block11: {
            String idTransazione = logger != null ? logger.getIdTransazione() : null;
            SemaphoreLock lock = null;
            try {
                lock = semaphorePoolingConnectionManager.acquire("initPoolingConnectionManager", idTransazione);
            }
            catch (Exception t) {
                throw new ConnettoreException(t.getMessage(), t);
            }
            try {
                if (mapPoolingConnectionManager.containsKey(key)) break block11;
                try {
                    PoolingAsyncClientConnectionManagerBuilder poolingConnectionManagerBuilder = PoolingAsyncClientConnectionManagerBuilder.create();
                    if (tlsStrategy != null) {
                        poolingConnectionManagerBuilder.setTlsStrategy(tlsStrategy);
                    } else {
                        poolingConnectionManagerBuilder.useSystemProperties();
                    }
                    poolingConnectionManagerBuilder.setPoolConcurrencyPolicy(PoolConcurrencyPolicy.LAX);
                    poolingConnectionManagerBuilder.setConnPoolPolicy(PoolReusePolicy.FIFO);
                    ConnettoreHttpPoolParams poolParams = connectionConfig.getHttpPoolParams();
                    Integer defaultMaxPerRoute = poolParams.getDefaultMaxPerRoute();
                    Integer maxTotal = poolParams.getMaxTotal();
                    if (maxTotal != null && maxTotal > 0) {
                        poolingConnectionManagerBuilder.setMaxConnTotal(poolParams.getMaxTotal());
                    }
                    if (defaultMaxPerRoute != null && defaultMaxPerRoute > 0) {
                        poolingConnectionManagerBuilder.setMaxConnPerRoute(poolParams.getDefaultMaxPerRoute());
                    }
                    ConnectionConfig config = ConnettoreHTTPCOREConnectionManager.buildConnectionConfig(poolParams, connectionConfig.getConnectionTimeout().intValue());
                    poolingConnectionManagerBuilder.setDefaultConnectionConfig(config);
                    PoolingAsyncClientConnectionManager poolingConnectionManager = poolingConnectionManagerBuilder.build();
                    mapPoolingConnectionManager.put(key, poolingConnectionManager);
                }
                catch (Exception t) {
                    throw new ConnettoreException(t.getMessage(), t);
                }
            }
            finally {
                semaphorePoolingConnectionManager.release(lock, "initPoolingConnectionManager", idTransazione);
            }
        }
    }

    private static ConnectionConfig buildConnectionConfig(ConnettoreHttpPoolParams poolParams, long connectionTimeout) {
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Integer closeIdleConnectionsAfterSeconds = op2Properties.getNIOConfigAsyncClientCloseIdleConnectionsAfterSeconds();
        boolean idleConnectionEvictorEnabled = closeIdleConnectionsAfterSeconds != null && closeIdleConnectionsAfterSeconds > 0;
        int sleepTimeSeconds = -1;
        if (idleConnectionEvictorEnabled) {
            sleepTimeSeconds = op2Properties.getNIOConfigAsyncClientCloseIdleConnectionsCheckIntervalSeconds();
        }
        return ConnettoreHTTPCOREUtils.buildConnectionConfig(poolParams, connectionTimeout, idleConnectionEvictorEnabled, sleepTimeSeconds);
    }

    public static synchronized void stop() throws ConnettoreException {
        ArrayList<Throwable> listT = new ArrayList<Throwable>();
        if (idleConnectionEvictor != null) {
            try {
                idleConnectionEvictor.setStop(true);
                idleConnectionEvictor.waitShutdown();
            }
            catch (Exception t) {
                listT.add(t);
            }
        }
        ConnettoreHTTPCOREConnectionManager.stopClients(listT);
        ConnettoreHTTPCOREConnectionManager.stopConnectionManager(listT);
        ConnettoreHTTPCOREConnectionManager.throwExceptions(listT);
    }

    public static synchronized void restartConnectionManager() throws ConnettoreException {
        ArrayList<Throwable> listT = new ArrayList<Throwable>();
        ConnettoreHTTPCOREConnectionManager.stopClients(listT);
        ConnettoreHTTPCOREConnectionManager.stopConnectionManager(listT);
        ConnettoreHTTPCOREConnectionManager.throwExceptions(listT);
    }

    private static void throwExceptions(List<Throwable> listT) throws ConnettoreException {
        if (listT.size() == 1) {
            throw new ConnettoreException(listT.get(0).getMessage(), listT.get(0));
        }
        UtilsMultiException multiExc = new UtilsMultiException(listT.toArray(new Throwable[1]));
        throw new ConnettoreException(multiExc.getMessage(), multiExc);
    }

    private static void stopClients(List<Throwable> listT) throws ConnettoreException {
        if (mapConnection != null && !mapConnection.isEmpty()) {
            for (String key : mapConnection.keySet()) {
                ConnettoreHTTPCOREConnection connection = mapConnection.get(key);
                try {
                    connection.close();
                }
                catch (Exception t) {
                    listT.add(new ConnettoreException("NIO Connection [" + key + "] close error: " + t.getMessage(), t));
                }
            }
            mapConnection.clear();
        }
    }

    private static void stopConnectionManager(List<Throwable> listT) {
        if (mapPoolingConnectionManager != null && !mapPoolingConnectionManager.isEmpty()) {
            for (String key : mapPoolingConnectionManager.keySet()) {
                if (key == null) continue;
                PoolingAsyncClientConnectionManager cm = mapPoolingConnectionManager.get(key);
                ConnettoreHTTPCOREConnectionManager.stopConnectionManager(cm, listT);
            }
            mapPoolingConnectionManager.clear();
        }
    }

    private static void stopConnectionManager(PoolingAsyncClientConnectionManager cm, List<Throwable> listT) {
        if (cm != null) {
            try {
                cm.close(CloseMode.GRACEFUL);
            }
            catch (Exception t) {
                listT.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(ConnettoreHTTPCOREConnectionConfig connectionConfig, Loader loader, ConnettoreLogger logger, RequestInfo requestInfo, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        String key = connectionConfig.toKeyConnection();
        String idTransazione = logger != null ? logger.getIdTransazione() : null;
        SemaphoreLock lock = null;
        try {
            lock = semaphoreConnection.acquire("initConnection", idTransazione);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
        try {
            if (!mapConnection.containsKey(key)) {
                ConnettoreHTTPCOREConnection resource = ConnettoreHTTPCOREConnectionManager.buildAsyncClient(connectionConfig, loader, logger, key, requestInfo, keepAliveStrategy, httpRequestInterceptor);
                mapConnection.put(key, resource);
            }
        }
        finally {
            semaphoreConnection.release(lock, "initConnection", idTransazione);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnettoreHTTPCOREConnection update(ConnettoreHTTPCOREConnectionConfig connectionConfig, Loader loader, ConnettoreLogger logger, RequestInfo requestInfo, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        String key = connectionConfig.toKeyConnection();
        String idTransazione = logger != null ? logger.getIdTransazione() : null;
        SemaphoreLock lock = null;
        try {
            lock = semaphoreConnection.acquire("updateConnection", idTransazione);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
        try {
            if (mapConnection.containsKey(key)) {
                ConnettoreHTTPCOREConnection con = mapConnection.remove(key);
                mapConnection.put("expired_" + key + "_" + UUID.randomUUID().toString(), con);
            }
            ConnettoreHTTPCOREConnection resource = ConnettoreHTTPCOREConnectionManager.buildAsyncClient(connectionConfig, loader, logger, key, requestInfo, keepAliveStrategy, httpRequestInterceptor);
            mapConnection.put(key, resource);
            ConnettoreHTTPCOREConnection connettoreHTTPCOREConnection = resource;
            return connettoreHTTPCOREConnection;
        }
        finally {
            semaphoreConnection.release(lock, "updateConnection", idTransazione);
        }
    }

    private static ConnettoreHTTPCOREConnection buildAsyncClient(ConnettoreHTTPCOREConnectionConfig connectionConfig, Loader loader, ConnettoreLogger logger, String key, RequestInfo requestInfo, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        try {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            OpenSPCoop2Properties op2 = OpenSPCoop2Properties.getInstance();
            ConnettoreHTTPCOREUtils.setTimeout(requestConfigBuilder, connectionConfig);
            ConnettoreHTTPCOREUtils.setRedirect(requestConfigBuilder, connectionConfig);
            RequestConfig requestConfig = requestConfigBuilder.build();
            String keyPool = connectionConfig.toKeyConnectionManager();
            if (!mapPoolingConnectionManager.containsKey(keyPool)) {
                TlsStrategy tlsStrategy = ConnettoreHTTPCOREConnectionManager.buildClientTlsStrategyBuilder(connectionConfig, loader, requestInfo, logger);
                ConnettoreHTTPCOREConnectionManager.initialize(keyPool, tlsStrategy, connectionConfig, logger);
            }
            PoolingAsyncClientConnectionManager cm = mapPoolingConnectionManager.get(keyPool);
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClients.custom();
            httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)cm);
            httpClientBuilder.setConnectionManagerShared(true);
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            httpClientBuilder.disableAuthCaching();
            DefaultConnectionReuseStrategy defaultClientConnectionReuseStrategy = new DefaultConnectionReuseStrategy();
            httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)defaultClientConnectionReuseStrategy);
            if (keepAliveStrategy != null) {
                httpClientBuilder.setKeepAliveStrategy(keepAliveStrategy);
            }
            if (httpRequestInterceptor != null) {
                httpClientBuilder.addRequestInterceptorLast((HttpRequestInterceptor)httpRequestInterceptor);
            }
            if (connectionConfig.isFollowRedirect()) {
                httpClientBuilder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE);
            }
            ConnettoreHTTPCOREConnectionManager.setProxy(httpClientBuilder, connectionConfig);
            Integer numeroThread = op2.getNIOConfigAsyncHttpclientIoReactorThread();
            if (numeroThread != null && numeroThread > 0) {
                IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(numeroThread.intValue()).build();
                httpClientBuilder.setIOReactorConfig(ioReactorConfig);
            }
            Callback callback = e -> {
                OpenSPCoop2Logger.getLoggerOpenSPCoopConnettori().error("[IoReactorExceptionCallback] " + e.getMessage(), (Throwable)e);
                OpenSPCoop2Logger.getLoggerOpenSPCoopCore().error("[IoReactorExceptionCallback] " + e.getMessage(), (Throwable)e);
            };
            httpClientBuilder.setIoReactorExceptionCallback(callback);
            CloseableHttpAsyncClient httpclient = httpClientBuilder.build();
            httpclient.start();
            int expireUnusedAfterSeconds = op2.getNIOConfigAsyncClientExpireUnusedAfterSeconds();
            int closeUnusedAfterSeconds = op2.getNIOConfigAsyncClientCloseUnusedAfterSeconds();
            return new ConnettoreHTTPCOREConnection(key, httpclient, requestConfig, expireUnusedAfterSeconds, closeUnusedAfterSeconds);
        }
        catch (Exception t) {
            throw new ConnettoreException(t.getMessage(), t);
        }
    }

    private static void setProxy(HttpAsyncClientBuilder httpClientBuilder, AbstractConnettoreConnectionConfig connectionConfig) {
        if (connectionConfig.getProxyHost() != null && connectionConfig.getProxyPort() != null) {
            HttpHost proxy = new HttpHost(connectionConfig.getProxyHost(), connectionConfig.getProxyPort().intValue());
            httpClientBuilder.setProxy(proxy);
        } else {
            httpClientBuilder.useSystemProperties();
        }
    }

    private static TlsStrategy buildClientTlsStrategyBuilder(ConnettoreHTTPCOREConnectionConfig connectionConfig, Loader loader, RequestInfo requestInfo, ConnettoreLogger logger) throws UtilsException {
        TlsStrategy tlsStrategy = null;
        if (connectionConfig.getSslContextProperties() != null) {
            SSLContext sslContext = null;
            HostnameVerifier hostnameVerifier = null;
            StringBuilder bfLog = new StringBuilder();
            sslContext = ConnettoreHTTPCOREConnectionManager.buildSSLContext(connectionConfig.getSslContextProperties(), requestInfo, logger, bfLog);
            hostnameVerifier = SSLUtilities.generateHostnameVerifier((SSLConfig)connectionConfig.getSslContextProperties(), (StringBuilder)bfLog, (Logger)logger.getLogger(), (Loader)loader);
            if (connectionConfig.isDebug()) {
                logger.debug(bfLog.toString());
            }
            ClientTlsStrategyBuilder tlsBuilder = ClientTlsStrategyBuilder.create();
            tlsBuilder.setSslContext(sslContext);
            tlsBuilder.setHostnameVerifier(hostnameVerifier);
            tlsStrategy = tlsBuilder.buildAsync();
        }
        return tlsStrategy;
    }

    private static SSLContext buildSSLContext(SSLConfig httpsProperties, RequestInfo requestInfo, ConnettoreLogger logger, StringBuilder bfLog) throws UtilsException {
        String msgError;
        if (httpsProperties.getKeyStore() == null && httpsProperties.getKeyStoreLocation() != null) {
            try {
                httpsProperties.setKeyStore(GestoreKeystoreCache.getMerlinKeystore((RequestInfo)requestInfo, (String)httpsProperties.getKeyStoreLocation(), (String)httpsProperties.getKeyStoreType(), (String)httpsProperties.getKeyStorePassword()).getKeyStore().getKeystore());
            }
            catch (Exception e) {
                msgError = "Lettura keystore '" + httpsProperties.getKeyStoreLocation() + "' dalla cache fallita: " + e.getMessage();
                logger.error(msgError, e);
            }
        }
        if (httpsProperties.getTrustStore() == null && httpsProperties.getTrustStoreLocation() != null) {
            try {
                httpsProperties.setTrustStore(GestoreKeystoreCache.getMerlinTruststore((RequestInfo)requestInfo, (String)httpsProperties.getTrustStoreLocation(), (String)httpsProperties.getTrustStoreType(), (String)httpsProperties.getTrustStorePassword()).getTrustStore().getKeystore());
            }
            catch (Exception e) {
                msgError = "Lettura truststore '" + httpsProperties.getTrustStoreLocation() + "' dalla cache fallita: " + e.getMessage();
                logger.error(msgError, e);
            }
        }
        if (httpsProperties.getTrustStoreCRLs() == null && httpsProperties.getTrustStoreCRLsLocation() != null) {
            try {
                httpsProperties.setTrustStoreCRLs(GestoreKeystoreCache.getCRLCertstore((RequestInfo)requestInfo, (String)httpsProperties.getTrustStoreCRLsLocation()).getCertStore());
            }
            catch (Exception e) {
                msgError = "Lettura CRLs '" + httpsProperties.getTrustStoreLocation() + "' dalla cache CRL fallita: " + e.getMessage();
                logger.error(msgError, e);
            }
        }
        return SSLUtilities.generateSSLContext((SSLConfig)httpsProperties, (StringBuilder)bfLog);
    }

    public static ConnettoreHTTPCOREConnection getConnettoreHTTPCOREConnection(ConnettoreHTTPCOREConnectionConfig connectionConfig, Loader loader, ConnettoreLogger logger, RequestInfo requestInfo, ConnectionKeepAliveStrategy keepAliveStrategy, ConnettoreHttpRequestInterceptor httpRequestInterceptor) throws ConnettoreException {
        ConnettoreHTTPCOREConnection connection = null;
        String key = connectionConfig.toKeyConnection();
        if (!mapConnection.containsKey(key)) {
            ConnettoreHTTPCOREConnectionManager.init(connectionConfig, loader, logger, requestInfo, keepAliveStrategy, httpRequestInterceptor);
            connection = mapConnection.get(key);
            connection.refresh();
        } else {
            connection = mapConnection.get(key);
            connection.refresh();
            if (connection.isExpired()) {
                connection = ConnettoreHTTPCOREConnectionManager.update(connectionConfig, loader, logger, requestInfo, keepAliveStrategy, httpRequestInterceptor);
            }
        }
        return connection;
    }
}

