/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.RisultatoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoBanda;
import org.openspcoop2.core.controllo_traffico.constants.TipoFinestra;
import org.openspcoop2.core.controllo_traffico.constants.TipoLatenza;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.statistiche.StatisticaGiornaliera;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.StatisticaOraria;
import org.openspcoop2.core.statistiche.StatisticaSettimanale;
import org.openspcoop2.core.statistiche.constants.TipoPorta;
import org.openspcoop2.core.statistiche.dao.IServiceManager;
import org.openspcoop2.core.statistiche.dao.IStatisticaOrariaServiceSearch;
import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.core.statistiche.utils.StatisticheUtils;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.IServiceSearchWithoutId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.DBStatisticheManager;
import org.openspcoop2.pdd.config.DBTransazioniManager;
import org.openspcoop2.pdd.config.Resource;
import org.openspcoop2.pdd.core.controllo_traffico.ConfigurazioneGatewayControlloTraffico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.date.DateManager;
import org.slf4j.Logger;

public class DatiStatisticiDAOManager {
    private static DatiStatisticiDAOManager staticInstance = null;
    private ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico;
    private boolean debug = false;
    private String tipoDatabase = null;
    private DAOFactory daoFactory = null;
    private Logger daoFactoryLogger = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesStatistiche = null;
    private DBStatisticheManager dbStatisticheManager = null;
    private boolean checkState = false;
    private Logger log;
    private static final String RISORSA_DB_NON_DISPONIBILE = "Risorsa al database non disponibile";
    private static final String CONNESSIONE_DB_NON_DISPONIBILE = "Connessione non disponibile";
    private static final String MODEL_UNKNOWN = "Model unknown";
    private static final String DAO_UNKNOWN = "DAO unknown";

    public static synchronized void initialize(ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico) throws CoreException {
        if (staticInstance == null) {
            staticInstance = new DatiStatisticiDAOManager(configurazioneControlloTraffico);
        }
    }

    public static DatiStatisticiDAOManager getInstance() throws CoreException {
        if (staticInstance == null) {
            Class<DatiStatisticiDAOManager> clazz = DatiStatisticiDAOManager.class;
            synchronized (DatiStatisticiDAOManager.class) {
                throw new CoreException("DatiStatisticiDAOManager non inizializzato");
            }
        }
        return staticInstance;
    }

    private void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    private void logDebug(String msg, Exception e) {
        if (this.log != null) {
            this.log.debug(msg, (Throwable)e);
        }
    }

    private void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    private DatiStatisticiDAOManager(ConfigurazioneGatewayControlloTraffico configurazioneControlloTraffico) throws CoreException {
        try {
            this.configurazioneControlloTraffico = configurazioneControlloTraffico;
            this.debug = this.configurazioneControlloTraffico.isDebug();
            this.tipoDatabase = this.configurazioneControlloTraffico.getTipoDatabaseConfig();
            if (this.tipoDatabase == null) {
                throw new CoreException("Tipo Database non definito");
            }
            DAOFactoryProperties daoFactoryProperties = null;
            this.daoFactoryLogger = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTrafficoSql(this.debug);
            this.daoFactory = DAOFactory.getInstance((Logger)this.daoFactoryLogger);
            daoFactoryProperties = DAOFactoryProperties.getInstance((Logger)this.daoFactoryLogger);
            this.daoFactoryServiceManagerPropertiesStatistiche = daoFactoryProperties.getServiceManagerProperties((IProjectInfo)ProjectInfo.getInstance());
            this.daoFactoryServiceManagerPropertiesStatistiche.setShowSql(this.debug);
            this.daoFactoryServiceManagerPropertiesStatistiche.setDatabaseType(this.tipoDatabase);
            this.dbStatisticheManager = DBStatisticheManager.getInstance();
            if (this.dbStatisticheManager.useRuntimePdD() || this.dbStatisticheManager.useTransazioni() && DBTransazioniManager.getInstance().useRuntimePdD()) {
                this.checkState = true;
            }
            this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(this.debug);
        }
        catch (Exception e) {
            throw new CoreException("Errore durante l'inizializzazione del datasource: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RisultatoStatistico readNumeroEsiti(String key, TipoPeriodoStatistico tipoPeriodo, Integer periodLength, Date endDate, List<Integer> esiti, IDServizio servizio, IDSoggetto mittente, List<String> ignoreOperations, DatiTransazione datiTransazione, IState state) throws CoreException {
        RisultatoStatistico risultatoStatistico;
        Resource r = null;
        boolean useConnectionRuntime = false;
        IDSoggetto dominio = datiTransazione.getDominio();
        String idModulo = datiTransazione.getModulo() + ".statistiche.readExpression";
        String idTransazione = datiTransazione.getIdTransazione();
        try {
            StateMessage s;
            Connection con = null;
            if (this.checkState && state != null && state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                con = s.getConnectionDB();
                useConnectionRuntime = true;
            }
            if (!useConnectionRuntime) {
                r = this.dbStatisticheManager.getResource(dominio, idModulo, idTransazione);
                if (r == null) {
                    throw new CoreException(RISORSA_DB_NON_DISPONIBILE);
                }
                con = (Connection)r.getResource();
            }
            if (con == null) {
                throw new CoreException(CONNESSIONE_DB_NON_DISPONIBILE);
            }
            IServiceManager statisticheSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesStatistiche, this.daoFactoryLogger);
            boolean useGiornaliero = this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanale_usaStatisticheGiornaliere();
            StatisticaModel model = null;
            IStatisticaOrariaServiceSearch dao = null;
            Calendar c = Calendar.getInstance();
            c.setTime(endDate);
            switch (tipoPeriodo) {
                case ORARIO: {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = statisticheSM.getStatisticaOrariaServiceSearch();
                    c.add(10, -periodLength.intValue());
                    break;
                }
                case GIORNALIERO: {
                    model = StatisticaGiornaliera.model().STATISTICA_BASE;
                    dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                    c.add(5, -periodLength.intValue());
                    break;
                }
                case SETTIMANALE: {
                    model = useGiornaliero ? StatisticaGiornaliera.model().STATISTICA_BASE : StatisticaSettimanale.model().STATISTICA_BASE;
                    dao = useGiornaliero ? statisticheSM.getStatisticaGiornalieraServiceSearch() : statisticheSM.getStatisticaSettimanaleServiceSearch();
                    c.add(5, -7 * periodLength);
                    break;
                }
                case MENSILE: {
                    model = useGiornaliero ? StatisticaGiornaliera.model().STATISTICA_BASE : StatisticaMensile.model().STATISTICA_BASE;
                    dao = useGiornaliero ? statisticheSM.getStatisticaGiornalieraServiceSearch() : statisticheSM.getStatisticaMensileServiceSearch();
                    c.add(2, -periodLength.intValue());
                    break;
                }
            }
            Date startDate = c.getTime();
            if (model == null) {
                throw new CoreException(MODEL_UNKNOWN);
            }
            if (dao == null) {
                throw new CoreException(DAO_UNKNOWN);
            }
            IExpression expression = dao.newExpression();
            expression.between(model.DATA, (Object)startDate, (Object)endDate);
            if (esiti != null) {
                expression.in(model.ESITO, esiti);
            }
            expression.equals(model.SERVIZIO, (Object)servizio.getNome());
            expression.equals(model.TIPO_SERVIZIO, (Object)servizio.getTipo());
            expression.equals(model.VERSIONE_SERVIZIO, (Object)servizio.getVersione());
            expression.equals(model.DESTINATARIO, (Object)servizio.getSoggettoErogatore().getNome());
            expression.equals(model.TIPO_DESTINATARIO, (Object)servizio.getSoggettoErogatore().getTipo());
            expression.isNotNull(model.NUMERO_TRANSAZIONI);
            if (mittente != null) {
                expression.equals(model.MITTENTE, (Object)mittente.getNome());
                expression.equals(model.TIPO_MITTENTE, (Object)mittente.getTipo());
            }
            if (ignoreOperations != null) {
                for (String ignoreOperation : ignoreOperations) {
                    expression.notEquals(model.AZIONE, (Object)ignoreOperation);
                }
            }
            RisultatoStatistico risultato = new RisultatoStatistico();
            risultato.setDateCheck(DateManager.getDate());
            risultato.setDataInizio(startDate);
            risultato.setDataFine(endDate);
            FunctionField ff = new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma");
            try {
                Object result = dao.aggregate(expression, ff);
                if (result != null && this.isKnownType(result)) {
                    this.logDebug("NumeroRichiesteFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    Long l = this.translateType(result);
                    if (l == null) throw new CoreException("Translate type (result) '" + String.valueOf(result) + "' non riuscito");
                    risultato.setRisultato(l.longValue());
                } else {
                    if (result != null) {
                        this.logDebug("NumeroRichiesteNotFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    } else {
                        this.logDebug("NumeroRichiesteNotFound, result is null");
                    }
                    risultato.setRisultato(0L);
                }
            }
            catch (NotFoundException notFound) {
                this.logDebug("NumeroRichiesteNotFound:" + notFound.getMessage(), (Exception)((Object)notFound));
                risultato.setRisultato(0L);
            }
            risultatoStatistico = risultato;
        }
        catch (Exception e) {
            try {
                this.logError("Errore durante la raccolta dei dati statisti (" + key + "): " + e.getMessage(), e);
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (useConnectionRuntime) throw throwable;
                    if (r == null) throw throwable;
                    this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (useConnectionRuntime) return risultatoStatistico;
            if (r == null) return risultatoStatistico;
            this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
            return risultatoStatistico;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return risultatoStatistico;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RisultatoStatistico readNumeroRichieste(String key, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws CoreException {
        RisultatoStatistico risultatoStatistico;
        Resource r = null;
        boolean useConnectionRuntime = false;
        IDSoggetto dominio = datiTransazione.getDominio();
        String idModulo = datiTransazione.getModulo() + ".statistiche.readNumeroRichieste";
        String idTransazione = datiTransazione.getIdTransazione();
        try {
            StateMessage s;
            Connection con = null;
            if (this.checkState && state != null && state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                con = s.getConnectionDB();
                useConnectionRuntime = true;
            }
            if (!useConnectionRuntime) {
                r = this.dbStatisticheManager.getResource(dominio, idModulo, idTransazione);
                if (r == null) {
                    throw new CoreException(RISORSA_DB_NON_DISPONIBILE);
                }
                con = (Connection)r.getResource();
            }
            if (con == null) {
                throw new CoreException(CONNESSIONE_DB_NON_DISPONIBILE);
            }
            IServiceManager statisticheSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesStatistiche, this.daoFactoryLogger);
            StatisticaModel model = null;
            IStatisticaOrariaServiceSearch dao = null;
            if (tipoFinestra != null && TipoFinestra.SCORREVOLE.equals((Object)tipoFinestra)) {
                model = StatisticaOraria.model().STATISTICA_BASE;
                dao = statisticheSM.getStatisticaOrariaServiceSearch();
            } else {
                switch (tipoPeriodo) {
                    case ORARIO: {
                        model = StatisticaOraria.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaOrariaServiceSearch();
                        break;
                    }
                    case GIORNALIERO: {
                        model = StatisticaGiornaliera.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                        break;
                    }
                    case SETTIMANALE: {
                        if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanale_usaStatisticheGiornaliere()) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                            break;
                        }
                        model = StatisticaSettimanale.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaSettimanaleServiceSearch();
                        break;
                    }
                    case MENSILE: {
                        if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneMensile_usaStatisticheGiornaliere()) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                            break;
                        }
                        model = StatisticaMensile.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaMensileServiceSearch();
                        break;
                    }
                }
            }
            if (model == null) {
                throw new CoreException(MODEL_UNKNOWN);
            }
            if (dao == null) {
                throw new CoreException(DAO_UNKNOWN);
            }
            IExpression expression = this.createWhereExpressionNumeroRichieste((IServiceSearchWithoutId<?>)dao, model, tipoRisorsa, leftInterval, rightInterval, datiTransazione.getTipoPdD(), protocolFactory, datiTransazione.getProtocollo(), groupByPolicy, filtro, state, requestInfo);
            FunctionField ff = new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma");
            RisultatoStatistico risultato = new RisultatoStatistico();
            risultato.setDataInizio(leftInterval);
            risultato.setDataFine(rightInterval);
            risultato.setDateCheck(DateManager.getDate());
            try {
                Object result = dao.aggregate(expression, ff);
                if (result != null && this.isKnownType(result)) {
                    this.logDebug("NumeroRichiesteFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    Long l = this.translateType(result);
                    if (l == null) throw new CoreException("Translate type (result) '" + String.valueOf(result) + "' non riuscito");
                    risultato.setRisultato(l.longValue());
                } else {
                    if (result != null) {
                        this.logDebug("NumeroRichiesteNotFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    } else {
                        this.logDebug("NumeroRichiesteNotFound, result is null");
                    }
                    risultato.setRisultato(0L);
                }
            }
            catch (NotFoundException notFound) {
                this.logDebug("NumeroRichiesteNotFound:" + notFound.getMessage(), (Exception)((Object)notFound));
                risultato.setRisultato(0L);
            }
            risultatoStatistico = risultato;
        }
        catch (Exception e) {
            try {
                this.logError("Errore durante la raccolta dei dati statisti (key:" + key + "): " + e.getMessage(), e);
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (useConnectionRuntime) throw throwable;
                    if (r == null) throw throwable;
                    this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (useConnectionRuntime) return risultatoStatistico;
            if (r == null) return risultatoStatistico;
            this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
            return risultatoStatistico;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return risultatoStatistico;
    }

    private IExpression createWhereExpressionNumeroRichieste(IServiceSearchWithoutId<?> dao, StatisticaModel model, TipoRisorsa tipoRisorsa, Date dataInizio, Date dataFine, TipoPdD tipoPdDTransazioneInCorso, IProtocolFactory<?> protocolFactory, String protocollo, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException, DriverRegistroServiziException, DriverConfigurazioneException {
        IExpression expr = this.createWhereExpression(dao, model, tipoRisorsa, dataInizio, dataFine, tipoPdDTransazioneInCorso, protocolFactory, protocollo, groupByPolicy, filtro, state, requestInfo);
        expr.isNotNull(model.NUMERO_TRANSAZIONI);
        return expr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RisultatoStatistico readOccupazioneBanda(String key, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, TipoBanda tipoBanda, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws CoreException {
        RisultatoStatistico risultatoStatistico;
        Resource r = null;
        boolean useConnectionRuntime = false;
        IDSoggetto dominio = datiTransazione.getDominio();
        String idModulo = datiTransazione.getModulo() + ".statistiche.readOccupazioneBanda";
        String idTransazione = datiTransazione.getIdTransazione();
        try {
            StateMessage s;
            Connection con = null;
            if (this.checkState && state != null && state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                con = s.getConnectionDB();
                useConnectionRuntime = true;
            }
            if (!useConnectionRuntime) {
                r = this.dbStatisticheManager.getResource(dominio, idModulo, idTransazione);
                if (r == null) {
                    throw new CoreException(RISORSA_DB_NON_DISPONIBILE);
                }
                con = (Connection)r.getResource();
            }
            if (con == null) {
                throw new CoreException(CONNESSIONE_DB_NON_DISPONIBILE);
            }
            IServiceManager statisticheSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesStatistiche, this.daoFactoryLogger);
            StatisticaModel model = null;
            IStatisticaOrariaServiceSearch dao = null;
            if (tipoFinestra != null && TipoFinestra.SCORREVOLE.equals((Object)tipoFinestra)) {
                model = StatisticaOraria.model().STATISTICA_BASE;
                dao = statisticheSM.getStatisticaOrariaServiceSearch();
            } else {
                switch (tipoPeriodo) {
                    case ORARIO: {
                        model = StatisticaOraria.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaOrariaServiceSearch();
                        break;
                    }
                    case GIORNALIERO: {
                        model = StatisticaGiornaliera.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                        break;
                    }
                    case SETTIMANALE: {
                        if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanale_usaStatisticheGiornaliere()) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                            break;
                        }
                        model = StatisticaSettimanale.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaSettimanaleServiceSearch();
                        break;
                    }
                    case MENSILE: {
                        if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneMensile_usaStatisticheGiornaliere()) {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                            break;
                        }
                        model = StatisticaMensile.model().STATISTICA_BASE;
                        dao = statisticheSM.getStatisticaMensileServiceSearch();
                        break;
                    }
                }
            }
            if (model == null) {
                throw new CoreException(MODEL_UNKNOWN);
            }
            if (dao == null) {
                throw new CoreException(DAO_UNKNOWN);
            }
            IExpression expression = this.createWhereExpressionBanda((IServiceSearchWithoutId<?>)dao, model, tipoRisorsa, leftInterval, rightInterval, datiTransazione.getTipoPdD(), protocolFactory, datiTransazione.getProtocollo(), groupByPolicy, filtro, tipoBanda, state, requestInfo);
            FunctionField ff = null;
            switch (tipoBanda) {
                case COMPLESSIVA: {
                    ff = new FunctionField(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA, Function.SUM, "somma");
                    break;
                }
                case INTERNA: {
                    ff = new FunctionField(model.DIMENSIONI_BYTES_BANDA_INTERNA, Function.SUM, "somma");
                    break;
                }
                case ESTERNA: {
                    ff = new FunctionField(model.DIMENSIONI_BYTES_BANDA_ESTERNA, Function.SUM, "somma");
                    break;
                }
            }
            RisultatoStatistico risultato = new RisultatoStatistico();
            risultato.setDataInizio(leftInterval);
            risultato.setDataFine(rightInterval);
            risultato.setDateCheck(DateManager.getDate());
            try {
                Object result = dao.aggregate(expression, ff);
                if (result != null && this.isKnownType(result)) {
                    this.logDebug("BandaFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    Long l = this.translateType(result);
                    if (l == null) throw new CoreException("Translate type (result) '" + String.valueOf(result) + "' non riuscito");
                    risultato.setRisultato(l.longValue());
                } else {
                    if (result != null) {
                        this.logDebug("BandaNotFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                    } else {
                        this.logDebug("BandaNotFound, result is null");
                    }
                    risultato.setRisultato(0L);
                }
            }
            catch (NotFoundException notFound) {
                this.logDebug("BandaNotFound:" + notFound.getMessage(), (Exception)((Object)notFound));
                risultato.setRisultato(0L);
            }
            risultatoStatistico = risultato;
        }
        catch (Exception e) {
            try {
                this.logError("Errore durante la raccolta dei dati statisti (key:" + key + "): " + e.getMessage(), e);
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (useConnectionRuntime) throw throwable;
                    if (r == null) throw throwable;
                    this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (useConnectionRuntime) return risultatoStatistico;
            if (r == null) return risultatoStatistico;
            this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
            return risultatoStatistico;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return risultatoStatistico;
    }

    private IExpression createWhereExpressionBanda(IServiceSearchWithoutId<?> dao, StatisticaModel model, TipoRisorsa tipoRisorsa, Date dataInizio, Date dataFine, TipoPdD tipoPdDTransazioneInCorso, IProtocolFactory<?> protocolFactory, String protocollo, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, TipoBanda tipoBanda, IState state, RequestInfo requestInfo) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException, DriverRegistroServiziException, DriverConfigurazioneException {
        IExpression expr = this.createWhereExpression(dao, model, tipoRisorsa, dataInizio, dataFine, tipoPdDTransazioneInCorso, protocolFactory, protocollo, groupByPolicy, filtro, state, requestInfo);
        switch (tipoBanda) {
            case COMPLESSIVA: {
                expr.isNotNull(model.DIMENSIONI_BYTES_BANDA_COMPLESSIVA);
                break;
            }
            case INTERNA: {
                expr.isNotNull(model.DIMENSIONI_BYTES_BANDA_INTERNA);
                break;
            }
            case ESTERNA: {
                expr.isNotNull(model.DIMENSIONI_BYTES_BANDA_ESTERNA);
            }
        }
        return expr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RisultatoStatistico readLatenza(String key, TipoRisorsa tipoRisorsa, TipoFinestra tipoFinestra, TipoPeriodoStatistico tipoPeriodo, Date leftInterval, Date rightInterval, TipoLatenza tipoLatenza, DatiTransazione datiTransazione, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo, IProtocolFactory<?> protocolFactory) throws CoreException {
        RisultatoStatistico risultatoStatistico;
        Resource r = null;
        boolean useConnectionRuntime = false;
        IDSoggetto dominio = datiTransazione.getDominio();
        String idModulo = datiTransazione.getModulo() + ".statistiche.readLatenza";
        String idTransazione = datiTransazione.getIdTransazione();
        try {
            RisultatoStatistico risultato;
            block41: {
                StateMessage s;
                Connection con = null;
                if (this.checkState && state != null && state instanceof StateMessage && (s = (StateMessage)state).getConnectionDB() != null && !s.getConnectionDB().isClosed()) {
                    con = s.getConnectionDB();
                    useConnectionRuntime = true;
                }
                if (!useConnectionRuntime) {
                    r = this.dbStatisticheManager.getResource(dominio, idModulo, idTransazione);
                    if (r == null) {
                        throw new CoreException(RISORSA_DB_NON_DISPONIBILE);
                    }
                    con = (Connection)r.getResource();
                }
                if (con == null) {
                    throw new CoreException(CONNESSIONE_DB_NON_DISPONIBILE);
                }
                IServiceManager statisticheSM = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, this.daoFactoryServiceManagerPropertiesStatistiche, this.daoFactoryLogger);
                StatisticaModel model = null;
                IStatisticaOrariaServiceSearch dao = null;
                boolean calcolaSommeMediaPesata = false;
                if (tipoFinestra != null && TipoFinestra.SCORREVOLE.equals((Object)tipoFinestra)) {
                    model = StatisticaOraria.model().STATISTICA_BASE;
                    dao = statisticheSM.getStatisticaOrariaServiceSearch();
                } else {
                    switch (tipoPeriodo) {
                        case ORARIO: {
                            model = StatisticaOraria.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaOrariaServiceSearch();
                            break;
                        }
                        case GIORNALIERO: {
                            model = StatisticaGiornaliera.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                            break;
                        }
                        case SETTIMANALE: {
                            if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanale_usaStatisticheGiornaliere()) {
                                model = StatisticaGiornaliera.model().STATISTICA_BASE;
                                dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                                calcolaSommeMediaPesata = this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanaleMensile_usaStatisticheGiornaliere_latenza_mediaPesata();
                                break;
                            }
                            model = StatisticaSettimanale.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaSettimanaleServiceSearch();
                            break;
                        }
                        case MENSILE: {
                            if (this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneMensile_usaStatisticheGiornaliere()) {
                                model = StatisticaGiornaliera.model().STATISTICA_BASE;
                                dao = statisticheSM.getStatisticaGiornalieraServiceSearch();
                                calcolaSommeMediaPesata = this.configurazioneControlloTraffico.isElaborazioneStatistica_distribuzioneSettimanaleMensile_usaStatisticheGiornaliere_latenza_mediaPesata();
                                break;
                            }
                            model = StatisticaMensile.model().STATISTICA_BASE;
                            dao = statisticheSM.getStatisticaMensileServiceSearch();
                            break;
                        }
                    }
                }
                if (model == null) {
                    throw new CoreException(MODEL_UNKNOWN);
                }
                if (dao == null) {
                    throw new CoreException(DAO_UNKNOWN);
                }
                ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)dao).getFieldConverter();
                IExpression expression = this.createWhereExpressionLatenza((IServiceSearchWithoutId<?>)dao, model, tipoRisorsa, leftInterval, rightInterval, datiTransazione.getTipoPdD(), protocolFactory, datiTransazione.getProtocollo(), groupByPolicy, filtro, tipoLatenza, state, requestInfo);
                FunctionField ff = null;
                switch (tipoLatenza) {
                    case PORTA: {
                        ff = StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_PORTA, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza");
                        break;
                    }
                    case SERVIZIO: {
                        ff = StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_SERVIZIO, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza");
                        break;
                    }
                    default: {
                        ff = StatisticheUtils.calcolaMedia((ISQLFieldConverter)fieldConverter, (IField)model.LATENZA_TOTALE, (IField)model.NUMERO_TRANSAZIONI, (String)"somma_latenza");
                    }
                }
                FunctionField ffSommaPesata = null;
                if (calcolaSommeMediaPesata) {
                    ffSommaPesata = new FunctionField(model.NUMERO_TRANSAZIONI, Function.SUM, "somma_media_pesata");
                }
                risultato = new RisultatoStatistico();
                risultato.setDataInizio(leftInterval);
                risultato.setDataFine(rightInterval);
                risultato.setDateCheck(DateManager.getDate());
                try {
                    if (ffSommaPesata != null) {
                        expression.addGroupBy(model.DATA);
                        List list = dao.groupBy(expression, new FunctionField[]{ff, ffSommaPesata});
                        if (list != null && !list.isEmpty()) {
                            long sommaMediePesate = 0L;
                            long sommaNumeroTransazioni = 0L;
                            for (Map map : list) {
                                Long l;
                                Object result = map.get("somma_latenza");
                                Object resultPesata = map.get("somma_media_pesata");
                                long latenza = 0L;
                                long numeroTransazioni = 0L;
                                if (result != null && this.isKnownType(result)) {
                                    l = this.translateType(result);
                                    if (l == null) throw new CoreException("Translate type (result) '" + String.valueOf(result) + "' non riuscito");
                                    latenza = l;
                                }
                                if (resultPesata != null && this.isKnownType(resultPesata)) {
                                    l = this.translateType(resultPesata);
                                    if (l == null) throw new CoreException("Translate type (resultPesata) '" + String.valueOf(resultPesata) + "' non riuscito");
                                    numeroTransazioni = l;
                                }
                                sommaNumeroTransazioni += numeroTransazioni;
                                long mediaPesata = latenza * numeroTransazioni;
                                sommaMediePesate += mediaPesata;
                            }
                            long risultatoPesato = sommaNumeroTransazioni > 0L ? sommaMediePesate / sommaNumeroTransazioni : 0L;
                            risultato.setRisultato(risultatoPesato);
                            break block41;
                        } else {
                            this.logDebug("LatenzaNotFound");
                            risultato.setRisultato(0L);
                        }
                        break block41;
                    }
                    Object result = dao.aggregate(expression, ff);
                    if (result != null && this.isKnownType(result)) {
                        this.logDebug("LatenzaFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                        Long l = this.translateType(result);
                        if (l == null) throw new CoreException("Translate type (result) '" + String.valueOf(result) + "' non riuscito");
                        risultato.setRisultato(l.longValue());
                    } else {
                        if (result != null) {
                            this.logDebug("LatenzaNotFound [" + result.getClass().getName() + "]: " + String.valueOf(result));
                        } else {
                            this.logDebug("LatenzaNotFound, result is null");
                        }
                        risultato.setRisultato(0L);
                    }
                }
                catch (NotFoundException notFound) {
                    this.logDebug("LatenzaNotFound:" + notFound.getMessage(), (Exception)((Object)notFound));
                    risultato.setRisultato(0L);
                }
            }
            risultatoStatistico = risultato;
        }
        catch (Exception e) {
            try {
                this.logError("Errore durante la raccolta dei dati statisti (key:" + key + "): " + e.getMessage(), e);
                throw new CoreException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (useConnectionRuntime) throw throwable;
                    if (r == null) throw throwable;
                    this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (useConnectionRuntime) return risultatoStatistico;
            if (r == null) return risultatoStatistico;
            this.dbStatisticheManager.releaseResource(dominio, idModulo, r);
            return risultatoStatistico;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return risultatoStatistico;
    }

    private IExpression createWhereExpressionLatenza(IServiceSearchWithoutId<?> dao, StatisticaModel model, TipoRisorsa tipoRisorsa, Date dataInizio, Date dataFine, TipoPdD tipoPdDTransazioneInCorso, IProtocolFactory<?> protocolFactory, String protocollo, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, TipoLatenza tipoLatenza, IState state, RequestInfo requestInfo) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException, DriverRegistroServiziException, DriverConfigurazioneException {
        IExpression expr = this.createWhereExpression(dao, model, tipoRisorsa, dataInizio, dataFine, tipoPdDTransazioneInCorso, protocolFactory, protocollo, groupByPolicy, filtro, state, requestInfo);
        int[] esiti = null;
        esiti = TipoPdD.DELEGATA.equals((Object)tipoPdDTransazioneInCorso) ? (int[])this.configurazioneControlloTraffico.getCalcoloLatenzaPortaDelegataEsitiConsiderati().get(protocollo) : (int[])this.configurazioneControlloTraffico.getCalcoloLatenzaPortaApplicativaEsitiConsiderati().get(protocollo);
        IExpression exprEsiti = dao.newExpression();
        exprEsiti.or();
        for (int i = 0; i < esiti.length; ++i) {
            exprEsiti.equals(model.ESITO, (Object)esiti[i]);
        }
        expr.and(new IExpression[]{exprEsiti});
        switch (tipoLatenza) {
            case PORTA: {
                expr.isNotNull(model.LATENZA_PORTA);
                break;
            }
            case SERVIZIO: {
                expr.isNotNull(model.LATENZA_SERVIZIO);
                break;
            }
            default: {
                expr.isNotNull(model.LATENZA_TOTALE);
            }
        }
        return expr;
    }

    private IExpression createWhereExpression(IServiceSearchWithoutId<?> dao, StatisticaModel model, TipoRisorsa tipoRisorsa, Date dataInizio, Date dataFine, TipoPdD tipoPdDTransazioneInCorso, IProtocolFactory<?> protocolFactory, String protocollo, IDUnivocoGroupByPolicy groupByPolicy, AttivazionePolicyFiltro filtro, IState state, RequestInfo requestInfo) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException, ProtocolException, DriverRegistroServiziException, DriverConfigurazioneException {
        String azione;
        ArrayList<IDServizio> idServiziByTag;
        IDServizio idServizio;
        IDSoggetto erogatore;
        IDSoggetto fruitore;
        IExpression expr;
        block76: {
            block78: {
                ConfigurazionePdDManager configurazionePdDManager;
                block79: {
                    boolean policyGlobale;
                    block77: {
                        expr = null;
                        expr = dao.newExpression();
                        expr.and();
                        expr.between(model.DATA, (Object)dataInizio, (Object)dataFine);
                        StatisticheUtils.selezionaRecordValidi((IExpression)expr, (StatisticaModel)model);
                        int[] esitiPolicyViolate = (int[])this.configurazioneControlloTraffico.getEsitiPolicyViolate().get(protocollo);
                        IExpression exprEsitiPolicyViolate = dao.newExpression();
                        exprEsitiPolicyViolate.or();
                        for (int i = 0; i < esitiPolicyViolate.length; ++i) {
                            exprEsitiPolicyViolate.equals(model.ESITO, (Object)esitiPolicyViolate[i]);
                        }
                        expr.not(exprEsitiPolicyViolate);
                        switch (tipoRisorsa) {
                            case NUMERO_RICHIESTE: 
                            case DIMENSIONE_MASSIMA_MESSAGGIO: 
                            case OCCUPAZIONE_BANDA: 
                            case TEMPO_COMPLESSIVO_RISPOSTA: 
                            case TEMPO_MEDIO_RISPOSTA: {
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO: {
                                expr.in(model.ESITO, (Collection)EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeOk());
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE: {
                                expr.in(model.ESITO, (Collection)EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeKo_senzaFaultApplicativo());
                                break;
                            }
                            case NUMERO_FAULT_APPLICATIVI: {
                                expr.in(model.ESITO, (Collection)EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeFaultApplicativo());
                                break;
                            }
                            case NUMERO_RICHIESTE_FALLITE_OFAULT_APPLICATIVI: {
                                expr.in(model.ESITO, (Collection)EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeKo());
                                break;
                            }
                            case NUMERO_RICHIESTE_COMPLETATE_CON_SUCCESSO_OFAULT_APPLICATIVI: {
                                ArrayList esitiAppartenentiGruppo = new ArrayList();
                                esitiAppartenentiGruppo.addAll(EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeOk());
                                esitiAppartenentiGruppo.addAll(EsitiProperties.getInstance((Logger)this.daoFactoryLogger, protocolFactory).getEsitiCodeFaultApplicativo());
                                expr.in(model.ESITO, esitiAppartenentiGruppo);
                                break;
                            }
                        }
                        policyGlobale = true;
                        if (filtro != null && filtro.isEnabled() && filtro.getNomePorta() != null && !"".equals(filtro.getNomePorta())) {
                            policyGlobale = false;
                        }
                        TipoPorta tipoPortaStat = null;
                        TipoPdD tipoPdD = groupByPolicy.getRuoloPortaAsTipoPdD();
                        if (tipoPdD == null && filtro != null && filtro.isEnabled() && filtro.getRuoloPorta() != null && !"".equals(filtro.getRuoloPorta().getValue()) && !RuoloPolicy.ENTRAMBI.equals((Object)filtro.getRuoloPorta())) {
                            if (RuoloPolicy.DELEGATA.equals((Object)filtro.getRuoloPorta())) {
                                tipoPdD = TipoPdD.DELEGATA;
                            }
                            if (RuoloPolicy.APPLICATIVA.equals((Object)filtro.getRuoloPorta())) {
                                tipoPdD = TipoPdD.APPLICATIVA;
                            }
                        }
                        if (tipoPdD != null) {
                            switch (tipoPdD) {
                                case DELEGATA: {
                                    tipoPortaStat = TipoPorta.DELEGATA;
                                    break;
                                }
                                case APPLICATIVA: {
                                    tipoPortaStat = TipoPorta.APPLICATIVA;
                                    break;
                                }
                                case INTEGRATION_MANAGER: {
                                    tipoPortaStat = TipoPorta.INTEGRATION_MANAGER;
                                    break;
                                }
                                case ROUTER: {
                                    tipoPortaStat = TipoPorta.ROUTER;
                                }
                            }
                            expr.equals(model.TIPO_PORTA, (Object)tipoPortaStat);
                        }
                        fruitore = groupByPolicy.getFruitoreIfDefined();
                        List fruitoriByRuolo = null;
                        if (fruitore == null && filtro != null && filtro.isEnabled()) {
                            if (filtro.getTipoFruitore() != null && !"".equals(filtro.getTipoFruitore()) && filtro.getNomeFruitore() != null && !"".equals(filtro.getNomeFruitore())) {
                                fruitore = new IDSoggetto(filtro.getTipoFruitore(), filtro.getNomeFruitore());
                            } else if (filtro.getRuoloFruitore() != null && !"".equals(filtro.getRuoloFruitore()) && (policyGlobale || TipoPdD.APPLICATIVA.equals((Object)tipoPdD))) {
                                RegistroServiziManager registroManager = RegistroServiziManager.getInstance((IState)state);
                                FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
                                IDRuolo idRuolo = new IDRuolo(filtro.getRuoloFruitore());
                                filtroRicerca.setIdRuolo(idRuolo);
                                try {
                                    fruitoriByRuolo = registroManager.getAllIdSoggetti(filtroRicerca, null);
                                }
                                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                    // empty catch block
                                }
                            }
                        }
                        if (fruitore != null) {
                            expr.equals(model.TIPO_MITTENTE, (Object)fruitore.getTipo());
                            expr.equals(model.MITTENTE, (Object)fruitore.getNome());
                        } else if (fruitoriByRuolo != null && !fruitoriByRuolo.isEmpty()) {
                            ArrayList<IExpression> l = new ArrayList<IExpression>();
                            for (IDSoggetto soggetto : fruitoriByRuolo) {
                                IExpression exprSoggetto = dao.newExpression();
                                exprSoggetto.equals(model.TIPO_MITTENTE, (Object)soggetto.getTipo());
                                exprSoggetto.and();
                                exprSoggetto.equals(model.MITTENTE, (Object)soggetto.getNome());
                                l.add(exprSoggetto);
                            }
                            expr.or(l.toArray(new IExpression[l.size()]));
                        }
                        erogatore = groupByPolicy.getErogatoreIfDefined();
                        List erogatoriByRuolo = null;
                        if (erogatore == null && filtro != null && filtro.isEnabled()) {
                            if (filtro.getTipoErogatore() != null && !"".equals(filtro.getTipoErogatore()) && filtro.getNomeErogatore() != null && !"".equals(filtro.getNomeErogatore())) {
                                erogatore = new IDSoggetto(filtro.getTipoErogatore(), filtro.getNomeErogatore());
                            } else if (filtro.getRuoloErogatore() != null && !"".equals(filtro.getRuoloErogatore())) {
                                RegistroServiziManager registroManager = RegistroServiziManager.getInstance((IState)state);
                                FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
                                IDRuolo idRuolo = new IDRuolo(filtro.getRuoloErogatore());
                                filtroRicerca.setIdRuolo(idRuolo);
                                try {
                                    erogatoriByRuolo = registroManager.getAllIdSoggetti(filtroRicerca, null);
                                }
                                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                    // empty catch block
                                }
                            }
                        }
                        if (erogatore != null) {
                            expr.equals(model.TIPO_DESTINATARIO, (Object)erogatore.getTipo());
                            expr.equals(model.DESTINATARIO, (Object)erogatore.getNome());
                        } else if (erogatoriByRuolo != null && !erogatoriByRuolo.isEmpty()) {
                            ArrayList<IExpression> l = new ArrayList<IExpression>();
                            for (IDSoggetto soggetto : erogatoriByRuolo) {
                                IExpression exprSoggetto = dao.newExpression();
                                exprSoggetto.equals(model.TIPO_DESTINATARIO, (Object)soggetto.getTipo());
                                exprSoggetto.and();
                                exprSoggetto.equals(model.DESTINATARIO, (Object)soggetto.getNome());
                                l.add(exprSoggetto);
                            }
                            expr.or(l.toArray(new IExpression[l.size()]));
                        }
                        idServizio = groupByPolicy.getServizioIfDefined();
                        idServiziByTag = null;
                        if (idServizio != null || filtro == null || !filtro.isEnabled()) break block76;
                        if (filtro.getTipoServizio() == null || "".equals(filtro.getTipoServizio()) || filtro.getNomeServizio() == null || "".equals(filtro.getNomeServizio()) || filtro.getVersioneServizio() == null) break block77;
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(filtro.getTipoServizio(), filtro.getNomeServizio(), null, null, filtro.getVersioneServizio().intValue());
                        break block76;
                    }
                    if (policyGlobale || filtro.getNomePorta() == null || "".equals(filtro.getNomePorta()) || filtro.getRuoloPorta() == null) break block78;
                    configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                    if (!RuoloPolicy.DELEGATA.equals((Object)filtro.getRuoloPorta())) break block79;
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(filtro.getNomePorta());
                    PortaDelegata pd = configurazionePdDManager.getPortaDelegataSafeMethod(idPD, requestInfo);
                    if (pd != null && pd.getServizio() != null && pd.getSoggettoErogatore() != null) {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
                    }
                    break block76;
                }
                IDPortaApplicativa idPA = new IDPortaApplicativa();
                idPA.setNome(filtro.getNomePorta());
                PortaApplicativa pa = configurazionePdDManager.getPortaApplicativaSafeMethod(idPA, requestInfo);
                if (pa == null || pa.getServizio() == null) break block76;
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValuesWithoutCheck(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                break block76;
            }
            if (filtro.getTag() != null && !"".equals(filtro.getTag())) {
                RegistroServiziManager registroManager = RegistroServiziManager.getInstance((IState)state);
                FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
                filtroRicercaAccordi.setIdGruppo(new IDGruppo(filtro.getTag()));
                List lIdAccordi = null;
                try {
                    lIdAccordi = registroManager.getAllIdAccordiServizioParteComune(filtroRicercaAccordi, null);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (lIdAccordi != null && !lIdAccordi.isEmpty()) {
                    for (IDAccordo idAccordoByTag : lIdAccordi) {
                        FiltroRicercaServizi filtroRicerca = new FiltroRicercaServizi();
                        filtroRicerca.setIdAccordoServizioParteComune(idAccordoByTag);
                        if (erogatore != null) {
                            filtroRicerca.setTipoSoggettoErogatore(erogatore.getTipo());
                            filtroRicerca.setNomeSoggettoErogatore(erogatore.getNome());
                        }
                        List lIdServizi = null;
                        try {
                            lIdServizi = registroManager.getAllIdServizi(filtroRicerca, null);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            // empty catch block
                        }
                        if (lIdServizi == null || lIdServizi.isEmpty()) continue;
                        if (idServiziByTag == null) {
                            idServiziByTag = new ArrayList<IDServizio>();
                        }
                        for (IDServizio idServizioByTag : lIdServizi) {
                            idServiziByTag.add(idServizioByTag);
                        }
                    }
                }
            }
        }
        if (idServizio != null) {
            expr.equals(model.TIPO_SERVIZIO, (Object)idServizio.getTipo());
            expr.equals(model.SERVIZIO, (Object)idServizio.getNome());
            expr.equals(model.VERSIONE_SERVIZIO, (Object)idServizio.getVersione());
        } else if (idServiziByTag != null && !idServiziByTag.isEmpty()) {
            ArrayList<IExpression> l = new ArrayList<IExpression>();
            for (IDServizio idServizioByTag : idServiziByTag) {
                IExpression exprServizio = dao.newExpression();
                exprServizio.and();
                exprServizio.equals(model.TIPO_DESTINATARIO, (Object)idServizioByTag.getSoggettoErogatore().getTipo());
                exprServizio.equals(model.DESTINATARIO, (Object)idServizioByTag.getSoggettoErogatore().getNome());
                exprServizio.equals(model.TIPO_SERVIZIO, (Object)idServizioByTag.getTipo());
                exprServizio.equals(model.SERVIZIO, (Object)idServizioByTag.getNome());
                exprServizio.equals(model.VERSIONE_SERVIZIO, (Object)idServizioByTag.getVersione());
                l.add(exprServizio);
            }
            expr.or(l.toArray(new IExpression[l.size()]));
        }
        String protocolloGroupBy = groupByPolicy.getProtocolloIfDefined();
        if (protocolloGroupBy == null && filtro != null && filtro.isEnabled() && filtro.getProtocollo() != null && !"".equals(filtro.getProtocollo())) {
            protocolloGroupBy = filtro.getProtocollo();
        }
        if (protocolloGroupBy != null && fruitore == null && erogatore == null && idServizio == null) {
            List listaTipiSoggetto = (List)ProtocolFactoryManager.getInstance().getOrganizationTypes().get((Object)protocolloGroupBy);
            expr.in(model.TIPO_MITTENTE, (Collection)listaTipiSoggetto);
            expr.in(model.TIPO_DESTINATARIO, (Collection)listaTipiSoggetto);
        }
        if ((azione = groupByPolicy.getAzioneIfDefined()) != null) {
            expr.equals(model.AZIONE, (Object)azione);
        } else if (filtro != null && filtro.isEnabled() && filtro.getAzione() != null && !"".equals(filtro.getAzione()) && idServizio != null) {
            IDAccordo tmp = filtro.getAzione().split(",");
            ArrayList<IDAccordo> azioneList = new ArrayList<IDAccordo>();
            if (tmp != null && ((String[])tmp).length > 0) {
                for (IDAccordo az : tmp) {
                    azioneList.add(az);
                }
            }
            expr.in(model.AZIONE, azioneList);
        }
        String servizioApplicativoFruitore = groupByPolicy.getServizioApplicativoFruitoreIfDefined();
        List<IDServizioApplicativo> servizioApplicativoFruitoreByRuolo = null;
        if (servizioApplicativoFruitore == null && filtro != null && filtro.isEnabled()) {
            if (filtro.getServizioApplicativoFruitore() != null && !"".equals(filtro.getServizioApplicativoFruitore())) {
                servizioApplicativoFruitore = filtro.getServizioApplicativoFruitore();
            } else if (filtro.getRuoloFruitore() != null && !"".equals(filtro.getRuoloFruitore())) {
                ConfigurazionePdDManager configurazionePdDManager = ConfigurazionePdDManager.getInstance(state);
                FiltroRicercaServiziApplicativi filtroRicerca = new FiltroRicercaServiziApplicativi();
                IDRuolo idRuolo = new IDRuolo(filtro.getRuoloFruitore());
                filtroRicerca.setIdRuolo(idRuolo);
                List<IDServizioApplicativo> list = null;
                try {
                    list = configurazionePdDManager.getAllIdServiziApplicativi(filtroRicerca);
                }
                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                    // empty catch block
                }
                if (list != null && !list.isEmpty()) {
                    servizioApplicativoFruitoreByRuolo = list;
                }
            }
        }
        if (servizioApplicativoFruitore != null) {
            expr.equals(model.SERVIZIO_APPLICATIVO, (Object)servizioApplicativoFruitore);
        } else if (servizioApplicativoFruitoreByRuolo != null && !servizioApplicativoFruitoreByRuolo.isEmpty()) {
            ArrayList<IExpression> l = new ArrayList<IExpression>();
            for (IDServizioApplicativo idServizioApplicativo : servizioApplicativoFruitoreByRuolo) {
                IExpression exprServizioApplicativo = dao.newExpression();
                exprServizioApplicativo.and();
                exprServizioApplicativo.equals(model.TIPO_MITTENTE, (Object)idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                exprServizioApplicativo.equals(model.MITTENTE, (Object)idServizioApplicativo.getIdSoggettoProprietario().getNome());
                exprServizioApplicativo.equals(model.SERVIZIO_APPLICATIVO, (Object)idServizioApplicativo.getNome());
                l.add(exprServizioApplicativo);
            }
            expr.or(l.toArray(new IExpression[l.size()]));
        }
        if (TipoPdD.APPLICATIVA.equals((Object)tipoPdDTransazioneInCorso)) {
            String servizioApplicativoErogatore = groupByPolicy.getServizioApplicativoErogatoreIfDefined();
            if (servizioApplicativoErogatore == null && filtro != null && filtro.isEnabled() && filtro.getServizioApplicativoErogatore() != null && !"".equals(filtro.getServizioApplicativoErogatore())) {
                servizioApplicativoErogatore = filtro.getServizioApplicativoErogatore();
            }
            if (servizioApplicativoErogatore != null) {
                expr.equals(model.SERVIZIO_APPLICATIVO, (Object)servizioApplicativoErogatore);
            }
        }
        return expr;
    }

    private boolean isKnownType(Object result) {
        return result instanceof Long || result instanceof Integer || result instanceof Short || result instanceof Double || result instanceof Float;
    }

    private Long translateType(Object result) {
        if (result instanceof Long) {
            return (Long)result;
        }
        if (result instanceof Integer) {
            return ((Integer)result).longValue();
        }
        if (result instanceof Short) {
            return ((Short)result).longValue();
        }
        if (result instanceof Double) {
            return ((Double)result).longValue();
        }
        if (result instanceof Float) {
            return ((Float)result).longValue();
        }
        return null;
    }
}

