/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver;

import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.ConfigurazioneControlloTraffico;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.DatiTransazione;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.driver.IGestorePolicyAttive;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreads;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyShutdownException;
import org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbDeserializer;
import org.openspcoop2.core.controllo_traffico.utils.serializer.JaxbSerializer;
import org.openspcoop2.pdd.config.DynamicClusterManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.BuilderDatiCollezionatiDistributed;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.GestorePolicyAttive;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreads;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreadsDB;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreadsDistributedCounters;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.PolicyGroupByActiveThreadsDistributedCountersWithLock;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.HazelcastManager;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedLocalCache;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedNearCache;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessorPutAsync;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessorPutSync;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedNoCache;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.PolicyGroupByActiveThreadsDistributedReplicatedMap;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.PolicyGroupByActiveThreadsDistributedRedis;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.RedissonManager;
import org.openspcoop2.pdd.services.OpenSPCoop2Startup;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class GestorePolicyAttiveInMemory
implements IGestorePolicyAttive {
    private Map<String, IPolicyGroupByActiveThreadsInMemory> mapActiveThreadsPolicy = new HashMap<String, IPolicyGroupByActiveThreadsInMemory>();
    private final Semaphore lock = new Semaphore("GestorePolicyAttiveInMemory");
    private static final String IMPL_DESCR = "Implementazione InMemory IGestorePolicyAttive";
    private Logger log;
    private PolicyGroupByActiveThreadsType type;
    private boolean useCountersWithLock = false;
    private boolean isStop = false;
    private static final String ZIP_POLICY_PREFIX = "policy-";
    private static final String ZIP_POLICY_ID_ACTIVE_SUFFIX = "-id-active.txt";
    private static final String ZIP_POLICY_CONFIGURAZIONE_POLICY_SUFFIX = "ConfigurazionePolicy.xml";
    private static final String ZIP_POLICY_ATTIVAZIONE_POLICY_SUFFIX = "AttivazionePolicy.xml";
    private static final String ZIP_POLICY_ID_DATI_COLLEZIONATI_POLICY_SUFFIX = "-id-datiCollezionati.txt";
    private static final String ZIP_POLICY_DATI_COLLEZIONATI_POLICY_SUFFIX = "-datiCollezionati.txt";

    public static String getImplDescr() {
        return IMPL_DESCR;
    }

    public void initialize(Logger log, boolean isStartupGovWay, PolicyGroupByActiveThreadsType type, Object ... params) throws PolicyException {
        this.log = log;
        this.type = type;
        if (this.type == null) {
            this.type = PolicyGroupByActiveThreadsType.LOCAL;
        }
        switch (this.type) {
            case LOCAL: {
                break;
            }
            case LOCAL_DIVIDED_BY_NODES: {
                if (!DynamicClusterManager.isInitialized()) {
                    try {
                        DynamicClusterManager.initStaticInstance();
                        DynamicClusterManager.getInstance().setRateLimitingGestioneCluster(true);
                        DynamicClusterManager.getInstance().register(log);
                        OpenSPCoop2Startup.startTimerClusterDinamicoThread();
                        break;
                    }
                    catch (Exception e) {
                        throw new PolicyException(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    DynamicClusterManager.getInstance().setRateLimitingGestioneCluster(true);
                    break;
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
            }
            case DATABASE: {
                break;
            }
            case HAZELCAST_MAP: 
            case HAZELCAST_NEAR_CACHE: 
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: 
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: 
            case HAZELCAST_REPLICATED_MAP: {
                HazelcastManager.getInstance(this.type);
                break;
            }
            case HAZELCAST_PNCOUNTER: 
            case HAZELCAST_ATOMIC_LONG: 
            case HAZELCAST_ATOMIC_LONG_ASYNC: {
                HazelcastManager.getInstance(this.type);
                if (OpenSPCoop2Startup.isStartedTimerHazelcastOrphanedProxiesCleanup()) break;
                try {
                    OpenSPCoop2Startup.startTimerHazelcastOrphanedProxiesCleanup();
                    break;
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
            }
            case HAZELCAST_LOCAL_CACHE: {
                HazelcastManager.getInstance(this.type);
                if (OpenSPCoop2Startup.isStartedTimerClusteredRateLimitingLocalCache()) break;
                try {
                    OpenSPCoop2Startup.startTimerClusteredRateLimitingLocalCache(this);
                    break;
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
            }
            case REDISSON_MAP: 
            case REDISSON_ATOMIC_LONG: 
            case REDISSON_LONGADDER: {
                boolean throwInitializingException = true;
                if (isStartupGovWay) {
                    throwInitializingException = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryRedisThrowExceptionIfRedisNotReady();
                }
                try {
                    RedissonManager.getRedissonClient(throwInitializingException);
                    break;
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.type.isHazelcastCounters() || this.type.isRedisCounters()) {
            this.useCountersWithLock = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryRemoteCountersUseLocalLock();
        }
    }

    public PolicyGroupByActiveThreadsType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPolicyGroupByActiveThreads getActiveThreadsPolicy(ActivePolicy activePolicy, DatiTransazione datiTransazione, Object state) throws PolicyShutdownException, PolicyException {
        String uniqueIdMap = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)activePolicy.getInstanceConfiguration());
        SemaphoreLock slock = this.lock.acquireThrowRuntime("getActiveThreadsPolicy(ActivePolicy)");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            IPolicyGroupByActiveThreadsInMemory active = null;
            if (this.mapActiveThreadsPolicy.containsKey(uniqueIdMap)) {
                active = this.mapActiveThreadsPolicy.get(uniqueIdMap);
            } else {
                active = this.newPolicyGroupByActiveThreadsInMemory(activePolicy, uniqueIdMap, datiTransazione, state);
                this.mapActiveThreadsPolicy.put(uniqueIdMap, active);
            }
            IPolicyGroupByActiveThreadsInMemory iPolicyGroupByActiveThreadsInMemory = active;
            return iPolicyGroupByActiveThreadsInMemory;
        }
        finally {
            this.lock.release(slock, "getActiveThreadsPolicy(ActivePolicy)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPolicyGroupByActiveThreads getActiveThreadsPolicy(String uniqueIdMap) throws PolicyShutdownException, PolicyException, PolicyNotFoundException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("getActiveThreadsPolicy(uniqueIdMap)");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            IPolicyGroupByActiveThreads active = null;
            if (!this.mapActiveThreadsPolicy.containsKey(uniqueIdMap)) {
                throw new PolicyNotFoundException("ActivePolicy [" + uniqueIdMap + "] notFound");
            }
            active = (IPolicyGroupByActiveThreads)this.mapActiveThreadsPolicy.get(uniqueIdMap);
            IPolicyGroupByActiveThreads iPolicyGroupByActiveThreads = active;
            return iPolicyGroupByActiveThreads;
        }
        finally {
            this.lock.release(slock, "getActiveThreadsPolicy(uniqueIdMap)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sizeActivePolicyThreads(boolean sum) throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("sizeActivePolicyThreads");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            if (sum) {
                long sumLong = 0L;
                if (this.mapActiveThreadsPolicy != null && !this.mapActiveThreadsPolicy.isEmpty()) {
                    for (String idPolicy : this.mapActiveThreadsPolicy.keySet()) {
                        sumLong += this.mapActiveThreadsPolicy.get(idPolicy).getActiveThreads();
                    }
                }
                long l = sumLong;
                return l;
            }
            long l = this.mapActiveThreadsPolicy.size();
            return l;
        }
        finally {
            this.lock.release(slock, "sizeActivePolicyThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printKeysPolicy(String separator) throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("printKeysPolicy");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            StringBuilder bf = new StringBuilder();
            if (this.mapActiveThreadsPolicy != null && !this.mapActiveThreadsPolicy.isEmpty()) {
                int i = 0;
                Iterator<String> iterator = this.mapActiveThreadsPolicy.keySet().iterator();
                while (iterator.hasNext()) {
                    String idPolicy;
                    String key = idPolicy = iterator.next();
                    if (i > 0) {
                        bf.append(separator);
                    }
                    bf.append("Cache-" + String.valueOf(this.type) + "[" + i + "]=[" + key + "]");
                    ++i;
                }
            }
            String string = bf.toString();
            return string;
        }
        finally {
            this.lock.release(slock, "printKeysPolicy");
        }
    }

    public String printInfoPolicy(String id, String separatorGroups) throws PolicyShutdownException, PolicyException, PolicyNotFoundException {
        IPolicyGroupByActiveThreadsInMemory activeThreads = (IPolicyGroupByActiveThreadsInMemory)this.getActiveThreadsPolicy(id);
        try {
            return activeThreads.printInfos(this.log, separatorGroups);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveThreadsPolicy(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("removeActiveThreadsPolicy");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            IPolicyGroupByActiveThreadsInMemory policy = this.mapActiveThreadsPolicy.remove(idActivePolicy);
            if (policy != null) {
                try {
                    policy.remove();
                }
                catch (Throwable e) {
                    this.log.error("removeActiveThreadsPolicy failed: " + e.getMessage(), e);
                }
            }
        }
        finally {
            this.lock.release(slock, "removeActiveThreadsPolicy");
        }
    }

    public void removeActiveThreadsPolicyUnsafe(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        if (this.isStop) {
            throw new PolicyShutdownException("Policy Manager shutdown");
        }
        IPolicyGroupByActiveThreadsInMemory policy = this.mapActiveThreadsPolicy.remove(idActivePolicy);
        if (policy != null) {
            try {
                policy.remove();
            }
            catch (Throwable e) {
                this.log.error("removeActiveThreadsPolicyUnsafe failed: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllActiveThreadsPolicy() throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("removeAllActiveThreadsPolicy");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            for (IPolicyGroupByActiveThreadsInMemory policy : this.mapActiveThreadsPolicy.values()) {
                try {
                    policy.remove();
                }
                catch (Throwable e) {
                    this.log.error("removeAllActiveThreadsPolicy (policy.remove) failed: " + e.getMessage(), e);
                }
            }
            this.mapActiveThreadsPolicy.clear();
        }
        finally {
            this.lock.release(slock, "removeAllActiveThreadsPolicy");
        }
    }

    public void resetCountersActiveThreadsPolicy(String idActivePolicy) throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("resetCountersActiveThreadsPolicy");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            if (this.mapActiveThreadsPolicy.containsKey(idActivePolicy)) {
                this.mapActiveThreadsPolicy.get(idActivePolicy).resetCounters();
            }
        }
        finally {
            this.lock.release(slock, "resetCountersActiveThreadsPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCountersAllActiveThreadsPolicy() throws PolicyShutdownException, PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("resetCountersAllActiveThreadsPolicy");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            if (this.mapActiveThreadsPolicy.size() > 0) {
                for (String key : this.mapActiveThreadsPolicy.keySet()) {
                    this.mapActiveThreadsPolicy.get(key).resetCounters();
                }
            }
        }
        finally {
            this.lock.release(slock, "resetCountersAllActiveThreadsPolicy");
        }
    }

    public Set<Map.Entry<String, IPolicyGroupByActiveThreadsInMemory>> entrySet() throws PolicyShutdownException, PolicyException {
        Set<Map.Entry<String, IPolicyGroupByActiveThreadsInMemory>> activeThreadsPolicies;
        SemaphoreLock slock = this.lock.acquireThrowRuntime("updateLocalCacheMap");
        try {
            if (this.isStop) {
                throw new PolicyShutdownException("Policy Manager shutdown");
            }
            activeThreadsPolicies = this.mapActiveThreadsPolicy.entrySet();
        }
        finally {
            this.lock.release(slock, "updateLocalCacheMap");
        }
        return activeThreadsPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream out) throws PolicyException {
        SemaphoreLock slock = null;
        try {
            slock = this.lock.acquireThrowRuntime("serialize");
            if (this.isStop) {
                throw new PolicyException("Already serialized");
            }
            this.isStop = true;
            if (this.mapActiveThreadsPolicy == null || this.mapActiveThreadsPolicy.size() <= 0) {
                return;
            }
            ZipOutputStream zipOut = null;
            try {
                zipOut = new ZipOutputStream(out);
                Object rootPackageDir = "";
                rootPackageDir = "openspcoop" + File.separatorChar;
                int index = 1;
                for (String idActivePolicy : this.mapActiveThreadsPolicy.keySet()) {
                    String idFileActivePolicy = ZIP_POLICY_PREFIX + index;
                    String nomeFile = idFileActivePolicy + ZIP_POLICY_ID_ACTIVE_SUFFIX;
                    zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                    zipOut.write(idActivePolicy.getBytes());
                    IPolicyGroupByActiveThreadsInMemory active = this.mapActiveThreadsPolicy.get(idActivePolicy);
                    if (active != null) {
                        Map map;
                        ActivePolicy activePolicy = active.getActivePolicy();
                        JaxbSerializer serializer = new JaxbSerializer();
                        byte[] cPolicy = null;
                        if (activePolicy.getConfigurazionePolicy() != null) {
                            try {
                                cPolicy = serializer.toByteArray(activePolicy.getConfigurazionePolicy());
                            }
                            catch (Throwable t) {
                                this.log.error("[" + String.valueOf(this.type) + "] Serializzazione configurazione policy '" + activePolicy.getConfigurazionePolicy().getIdPolicy() + "' fallita: " + t.getMessage(), t);
                            }
                            if (cPolicy == null) continue;
                        }
                        byte[] aPolicy = null;
                        if (activePolicy.getInstanceConfiguration() != null) {
                            try {
                                aPolicy = serializer.toByteArray(activePolicy.getInstanceConfiguration());
                            }
                            catch (Throwable t) {
                                this.log.error("[" + String.valueOf(this.type) + "] Serializzazione attivazione policy '" + activePolicy.getInstanceConfiguration().getAlias() + "' (" + activePolicy.getInstanceConfiguration().getIdActivePolicy() + ") fallita: " + t.getMessage(), t);
                            }
                            if (aPolicy == null) continue;
                        }
                        if (activePolicy.getConfigurazionePolicy() != null) {
                            nomeFile = idFileActivePolicy + File.separatorChar + ZIP_POLICY_CONFIGURAZIONE_POLICY_SUFFIX;
                            zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                            zipOut.write(cPolicy);
                        }
                        if (activePolicy.getInstanceConfiguration() != null) {
                            nomeFile = idFileActivePolicy + File.separatorChar + ZIP_POLICY_ATTIVAZIONE_POLICY_SUFFIX;
                            zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                            zipOut.write(aPolicy);
                        }
                        if ((map = active.getMapActiveThreads()) != null && map.size() > 0) {
                            int indexDatoCollezionato = 1;
                            for (IDUnivocoGroupByPolicy idUnivocoGroupByPolicy : map.keySet()) {
                                String idFileRaggruppamento = idFileActivePolicy + File.separatorChar + "groupBy" + File.separatorChar + "groupBy-" + indexDatoCollezionato;
                                String id = null;
                                try {
                                    id = IDUnivocoGroupByPolicy.serialize((IDUnivocoGroupByPolicy)idUnivocoGroupByPolicy);
                                }
                                catch (Throwable t) {
                                    this.log.error("[" + String.valueOf(this.type) + "] Serializzazione idUnivocoGroupByPolicy (" + String.valueOf(idUnivocoGroupByPolicy) + ") della policy '" + activePolicy.getInstanceConfiguration().getAlias() + "' (" + activePolicy.getInstanceConfiguration().getIdActivePolicy() + ") fallita: " + t.getMessage(), t);
                                }
                                if (id == null) continue;
                                DatiCollezionati datiCollezionati = (DatiCollezionati)map.get(idUnivocoGroupByPolicy);
                                String dati = null;
                                try {
                                    dati = DatiCollezionati.serialize((DatiCollezionati)datiCollezionati);
                                }
                                catch (Throwable t) {
                                    this.log.error("[" + String.valueOf(this.type) + "] Serializzazione dati per idUnivocoGroupByPolicy (" + String.valueOf(idUnivocoGroupByPolicy) + ") della policy '" + activePolicy.getInstanceConfiguration().getAlias() + "' (" + activePolicy.getInstanceConfiguration().getIdActivePolicy() + ") fallita: " + t.getMessage(), t);
                                }
                                if (dati == null) continue;
                                nomeFile = idFileRaggruppamento + ZIP_POLICY_ID_DATI_COLLEZIONATI_POLICY_SUFFIX;
                                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                                zipOut.write(id.getBytes());
                                nomeFile = idFileRaggruppamento + File.separatorChar + "dati-datiCollezionati.txt";
                                zipOut.putNextEntry(new ZipEntry((String)rootPackageDir + nomeFile));
                                zipOut.write(dati.getBytes());
                                ++indexDatoCollezionato;
                            }
                        }
                    }
                    ++index;
                }
                zipOut.flush();
            }
            catch (Exception e) {
                throw new PolicyException(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (zipOut != null) {
                        zipOut.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.lock.release(slock, "serialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initialize(InputStream in, ConfigurazioneControlloTraffico configurazioneControlloTraffico) throws PolicyException {
        SemaphoreLock slock = null;
        try {
            slock = this.lock.acquireThrowRuntime("initialize");
            if (in == null) {
                return;
            }
            File f = null;
            ZipFile zipFile = null;
            String entryName = null;
            try {
                byte[] bytesIn = Utilities.getAsByteArray((InputStream)in);
                in.close();
                in = null;
                if (bytesIn == null) return;
                if (bytesIn.length <= 0) {
                    return;
                }
                f = FileSystemUtilities.createTempFile((String)"controlloTraffico", (String)".tmp");
                FileSystemUtilities.writeFile((File)f, (byte[])bytesIn);
                try {
                    zipFile = new ZipFile(f);
                }
                catch (Throwable t) {
                    this.log.error("Inizializzazione immagine ControlloTraffico precedente allo shutdown non ripristinabile, immagine corrotta: " + t.getMessage(), t);
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (f != null && f.delete()) {
                            // empty if block
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.lock.release(slock, "initialize");
                    return;
                }
                JaxbDeserializer deserializer = new JaxbDeserializer();
                String rootPackageDir = "openspcoop" + File.separatorChar;
                String rootDir = null;
                String idActivePolicy = null;
                ConfigurazionePolicy configurazionePolicy = null;
                AttivazionePolicy attivazionePolicy = null;
                HashMap<IDUnivocoGroupByPolicy, DatiCollezionati> map = null;
                IDUnivocoGroupByPolicy idDatiCollezionati = null;
                Iterator it = ZipUtilities.entries((ZipFile)zipFile, (boolean)true);
                while (it.hasNext()) {
                    ZipEntry zipEntry = (ZipEntry)it.next();
                    entryName = ZipUtilities.operativeSystemConversion((String)zipEntry.getName());
                    if (rootDir == null) {
                        rootDir = ZipUtilities.getRootDir((String)entryName);
                    }
                    if (zipEntry.isDirectory()) continue;
                    FileDataSource fds = new FileDataSource(entryName);
                    String nome = fds.getName();
                    String tipo = nome.substring(nome.lastIndexOf(".") + 1, nome.length());
                    tipo = tipo.toUpperCase();
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    byte[] content = Utilities.getAsByteArray((InputStream)inputStream);
                    try {
                        if (!entryName.startsWith(rootPackageDir + ZIP_POLICY_PREFIX)) throw new Exception("Entry unknown");
                        if (entryName.endsWith(ZIP_POLICY_ID_ACTIVE_SUFFIX)) {
                            if (idActivePolicy != null) {
                                this.mapActiveThreadsPolicy.put(idActivePolicy, this.buildPolicyGroupByActiveThreads(configurazionePolicy, attivazionePolicy, map, configurazioneControlloTraffico));
                                idActivePolicy = null;
                                configurazionePolicy = null;
                                attivazionePolicy = null;
                                map = null;
                                idDatiCollezionati = null;
                            }
                            idActivePolicy = new String(content);
                            map = new HashMap<IDUnivocoGroupByPolicy, DatiCollezionati>();
                            continue;
                        }
                        if (entryName.endsWith(ZIP_POLICY_CONFIGURAZIONE_POLICY_SUFFIX)) {
                            configurazionePolicy = deserializer.readConfigurazionePolicy(content);
                            continue;
                        }
                        if (entryName.endsWith(ZIP_POLICY_ATTIVAZIONE_POLICY_SUFFIX)) {
                            attivazionePolicy = deserializer.readAttivazionePolicy(content);
                            continue;
                        }
                        if (entryName.endsWith(ZIP_POLICY_ID_DATI_COLLEZIONATI_POLICY_SUFFIX)) {
                            idDatiCollezionati = IDUnivocoGroupByPolicy.deserialize((String)new String(content));
                            continue;
                        }
                        if (!entryName.endsWith(ZIP_POLICY_DATI_COLLEZIONATI_POLICY_SUFFIX)) continue;
                        if (idDatiCollezionati == null) {
                            throw new Exception("Identificativo di group by not found");
                        }
                        map.put(idDatiCollezionati, DatiCollezionati.deserialize((String)new String(content)));
                    }
                    finally {
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (idActivePolicy == null) return;
                this.mapActiveThreadsPolicy.put(idActivePolicy, this.buildPolicyGroupByActiveThreads(configurazionePolicy, attivazionePolicy, map, configurazioneControlloTraffico));
                idActivePolicy = null;
                configurazionePolicy = null;
                attivazionePolicy = null;
                map = null;
                idDatiCollezionati = null;
                return;
            }
            catch (Exception e) {
                throw new PolicyException("[" + entryName + "] " + e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (f != null && f.delete()) {
                        // empty if block
                    }
                }
                catch (Exception exception) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.lock.release(slock, "initialize");
        }
    }

    public void cleanOldActiveThreadsPolicy() throws PolicyException {
        SemaphoreLock slock = this.lock.acquireThrowRuntime("cleanOldActiveThreadsPolicy");
        try {
            if (this.mapActiveThreadsPolicy != null && !this.mapActiveThreadsPolicy.isEmpty()) {
                for (String uniqueIdMap : this.mapActiveThreadsPolicy.keySet()) {
                    for (PolicyGroupByActiveThreadsType tipo : GestorePolicyAttive.getTipiGestoriAttivi()) {
                        if (tipo.equals((Object)this.type)) continue;
                        GestorePolicyAttive.getInstance(tipo).removeActiveThreadsPolicyUnsafe(uniqueIdMap);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.release(slock, "cleanOldActiveThreadsPolicy");
        }
    }

    private IPolicyGroupByActiveThreadsInMemory buildPolicyGroupByActiveThreads(ConfigurazionePolicy configurazionePolicy, AttivazionePolicy attivazionePolicy, Map<IDUnivocoGroupByPolicy, DatiCollezionati> map, ConfigurazioneControlloTraffico configurazioneControlloTraffico) throws Exception {
        if (configurazionePolicy == null) {
            throw new PolicyException("ConfigurazionePolicy non presente");
        }
        if (attivazionePolicy == null) {
            throw new PolicyException("AttivazionePolicy non presente");
        }
        if (configurazioneControlloTraffico == null) {
            throw new PolicyException("ConfigurazioneControlloTraffico non presente");
        }
        ActivePolicy activePolicy = new ActivePolicy();
        activePolicy.setConfigurazioneControlloTraffico(configurazioneControlloTraffico);
        activePolicy.setConfigurazionePolicy(configurazionePolicy);
        activePolicy.setInstanceConfiguration(attivazionePolicy);
        activePolicy.setTipoRisorsaPolicy(TipoRisorsa.toEnumConstant((String)configurazionePolicy.getRisorsa(), (boolean)true));
        String uniqueIdMap = UniqueIdentifierUtilities.getUniqueId((AttivazionePolicy)activePolicy.getInstanceConfiguration());
        IPolicyGroupByActiveThreadsInMemory p = this.newPolicyGroupByActiveThreadsInMemory(activePolicy, uniqueIdMap, null, null);
        if (map != null && map.size() > 0) {
            for (IDUnivocoGroupByPolicy id : map.keySet()) {
                map.get(id).initActiveRequestCounter();
            }
            p.initMap(map);
        }
        return p;
    }

    private IPolicyGroupByActiveThreadsInMemory newPolicyGroupByActiveThreadsInMemory(ActivePolicy activePolicy, String uniqueIdMap, DatiTransazione datiTransazione, Object state) throws PolicyException {
        switch (this.type) {
            case LOCAL: {
                return new PolicyGroupByActiveThreads(activePolicy, this.type);
            }
            case LOCAL_DIVIDED_BY_NODES: {
                return new PolicyGroupByActiveThreads(activePolicy, this.type);
            }
            case DATABASE: {
                return new PolicyGroupByActiveThreadsDB(activePolicy, this.type, uniqueIdMap, state != null && state instanceof IState ? (IState)state : null, datiTransazione != null ? datiTransazione.getDominio() : null, datiTransazione != null ? datiTransazione.getIdTransazione() : null);
            }
            case HAZELCAST_LOCAL_CACHE: {
                return new PolicyGroupByActiveThreadsDistributedLocalCache(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_NEAR_CACHE: {
                return new PolicyGroupByActiveThreadsDistributedNearCache(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                return new PolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessorPutSync(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                return new PolicyGroupByActiveThreadsDistributedNearCacheWithoutEntryProcessorPutAsync(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_MAP: {
                return new PolicyGroupByActiveThreadsDistributedNoCache(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_REPLICATED_MAP: {
                return new PolicyGroupByActiveThreadsDistributedReplicatedMap(activePolicy, uniqueIdMap, HazelcastManager.getInstance(this.type));
            }
            case HAZELCAST_PNCOUNTER: 
            case HAZELCAST_ATOMIC_LONG: 
            case HAZELCAST_ATOMIC_LONG_ASYNC: 
            case REDISSON_ATOMIC_LONG: 
            case REDISSON_LONGADDER: {
                BuilderDatiCollezionatiDistributed builder = BuilderDatiCollezionatiDistributed.getBuilder(this.type);
                if (this.useCountersWithLock) {
                    return new PolicyGroupByActiveThreadsDistributedCountersWithLock(activePolicy, uniqueIdMap, builder);
                }
                return new PolicyGroupByActiveThreadsDistributedCounters(activePolicy, uniqueIdMap, builder);
            }
            case REDISSON_MAP: {
                boolean throwInitializingException = true;
                RedissonClient redissonClient = null;
                try {
                    redissonClient = RedissonManager.getRedissonClient(throwInitializingException);
                }
                catch (Exception e) {
                    throw new PolicyException(e.getMessage(), (Throwable)e);
                }
                return new PolicyGroupByActiveThreadsDistributedRedis(activePolicy, uniqueIdMap, redissonClient);
            }
        }
        throw new PolicyException("Unsupported type '" + String.valueOf(this.type) + "'");
    }
}

