/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.InitProcessor;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.ResetCountersProcessor;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public abstract class AbstractPolicyGroupByActiveThreadsDistributed
implements IPolicyGroupByActiveThreadsInMemory {
    protected final HazelcastInstance hazelcast;
    protected final IMap<IDUnivocoGroupByPolicy, DatiCollezionati> distributedMap;
    protected final ActivePolicy activePolicy;
    protected PolicyGroupByActiveThreadsType type;
    protected String uniqueIdMapIdActivePolicy;
    protected Date uniqueIdMapUpdateTime;

    protected AbstractPolicyGroupByActiveThreadsDistributed(ActivePolicy policy, String uniqueIdMap, PolicyGroupByActiveThreadsType type, HazelcastInstance hazelcast) throws PolicyException {
        this.activePolicy = policy;
        this.hazelcast = hazelcast;
        this.uniqueIdMapIdActivePolicy = UniqueIdentifierUtilities.extractIdActivePolicy((String)uniqueIdMap);
        try {
            this.uniqueIdMapUpdateTime = UniqueIdentifierUtilities.extractUpdateTimeActivePolicy((String)uniqueIdMap);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
        this.type = type;
        String mapName = "hazelcast-";
        switch (type) {
            case HAZELCAST_MAP: {
                mapName = "hazelcast-";
                break;
            }
            case HAZELCAST_NEAR_CACHE: {
                mapName = "hazelcast-near-cache-";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP: {
                mapName = "hazelcast-near-cache-unsafe-sync-map-";
                break;
            }
            case HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP: {
                mapName = "hazelcast-near-cache-unsafe-async-map-";
                break;
            }
            case HAZELCAST_LOCAL_CACHE: {
                mapName = "hazelcast-local-cache-";
                break;
            }
        }
        boolean oneMapForeachPolicy = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy();
        if (oneMapForeachPolicy && PolicyGroupByActiveThreadsType.HAZELCAST_LOCAL_CACHE.equals((Object)this.type)) {
            log.warn("Property isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy non compatibile con HAZELCAST_LOCAL_CACHE");
            oneMapForeachPolicy = false;
        }
        if (oneMapForeachPolicy) {
            this.distributedMap = this.hazelcast.getMap(mapName + this.uniqueIdMapIdActivePolicy + "-rate-limiting");
            log.info("Hazelcast: Utilizzo Una Distributed Map per gruppo.");
        } else {
            this.distributedMap = this.hazelcast.getMap(mapName + "rate-limiting");
            log.info("Hazelcast: Utilizzo Una Distributed Map globale.");
        }
        if (this.distributedMap.get((Object)new IDUnivocoGroupByPolicy()) != null) {
            // empty if block
        }
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        return this.distributedMap;
    }

    public IMap<IDUnivocoGroupByPolicy, DatiCollezionati> getDistributedMapActiveThreads() {
        return this.distributedMap;
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    public void initMap(Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry : map.entrySet()) {
                IDUnivocoGroupByPolicy datiGroupBy = entry.getKey();
                datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
                DatiCollezionati dati = map.get(datiGroupBy);
                InitProcessor initProcessor = new InitProcessor(dati);
                this.distributedMap.executeOnKey((Object)datiGroupBy, (EntryProcessor)initProcessor);
            }
        }
    }

    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        long counter = 0L;
        if (filtro != null) {
            for (Map.Entry entry : this.distributedMap.entrySet()) {
                IDUnivocoGroupByPolicy datiGroupBy = (IDUnivocoGroupByPolicy)entry.getKey();
                if (!datiGroupBy.match(filtro)) continue;
                DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
                counter += datiCollezionati.getActiveRequestCounter().longValue();
            }
        }
        return counter;
    }

    public void resetCounters() {
        this.distributedMap.executeOnEntries((EntryProcessor)new ResetCountersProcessor());
    }

    public void remove() throws UtilsException {
        ArrayList<IDUnivocoGroupByPolicy> deleteList = new ArrayList<IDUnivocoGroupByPolicy>();
        for (IDUnivocoGroupByPolicy datiGroupBy : this.distributedMap.keySet()) {
            IDUnivocoGroupByPolicyMapId mapId;
            if (!(datiGroupBy instanceof IDUnivocoGroupByPolicyMapId) || !this.uniqueIdMapIdActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
            deleteList.add(datiGroupBy);
        }
        while (!deleteList.isEmpty()) {
            IDUnivocoGroupByPolicy id = (IDUnivocoGroupByPolicy)deleteList.remove(0);
            this.distributedMap.remove((Object)id);
        }
    }

    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        return this.printInfos(log, separatorGroups, (Map<IDUnivocoGroupByPolicy, DatiCollezionati>)this.distributedMap);
    }

    protected String printInfos(Logger log, String separatorGroups, Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        StringBuilder bf = new StringBuilder();
        for (Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry : map.entrySet()) {
            IDUnivocoGroupByPolicyMapId mapId;
            IDUnivocoGroupByPolicy datiGroupBy = entry.getKey();
            DatiCollezionati datiCollezionati = map.get(datiGroupBy);
            if (OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy() != null && !OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy().booleanValue() && !this.uniqueIdMapIdActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
            bf.append(separatorGroups);
            bf.append("\n");
            bf.append("Sincronizzazione").append(" ").append(this.type.toLabel());
            bf.append("\n");
            bf.append("Criterio di Collezionamento dei Dati\n");
            bf.append(datiGroupBy.toString(true));
            bf.append("\n");
            datiCollezionati.checkDate(log, this.activePolicy);
            bf.append(datiCollezionati.toString());
            bf.append("\n");
        }
        if (bf.length() <= 0) {
            bf.append("Nessuna informazione disponibile");
            return bf.toString();
        }
        return bf.toString() + separatorGroups;
    }

    protected IDUnivocoGroupByPolicy augmentIDUnivoco(IDUnivocoGroupByPolicy idUnivoco) {
        if (OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy() != null && OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy().booleanValue()) {
            return idUnivoco;
        }
        if (idUnivoco instanceof IDUnivocoGroupByPolicyMapId) {
            return idUnivoco;
        }
        return new IDUnivocoGroupByPolicyMapId(idUnivoco, this.uniqueIdMapIdActivePolicy);
    }
}

