/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.replicatedmap.ReplicatedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.controllo_traffico.beans.ActivePolicy;
import org.openspcoop2.core.controllo_traffico.beans.DatiCollezionati;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicy;
import org.openspcoop2.core.controllo_traffico.beans.IDUnivocoGroupByPolicyMapId;
import org.openspcoop2.core.controllo_traffico.beans.MisurazioniTransazione;
import org.openspcoop2.core.controllo_traffico.beans.UniqueIdentifierUtilities;
import org.openspcoop2.core.controllo_traffico.driver.IPolicyGroupByActiveThreadsInMemory;
import org.openspcoop2.core.controllo_traffico.driver.PolicyException;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.driver.PolicyNotFoundException;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.PolicyDateUtils;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class PolicyGroupByActiveThreadsDistributedReplicatedMap
implements IPolicyGroupByActiveThreadsInMemory {
    protected final HazelcastInstance hazelcast;
    protected final ReplicatedMap<IDUnivocoGroupByPolicy, DatiCollezionati> distributedMap;
    protected final ActivePolicy activePolicy;
    protected String uniqueIdMapIdActivePolicy;
    protected Date uniqueIdMapUpdateTime;

    public PolicyGroupByActiveThreadsDistributedReplicatedMap(ActivePolicy policy, String uniqueIdMap, HazelcastInstance hazelcast) throws PolicyException {
        this.activePolicy = policy;
        this.hazelcast = hazelcast;
        this.uniqueIdMapIdActivePolicy = UniqueIdentifierUtilities.extractIdActivePolicy((String)uniqueIdMap);
        try {
            this.uniqueIdMapUpdateTime = UniqueIdentifierUtilities.extractUpdateTimeActivePolicy((String)uniqueIdMap);
        }
        catch (Exception e) {
            throw new PolicyException(e.getMessage(), (Throwable)e);
        }
        OpenSPCoop2Properties op2Properties = OpenSPCoop2Properties.getInstance();
        Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Properties.isControlloTrafficoDebug());
        String mapName = "hazelcast-replicated-map";
        boolean oneMapForeachPolicy = OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy();
        if (oneMapForeachPolicy) {
            this.distributedMap = this.hazelcast.getReplicatedMap(mapName + this.uniqueIdMapIdActivePolicy + "-rate-limiting");
            log.info("Hazelcast: Utilizzo Una Distributed Map per gruppo.");
        } else {
            this.distributedMap = this.hazelcast.getReplicatedMap(mapName + "rate-limiting");
            log.info("Hazelcast: Utilizzo Una Distributed Map globale.");
        }
        if (this.distributedMap.get((Object)new IDUnivocoGroupByPolicy()) != null) {
            // empty if block
        }
    }

    public ActivePolicy getActivePolicy() {
        return this.activePolicy;
    }

    public java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> getMapActiveThreads() {
        return this.distributedMap;
    }

    public long getActiveThreads() {
        return this.getActiveThreads(null);
    }

    public void initMap(java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry : map.entrySet()) {
                IDUnivocoGroupByPolicy datiGroupBy = entry.getKey();
                datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
                DatiCollezionati dati = map.get(datiGroupBy);
                this.distributedMap.put((Object)datiGroupBy, (Object)dati);
            }
        }
    }

    public long getActiveThreads(IDUnivocoGroupByPolicy filtro) {
        long counter = 0L;
        if (filtro != null) {
            for (Map.Entry entry : this.distributedMap.entrySet()) {
                IDUnivocoGroupByPolicy datiGroupBy = (IDUnivocoGroupByPolicy)entry.getKey();
                if (!datiGroupBy.match(filtro)) continue;
                DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
                counter += datiCollezionati.getActiveRequestCounter().longValue();
            }
        }
        return counter;
    }

    public void resetCounters() {
        if (this.distributedMap.size() > 0) {
            for (Map.Entry entry : this.distributedMap.entrySet()) {
                IDUnivocoGroupByPolicy datiGroupBy = (IDUnivocoGroupByPolicy)entry.getKey();
                DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
                datiCollezionati.resetCounters();
                this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
            }
        }
    }

    public void remove() throws UtilsException {
        ArrayList<IDUnivocoGroupByPolicy> deleteList = new ArrayList<IDUnivocoGroupByPolicy>();
        for (IDUnivocoGroupByPolicy datiGroupBy : this.distributedMap.keySet()) {
            IDUnivocoGroupByPolicyMapId mapId;
            if (!(datiGroupBy instanceof IDUnivocoGroupByPolicyMapId) || !this.uniqueIdMapIdActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
            deleteList.add(datiGroupBy);
        }
        while (!deleteList.isEmpty()) {
            IDUnivocoGroupByPolicy id = (IDUnivocoGroupByPolicy)deleteList.remove(0);
            this.distributedMap.remove((Object)id);
        }
    }

    public DatiCollezionati registerStartRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException {
        datiGroupBy = this.augmentIDUnivoco(datiGroupBy);
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)datiGroupBy);
        boolean newDati = false;
        if (datiCollezionati == null) {
            Date gestorePolicyConfigDate = PolicyDateUtils.readGestorePolicyConfigDateIntoContext(ctx);
            datiCollezionati = new DatiCollezionati(this.activePolicy.getInstanceConfiguration().getUpdateTime(), gestorePolicyConfigDate);
            newDati = true;
        } else if (datiCollezionati.getUpdatePolicyDate() != null && !datiCollezionati.getUpdatePolicyDate().equals(this.activePolicy.getInstanceConfiguration().getUpdateTime())) {
            datiCollezionati.resetCounters(this.activePolicy.getInstanceConfiguration().getUpdateTime());
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        if (newDati) {
            datiCollezionatiPerPolicyVerifier.initDatiIniziali(this.activePolicy);
            datiCollezionatiPerPolicyVerifier.checkDate(log, this.activePolicy);
        }
        datiCollezionati.registerStartRequest(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
        return datiCollezionatiPerPolicyVerifier;
    }

    public DatiCollezionati updateDatiStartRequestApplicabile(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx) throws PolicyException, PolicyNotFoundException {
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)(datiGroupBy = this.augmentIDUnivoco(datiGroupBy)));
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        DatiCollezionati datiCollezionatiPerPolicyVerifier = datiCollezionati.newInstance();
        boolean updated = datiCollezionati.updateDatiStartRequestApplicabile(log, this.activePolicy, ctx, datiCollezionatiPerPolicyVerifier);
        if (updated) {
            this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
            return datiCollezionatiPerPolicyVerifier;
        }
        return null;
    }

    public void registerStopRequest(Logger log, String idTransazione, IDUnivocoGroupByPolicy datiGroupBy, Map<Object> ctx, MisurazioniTransazione dati, boolean isApplicabile, boolean isViolata) throws PolicyException, PolicyNotFoundException {
        DatiCollezionati datiCollezionati = (DatiCollezionati)this.distributedMap.get((Object)(datiGroupBy = this.augmentIDUnivoco(datiGroupBy)));
        if (datiCollezionati == null) {
            throw new PolicyNotFoundException("Non sono presenti alcun threads registrati per la richiesta con dati identificativi [" + datiGroupBy.toString() + "]");
        }
        datiCollezionati.registerEndRequest(log, this.activePolicy, ctx, dati);
        if (isApplicabile) {
            List esitiCodeOk = null;
            List esitiCodeKoSenzaFaultApplicativo = null;
            List esitiCodeFaultApplicativo = null;
            try {
                EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)dati.getProtocollo());
                esitiCodeOk = esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                esitiCodeKoSenzaFaultApplicativo = esitiProperties.getEsitiCodeKo_senzaFaultApplicativo();
                esitiCodeFaultApplicativo = esitiProperties.getEsitiCodeFaultApplicativo();
            }
            catch (Exception e) {
                throw new PolicyException(e.getMessage(), (Throwable)e);
            }
            datiCollezionati.updateDatiEndRequestApplicabile(log, this.activePolicy, ctx, dati, esitiCodeOk, esitiCodeKoSenzaFaultApplicativo, esitiCodeFaultApplicativo, isViolata);
            this.distributedMap.put((Object)datiGroupBy, (Object)datiCollezionati);
        }
    }

    public String printInfos(Logger log, String separatorGroups) throws UtilsException {
        return this.printInfos(log, separatorGroups, (java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati>)this.distributedMap);
    }

    protected String printInfos(Logger log, String separatorGroups, java.util.Map<IDUnivocoGroupByPolicy, DatiCollezionati> map) {
        StringBuilder bf = new StringBuilder();
        for (Map.Entry<IDUnivocoGroupByPolicy, DatiCollezionati> entry : map.entrySet()) {
            IDUnivocoGroupByPolicyMapId mapId;
            IDUnivocoGroupByPolicy datiGroupBy = entry.getKey();
            DatiCollezionati datiCollezionati = map.get(datiGroupBy);
            if (OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy() != null && !OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy().booleanValue() && !this.uniqueIdMapIdActivePolicy.equals((mapId = (IDUnivocoGroupByPolicyMapId)datiGroupBy).getUniqueMapId())) continue;
            bf.append(separatorGroups);
            bf.append("\n");
            bf.append("Sincronizzazione").append(" ").append(PolicyGroupByActiveThreadsType.HAZELCAST_REPLICATED_MAP.toLabel());
            bf.append("\n");
            bf.append("Criterio di Collezionamento dei Dati\n");
            bf.append(datiGroupBy.toString(true));
            bf.append("\n");
            datiCollezionati.checkDate(log, this.activePolicy);
            bf.append(datiCollezionati.toString());
            bf.append("\n");
        }
        if (bf.length() <= 0) {
            bf.append("Nessuna informazione disponibile");
            return bf.toString();
        }
        return bf.toString() + separatorGroups;
    }

    protected IDUnivocoGroupByPolicy augmentIDUnivoco(IDUnivocoGroupByPolicy idUnivoco) {
        if (OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy() != null && OpenSPCoop2Properties.getInstance().isControlloTrafficoGestorePolicyInMemoryHazelcastOneMapForeachPolicy().booleanValue()) {
            return idUnivoco;
        }
        if (idUnivoco instanceof IDUnivocoGroupByPolicyMapId) {
            return idUnivoco;
        }
        return new IDUnivocoGroupByPolicyMapId(idUnivoco, this.uniqueIdMapIdActivePolicy);
    }
}

