/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import java.util.concurrent.CompletionStage;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.HazelcastManager;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.AtomicLongOperation;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.hazelcast.counters.AtomicLongResponse;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.slf4j.Logger;

public class DatoAtomicLong {
    private HazelcastInstance hazelcast;
    private String name;
    private IAtomicLong counter;
    private int failover = -1;
    private int failoverCheckEveryMs = -1;
    private Logger logControlloTraffico;
    private PolicyGroupByActiveThreadsType policyType;
    private boolean registryEnabled = false;

    public DatoAtomicLong(HazelcastInstance hazelcast, String name) {
        this(hazelcast, name, null);
    }

    public DatoAtomicLong(HazelcastInstance hazelcast, String name, PolicyGroupByActiveThreadsType policyType) {
        this.hazelcast = hazelcast;
        this.name = name;
        this.policyType = policyType;
        this.initCounter();
        OpenSPCoop2Properties op2Props = OpenSPCoop2Properties.getInstance();
        this.failover = op2Props.getHazelcastCPSubsystemDistributedObjectDestroyedExceptionFailover();
        this.failoverCheckEveryMs = op2Props.getHazelcastCPSubsystemDistributedObjectDestroyedExceptionFailoverCheckEveryMs();
        this.logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Props.isControlloTrafficoDebug());
        if (this.policyType != null && op2Props.isControlloTrafficoGestorePolicyInMemoryHazelcastAtomicLongRegistryEnabled()) {
            this.registryEnabled = true;
            HazelcastManager.registerAtomicLongCounter(this.policyType, this.name);
        }
    }

    private void initCounter() {
        this.counter = this.hazelcast.getCPSubsystem().getAtomicLong(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void set(long value) {
        this.process(AtomicLongOperation.SET, value, -1L);
    }

    public long get() {
        AtomicLongResponse r = this.process(AtomicLongOperation.GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long addAndGet(long value) {
        AtomicLongResponse r = this.process(AtomicLongOperation.ADD_AND_GET, value, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long incrementAndGet() {
        AtomicLongResponse r = this.process(AtomicLongOperation.INCREMENT_AND_GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long decrementAndGet() {
        AtomicLongResponse r = this.process(AtomicLongOperation.DECREMENT_AND_GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public CompletionStage<Long> addAndGetAsync(long value) {
        AtomicLongResponse r = this.process(AtomicLongOperation.ADD_AND_GET_ASYNC, value, -1L);
        return r != null ? r.valueAsync : null;
    }

    public CompletionStage<Long> incrementAndGetAsync() {
        AtomicLongResponse r = this.process(AtomicLongOperation.INCREMENT_AND_GET_ASYNC, -1L, -1L);
        return r != null ? r.valueAsync : null;
    }

    public CompletionStage<Long> decrementAndGetAsync() {
        AtomicLongResponse r = this.process(AtomicLongOperation.DECREMENT_AND_GET_ASYNC, -1L, -1L);
        return r != null ? r.valueAsync : null;
    }

    public boolean compareAndSet(long compare, long set) {
        AtomicLongResponse r = this.process(AtomicLongOperation.COMPARE_AND_SET, compare, set);
        return r != null && r.valueB;
    }

    public void destroy() {
        this.process(AtomicLongOperation.DESTROY, -1L, -1L);
        if (this.registryEnabled && this.policyType != null) {
            HazelcastManager.unregisterAtomicLongCounter(this.policyType, this.name);
        }
    }

    private AtomicLongResponse process(AtomicLongOperation op, long arg1, long arg2) {
        String prefix = "[Hazelcast-IAtomicLong-" + this.name + " operation:" + String.valueOf((Object)op) + "] ";
        if (this.failover > 0) {
            return this.processFailOver(prefix, op, arg1, arg2);
        }
        return this.operation(prefix, op, arg1, arg2);
    }

    private AtomicLongResponse processFailOver(String prefix, AtomicLongOperation op, long arg1, long arg2) {
        boolean success = false;
        Throwable eFinal = null;
        AtomicLongResponse v = null;
        for (int i = 0; i < this.failover; ++i) {
            try {
                if (i > 0 && this.failoverCheckEveryMs > 0) {
                    Utilities.sleep((long)this.failoverCheckEveryMs);
                    this.initCounter();
                }
                v = this.operation(prefix, op, arg1, arg2);
                success = true;
                break;
            }
            catch (DistributedObjectDestroyedException e) {
                eFinal = e;
                if (i == 0) {
                    this.logControlloTraffico.error(prefix + "rilevato contatore distrutto (verr\u00e0 riprovata la creazione): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                this.logControlloTraffico.error(prefix + "il tenativo i=" + i + " di ricreare il contatore \u00e8 fallito: " + e.getMessage(), (Throwable)e);
                continue;
            }
            catch (RuntimeException e) {
                String causeName;
                Throwable cause = e.getCause();
                String exceptionName = e.getClass().getSimpleName();
                String string = causeName = cause != null ? cause.getClass().getSimpleName() : "null";
                if (this.isMemberRelatedError(e, cause, exceptionName, causeName)) {
                    eFinal = e;
                    if (i == 0) {
                        this.logControlloTraffico.error(prefix + "errore relativo a membro cluster (" + exceptionName + "/" + causeName + ") durante operazione (verr\u00e0 riprovata l'operazione): " + e.getMessage(), (Throwable)e);
                        continue;
                    }
                    this.logControlloTraffico.error(prefix + "il tenativo i=" + i + " \u00e8 fallito per errore membro cluster (" + exceptionName + "/" + causeName + "): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (!success) {
            this.throwDistributedObjectDestroyedException(prefix, (RuntimeException)eFinal);
        }
        return v;
    }

    private boolean isMemberRelatedError(Throwable e, Throwable cause, String exceptionName, String causeName) {
        if (e instanceof MemberLeftException || e instanceof TargetNotMemberException) {
            return true;
        }
        if (cause instanceof MemberLeftException || cause instanceof TargetNotMemberException) {
            return true;
        }
        if (exceptionName.contains("MemberLeft") || exceptionName.contains("TargetNotMember")) {
            return true;
        }
        if (causeName.contains("MemberLeft") || causeName.contains("TargetNotMember")) {
            return true;
        }
        String message = e.getMessage();
        return message != null && (message.contains("Member") && message.contains("left cluster") || message.contains("Not Member") || message.contains("target") && message.contains("not") && message.contains("member"));
    }

    private void throwDistributedObjectDestroyedException(String prefix, RuntimeException eFinal) {
        String msg = prefix + "tutti i tentativi di eseguire l'operazione sul contatore sono falliti";
        this.logControlloTraffico.error(msg);
        if (eFinal != null) {
            throw eFinal;
        }
        throw new UtilsRuntimeException("tutti i tentativi di eseguire l'operazione sul contatore sono falliti");
    }

    private AtomicLongResponse operation(String prefix, AtomicLongOperation op, long arg1, long arg2) {
        switch (op) {
            case SET: {
                this.counter.set(arg1);
                return null;
            }
            case GET: {
                return new AtomicLongResponse(this.counter.get());
            }
            case ADD_AND_GET: {
                return new AtomicLongResponse(this.counter.addAndGet(arg1));
            }
            case INCREMENT_AND_GET: {
                return new AtomicLongResponse(this.counter.incrementAndGet());
            }
            case DECREMENT_AND_GET: {
                return new AtomicLongResponse(this.counter.decrementAndGet());
            }
            case ADD_AND_GET_ASYNC: {
                return new AtomicLongResponse(this.counter.addAndGetAsync(arg1));
            }
            case INCREMENT_AND_GET_ASYNC: {
                return new AtomicLongResponse(this.counter.incrementAndGetAsync());
            }
            case DECREMENT_AND_GET_ASYNC: {
                return new AtomicLongResponse(this.counter.decrementAndGetAsync());
            }
            case COMPARE_AND_SET: {
                return new AtomicLongResponse(this.counter.compareAndSet(arg1, arg2));
            }
            case DESTROY: {
                try {
                    this.counter.destroy();
                }
                catch (Throwable e) {
                    this.logControlloTraffico.error(prefix + "destroy non riuscito: " + e.getMessage(), e);
                    throw e;
                }
                return null;
            }
        }
        return null;
    }
}

