/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson;

import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.ReadMode;
import org.redisson.config.SslVerificationMode;
import org.slf4j.Logger;

public class RedissonManager {
    private static Logger logStartup;
    private static Logger log;
    private static List<String> connectionUrl;
    private static final String INIZIALIZZAZIONE_FALLITA = "Inizializzazione RedissonClient fallita: ";
    private static RedissonClient redisson;

    private RedissonManager() {
    }

    public static synchronized void initialize(Logger logStartup, Logger log, List<String> connectionUrl) {
        if (RedissonManager.connectionUrl == null) {
            RedissonManager.logStartup = logStartup;
            RedissonManager.log = log;
            RedissonManager.connectionUrl = connectionUrl;
        }
    }

    private static synchronized void initRedissonClient(boolean throwInitializingException) throws UtilsException {
        if (redisson == null) {
            logStartup.info("Inizializzazione RedissonClient ...");
            log.info("Inizializzazione RedissonClient ...");
            try {
                Config redisConf = new Config();
                redisConf.setSslVerificationMode(SslVerificationMode.STRICT);
                redisConf.useClusterServers().addNodeAddress(connectionUrl.toArray(new String[1])).setReadMode(ReadMode.MASTER_SLAVE);
                redisson = Redisson.create((Config)redisConf);
                logStartup.info("Inizializzazione RedissonClient effettuata con successo");
                log.info("Inizializzazione RedissonClient effettuata con successo");
            }
            catch (Exception t) {
                if (throwInitializingException) {
                    throw new UtilsException(INIZIALIZZAZIONE_FALLITA + t.getMessage(), (Throwable)t);
                }
                logStartup.error(INIZIALIZZAZIONE_FALLITA + t.getMessage(), (Throwable)t);
                log.error(INIZIALIZZAZIONE_FALLITA + t.getMessage(), (Throwable)t);
            }
        }
    }

    public static RedissonClient getRedissonClient(boolean throwInitializingException) throws UtilsException {
        if (redisson == null) {
            RedissonManager.initRedissonClient(throwInitializingException);
        }
        return redisson;
    }

    public static boolean isRedissonClientInitialized() {
        return redisson != null;
    }

    static {
        connectionUrl = null;
        redisson = null;
    }
}

