/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.RAtomicLongOperation;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.RAtomicLongResponse;
import org.openspcoop2.pdd.core.controllo_traffico.policy.driver.redisson.counters.RedisTTLConfig;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;

public class DatoRAtomicLong {
    private RedissonClient redisson;
    private String name;
    private RAtomicLong counter;
    private RedisTTLConfig ttlConfig;
    private boolean ttlApplied = false;
    private int failover = -1;
    private int failoverCheckEveryMs = -1;
    private Logger logControlloTraffico;

    public void setFailover(int failover) {
        this.failover = failover;
    }

    private void logDebug(String msg) {
        if (this.logControlloTraffico != null) {
            this.logControlloTraffico.debug(msg);
        }
    }

    private void logWarn(String msg) {
        if (this.logControlloTraffico != null) {
            this.logControlloTraffico.warn(msg);
        }
    }

    public DatoRAtomicLong(RedissonClient redisson, String name) {
        this(redisson, name, null);
    }

    public DatoRAtomicLong(RedissonClient redisson, String name, RedisTTLConfig ttlConfig) {
        this.redisson = redisson;
        this.name = name;
        this.ttlConfig = ttlConfig;
        this.initCounter();
        OpenSPCoop2Properties op2Props = OpenSPCoop2Properties.getInstance();
        this.failover = -1;
        this.failoverCheckEveryMs = -1;
        this.logControlloTraffico = OpenSPCoop2Logger.getLoggerOpenSPCoopControlloTraffico(op2Props.isControlloTrafficoDebug());
    }

    private void initCounter() {
        this.counter = this.redisson.getAtomicLong(this.name);
    }

    public String getName() {
        return this.name;
    }

    private void applyTTLIfNeeded() {
        if (this.ttlConfig != null && this.ttlConfig.isEnabled() && !this.ttlApplied) {
            try {
                boolean applied;
                long ttlSeconds = this.ttlConfig.getTtlSeconds();
                if (ttlSeconds > 0L && (applied = this.counter.expire(Duration.ofSeconds(ttlSeconds)))) {
                    this.ttlApplied = true;
                }
            }
            catch (Exception e) {
                this.logWarn("[Redis-TTL] Impossibile applicare TTL al contatore " + this.name + ": " + e.getMessage());
            }
        }
    }

    private void applyTTLIfNeededAsync() {
        block4: {
            if (this.ttlConfig != null && this.ttlConfig.isEnabled() && !this.ttlApplied) {
                try {
                    long ttlSeconds = this.ttlConfig.getTtlSeconds();
                    if (ttlSeconds > 0L) {
                        this.applyTTLIfNeededAsync(ttlSeconds);
                    }
                }
                catch (Exception e) {
                    if (this.logControlloTraffico == null) break block4;
                    this.logWarn("[Redis-TTL] Impossibile applicare TTL async al contatore " + this.name + ": " + e.getMessage());
                }
            }
        }
    }

    private void applyTTLIfNeededAsync(long ttlSeconds) {
        this.counter.expireAsync(Duration.ofSeconds(ttlSeconds)).thenAccept(applied -> {
            if (applied != null && applied.booleanValue()) {
                this.ttlApplied = true;
                if (this.logControlloTraffico != null && this.logControlloTraffico.isDebugEnabled()) {
                    this.logDebug("[Redis-TTL] Applicato TTL async di " + ttlSeconds + " secondi al contatore: " + this.name);
                }
            }
        });
    }

    private void renewTTLIfNeeded() {
        block4: {
            if (this.ttlConfig != null && this.ttlConfig.isEnabled() && this.ttlConfig.isRenewTTLOnWrite()) {
                try {
                    long ttlSeconds = this.ttlConfig.getTtlSeconds();
                    if (ttlSeconds > 0L) {
                        this.counter.expire(Duration.ofSeconds(ttlSeconds));
                    }
                }
                catch (Exception e) {
                    if (this.logControlloTraffico == null || !this.logControlloTraffico.isDebugEnabled()) break block4;
                    this.logDebug("[Redis-TTL] Impossibile rinnovare TTL per " + this.name + ": " + e.getMessage());
                }
            }
        }
    }

    private void renewTTLIfNeededAsync() {
        block4: {
            if (this.ttlConfig != null && this.ttlConfig.isEnabled() && this.ttlConfig.isRenewTTLOnWrite()) {
                try {
                    long ttlSeconds = this.ttlConfig.getTtlSeconds();
                    if (ttlSeconds > 0L) {
                        this.counter.expireAsync(Duration.ofSeconds(ttlSeconds));
                    }
                }
                catch (Exception e) {
                    if (this.logControlloTraffico == null || !this.logControlloTraffico.isDebugEnabled()) break block4;
                    this.logDebug("[Redis-TTL] Impossibile rinnovare TTL async per " + this.name + ": " + e.getMessage());
                }
            }
        }
    }

    public void ensureTTLApplied() {
        if (this.ttlConfig != null && this.ttlConfig.isEnabled() && !this.ttlApplied && this.counter.isExists()) {
            this.applyTTLIfNeeded();
        }
    }

    public void set(long value) {
        this.process(RAtomicLongOperation.SET, value, -1L);
        this.applyTTLIfNeeded();
        this.renewTTLIfNeeded();
    }

    public long get() {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public long addAndGet(long value) {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.ADD_AND_GET, value, -1L);
        this.applyTTLIfNeeded();
        this.renewTTLIfNeeded();
        return r != null ? r.valueL : -1L;
    }

    public long incrementAndGet() {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.INCREMENT_AND_GET, -1L, -1L);
        this.applyTTLIfNeeded();
        this.renewTTLIfNeeded();
        return r != null ? r.valueL : -1L;
    }

    public long decrementAndGet() {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.DECREMENT_AND_GET, -1L, -1L);
        return r != null ? r.valueL : -1L;
    }

    public CompletionStage<Long> addAndGetAsync(long value) {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.ADD_AND_GET_ASYNC, value, -1L);
        if (r == null || r.valueAsync == null) {
            return null;
        }
        return r.valueAsync.thenApply(result -> {
            this.applyTTLIfNeededAsync();
            this.renewTTLIfNeededAsync();
            return result;
        });
    }

    public CompletionStage<Long> incrementAndGetAsync() {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.INCREMENT_AND_GET_ASYNC, -1L, -1L);
        if (r == null || r.valueAsync == null) {
            return null;
        }
        return r.valueAsync.thenApply(result -> {
            this.applyTTLIfNeededAsync();
            this.renewTTLIfNeededAsync();
            return result;
        });
    }

    public CompletionStage<Long> decrementAndGetAsync() {
        RAtomicLongResponse r = this.process(RAtomicLongOperation.DECREMENT_AND_GET_ASYNC, -1L, -1L);
        return r != null ? r.valueAsync : null;
    }

    public boolean compareAndSet(long compare, long set) {
        boolean casResult;
        RAtomicLongResponse r = this.process(RAtomicLongOperation.COMPARE_AND_SET, compare, set);
        boolean bl = casResult = r != null && r.valueB;
        if (casResult) {
            this.forceApplyTTL();
        } else {
            this.applyTTLIfNeeded();
        }
        return casResult;
    }

    private void forceApplyTTL() {
        if (this.ttlConfig != null && this.ttlConfig.isEnabled()) {
            try {
                boolean applied;
                long ttlSeconds = this.ttlConfig.getTtlSeconds();
                if (ttlSeconds > 0L && (applied = this.counter.expire(Duration.ofSeconds(ttlSeconds)))) {
                    this.ttlApplied = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void delete() {
        this.process(RAtomicLongOperation.DELETE, -1L, -1L);
    }

    public long remainTimeToLive() {
        try {
            return this.counter.remainTimeToLive();
        }
        catch (Exception e) {
            if (this.logControlloTraffico != null && this.logControlloTraffico.isDebugEnabled()) {
                this.logDebug("[Redis-TTL] Impossibile ottenere TTL rimanente per " + this.name + ": " + e.getMessage());
            }
            return -2L;
        }
    }

    public boolean exists() {
        try {
            return this.counter.isExists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setTTL(long ttlSeconds) {
        block3: {
            if (ttlSeconds > 0L) {
                try {
                    this.counter.expire(Duration.ofSeconds(ttlSeconds));
                }
                catch (Exception e) {
                    if (this.logControlloTraffico == null) break block3;
                    this.logWarn("[Redis-TTL] Impossibile impostare TTL per " + this.name + ": " + e.getMessage());
                }
            }
        }
    }

    public void clearTTL() {
        block2: {
            try {
                this.counter.clearExpire();
            }
            catch (Exception e) {
                if (this.logControlloTraffico == null) break block2;
                this.logWarn("[Redis-TTL] Impossibile rimuovere TTL per " + this.name + ": " + e.getMessage());
            }
        }
    }

    public RedisTTLConfig getTTLConfig() {
        return this.ttlConfig;
    }

    private RAtomicLongResponse process(RAtomicLongOperation op, long arg1, long arg2) {
        String prefix = "[Redis-RAtomicLong-" + this.name + " operation:" + String.valueOf((Object)op) + "] ";
        if (this.failover > 0) {
            return this.processFailOver(prefix, op, arg1, arg2);
        }
        return this.operation(prefix, op, arg1, arg2);
    }

    private RAtomicLongResponse processFailOver(String prefix, RAtomicLongOperation op, long arg1, long arg2) {
        boolean success = false;
        Exception eFinal = null;
        RAtomicLongResponse v = null;
        for (int i = 0; i < this.failover; ++i) {
            try {
                if (i > 0 && this.failoverCheckEveryMs > 0) {
                    Utilities.sleep((long)this.failoverCheckEveryMs);
                    this.initCounter();
                }
                v = this.operation(prefix, op, arg1, arg2);
                success = true;
                break;
            }
            catch (Exception e) {
                eFinal = e;
                if (i == 0) {
                    this.logControlloTraffico.error(prefix + "rilevato contatore distrutto (verr\u00e0 riprovata la creazione): " + e.getMessage(), (Throwable)e);
                    continue;
                }
                this.logControlloTraffico.error(prefix + "il tenativo i=" + i + " di ricreare il contatore \u00e8 fallito: " + e.getMessage(), (Throwable)e);
                continue;
            }
        }
        if (!success) {
            this.throwDistributedObjectDestroyedException(prefix, eFinal);
        }
        return v;
    }

    private void throwDistributedObjectDestroyedException(String prefix, Exception eFinal) {
        String msg = prefix + "tutti i tentativi di ricreare il contatore sono falliti";
        this.logControlloTraffico.error(msg);
        if (eFinal != null) {
            throw new UtilsRuntimeException((Throwable)eFinal);
        }
        throw new UtilsRuntimeException("tutti i tentativi di ricreare il contatore sono falliti");
    }

    private RAtomicLongResponse operation(String prefix, RAtomicLongOperation op, long arg1, long arg2) {
        switch (op) {
            case SET: {
                this.counter.set(arg1);
                return null;
            }
            case GET: {
                return new RAtomicLongResponse(this.counter.get());
            }
            case ADD_AND_GET: {
                return new RAtomicLongResponse(this.counter.addAndGet(arg1));
            }
            case INCREMENT_AND_GET: {
                return new RAtomicLongResponse(this.counter.incrementAndGet());
            }
            case DECREMENT_AND_GET: {
                return new RAtomicLongResponse(this.counter.decrementAndGet());
            }
            case ADD_AND_GET_ASYNC: {
                return new RAtomicLongResponse((CompletionStage<Long>)this.counter.addAndGetAsync(arg1));
            }
            case INCREMENT_AND_GET_ASYNC: {
                return new RAtomicLongResponse((CompletionStage<Long>)this.counter.incrementAndGetAsync());
            }
            case DECREMENT_AND_GET_ASYNC: {
                return new RAtomicLongResponse((CompletionStage<Long>)this.counter.decrementAndGetAsync());
            }
            case COMPARE_AND_SET: {
                return new RAtomicLongResponse(this.counter.compareAndSet(arg1, arg2));
            }
            case DELETE: {
                try {
                    this.counter.delete();
                }
                catch (Throwable e) {
                    this.logControlloTraffico.error(prefix + "delete non riuscito: " + e.getMessage(), e);
                    throw e;
                }
                return null;
            }
        }
        return null;
    }
}

